//                      ******************************
//                      **   STM CONTROL PROGRAM    **
//                      **                          **
//                      **         by Joseph Gatt   **
//                      ******************************


#include "timing6.h"
#include "ioboard3.h"
#include "array13.h"
#include "tunsee.h"
#include <fcntl.h>

#define            BUF_SIZE 40000   // Z-buffer size (for saving)
#define	             SHADES 0x02    // attenuator for preview
#define       RETLEVEL_STEP 0x0AA0  // Iref displacemet for forcing RETRACT
#ifdef NOCARD
  #define              WAIT 0x01    // move delay
  #define           LG_WAIT 0x00    // ... and in log form
#else
  #define              WAIT 0x10
  #define           LG_WAIT 0x04
#endif

#define    CRO_viewport setviewport(0,0,319,255,0);
#define raster_viewport setviewport(0,256,399,455,0);
#define   text_viewport setviewport(340,0,639,16,0);                    \
			clearviewport();                                \
			setcolor(255);


enum {SEEK,RETRACT,APPROACH,ATTACK,SUSTAIN,RELAX} control;  // Z-control mode
unsigned int frame, steep=50, beep=0, stepcount=0, stepper_direction=0;
signed int X=0, Y=0, Z=0, Zo, x, y, x2, y2, p, attack, QR;
signed int It= -0x0200, Iref = -0x0400, Vb, d;
signed char V[640], V2[640];
unsigned char shift, noise=0, Vfilter=0;
unsigned char noscan=0, whisper=0;
long int Zav=0;
unsigned char logicstat=0x00;
char scanflags[5]={' ',' ',' ',' ',' '};


void sampling_delay(unsigned char m)                         {
static unsigned int late_logged=0;

if (wate(m)) late_logged += 20;   // if error, register late sampling status
if(late_logged) { putpixel(0,0,255); late_logged-- ; }
else putpixel(0,0,0);                                    }


void flagging(int flg, char symb, int stat)                          {

  setviewport(540,455,639,479,0); clearviewport(); setcolor(100);
  if(stat) scanflags[flg]= symb; else scanflags[flg] = ' ';
  outtext(scanflags);                                                }


void draw_ruler(char hue)                                               {
  int i,d=0;

  setviewport(320,0,339,255,0);              // draw markers
  setcolor(hue);
  for(i=0;i<20;i++)       {                  // tenths ruler
  d+=51;
  line (0,d>>2,10,d>>2);  }

  line(0,  0,15,  0);                        // longer lines
  line(0, 63,12, 63);
  line(0,127,15,127);
  line(0,191,12,191);
  line(0,255,15,255);

  setviewport(0,456,339,479,0);              // doubling-factor scale
  outtext("0   1   2   3   4   5   6   7");                             }


void move_marker(int vel)         { //changes Iref, showing it on ruler
  static int marker;

  setviewport(320,0,339,255,0);
  setcolor(0);
  line(0,marker,19,marker);
  Iref += vel<<8;
  marker = 127-(Iref>>8);
  setcolor(255);
  line(0,marker,19,marker);
  draw_ruler(100);                 }


void move_Vb_marker(int vel)         { //changes Vb, showing it on ruler
  static int marker;

  setviewport(320,0,339,255,0);
  setcolor(0);
  line(0,marker,19,marker);
  Vb += vel<<8;
  marker = 127-(Vb>>8);
  setcolor(150);
  line(0,marker,19,marker);
  draw_ruler(100);
  write_word(DAC4,Vb);                           }


void choice_parms(void)              {

Vb= -0x0D00;     move_Vb_marker(0);
Iref = Vb - 0x0600; move_marker(0);  }


#ifdef hemisphere
int func_hemisphere(void)      {
  float q,r,s;

  if(noscan){q=0; r=0;} else {q=Y; r=X;}
  s = 512000-q*q-r*r;           // stretched hemisphere
  if (s>0) return 4*sqrt(s);    // for testing only
  else  return 0;              }
#endif


void stepper(void)                                                      {
  static signed int counter=-80;
  static        int stopping= 0;

if(stopping)                                                          {
  if(++counter >= 8)                                                {
	 counter = -8; write_byte(LOGIC_OUT,logicstat|0x01); stopping=0; }
  return;                                                             }
if(!stepcount) return;
if(++counter >= 80)                                 {
  counter = -80;
  if(stepper_direction)
	 switch(logicstat)                           {
		case 0x00:logicstat = 0x40; break;
		case 0x40:logicstat = 0xC0; break;
		case 0xC0:logicstat = 0x80; break;
		case 0x80:logicstat = 0x00; break;
		default:  ;                               }
  else
	 switch(logicstat)                           {
		case 0x80:logicstat = 0xC0; break;
		case 0xC0:logicstat = 0x40; break;
		case 0x40:logicstat = 0x00; break;
		case 0x00:logicstat = 0x80; break;
		default:  ;                               }
  write_byte(LOGIC_OUT,logicstat);

if(!(--stepcount))  stopping = 1;                   }                   }


void gap_control(void)                                                 {
signed int  Qb, QX, QY;
static signed int limiz =0;
signed long int P, Zold=0;


sampling_delay(2);

#ifndef NOCARD
  Z = sample_word();
#endif

#ifdef MONITOR_VAR
	clr_var_marker
#endif

if(beep) if(!--beep) speaker(0);

switch(control)                                                  {
  case   APPROACH: limiz = 1920; control = ATTACK;
  case   RETRACT: QR = Vb + RETLEVEL_STEP; break;
  case   ATTACK : if(Z > 0x7E00) {control = SUSTAIN;
		  stepper_direction=1; stepcount=1;} break;
  case   SUSTAIN : if(frame == 3) {control = RELAX; QR=Iref;} break;
  case	 RELAX:  if(!frame)                                            {
			if( (--limiz <= 0) || (Z > -0x7E00) )        {
			  control=SEEK; beep=2000; speaker(1);       }
			else                                         {
			  control=ATTACK;QR=Vb+RETLEVEL_STEP; break; } }
  default :   QR = Iref;   /* enable SEEK control function*/     }


#ifdef MONITOR_VAR
  disp_var_marker(logicstat)
#endif

#ifdef hemisphere
Z=func_hemisphere();
//  P=p=func_hemisphere(); P -= Z;
//  if(P>0) Z=p;
#endif

QX = X; QY = Y;
if(noscan) QX=QY=0;

#ifndef NOCARD
if(!whisper)                                  {
  write_word(DAC1,QX);   // update DAC levels
  write_word(DAC2,QR);
  write_word(DAC3,QY); 								 }
#endif
  Zav *= 6; Zav += Zold; Zav += Z; Zav >>=3; Zold = Z;
  if(Vfilter) Z = Zav;                                      }


// Save z-buffer to hard disk.
void store(void)                                   {
int handle;
unsigned int i, count;
unsigned long ndx;
char reply[16]={14};  //set first element to max string size i.e. 14.

ndx = BUF_SIZE;

text_viewport
outtext("Save file name: ");
cgets(reply);
for(i=0;i<14;i++) reply[i] = reply[i+2];
outtext(reply);

// create a file containing ndx bytes
if (_dos_creat(reply, _A_NORMAL, &handle) != 0)   {
  clearviewport();
  outtext("Unable to create file");               }
else                                              {
  if (_dos_write(handle, z, ndx, &count) != 0)  {
	 clearviewport();
	 outtext("Unable to write to file");         }
  else
		 _dos_close(handle);                        }

while(!kbhit());
clearviewport();   			              }


// tick macro   (performs gap control)
#define tick                      \
gap_control();

// tock macro   (updates "digital storage cro trace")
#define tock(vert)                        \
putpixel(d,vert-V[d],0);                  \
if(noise) V[d]=Z &0xFF; else V[d]=Z >>8;  \
putpixel(d,vert-V[d],255);                \
if(++d == 320) d=0;

void scanto(int j, int i, int slow)                                     {
int dX, dY, t=1;

raster_viewport
d=0;
tick tock(-129)


x2 = (x = X >> shift);       // screen co-ordinates are scaled down versions
y2 = (y = Y >> shift);       // ... of the scanning co-ordinates.

if(j>=X) dX=1; else dX=-1;
if(i>=Y) dY=1; else dY=-1;

do                                                    {
  if(! --t) 					 {
	 t=slow;
	 if(x!=j) goto moveX;
	 if(y!=i) goto moveY;
	 break;

  moveX:
	 X+=dX; x = X >> shift;
	 if(y==i) goto skip;

  moveY:
	 Y+=dY; y = Y >> shift;
skip:                                            }
	 tick tock(-129)
  if (y != y2 || x != x2) {
	 y2 = y; x2 = x;
	 p = (Z-Zo) >> (shift+SHADES);
if(x > -101 && x < 100 && y > -101 && y < 100)putpixel(x+100, y+100, p+128);}
								}while(1);
if(i==0 && j==0) X=Y=0;		  									 }


void normalise2(void)                                      {
int  m=0, n=0, Zmax = 0x8000, Zmin = 0x7FFF, delta;
unsigned char tmp;
long int drift=0;


drift=0;
for(n=0; n<200; n++)                           {
p = z[0][n]<<8; tmp =     z[1][n]; drift += p;  drift += tmp;   }
drift /= 200; Zmin = drift;

drift=0;
for(n=0; n<200; n++)                           {
p = z[198][n]<<8; tmp = z[199][n]; drift += p; drift += tmp;   }
drift /= 200;

drift -= Zmin; drift <<= 15; drift /= 30000;
delta = drift;

/*
  for(m=0; m<200; m+=2)                         {
	 for(n=0; n<200; n++)                 {
		p = z[m][n]<<8;
		tmp = z[m+1][n];
		p += tmp;
		if(p < Zmin) Zmin = p;
		if(p > Zmax) Zmax = p;        } }

drift = Zmax; drift -= Zmin; drift <<= 15; drift /= 30000;
delta = drift;
*/

  for(m=0; m<200; m+=2)                         {
	 for(n=0; n<200; n++)                 {
		p = z[m][n]<<8;
		tmp = z[m+1][n];
		p += tmp; p -= (drift += delta)>>15;
//					 p = (drift += delta)>>15;
		z[m][n] = p>>8;
		z[m+1][n] = p;                      }      }      }


void normalise(void)                                      {
int  m=0, n=0, Zmax = 0x8000, Zmin = 0x7FFF, halfing;
unsigned char tmp;


  for(m=0; m<200; m+=2)                         {
	 for(n=0; n<200; n++)                 {
		p = z[m][n]<<8;
		tmp = z[m+1][n];
		p += tmp;
		if(p < Zmin) Zmin = p;
		if(p > Zmax) Zmax = p;        } }

setviewport(340,456,439,479,0);  // vertical scale indicator window
clearviewport(); setcolor(100);

p = Zmax; p -= Zmin; p >>= (shift + 8);
switch(p)                                             {
case 0:  outtext("height 1:1"); halfing = 0; break;
case 1:  outtext("height 1:2"); halfing = 1; break;
case 2:  outtext("height 1:4"); halfing = 2; break;
case 3:  outtext("height 1:4"); halfing = 2; break;
case 4:  outtext("height 1:8"); halfing = 3; break;
case 5:  outtext("height 1:8"); halfing = 3; break;
case 6:  outtext("height 1:8"); halfing = 3; break;
case 7:  outtext("height 1:8"); halfing = 3; break;
default: outtext("height ???"); halfing = 4;          }

  for(m=0; m<200; m+=2)                      {
	 for(n=0; n<200; n++)                   {
		p = z[m][n]<<8;
		tmp = z[m+1][n];
		p = p + tmp - Zmin;
		p >>= shift+halfing;
		p -= 128;
		z[m][n] = z[m+1][n] = p;     } }									  }


void image(int slow)                                                     {
int t=slow;
long int q=0;

steep = 50;  // Treshold of noise acknowledgement for filter1
scanto(-101,-100,WAIT*2);
d=0; x2=x;

do                                                              {
  do                                                {
	 tick tock(-129)
	 q+=Z;                                     //height averageing register
	 if(! --t)                             {//check for time to move
	t=slow;X++; x = X >> shift;         //reset delay, move abscissa
	if(x != x2)                       {//if crossing over to new pixel
	  if(x>-100 && x<101)           { //recording area clipping
		 q>>=shift+LG_WAIT;           //work out average Z for pixel
		 z[y+100][x+99] = q>>8;      //... update Z-buffer
		 z[y+101][x+99] = q;
		 q = (q-Zo) >> (shift+SHADES);
		 putpixel(x+99, y+100, q+128);    // ... and pixels
		 putpixel(x+99, y+101, q+128);       }
		 q=0; x2=x;                            } } }while(x<102);

  do                                                {
	 tick tock(-129)
	 q+=Z;                                     //height averageing register
	 if(! --t)                                  {//check for time to move
	t=slow;X--; x = X >> shift;              //reset delay, move abscissa
	if(x != x2)                            {//if crossing over to new pixel
	  if(x>-102 && x<99)                 { //recording area clipping
		 q>>=shift+LG_WAIT;                //work out average Z for pixel
		 q = (q-Zo) >> (shift+SHADES);
		 putpixel(301-x, y+100, q+128);    //  update pixels
		 putpixel(301-x, y+101, q+128);   }
	  q=0; x2=x;                           } } }while(x>-102);

  y2=y;
  do                                    {  // step towards next ordinate
	 tick tock(-129)
	 if(! --t){t=slow; Y++; y = Y >> shift;} } while(y - y2 < 2);

if(kbhit()) {if(getch()=='o') {flagging(4,'o',noise^=1);
							 raster_viewport} else  break; }		  }while(y<99);
                                         /* repeat for 200 lines*/        }


void Xtrace(int slow)                                                     {
int X2=320, exit_flag=0, t=1;

gap_control();
Zo = Z;

CRO_viewport
while (exit_flag < 2)                                                {
  while (X2>10)                                            {
	 if(! --t)                     {
	 t=slow; X--;
	 gap_control();
	 putpixel(X2,127-V[X2],0);     // black out old pixel
	 V[X2]=Z >> 8;
	 if(!exit_flag) putpixel(X2,127-V[X2],150); // light up the Vnew (grey)
	 X2--;                          }               }

  while (X2<630)                                              {
	 if(! --t)                    {
	 t=slow; X++;
	 gap_control();
	 putpixel(X2,327-V2[X2],0);     // black out old pixel
	 V2[X2]=Z >> 8;
	 if(!exit_flag) putpixel(X2,327-V2[X2],150); // light up the Vnew (grey)
	 X2++;                         }                         }
  if(exit_flag) exit_flag=2; else if(kbhit()) exit_flag=1;       }
  move_marker(0);    // forces a re-drawing of the ruler

  if(getch()=='i') image(WAIT);
  scanto(0,0,WAIT*2);                                              }


void show(void)                                               {

int i, j;

raster_viewport

for(i=0; i<200; i++)                   {
  for(j=0; j<200; j++)               {
	 putpixel(j, i, z[i][j]+128);     } }                                  }


void show2(void)                                               {

int i, j,tmp;

raster_viewport

for(i=0; i<200; i+=2)                   {
  for(j=0; j<200; j++)               {
		p = z[i][j];
	 putpixel(j, i, p+128);
	 putpixel(j, i+1, p+128);     } }                                  }



void load(void)                                               {

int i,handle;
unsigned bytes;
char reply[16]={14};  //set first element to max string size i.e. 14.

text_viewport
outtext("Load file name: ");
cgets(reply);
for(i=0;i<14;i++) reply[i] = reply[i+2];
outtext(reply);

  if (_dos_open(reply, O_RDONLY, &handle) != 0)         {
	 clearviewport();
	 outtext("Unable to open file");                     }
  else                                                  {
	 if (_dos_read(handle, z, BUF_SIZE, &bytes) != 0) {
		clearviewport();
		outtext("Unable to read from file");           }
	 else
			  _dos_close(handle);                          }

  steep=50;  show();
  while(!kbhit());
  text_viewport     /* cls */                                 }


//Remove sharp-step noise
void filter1(int steep)               {
int i, j, average;

for(i=2; i<198; i+=2)                              {
  for(j=1; j<199; j++)                           {
	 average = ( z[i-2][j-1] + z[i-2][j] + z[i-2][j+1]
			+	z[i+2][j-1] + z[i+2][j] + z[i+2][j+1] ) / 6;
	 if(abs(average - z[i][j]) > steep)    {
		z[i+1][j] = z[i][j] = average; } } }
beep=2000; speaker(1);                    }


// rotate image by 90 degrees
void turn(void)  {
  int i, j, temp;

for(i=0; i<100; i++)                      {
  for(j=0; j<100; j++)                  {
	 temp = z[i][j];
	 z[i][j] = z[j][199-i];
	 z[j][199-i] = z[199-i][199-j];
	 z[199-i][199-j] = z[199-j][i];
	 z[199-j][i] = temp;                } }  }


void set_doubling(char c)             {   // set scan width

putpixel(3+ shift   *32,470,0);           // and update indicator
putpixel(3+(shift=c)*32,470,255);     }


#define note(chan,freq,dur)                 \
														  \
for(i=0;i<dur;i++)                   {      \
  for(d=0;d<freq;d++);                      \
  write_byte(chan,wave[i & 0x0F]);   }      \
  write_byte(chan,0x00);

// test tones
void music(void)                                {
unsigned i, wave[16];
double d;

for(d=0;d<16;d++) wave[d] = 100*sin(d*3.14/8);  // set up wave table

note(DAC0,7, 40000) note(DAC1,4, 30000)        // play one note per quadrant
note(DAC2,1, 20000) note(DAC3,10,40000)

text_viewport
outtext("midpoint voltage test ON");
while(!kbhit());   text_viewport        /* cls */	         }


void cro(void)                                                            {
  unsigned int exit_flag = 0, trig, n;

  for(n=0; n<640; n++) V[n]=V2[n]=0; //clear cro & xtrace buffers
  while(!exit_flag)                                                    {
	 while (!kbhit())                                                {
		for(frame=0; frame<5; frame++)                             {
	for(n=0; n<320; n++)                                  {
	  gap_control();
	  stepper();
	  tock(127)                               }  }  }

	 switch(getch())											{
		case '0': set_doubling(0);             break;
		case '1': set_doubling(1);             break;
		case '2': set_doubling(2);             break;
		case '3': set_doubling(3);             break;
		case '4': set_doubling(4);             break;
		case '5': set_doubling(5);             break;
		case '6': set_doubling(6);             break;
		case '7': set_doubling(7);             break;
		case '!': filter1(steep--); show();    break; // key sh-1
		case 'a': control=APPROACH;d=0;        break;
		case 'c': choice_parms();              break;
		case 'e': normalise();      show();    break;
		case 'E': normalise2();     show();    break;
		case 'f': flagging(3,'f',Vfilter^=1);  break;
		case 'H': show2();                     break;
		case 'l': load();                      break;
		case 'm': music(); /* test tones */    break;
		case 'n': render(1);                   break;
		case 'N': render(0);                   break;
		case 'o': flagging(4,'o',noise^=1);    break;
		case 'p': flagging(0,'p',noscan^=1);   break;
		case 'q': exit_flag=1;                 break;
		case 'r': control=RETRACT;
                          flagging(1,'r',1); break;
		case 's': control=SEEK;
								  flagging(1,'s',1); break;
		case 't': turn();           show();    break;
		case 'v': store();                     break; // "save"
		case 'w': show();                      break;
		case 'W': flagging(2,'W',whisper^=1);  break;
		case 'x': control=SEEK; Xtrace(WAIT);  break;
		case '-': move_marker(-1);             break;
		case '=': move_marker( 1);             break;
		case '_': move_marker(-9);             break;
		case '+': move_marker( 9);             break;
		case 'y': move_Vb_marker(-1);          break;
		case 'u': move_Vb_marker( 1);          break;
		case 'Y': move_Vb_marker(-9);          break;
		case 'U': move_Vb_marker( 9);          break;
		case '[': stepper_direction=0; stepcount=48; break;
		case ']': stepper_direction=1; stepcount=48; break;
		case '/': stepper_direction=0; stepcount= 1; break;
		case '*': stepper_direction=1; stepcount= 1; break;
		case '|': stepper_direction=0; stepcount=1920; break;

/*
case ';':                  write_byte(LOGIC_OUT,logicstat|0x01);  break;
case '*': logicstat|=0x80; write_byte(LOGIC_OUT,logicstat&0xFE);  break;
case '/': logicstat&=0x7F; write_byte(LOGIC_OUT,logicstat&0xFE);  break;
case ',': logicstat|=0x40; write_byte(LOGIC_OUT,logicstat&0xFE);  break;
case '.': logicstat&=0xBF; write_byte(LOGIC_OUT,logicstat&0xFE);  break;
*/

#ifdef sliders
		knobs
#endif
		default :  	    ;                           }
		CRO_viewport                                      }

		 //  ensure stepper is powered down
		write_byte(LOGIC_OUT,logicstat|0x01);                }


int main(void)         {
  init_graphics(2);
  start_timer();        // Used for sampling delays
  init_centron();
  Vb = -0x1A00;         // Set Vbias to -2.00V
  Iref = Vb -0x0600;    // set Iref to 0.5V above open circuit current
  move_marker(0);       // Display markers and force a "draw_ruler"
  move_Vb_marker(0);
  stepcount=8;          // stepper initialisation
  CRO_viewport
  set_doubling(0);      // Set the scan width
  cro();                // Main loop
#ifndef NOCARD          // PROTECT THE OUTPUTS:
  select_IO(VACANT);    // Remove ADC address from address decoder...
#endif         //  ...in case the next CENTRONICS operation is "Output Mode"
  stop_timer();
  closegraph();
  return 0;             }



