C     ***************************************************************
C     THIS IS A FORTRAN PROGRAM COMPUTES THE
C
C        I.   RADIATED POWER
C        II.  MAXIMUM DIRECTIVITY
C
C     OF ANY ANTENNA.  THE MAXIMUM DIRECTIVITY IS CALCULATED USING 
C     THE TRAILING EDGE METHOD IN INCREMENTS OF 1 DEGREE IN THETA 
C     AND 1 DEGREE IN PHI.
C
C        ** INPUT PARAMETERS
C        1. TL, TU:  LOWER AND UPPER BOUNDS IN THETA (IN DEGREES)
C        2. PL, PU:  LOWER AND UPPER BOUNDS IN PHI (IN DEGREES)
C        3. F(THETA,PHI):  THE RADIATION INTENSITY FUNCTION
C
C        ** NOTE:
C        THE RADIATION INTENSITY FUNCTION F MUST BE PROVIDED FOR A 
C        GIVEN ANTENNA, AND SHOULD BE INSERTED INTO THE SUBROUTINE U.
C
C        ** EXAMPLE:
C        IF THE ANTENNA IS RADIATING ONLY IN THE UPPER HEMISPHERE,
C        THE BOUNDS ON THETA ARE 0 AND 90 (DEGREES) AND THE BOUNDS
C        IN PHI ARE 0 AND 360 (DEGREES).
C     ***************************************************************
      
C                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                LE=FILNAM,STATUS='UNKNOWN')

      ELSE 
         WRITE(6,40)
         STOP

      ENDIF

C     Definition of constants and initialization
C     ------------------------------------------

      PI=4.0*ATAN(1.0)
      PRAD=0.0
      UMAX=0.0
      
C     Read lower and upper bounds on theta and phi
C     --------------------------------------------

      WRITE(6,50)
      READ(5,*,ERR=999) TL
      WRITE(6,60)
      READ(5,*,ERR=999) TU
      WRITE(6,70) 
      READ(5,*,ERR=999) PL
      WRITE(6,80)
      READ(5,*,ERR=999) PU

C     --------------------------Main Program--------------------------
C
      THETA=PI/180.0
      PHI=PI/180.0
      PLL=PL+1

      DO 1 J=PLL,PU
         XJ=FLOAT(J)*PI/180.0
         TLL=TL+1
         DO 2 I=TLL,TU
            XI=FLOAT(I)*PI/180.0
            CALL U(XI,XJ,F)
            IF (F.GT.UMAX) UMAX=F
            UA=THETA*PHI*F*SIN(XI)
            PRAD=PRAD+UA
 2       CONTINUE
 1    CONTINUE

      DR=4.0*PI*UMAX/PRAD
      DRDB=10.0*LOG10(DR)

C     Echo input parameters
C     ---------------------

      WRITE(DEVICE,90)
      WRITE(DEVICE,100) TL
      WRITE(DEVICE,110) TU
      WRITE(DEVICE,120) PL
      WRITE(DEVICE,130) PU

C     Output computed parameters
C     --------------------------

      WRITE(DEVICE,140)
      WRITE(DEVICE,150) PRAD
      WRITE(DEVICE,160) DR
      WRITE(DEVICE,170) DRDB


C     ********* FORMAT STATEMENTS *************************************

 5    FORMAT(3X,'WARNING: MAKE SURE YOU DEFINE THE RADIATION INTENSITY'
     $      ,/,3X,'-------  IN THE SUBROUTINE CALLED U() !!!!',/)

 10   FORMAT(3X,'OUTPUT DEVICE OPTION',/,6X
     $      ,'OPTION (1): SCREEN',/,6X,'OPTION (2): OUTPUT FILE',//,3X
     $      ,'OUTPUT DEVICE = ',$)

 20   FORMAT(I1)


 30   FORMAT(3X,'INPUT THE DESIRED OUTPUT FILNAME (in single quotes) = '
     &      ,$)

 40   FORMAT(/,3X,'*** ERROR ***',/,3X
     $      ,'OUTPUTING DEVICE NUMBER SHOULD BE EITHER 1 OR 2')

 50   FORMAT(/,3X,'THE LOWER BOUND OF THETA IN DEGREES = ',$)
 60   FORMAT(3X,'THE UPPER BOUND OF THETA IN DEGREES = ',$)
 70   FORMAT(3X,'THE LOWER BOUND OF PHI IN DEGREES = ',$)
 80   FORMAT(3X,'THE UPPER BOUND OF PHI IN DEGREES = ',$)

 90   FORMAT(/,3X,'INPUT PARAMETERS',/,3X,'================',/)

 100   FORMAT(3X,'THE LOWER BOUND OF THETA IN DEGREES = ',I3)
 110   FORMAT(3X,'THE UPPER BOUND OF THETA IN DEGREES = ',I3)
 120   FORMAT(3X,'THE LOWER BOUND OF PHI IN DEGREES = ',I3)
 130   FORMAT(3X,'THE UPPER BOUND OF PHI IN DEGREES = ',I3)

 140   FORMAT(/,3X,'OUTPUT PARAMETERS',/,3X,'=================',/)

 150   FORMAT(3X,'RADIATED POWER IN WATTS = ',F16.4)
 160   FORMAT(3X,'DIRECTIVITY (DIMENSIONLESS) = ',F16.4)
 170   FORMAT(3X,'DIRECTIVITY (dB) = ',F16.4)


      STOP                      ! END OF THE MAIN PROGRAM 

C     ********** ERROR CONDITIONS *************************************
C
 999     WRITE(6,1000)
 1000    FORMAT(/,3X,'***** ERROR *****',/,3X
     $         ,'INPUT DATA ARE NOT OF THE RIGHT FORMAT',/)


      END

C     *****************************************************************
C     Subroutine U:  Insert expression for radiation intensity, F
C
      SUBROUTINE U(THETA,PHI,F)
C     *****************************************************************
      REAL PI,THETA,PHI

      PI=4.0*ATAN(1.0)

C     Example of a Radiation Intensity, F:
C     ------------------------------------
      F=SIN(THETA)*(SIN(PHI))**2

      
      RETURN
      END


