C     ***************************************************************
C     THIS IS A FORTRAN PROGRAM THAT COMPUTES THE
C
C        I.   MAXIMUM DIRECTIVITY (DIMENSIONLESS AND IN dB)
C        II.  RADIATION RESISTANCE
C        III. INPUT RESISTANCE
C
C     FOR A SYMMETRICAL DIPOLE OF FINITE LENGTH.  THE DIPOLE IS 
C     RADIATING IN FREE SPACE.
C
C     THE DIRECTIVITY, RADIATION RESISTANCE AND INPUT RESISTANCE
C     ARE CALCULATED USING THE TRAILING EDGE METHOD IN INCREMENTS OF 
C     1 DEGREE IN THETA.
C
C        ** INPUT PARAMETERS
C        1.  L:  DIPOLE LENGTH (IN WAVELENGTHS)
C
C        ** NOTE:
C        THE FAR-ZONE ELECTRIC FIELD COMPONENT E-THETA EXISTS FOR
C        0 < THETA < 180 AND 0 < PHI < 360.
C     ***************************************************************
      
C     Declaration of Variables
C     ------------------------
      REAL L,TOL
      PARAMETER(TOL=1.0E-6)
      INTEGER DEVICE
      CHARACTER*12 FILNAM

C     ********** CHOICE OF OUTPUT ***********************************
C
      WRITE(6,10)
      READ(5,20,ERR=999) DEVICE

      IF(DEVICE .EQ. 1) THEN
         DEVICE=6

      ELSE IF(DEVICE .EQ. 2) THEN
         WRITE(6,30)
         READ(5,*,ERR=999) FILNAM
         OPEN(UNIT=DEVICE,FILE=FILNAM,STATUS='UNKNOWN')

      ELSE 
         WRITE(6,40)
         STOP

      ENDIF

C     Definition of constants and initialization
C     ------------------------------------------

      PI=4.0*ATAN(1.0)
      E=120.0*PI
      THETA=PI/180.0
      UMAX=0.0
      PRAD=0.0

C     Input the length of the dipole
C     ------------------------------

      WRITE(6,50)
      READ(5,*,ERR=999) L

      WRITE(DEVICE,60)
      WRITE(DEVICE,70) L

C     -------------------------- Main Program -------------------------

      A=L*PI
      DO 1 I=1,180
         XI=FLOAT(I)*PI/180.0
         IF (XI .EQ. PI) GO TO 2
         U=((COS(A*COS(XI))-COS(A))/SIN(XI))**2*(E/(8.0*PI**2))
         IF (U .GT. UMAX) UMAX=U
 2       CONTINUE
         UA=U*SIN(XI)*THETA*2.0*PI
         PRAD=PRAD+UA
 1    CONTINUE
      D=(4.0*PI*UMAX)/PRAD
      DDB=10.0*LOG10(D)
      RR=2.0*PRAD
      IF (A .EQ. PI) GO TO 3
      RIN=RR/SIN(A)**2

      
 3    WRITE(DEVICE,80)
      WRITE(DEVICE,90) D
      WRITE(DEVICE,100) DDB
      WRITE(DEVICE,110) RR

      IF (ABS(SIN(A)) .LT. TOL) THEN
         WRITE (DEVICE,130)
      ELSE
         WRITE (DEVICE,120) RIN
      ENDIF

C     ********* FORMAT STATEMENTS *************************************

 10   FORMAT(3X,'OUTPUT DEVICE OPTION',/,6X
     $      ,'OPTION (1): SCREEN',/,6X,'OPTION (2): OUTPUT FILE',//,3X
     $      ,'OUTPUT DEVICE = ',$)

 20   FORMAT(I1)

 30   FORMAT(3X,'INPUT THE DESIRED OUTPUT FILNAME (in single quotes) = '
     &      ,$)
 40   FORMAT(/,3X,'*** ERROR ***',/,3X
     $      ,'OUTPUTING DEVICE NUMBER SHOULD BE EITHER 1 OR 2')
 50   FORMAT(/,3X,'LENGTH OF DIPOLE IN WAVELENGTHS = ',$)


 60   FORMAT(/,3X,'INPUT PARAMETERS',/,3X,'================')
 70   FORMAT(/,3X,'LENGTH OF DIPOLE IN WAVELENGTHS = ',F16.4)

 80   FORMAT(/,3X,'OUTPUT PARAMETERS',/,3X,'=================',/)
 90   FORMAT(3X,'DIRECTIVITY (DIMENSIONLESS) = ',F16.4)
 100  FORMAT(3X,'DIRECTIVITY (dB) = ',F16.4)
 110  FORMAT(3X,'RADIATION RESISTANCE (Ohms) = ',F16.4)
 120  FORMAT(3X,'INPUT RESISTANCE (Ohms) = ',F16.4)
 130  FORMAT(3X,'INPUT RESISTANCE = INFINITY')

      STOP                      ! END OF THE MAIN PROGRAM 

C     ********** ERROR CONDITIONS *************************************
C
 999     WRITE(6,1000)
 1000    FORMAT(/,3X,'***** ERROR *****',/,3X
     $         ,'INPUT DATA ARE NOT OF THE RIGHT FORMAT',/)


      END



