program hwtest;         { PIC-Programmer hardware test. Version 1.0     }
uses delays,crt;        { Copyright (c), 1998, Jens Dyekjr Madsen - DK }

var
  ticks: longint absolute 0:$46c;       { Timer ticks                   }

procedure wait;                         { Wait 0.3s delay, or to key    }
var
  t: longint;
begin
  t:=ticks+6;
  repeat
  until (ticks>t) or keypressed;
end;

var
  comadr: array[1..4] of word absolute $0:$400; { Array at ComPort Addr }
  base: integer;                                { Base address for port }
  i: integer;                                   { Integer Counter       }
  v: integer;                                   { Integer Value variable}
begin
  val(paramstr(1),v,i);                         { Get Comport           }
  if (v<1) or (v>4) then                        { Check comport range   }
  begin                                         { Write help if error:  }
    writeln('Use:');
    writeln('   Test comport');
    halt;
  end;
  writeln('Testing Programmer at COM',v);       { Info                  }

  base:=comadr[v];                              { Setup Comport Base Adr}
  if base=0 then                                { Check if comport exist}
  begin
    writeln('- Comport not exist');
    halt;
  end;

  writeln;
  writeln('Press any key to abort');
  writeln;

  repeat                                        { Begin test            }
    port[base+3]:=$43;                          { Charge Capacitor      }
    port[base+4]:=0;                            { RTS, DTR high         }
    wait;                                       { Wait on charged       }
    shortdelay_on;
    port[base+3]:=3;                            { Reset TxD             }
    for i:=0 to 7 do                            { Send combinations     }
    begin
      if i=4 then port[base+3]:=$43;            { Send TxD              }
      port[base+4]:=i and 3;                    { Send RTS, DTR         }
      shortdelay;                               { Wait on input         }
      v:=(v shl 1)+(port[base+6] shr 4)and 1;   { Input Value from CTS  }
    end;
    shortdelay_off;

    port[base+3]:=$43;                          { DisCharge Capacitor   }
    port[base+4]:=3;                            { RTS, DTR high         }
    wait;                                       { Wait on discharged    }
    shortdelay_on;
    port[base+3]:=3;                            { Reset TxD             }
    for i:=0 to 7 do                            { Send combinations     }
    begin
      if i=4 then port[base+3]:=$43;            { Send TxD              }
      port[base+4]:=i and 3;                    { Send RTS, DTR         }
      shortdelay;                               { Wait on input         }
      v:=(v shl 1)+(port[base+6] shr 4)and 1;   { Input Value from CTS  }
    end;
    shortdelay_off;
    write(#13'Test Value: ',v:10);              { Output Test Value     }
  until keypressed;
end.
