#include <stdlib.h>
#include <stdio.h>
#include <fstream.h>
#include <time.h>
#include <string.h>
#include "blocklib.h"
#include "EncryptDES.h"

int keylength[]={0,8,8};

char* nullencryptor(const char data[8], const char* const key)
{       char* retval=new char[8];

        for (unsigned char i=0;i<8;i++)
                retval[i]=data[i];

        return retval;
}

char* XOR(const char data[8], const char* const key)
{       char* retval=new char[8];

        for (unsigned char i=0;i<8;i++)
                retval[i]=data[i]^key[i];

        return retval;
}

char* doDES_wrapper(const char data[8], const char* const key)
{       char* retval=new char[8];

        EncryptDES DESEngine;

        char vardata[8];
        char varkey[8];
        unsigned char i;

        for (i=0;i<8;i++)
                vardata[i]=data[i];

        for (i=0;i<8;i++)
                varkey[i]=key[i];

        DESEngine.doDES(vardata,varkey,retval);

        return retval;
}

char* undoDES_wrapper(const char data[8], const char* const key)
{       char* retval=new char[8];

        EncryptDES DESEngine;

        char vardata[8];
        char varkey[8];
        unsigned char i;

        for (i=0;i<8;i++)
                vardata[i]=data[i];

        for (i=0;i<8;i++)
                varkey[i]=key[i];


        DESEngine.undoDES(vardata,varkey,retval);

        return retval;
}

int main()
{       ifstream infile;
        ofstream outfile;

        int mode;
        int method;
        int direction;
		int keymode;
        char inname[129];
        char outname[129];

        char key[100];

        do
        {       cout<<"1 ... ECB\n";
                cout<<"2 ... CBC\n";
                cout<<"3 ... CFB\n";
                cout<<"4 ... OFB\n";
                cout<<"> ";
                cin>>mode;
        }
        while ((mode<1) || (mode>4));

        do
        {       cout<<"1 ... NullCypher\n";
                cout<<"2 ... XOR\n";
                cout<<"3 ... DES\n";
                cout<<"> ";
                cin>>method;
        }
        while ((method<1) || (method>4));

        do
        {       cout<<"1 ... Encrypt\n";
                cout<<"2 ... Decrypt\n";
                cout<<"> ";
                cin>>direction;
        }
        while ((direction<1) || (direction>2));

        do
        {       cout<<"Enter Source File > ";
                cin>>inname;
                infile.open(inname,ifstream::binary|ifstream::nocreate);
        }
        while (infile==NULL);

        do
        {       cout<<"Enter Target File > ";
                cin>>outname;
                outfile.open(outname,ofstream::out|ofstream::binary);
        }
        while (outfile==NULL);

		if (keylength[method-1]>0)
		{	do
			{       cout<<"1 ... Character Key\n";
					cout<<"2 ... ASCII Coded Key\n";
					cout<<"> ";
					cin>>keymode;
			}
			while ((keymode<1) || (keymode>2));

			if (keymode==1)
			{	do
				{	cout<<"Enter Key > ";
					cin>>key;
				}
				while (strlen(key)!=keylength[method-1]);
			}
			else
			{	cout<<"Enter Keybytes (decimal ASCII)\n";
				int keybyte;
				for (int i=0;i<keylength[method-1];i++)
				{	do 
					{	cout<<"["<<i+1<<"]: ";
						cin>>keybyte;
					}
					while ((keybyte<0) || (keybyte>255));
					
					key[i]=keybyte;
				}
			}
		}

        switch (mode)
        {       case 1: switch (method)
                        {       case 1: switch (direction)
                                        {       case 1: ECB_Encrypt(infile,outfile,key,nullencryptor);
                                                        break;
                                                case 2: ECB_Decrypt(infile,outfile,key,nullencryptor);
                                                        break;
                                        }
                                        break;
                                case 2: switch (direction)
                                        {       case 1: ECB_Encrypt(infile,outfile,key,XOR);
                                                        break;
                                                case 2: ECB_Decrypt(infile,outfile,key,XOR);
                                                        break;
                                        }
                                        break;
                                case 3: switch (direction)
                                        {       case 1: ECB_Encrypt(infile,outfile,key,doDES_wrapper);
                                                        break;
                                                case 2: ECB_Decrypt(infile,outfile,key,undoDES_wrapper);
                                                        break;
                                        }
                                        break;
                        }
                        break;
                case 2: switch (method)
                        {       case 1: switch (direction)
                                        {       case 1: CBC_Encrypt(infile,outfile,key,nullencryptor);
                                                        break;
                                                case 2: CBC_Decrypt(infile,outfile,key,nullencryptor);
                                                        break;
                                        }
                                        break;
                                case 2: switch (direction)
                                        {       case 1: CBC_Encrypt(infile,outfile,key,XOR);
                                                        break;
                                                case 2: CBC_Decrypt(infile,outfile,key,XOR);
                                                        break;
                                        }
                                        break;
                                case 3: switch (direction)
                                        {       case 1: CBC_Encrypt(infile,outfile,key,doDES_wrapper);
                                                        break;
                                                case 2: CBC_Decrypt(infile,outfile,key,undoDES_wrapper);
                                                        break;
                                        }
                                        break;
                        }
                        break;
                case 3: switch (method)
                        {       case 1: switch (direction)
                                        {       case 1: CFB_Encrypt(infile,outfile,key,nullencryptor);
                                                        break;
                                                case 2: CFB_Decrypt(infile,outfile,key,nullencryptor);
                                                        break;
                                        }
                                        break;
                                case 2: switch (direction)
                                        {       case 1: CFB_Encrypt(infile,outfile,key,XOR);
                                                        break;
                                                case 2: CFB_Decrypt(infile,outfile,key,XOR);
                                                        break;
                                        }
                                        break;
                                case 3: switch (direction)
                                        {       case 1: CFB_Encrypt(infile,outfile,key,doDES_wrapper);
                                                        break;
                                                case 2: CFB_Decrypt(infile,outfile,key,doDES_wrapper);
                                                        break;
                                        }
                                        break;
                        }
                        break;
               case 4: switch (method)
                        {       case 1: switch (direction)
                                        {       case 1: OFB_Encrypt(infile,outfile,key,nullencryptor);
                                                        break;
                                                case 2: OFB_Decrypt(infile,outfile,key,nullencryptor);
                                                        break;
                                        }
                                        break;
                                case 2: switch (direction)
                                        {       case 1: OFB_Encrypt(infile,outfile,key,XOR);
                                                        break;
                                                case 2: OFB_Decrypt(infile,outfile,key,XOR);
                                                        break;
                                        }
                                        break;
                                case 3: switch (direction)
                                        {       case 1: OFB_Encrypt(infile,outfile,key,doDES_wrapper);
                                                        break;
                                                case 2: OFB_Decrypt(infile,outfile,key,doDES_wrapper);
                                                        break;
                                        }
                                        break;
                        }
                        break;
        }

        infile.close();
        outfile.close();

        return 0;
}
