#ifndef blocklib_h
#define blocklib_h

#include <fstream.h>

// The following 4 Cryptographic modes can be used with any 64-bit Blockciphers,
// variable key length, that has the following interface:
// char* Cypher (const char data[8], const char* const key)

void ECB_Encrypt (istream& input,ostream& output,const char* const key,char* (*cipher) (const char[8],const char* const));
// The supplied cipher has to be in encoding mode.

void ECB_Decrypt (istream& input,ostream& output,const char* const key,char* (*cipher) (const char[8],const char* const));
// The supplied cipher has to be in decoding mode.

void CBC_Encrypt (istream& input,ostream& output,const char* const key,char* (*cipher) (const char[8],const char* const));
// The supplied cipher has to be in encoding mode.

void CBC_Decrypt (istream& input,ostream& output,const char* const key,char* (*cipher) (const char[8],const char* const));
// The supplied cipher has to be in decoding mode.

void CFB_Encrypt (istream& input,ostream& output,const char* const key,char* (*cipher) (const char[8],const char* const));
// The supplied cipher has to be in encoding mode.

void CFB_Decrypt (istream& input,ostream& output,const char* const key,char* (*cipher) (const char[8],const char* const));
// The supplied cipher has to be in ENCODING(!) mode.

void OFB_Encrypt (istream& input,ostream& output,const char* const key,char* (*cipher) (const char[8],const char* const));
// The supplied cipher has to be in encoding mode.

void OFB_Decrypt (istream& input,ostream& output,const char* const key,char* (*cipher) (const char[8],const char* const));
// The supplied cipher has to be in ENCODING(!) mode.

#endif