#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "EncryptDES.h"  //header-datei dieser klasse
#include "S_Boxes.cpp"   //s-boxen von manfred

   int EncryptDES::enabledumpbin = 0; //klassenvariable zur fehlersuche
   FILE *f;  //file zur fehlersuche und doku
   const bool LINE = 1;

// Tabelle der eingangspermutation IP
   const int TABLE_DES_IP[64] = {
   58,50,42,34,26,18,10, 2,
   60,52,44,36,28,20,12, 4,
   62,54,46,38,30,22,14, 6,
   64,56,48,40,32,24,16, 8,
   57,49,41,33,25,17, 9, 1,
   59,51,43,35,27,19,11, 3,
   61,53,45,37,29,21,13, 5,
   63,55,47,39,31,23,15, 7
   };

// Tabelle der ausgangspermutation FP:
   const int TABLE_DES_FP[64] = {
   40, 8,48,16,56,24,64,32,
   39, 7,47,15,55,23,63,31,
   38, 6,46,14,54,22,62,30,
   37, 5,45,13,53,21,61,29,
   36, 4,44,12,52,20,60,28,
   35, 3,43,11,51,19,59,27,
   34, 2,42,10,50,18,58,26,
   33, 1,41, 9,49,17,57,25
   };

// Tabelle fuer schluesselpermutation PC1:
   const int TABLE_DES_PC1[56] = {
   57,49,41,33,25,17, 9,
   1,58,50,42,34,26,18,
   10, 2,59,51,43,35,27,
   19,11, 3,60,52,44,36,
   63,55,47,39,31,23,15,
   7,62,54,46,38,30,22,
   14, 6,61,53,45,37,29,
   21,13, 5,28,20,12, 4
   };

// Tabelle PC2:
   const int TABLE_DES_PC2[48] = {
   14,17,11,24, 1, 5,
   3,28,15, 6,21,10,
   23,19,12, 4,26, 8,
   16, 7,27,20,13, 2,
   41,52,31,37,47,55,
   30,40,51,45,33,48,
   44,49,39,56,34,53,
   46,42,50,36,29,32
   };

// Tabelle fuer expansion E:
   const int TABLE_DES_E[48] = {
   32, 1, 2, 3, 4, 5,
   4, 5, 6, 7, 8, 9,
   8, 9,10,11,12,13,
   12,13,14,15,16,17,
   16,17,18,19,20,21,
   20,21,22,23,24,25,
   24,25,26,27,28,29,
   28,29,30,31,32, 1
   };

//  P-box
   const int TABLE_DES_P[32] = {
   16, 7,10,21,
   29,12,28,17,
   1,15,23,26,
   5,18,31,20,
   2, 8,24,14,
   32,27, 3, 9,
   19,13,30, 6,
   22,11, 4,25
   };

/*******************************************************************************
*  funktion doDES:
*  doDES gibt nach eingabe eines 8 Byte-Klartextwortes das verschluesselte
*  8 Byte Wort aus.
*  input: der zu verschluesselnde string von 8 byte lnge
*  key: der schluessel von 8 byte lnge
*  output: der verschluesselte string von 8 byte lnge
*  debug: debug = 1 gibt entwicklung der ausgabe aus
*******************************************************************************/
   void EncryptDES::doDES(char input[8], char key[8], char output[8]){
      doDES(input,key,output,0);//debug-modus off
   }

   void EncryptDES::doDES(char input[8], char key[8], char output[8], int debug){
   
      enabledumpbin = debug; //fuer debug-modus (file schreiben)
   
      if (enabledumpbin) {
         //file EncryptDES.txt anlegen zur dokumentation:
         f = fopen("encryptDES.txt", "w");
         if (f == NULL) {
            printf ("Kann file nicht anlegen!\n");
            dumpBin("Kann file nicht anlegen!\n");
         }
         dumpBin(LINE);
         dumpBin("Beginn Verschluesselung des Blockes:\n");
         dumpBin(LINE);
      	//eingegebenen klartext ausgeben:
         dumpBin("      Klartext: ");
         dumpBin(input);
      	//eingegebenen schluessel ausgeben:
         dumpBin("\n    Schluessel: ");
         dumpBin(key);
         dumpBin("\n");
      }
   
      bool chaine[64];   //eingabe als 64-bit block
      bool resultat[64]; //resultat als 64-bit block
      bool cle[64];      //schluessel
   
      //eingegebenen string in bitfeld umwandeln:
      strtobf(chaine, input);
      //eingegebenen schluessel in bitfeld umwandeln:
      strtobf(cle, key);
      //verschluesselung durchfuehren:
      encrypt(cle, resultat, chaine);
      //erhaltenes bitfeld in string umwandeln:
      bftostr(resultat, output);
   
      if (enabledumpbin) {
      
      //verschluesselten text ausgeben als hex:
         dumpBin(LINE);
         dumpBin("Verschluesselter Text  (hex): ");
         for (int i = 0; i < 8; i++)
            fprintf(f,"%x",(unsigned char)output[i]);
         dumpBin("\n");
         dumpBin(LINE);
      
      //datei schliessen:
         fclose(f);
      }
   
   }//ende doDES

/*******************************************************************************
*  funktion undoDES:
*  undoDES gibt nach eingabe eines 8 Byte-Chiffrewortes das entschluesselte
*  8 Byte Klartextwort aus.
*  input: der zu entschluesselnde string von 8 byte lnge
*  key: der schluessel von 8 byte lnge
*  output: der entschluesselte string von 8 byte lnge
*  debug: debug = 1 gibt entwicklung der ausgabe aus
*******************************************************************************/
   void EncryptDES::undoDES(char input[8], char key[8], char output[8]){
      undoDES(input,key,output,0);//debug-modus off
   }

   void EncryptDES::undoDES(char input[8], char key[8], char output[8], int debug){
   
      enabledumpbin = debug; //fuer debug-modus (file schreiben)
   
      if (enabledumpbin) {
         //file decryptDES.txt anlegen zur dokumentation:
         f = fopen("decryptDES.txt", "w");
         if (f == NULL) {
            printf ("Kann file nicht anlegen!\n");
            dumpBin("Kann file nicht anlegen!\n");
         }
      
         dumpBin(LINE);
         dumpBin("Beginn Entschluesselung des Blockes:\n");
         dumpBin(LINE);
      	//eingegebenen chiffretext ausgeben:
         dumpBin("      Chiffretext: ");
         dumpBin(input);
      	//eingegebenen schluessel ausgeben:
         dumpBin("\n    Schluessel: ");
         dumpBin(key);
         dumpBin("\n");
      }
   
      bool chaine[64];   //eingabe als 64-bit block
      bool resultat[64]; //resultat als 64-bit block
      bool cle[64];      //schluessel
   
      //eingegebenen string in bitfeld umwandeln:
      strtobf(chaine, input);
      //eingegebenen schluessel in bitfeld umwandeln:
      strtobf(cle, key);
      //verschluesselung durchfuehren:
      decrypt(cle, resultat, chaine);
      //erhaltenes bitfeld in string umwandeln:
      bftostr(resultat, output);
   
      if (enabledumpbin) {
      	//entschluesselten text ausgeben als hex:
         dumpBin(LINE);
         dumpBin("Entschluesselter Text: ");
         if (enabledumpbin)
            for (int i = 0; i < 8; i++)
               fprintf(f,"%c",(unsigned char)output[i]);
         dumpBin("\n");
         dumpBin(LINE);
      
      	//datei schliessen:
         fclose(f);
      }
   }//ende undoDES


/*******************************************************************************
*  funktion encrypt:
*  der funktion muss ein schlssel der lnge 64 bit, ein
*  bool-block der lnge 64 bit fr ausgabe, ein  bool-block der lnge 64 bit   *
*******************************************************************************/
   void EncryptDES::encrypt(bool key[64], bool outblk[64], bool inblk[64]) {
   
      bool r[32], l[32]; //zum aufteilen eines blocks in 2 teile
      bool fout[32];
      bool roundkey[56]; //fr den rundenschlssel
   
   //bildschirmausgabe und kontrolle:
      dumpBin("\n");
   //eingabestring in 2 haelften aufgeteilt:
      dumpBin("Eingabe(L)", inblk, 32);
      dumpBin("Eingabe(R)", inblk+32, 32);
   //schluessel in die beiden haelften aufgeteilt:
      dumpBin("Schluessel", key, 64);
   
   // erledigt die eingangspermutation (inititale permutation IP)
   // und teilt block in L und R:
      computeIP(l,r,inblk);
   
   //bildschirmausgabe zur kontrolle des linken und rechten blockes:
      dumpBin("Eing.-Perm.(L)", l, 32);
      dumpBin("Eing.-Perm.(R)", r, 32);
   
   //erzeugen des 1. rundenschluessels mittels schluesselpermutation,
   //anwenden der tabelle PC1:
      computeRoundKey(roundkey, key);
   
   //bildschirmausgabe fr kontrolle:
      dumpBin("perm.Schl.(C0)", roundkey, 28);
      dumpBin("perm.Schl.(D0)", roundkey+28, 28);
   
   //16 runden durchlaufen:
      for (int round = 0; round < 16; round++) {
      //bildschirmausgabe und kontrolle:
         dumpBin("\nBEGINNE VERSCHLUESSELUNG RUNDE: ", round+1);
         dumpBin(LINE);
         dumpBin("Rundenstart(L)", l, 32);
         dumpBin("Rundenstart(R)", r, 32);
      
      // rotiere rundenschlssel abhngig von der jeweiligen rundenanzahl:
      //in runde 1,2,9,16 wird rundenschluessel um 1 bit verschoben, ansonsten um 2 bit:
         rotateRoundKeyLeft(roundkey); //1x verschieben
      //in runde 3,4,5,6,7,8,10,11,12,13,14,15 um ein weiteres bit verschieben:
         if (round != 0 && round != 1 && round != 8 && round != 15)
            rotateRoundKeyLeft(roundkey);  //2.x verschieben
      //bildschirmausgabe und kontrolle:
         dumpBin("Rundenschl (C)", roundkey, 28);
         dumpBin("Rundenschl.(D)", roundkey+28, 28);
      
      //XOR-verknuepfung und s-boxen anwenden:
         computeF(fout, r, roundkey);
      //bildschirmausgabe und kontrolle:
         dumpBin("f(R,Schl.)", fout, 32);
      
      //mit dem Block L XOR verknuepfen:
         dumpBin("L", l, 32);
         for (int i = 0; i < 32; i++)
            l[i] ^= fout[i];  //XOR
         dumpBin("L XOR f(R,S.)", l, 32);
      
      //L und R wechseln fuer neue runde:
         exchange_L_and_R(l,r);
      
      //bildschirmausgabe und kontrolle:
         dumpBin("Rundenende(L)", l, 32);
         dumpBin("Rundenende(R)", r, 32);
      
         dumpBin(LINE);
      }//ende for schleife der runden
   
      dumpBin("\n");
   
   //L und R wechseln:
      exchange_L_and_R(l,r);
   
   /*zusammensetzen von L und R und ausgangspermutation anwenden: */
      computeFP(outblk,l,r);
   //bildschirmausgabe und kontrolle:
      dumpBin("Ausg.-Perm.(L)", outblk, 32);
      dumpBin("Ausg.-Perm.(R)", outblk+32, 32);
   
   }//ende encrypt

/*******************************************************************************
*  funktion decrypt:
*  der funktion muss ein schlssel der lnge 64 bit, ein
*  bool-block der lnge 64 bit fr ausgabe, ein  bool-block der lnge 64 bit   *
*******************************************************************************/
   void EncryptDES::decrypt(bool key[56], bool outblk[64], bool inblk[64]) {
      bool r[32], l[32]; //zum aufteilen eines blocks in 2 teile
      bool fout[32];
      bool roundkey[56]; //fr den rundenschlssel
   
   //bildschirmausgabe und kontrolle:
      dumpBin("\n");
   //eingabestring in 2 haelften aufgeteilt:
      dumpBin("Eingabe(L)", inblk, 32);
      dumpBin("Eingabe(R)", inblk+32, 32);
   //schluessel in die beiden haelften aufgeteilt:
      dumpBin("Schluessel", key, 64);
   
   // erledigt die inverse eingangspermutation (inverse inititale permutation IP-inverse)
   // und teilt block in L und R:
      computeIP(l,r,inblk);
   
   //bildschirmausgabe zur kontrolle des linken und rechten blockes:
      dumpBin("Eing.-Perm.(L)", l, 32);
      dumpBin("Eing.-Perm.(R)", r, 32);
   
   //erzeugen des 1. rundenschluessels mittels schluesselpermutation,
   //anwenden der tabelle PC1:
      computeRoundKey(roundkey, key);
   
   //bildschirmausgabe fr kontrolle:
      dumpBin("perm.Schl.(C0)", roundkey, 28);
      dumpBin("perm.Schl.(D0)", roundkey+28, 28);
   
   //16 runden durchlaufen:
      for (int round = 0; round < 16; round++) {
      //bildschirmausgabe und kontrolle:
         dumpBin("\nBEGINNE ENTSCHLUESSELUNG RUNDE: ", round+1);
         dumpBin(LINE);
         dumpBin("Rundenstart(L)", l, 32);
         dumpBin("Rundenstart(R)", r, 32);
      
      // rotiere rundenschlssel abhngig von der jeweiligen rundenanzahl:
      //in runde 1 wird rundenschluessel nicht verschoben
         if (round > 0) {
         //in runde 2,9,16 wird rundenschluessel um 1 bit verschoben, ansonsten um 2 bit:
            rotateRoundKeyRight(roundkey); //1x verschieben
         //in runde 3,4,5,6,7,8,10,11,12,13,14,15 um ein weiteres bit verschieben:
            if (round != 1 && round != 8 && round != 15)
               rotateRoundKeyRight(roundkey);  //2.x verschieben
         }
      //bildschirmausgabe und kontrolle:
         dumpBin("Rundenschl (C)", roundkey, 28);
         dumpBin("Rundenschl.(D)", roundkey+28, 28);
      
      //XOR-verknuepfung und s-boxen anwenden:
         computeF(fout, r, roundkey);
      //bildschirmausgabe und kontrolle:
         dumpBin("f(R,Schl.)", fout, 32);
      
      //mit dem Block L XOR verknuepfen:
         dumpBin("L", l, 32);
         for (int i = 0; i < 32; i++)
            l[i] ^= fout[i];  //XOR
         dumpBin("L XOR f(R,S.)", l, 32);
      
      //L und R wechseln fuer neue runde:
         exchange_L_and_R(l,r);
      
      //bildschirmausgabe und kontrolle:
         dumpBin("Rundenende(L)", l, 32);
         dumpBin("Rundenende(R)", r, 32);
      
         dumpBin(LINE);
      }//ende for schleife der runden
   
      dumpBin("\n");
   
   //L und R wechseln:
      exchange_L_and_R(l,r);
   
   /*zusammensetzen von L und R und inverse ausgangspermutation anwenden: */
      computeFP(outblk,l,r);
   //bildschirmausgabe und kontrolle:
      dumpBin("Ausg.-Perm.(L)", outblk, 32);
      dumpBin("Ausg.-Perm.(R)", outblk+32, 32);
   
   } //ende decrypt

/******************************************************************************/
/*  exchange_L_and_R:
 *  wechselt L und R
 ******************************************************************************/
   void EncryptDES::exchange_L_and_R(bool l[32], bool r[32]) {
   
      bool temp[32];
      for (int i = 0; i < 32; i++) {
         temp[i] = l[i];
         l[i] = r[i];
         r[i] = temp[i];
      }
   } //ende exchange_L_and_R

/******************************************************************************/
/*  computeRoundKey:
 *  erzeugt den 1. rundenschlssel aus key,
 *  der rundenschlssel wird in roundkey gespeichert
 *  anwendung der schluesselpermutation
 ******************************************************************************/

   void EncryptDES::computeRoundKey(bool roundkey[56], bool realkey[64]) {
   
   //schluessel permutieren:
      for (int i = 0; i < 56; i++)
         roundkey[i] = realkey[(TABLE_DES_PC1[i])-1];
   
   }//ende computeRoundKey

/******************************************************************************/
/*  rotateRoundKeyLeft:
 *  rotiert die 2 hlften des rundenschlssels um 1 bit nach links
 ******************************************************************************/
   void EncryptDES::rotateRoundKeyLeft(bool roundkey[56]) {
   
      dumpBin("Rotiere Key um eine Stelle nach links:\n");
      dumpBin("vor Rot. C", roundkey, 28);
      dumpBin("vor Rot. D", roundkey+28, 28);
   
      bool temp1, temp2;
      temp1 = roundkey[0];//erste stelle von C
      temp2 = roundkey[28];//erste stelle von D
   
      //nach links rotieren:
      for (int i = 0; i < 28; i++) {
         roundkey[i] = roundkey[i+1]; //linke haelfte C
         roundkey[i+28] = roundkey[i+28+1]; //rechte haelfte D
      }
   
      //letzte und 1. stelle austauschen:
      roundkey[27] = temp1;
      roundkey[55] = temp2;
      //dumpBin("nach Rot. C:", roundkey, 28);
      //dumpBin("nach Rot. D:", roundkey+28, 28);
   
   }//ende rotateRoundKeyLeft

/******************************************************************************/
/*  rotateRoundKeyRight:
 *  rotiert die 2 hlften des rundenschlssels um 1 bit nach rechts
 ******************************************************************************/
   void EncryptDES::rotateRoundKeyRight(bool roundkey[56]) {
   
      dumpBin("Rotiere Key um eine Stelle nach rechts:\n");
      dumpBin("vor Rot. C", roundkey, 28);
      dumpBin("vor Rot. D", roundkey+28, 28);
   
      bool temp1, temp2;
      temp1 = roundkey[27];//letze stelle von C
      temp2 = roundkey[55];//letze stelle von D
   
      //nach rechts rotieren:
      for (int i = 27; i > 0; i--) {
         roundkey[i] = roundkey[i-1]; //linke haelfte C
         roundkey[i+28] = roundkey[i+28-1]; //rechte haelfte D
      }
   
      //letzte und 1. stelle austauschen:
      roundkey[0] = temp1;
      roundkey[28] = temp2;
      //dumpBin("nach Rot. C:", roundkey, 28);
      //dumpBin("nach Rot. D:", roundkey+28, 28);
   
   }//ende rotateRoundKeyRight


/******************************************************************************/
/* computeIP:
*  erledigt die initiale permutation und teilt den block
*  in 2 hlften (L,R)
*******************************************************************************/
   void EncryptDES::computeIP(bool l[32], bool r[32], bool inblk[64]) {
      bool output[64];
	  int i;
   
   // initiale Permutation durchfuehren:
      for ( i = 0; i < 64; i++)
         output[i] = inblk[(TABLE_DES_IP[i])-1];
   
   // teilen in R und L: (2 32-bit bloecke)
   // Bit 0..31 zu L:
      for ( i =  0; i < 32; i++)
         l[i] = output[i];
   //Bit 32..63 zu R:
      for ( i = 32; i < 64; i++)
         r[i-32] = output[i];
   
   }// ende computeIP

/******************************************************************************/
/*  computeFP:
 *  setzt R und L wieder zusammen und
 *  erledigt die ausgangspermutation (invers zur eingangspermutation)
 ******************************************************************************/
   void EncryptDES::computeFP(bool outblk[64], bool l[32], bool r[32]) {
      bool input[64]; //speicher fuer L und R
	  int i;
   
   // setzt R und L wieder zusammen und speichert in input
      for ( i =  0; i < 32; i++)
         input[i] = l[i];
      for ( i = 32; i < 64; i++)
         input[i] = r[i-32];
   
   // Ausgangspermutation durchfhren:
      for ( i = 0; i < 64; i++)
         outblk[i] = input[(TABLE_DES_FP[i])-1];
   
   }// ende computeFP


/******************************************************************************/
/*  computeF:
 *  erweiterung (expansion) des teilblockes von 32 bit auf 48 bit,
 *  XOR Verknuepfung der Werte, s-boxen anwenden, p-permutation anwenden:
 ******************************************************************************/
   void EncryptDES::computeF(bool fout[32], bool r[32], bool roundkey[56]) {
      bool expandedblock[48], subkey[48], sout[32];
   
   //expandiere rechten block von 32 auf 48 Bit:
      computeExpansionE(expandedblock, r);
   //kontrolle und ausgabe:
      dumpBin("Expansion", expandedblock, 48);
   
   // erzeuge einen 48-bit subkey:
      computePC2(subkey, roundkey);
   //kontrolle und ausgabe:
      dumpBin("Subkey", subkey, 48);
   
   // XOR verknuepfung des schluessels und des expandierten blockes:
      for (int i = 0; i < 48; i++)
         expandedblock[i] ^= subkey[i]; //XOR verknuepfung der einzelnen bits
      dumpBin("XOR Exp.^Subk.", expandedblock, 48);
   
   //anwendung der s-boxen:
      dumpBin("---------------------- BEGINNE S-BOXEN-ANWENDUNG ---------------\n");
      computeS_Box(sout, expandedblock); //s-boxen anwenden
      dumpBin("zusammengef.", sout, 32); //kontrollausgabe
      dumpBin("---------------------- ENDE S-BOXEN-ANWENDUNG -----------------\n");
   
   //p-box-permutation durchfuehren:
      computeP(fout, sout);
      dumpBin("Permutation P", fout, 32);
   
   } //ende computeF

/*******************************************************************************
 *  computeP:
 *  erledige p-box-permutation:
*******************************************************************************/
   void EncryptDES::computeP(bool output[32], bool input[32]) {
   
   //p-Box anwenden:
      for (int i = 0; i < 32; i++)
         output[i] = input[TABLE_DES_P[i]-1];
   
   }//ende computeP

/*******************************************************************************
 * computeS_Box:
 * 48 bits in 8 x 6 bits aufteilen und doS_Box anwenden:
 ******************************************************************************/
   void EncryptDES::computeS_Box(bool out[32], bool in[48]) {
   
      bool part[6]; //zum speichern der 8 teile
      bool outvalue[4]; //zum speichern der ausgabe
      int k = 0, m = 0;
   
      for (int i = 0; i <  8; i++) {//8 teile durchlaufen
      
         for (int j = 0; j < 6; j++)
            part[j]=in[j+k]; //auslesen von je 6 bits
      
         dumpBin("Bitteil", part, 6); //kontrollausgabe
      
         k=k+6; // um die naechsten 6 bits auszulesen
      
         //s_box durchfuehren: ergebnis outValue
         //part 1 - 8 uebergeben und nr. der s-box uebergeben:
         doS_Box(outvalue, part, i+1);
      
         //ergebnis nach out schreiben:
         for (int l = 0; l < 4; l++)
            out[l+m]=outvalue[l];
      
         m=m+4;//out index erhoehen
      
      }//ende for
   
   }//ende computeS_Box

/*******************************************************************************
 * doS_Box:
 * liest 1. und letztes bit aus bitfolge von 6 bits aus und wendet diese
 * auf die s_boxen an, als zeile bzw. als spalte:
 * boxnumber bezeichnet die auswahl der jeweiligen s-box:
 ******************************************************************************/
   void EncryptDES::doS_Box(bool output[4], bool input[6], int boxnumber) {
   
    //s-boxen aus klasse s_boxen von manfred:
      S_Boxes boxes;
   
    //1. und letzte bit auslesen fuer auswahl der zeile:
      bool row[2];
      row[0]=input[0];
      row[1]=input[5];
    //aus zeile int machen:
      int introw;
      introw = (int)(row[1] + 2*row[0]);
   
    //restliche 4 bits zur auswahl der spalte:
      bool column[4];
      for (int i = 0; i <4; i++)
         column[i] = input[i+1];
   
    //aus spalte int machen:
      int intcolumn;
      intcolumn = (int)(column[3] + 2*column[2] + 4*column[1] + 8*column[0]);
   
   //kontrollausgaben:
      //dumpBin("Spalte bin", column, 4);
      //dumpBin("Zeile bin", row, 2);
      if (enabledumpbin) fprintf(f,"Spa./Zeile INT: %d; %d  ", intcolumn, introw);
   
    //s-boxen anwenden:
      int intout;
      switch(boxnumber) {
         case 1: intout = (int)boxes.s_box_1[introw] [intcolumn];
            dumpBin("  Wert S-Box 1:", intout);
            break;
         case 2: intout = (int)boxes.s_box_2[introw] [intcolumn];
            dumpBin("  Wert S-Box 2:", intout);
            break;
         case 3: intout = (int)boxes.s_box_3[introw] [intcolumn];
            dumpBin("  Wert S-Box 3:", intout);
            break;
         case 4: intout = (int)boxes.s_box_4[introw] [intcolumn];
            dumpBin("  Wert S-Box 4:", intout);
            break;
         case 5: intout = (int)boxes.s_box_5[introw] [intcolumn];
            dumpBin("  Wert S-Box 5:", intout);
            break;
         case 6: intout = (int)boxes.s_box_6[introw] [intcolumn];
            dumpBin("  Wert S-Box 6:", intout);
            break;
         case 7: intout = (int)boxes.s_box_7[introw] [intcolumn];
            dumpBin("  Wert S-Box 7:", intout);
            break;
         case 8: intout = (int)boxes.s_box_8[introw] [intcolumn];
            dumpBin("  Wert S-Box 8:", intout);
            break;
      } //ende switch auswahl s-boxen
   
    //integer wieder in bitstring umwandeln:
      output[3] = (intout & 1) ? 1 : 0;
      output[2] = (intout & 2) ? 1 : 0;
      output[1] = (intout & 4) ? 1 : 0;
      output[0] = (intout & 8) ? 1 : 0;
   
   }// ende doS_Box


/******************************************************************************/
/*  computePC2:
 *  anwendung der tabelle PC2
 ******************************************************************************/
   void EncryptDES::computePC2(bool subkey[48], bool roundkey[56]) {
   
     //subkey erzeugen:
      for (int i = 0; i < 48; i++)
         subkey[i] = roundkey[TABLE_DES_PC2[i]-1];
   }//ende computePC2

/******************************************************************************/
/*  computeExpansionE:
 *  erledigt die Expansion des Blockes von 32 Bit auf 48 Bit
 ******************************************************************************/
   void EncryptDES::computeExpansionE(bool expandedblock[48], bool r[32]) {
   
   //expansion durchfuehren:
      for (int i = 0; i < 48; i++)
         expandedblock[i] = r[(TABLE_DES_E[i])-1];
   
   }//ende computeExpansionE

/******************************************************************************/
/*  dumpBin:
 *  ausgabe des fortschrittes bei debug-modus:
 *  ausgabe wird in file EncryptDES.txt geschrieben
*******************************************************************************/
   void EncryptDES::dumpBin(char *str, int value) {
      if (enabledumpbin){
         fprintf(f,"%s %d \n", str, value); //string ausgeben
      }
   }

   void EncryptDES::dumpBin(bool lin) {
      if (enabledumpbin && (lin == 1))
         fprintf(f,"--------------------------------------------------------------------------------\n"); //linie ausgeben
   }

   void EncryptDES::dumpBin(char *str) {
      if (enabledumpbin){
         fprintf(f,"%s", str); //string ausgeben
      }
   }

   void EncryptDES::dumpBin(char *str, bool *b, int bits) {
      int i;
   //ausgabe der werte:
      if (enabledumpbin){
         //ausgabe des strings passend eingerueckt:
         for ( i = strlen(str); i < 14; i++)
            fprintf(f," ");     //einruecken
         fprintf(f,"%s: ", str); //string ausgeben
      
         //wert binaer ausgeben:
         for ( i = 0; i < bits; i++)
            fprintf(f,"%d", b[i]);
         fprintf(f,"\n");
      
      }//ende if
   } //ende dumpBin

/*******************************************************************************
 * string in bitfelder umwandeln und umgekehrt:
 ******************************************************************************/
 /* strtobf:
 // string zu einem bitfeld konvertieren:
 // uebergabe eines 8 byte strings, wird konvertiert in 64-bit BitString
 ******************************************************************************/
   void EncryptDES::strtobf(bool bitfield[64], char str[8]){
   
      dumpBin("\nchar in bitstring konvertieren:\n");
      dumpBin(LINE);
   
      int ascii[8]; //speicher fuer ascii zeichen des strings
      //string in ascii konvertieren:

	  int i;

      for ( i = 0; i < 8; i++)
         ascii[i]=(int) (unsigned char) (str[i]);
   
      //ascii in bits konvertieren:
      bool bitpart[8];//speicher der bits aus ascii, wird pro ascii zeichen 1 x verwendet
      int k = 0; //k zum fuellen des bitstrings laeuft von 0 bis 63
      for ( i = 0; i < 8; i++) {
        //konvertierung:
         bitpart[7] = (ascii[i] & 1) ? 1 : 0;
         bitpart[6] = (ascii[i] & 2) ? 1 : 0;
         bitpart[5] = (ascii[i] & 4) ? 1 : 0;
         bitpart[4] = (ascii[i] & 8) ? 1 : 0;
         bitpart[3] = (ascii[i] & 16) ? 1 : 0;
         bitpart[2] = (ascii[i] & 32) ? 1 : 0;
         bitpart[1] = (ascii[i] & 64) ? 1 : 0;
         bitpart[0] = (ascii[i] & 128) ? 1 : 0;
      
         for (int j = 0; j<8; j++)
            bitfield[k++]=bitpart[j];//bits in bitfield schreiben, k erhoehen
      
         if (enabledumpbin){
            fprintf(f,"CHAR:  %c   BIN: ", str[i]);//char wert ausgeben
            for (int l = 0; l < 8; l++) //bitwert ausgeben:
               fprintf(f,"%d", bitpart[l]);
            fprintf(f," ASCII: %d",  ascii[i]);//ascii wert ausgeben
            fprintf(f,"\n");
         }//ende if
      
      }//ende for
   
      //ausgabe des 64-bit strings:
      dumpBin("Bitstring", bitfield, 64);
   
   }//ende strtobf

/*******************************************************************************
// bftostr:
*  bit feld in string wandeln:
*  es wird ein 64 bit Bitstring bergeben und ein 8-byte char-string zurckgegeben
/******************************************************************************/
   void EncryptDES::bftostr (bool bitfield[64], char str[8]){
   
      dumpBin("\nBitstring in char konvertieren:\n");
      dumpBin(LINE);
   
      int ascii[8]; //zum speichern der ascii werte
   
      for (int i = 0; i < 8; i++) { //ascii werte auslesen:
        //binaer in int konvertieren:
         ascii[i] = (int)
            (  1*bitfield[7+(i*8)] +   2*bitfield[6+(i*8)] +
            4*bitfield[5+(i*8)] +   8*bitfield[4+(i*8)] +
            16*bitfield[3+(i*8)] +  32*bitfield[2+(i*8)] +
            64*bitfield[1+(i*8)] + 128*bitfield[0+(i*8)]   );
      
        //ascii werte in char konvertieren:
         if (enabledumpbin) {
            fprintf(f,"BIN: %d%d%d%d%d%d%d%d ",
               bitfield[0+(i*8)],bitfield[1+(i*8)],
               bitfield[2+(i*8)],bitfield[3+(i*8)],
               bitfield[4+(i*8)],bitfield[5+(i*8)],
               bitfield[6+(i*8)],bitfield[7+(i*8)]   );
         }//ende if
      
         //ascii in char konvertieren:
         str[i] = (unsigned char)ascii[i];
      
         if (enabledumpbin){
            fprintf(f,"CHAR: %c  ", str[i]);
            fprintf(f,"HEX: %x ",(unsigned char)str[i]);
            fprintf(f,"ASCII: %d \n", ascii[i]);
         }
      
      }//ende for
   
   }//ende bftostr

