; Programa que deja prendido un led 2 minutos y lo deja apagado 5 segundos

status		equ	0x03
porta		equ	0x05
trisa		equ	0x85
intcon		equ	0x0B
pir1		equ	0x0C
pie1		equ	0x8C
tmr1l		equ	0x0E
tmr1h		equ	0x0F
t1con		equ	0x10
contador	equ	0x20

org		0x00
		goto 	inicio

org		0x04
interrupcion	bcf	t1con, 0		; Detiene el Timer 1
		incf	contador, 1
		movlw	0xDB
		movwf	tmr1l
		movlw	0x0B
		movwf	tmr1h
		bcf	pir1, 0			; Clarea la bandera
		bsf	t1con, 0
		retfie						

org		0x0F
inicio		bsf	status, 5
		bsf	pie1, 0			; Habilita la interrupcion TMR1
		movlw	0x00
		movwf	trisa			; Puerto A de salida
		bcf	status, 5
		bsf	intcon, 7		; Habilta GIE
		bsf	intcon, 6
		movlw	0x34
		movwf	t1con

		bcf	porta, 0
	
ciclo		btfss	porta, 0
		call	prendido
		call	apagado
		goto	ciclo

apagado		bcf	porta, 0		; Apaga el led
		movlw	0x00
		movwf	contador
		movlw	0xDB
		movwf	tmr1l
		movlw	0x0B
		movwf	tmr1h
		bsf	t1con, 0		; Prende el TMR1
pro1		movlw	0x0A
		xorwf	contador, 0
		btfss	status, 2
		goto	pro1
		return

prendido	bsf	porta, 0		; Prende el led
		movlw	0x00
		movwf	contador
		movlw	0xDB
		movwf	tmr1l
		movlw	0x0B
		movwf	tmr1h
		bsf	t1con, 0		; Prende el TMR1
pro2		movlw	0xF0
		xorwf	contador, 0
		btfss	status, 2
		goto	pro2
		return

	END
		
		
