;PROYECTO INTEGRADOR
;Toma 3 datos distintos, hace conversin AD, almacena y muestra en displays mediante control externo

adcon0		equ		0x1F
adcon1		equ		0x9F
adresl		equ		0x9E
adresh		equ		0x1E
status		equ		0x03
porta		equ		0x05	; IA=<0:T,1:H,3:pH>[2,3,5]  ID=<2:c0,5:c1>[4,7]  N.I.=<4>
trisa		equ		0x85
portc		equ		0x07	; Van al 74LS47 [15,16,17]
trisc		equ		0x87
portd		equ		0x08	; Van a los 2N2222 [19,20,21,22]
trisd		equ		0x88
porte		equ		0x09	; Leds <0:T,1:H,2:pH> [8,9,10]
trise		equ		0x89
unidades	equ		0x21
decenas		equ		0x22
centenas	equ		0x23	
unmil		equ		0x24
temp1		equ		0x25
carga		equ		0x26

	org 0
	goto inicio

inicio		org 5
		bsf	status, 5
		movlw	0xFF
		movwf	trisa
		clrf	trisc
		clrf	trisd
		clrf	trise
		movlw	0x84
		movwf	adcon1			; Just:R	10000100   (DDD D|ADAA)

		bcf	status, 5

ciclo		NOP
		NOP
		btfss	porta, 2		; Testea c0
		goto	op0
		goto	op1

op0		btfsc	porta, 5		; Testea c1
		goto	op2
		movlw	0x01	
		movwf	porte			; Se prende led indicador de T [8]		(c1=0 y c0=0)
		call	temp
		goto	cuenta

op1		btfsc	porta, 5		; Testea c1
		goto	op3
		movlw	0x02
		movwf	porte			; Se prende led indicador de H [9]		(c1=0 y c0=1)
		call	hume
		goto	cuenta

op2		movlw	0x04
		movwf	porte			; Se prende led indicador de pH [10]		(c1=1 y c0=0)
		call	pH
		goto	cuenta

op3		movlw	0x07
		movwf	porte			; Se prenden todos los leds. Opcion no valida	(c1=1 y c0=1)
		goto	ciclo

temp		movlw	0x01
		movwf	adcon0			; Primera Conv. (T)	Fosc/2	CH0	00000001
		call	proceso   	
	return

hume		movlw	0x09
		movwf	adcon0			; Segunda Conv. (H)	Fosc/2	CH1	00001001
		call	proceso
	return
	
pH		movlw	0x19
		movwf	adcon0			;Tercera Conv.	(pH)	Fosc/2	CH3	00011001
		call	proceso
	return

proceso		NOP
		NOP
		bsf	adcon0, 2		; Arranca la conversion AD
pro1		btfsc	adcon0, 2
		goto	pro1
	return

cuenta		call	clarear
		btfsc	adresh, 0
		call	sumah0
		btfsc	adresh, 1
		call	sumah1
		bsf	status, 5
		movlw	0x00
		xorwf	adresl, 0
		btfsc	status, 2
		goto	disp
conteo						; Hace cuentas preguntando bit por bit
		bsf 	status, 5
		btfss 	adresl, 7
		goto 	n1
		bcf	status, 5
		movlw 	0x08
		addwf 	unidades, 1
		movlw 	0x02
		addwf 	decenas, 1 
		movlw 	0x01
		addwf 	centenas, 1
		call	prueba

n1 		bsf	status, 5
		btfss 	adresl, 6
		goto 	n2
		bcf	status, 5
		movlw 	0x04
		addwf 	unidades, 1
		movlw 	0x06
		addwf 	decenas, 1
		call	prueba

n2 		bsf	status, 5
		btfss 	adresl, 5
		goto 	n3
		bcf	status, 5
		movlw 	0x02
		addwf 	unidades, 1
		movlw 	0x03
		addwf 	decenas, 1
		call	prueba	

n3 		bsf	status, 5
		btfss 	adresl, 4
		goto 	n4
		bcf	status, 5
		movlw 	0x06
		addwf 	unidades, 1
		movlw 	0x01
		addwf 	decenas, 1
		call	prueba

n4		bsf	status, 5
		btfss 	adresl, 3
		goto 	n5
		bcf	status, 5
		movlw 	0x08
		addwf 	unidades, 1
		call	prueba

n5 		bsf	status, 5
		btfss 	adresl, 2
		goto 	n6
		bcf	status, 5
		movlw 	0x04
		addwf 	unidades, 1
		call	prueba

n6	 	bsf	status, 5
		btfss 	adresl, 1
		goto 	n7
		bcf	status, 5 
		movlw 	0x02
		addwf 	unidades, 1
		call	prueba

n7		bsf	status, 5
		btfss 	adresl,0
		goto	disp
		bcf	status, 5
		movlw 	0x01
		addwf 	unidades
		call 	prueba
	
disp		bcf	status, 5

		movf 	unidades, 0
          	movwf  	portc          ;se mueve unidades al puerto c
          	movlw   0x08 
          	movwf 	portd
          	call  	tiempo
          	clrf  	portd

          	movf	decenas, 0
          	movwf  	portc          ;se mueve decenas al puerto c
          	movlw 	0x04
          	movwf 	portd
          	call  	tiempo
          	clrf  	portd

	       	movf	centenas, 0
          	movwf 	portc          ;se mueve centenas al puerto c
          	movlw	0x02
          	movwf	portd
          	call 	tiempo
          	clrf 	portd

          	movf	unmil, 0
          	movwf	portc          ;se mueve unmil al puerto c
          	movlw  	0x01
          	movwf	portd
          	call 	tiempo
         	clrf 	portd
          	goto   	ciclo

clarear		clrf	unidades
		clrf	decenas
		clrf	centenas	
		clrf	unmil
	return

sumah0		movlw	0x06
		addwf	unidades, 1
		movlw	0x05
		addwf	decenas, 1
		movlw	0x02
		addwf	centenas, 1
	return

sumah1		movlw	0x02
		addwf	unidades, 1
		movlw	0x01
		addwf	decenas, 1
		movlw	0x05
		addwf	centenas, 1
	return

prueba		bsf	status, 0
		movlw 	0x0A
		movwf	carga
		movf	unidades, 0
		subwf	carga
		btfsc	status, 0
		return
		movlw	0x0A
		subwf	unidades, 1
		movlw	0x01
		addwf	decenas, 1
		bsf	status, 0
		movlw 	0x0A
		movwf	carga
		movf	decenas, 0
		subwf	carga
		btfsc	status, 0
		return
		movlw	0x0A
		subwf	decenas, 1
		movlw	0x01
		addwf	centenas, 1
		bsf	status, 0
		movlw 	0x0A
		movwf	carga
		movf	centenas, 0
		subwf	carga
		btfsc	status, 0
		return
		movlw	0x0A
		subwf	centenas, 1
		movlw	0x01
		addwf	unmil, 1
	return

tiempo  	movlw  	0xff
          	movwf  	temp1
loop      	decfsz 	temp1, 1
          	goto   	loop
	return	


       end	
