#include "stdio.h"
#include "conio.h"
#include "stdlib.h"
#include "graphics.h"
#include "dos.h"
#define NO 	0
#define YES 1

/*	Oswaldo Varela C. (Escuela Politcnica del Ejercito, Quito- Ecuador)
	Esta es una simple simulacin de gravedad, utilizando ciertas leyes, fisicas
	sin embargo, si se desea hacer un mtodo mas complejo, se deben utilizar
	fuerzas, mediante la segunda ley de Newton (F=m*a), donde se puede
	aplicar otros principios como la resistencia del aire, de aqui se derivan
	algunas formulas conocidas como:
	Vfinal = Vinicial + aceleracion * tiempo
	distancia = Vinicial * tiempo + 0.5 acelracion * tiempo^2
	Vfinal^2 = Vinicial^2 + 2 * aceleracion * distancia

	Ademas el programa esta utilizando un tiempo de retardo, pero se deberia
	trabajar con un mecanismo de reloj para tener mas precisin en los calculos
	y refrescos en la pantalla.
	Se debera tambien utilizar mecanismos de animacin utilizando varias
	paginas, donde se tendra un efecto mas 'suave' (smooth).
	Los conceptos basicos sobre esto se encuentran muy detallados en
	Denthor's Tutorials (english):
	http://www.csn.ul.ie/~darkstar/GFX/denthors.htm

	Este mecanismo resulta ideal para la animacin de personajes en varios
	videojuegos en general, complementado con la utilizacin de SPRITES se
	puede generar efectos bastante avanzados.
	(SPRITE: grafico almacenado en memoria, el cual puede ser desplegado en
	pantalla de manera inmediata; es utilizado para realizar animaciones.
	Este capitulo se encuentra detallado tambien en los tutoriales mencionados
	anteriormente.)*/

struct posicion{
	int y,x;
};

struct velocidad{
	int y,x;
};
/***************************************************************************/
class PERSONAJE{
	public:
	struct posicion pos;
	struct velocidad vel;
	int acelera;
	int saltando;
		void dibuja(int);
};
// funcion que dibuja el personaje en la posicion actual
void PERSONAJE::dibuja(int color){
	setcolor(color);
	circle(pos.x,pos.y,10);
	circle(pos.x,pos.y-3,3);
	circle(pos.x,pos.y-15,5);
	if(saltando==YES)rectangle(pos.x-2,pos.y+10,pos.x+2,pos.y+25);
	else rectangle(pos.x-10,pos.y+10,pos.x+10,pos.y+14);
}

/*************************** MAIN *****************************************/
void main(){
	int stop=0,delay_time=14;
	PERSONAJE Joe;
	int gdriver = DETECT, gmode;
	printf("Simulacin de Gravedad. Oswaldo Varela C. \n");
	printf("Presione + para aumentar tiempo de retardo y - para disminuirlo\n");
	printf("Teclas del 1..9 realizan salto de diferente magnitud\n");
	printf("Esc para salir...");
	getch();
	initgraph(&gdriver, &gmode, "");
	setcolor(12);
	line(0,415,639,415);//dibuja el piso
	Joe.pos.y = 400; //(posicion del piso)
	Joe.pos.x = 50;
	Joe.vel.y = 0;
	Joe.vel.x = 5;
	Joe.acelera = 2;
	Joe.saltando = NO;

	while(stop!=0x1b){   //Game loop, ciclo infinito hasta presionar ESC
		if (kbhit()){		//presiona una tecla
			stop=getch();
			if(stop=='+') delay_time++;
			if(stop=='-') if(delay_time>0)delay_time--;
			if( (stop>='1') && (stop<='9') ){//inicia salto
					Joe.vel.y = 5 * (stop-'0');   //determina velocidad inicial
					Joe.saltando = YES;
			}
		}
		if (Joe.saltando == YES){          //mueve a Joe si esta saltando
			Joe.vel.y = Joe.vel.y - Joe.acelera;//en este caso vel.y varia de 30 a -30
		}
		Joe.pos.y -= Joe.vel.y;				//mueve a Joe verticalmente
		Joe.pos.x += Joe.vel.x;				//mueve a Joe horizontalmente
		if(Joe.pos.x>640) Joe.vel.x=-5;//invierte velocidad si llega al limite
		if(Joe.pos.x<0) Joe.vel.x=5;//invierte velocidad si llega al limite de
												//la pantalla
		if (Joe.pos.y > 400){          //Chequea si Joe llega al piso
			Joe.vel.y = 0;
			Joe.pos.y = 400;
			Joe.saltando = NO;
		}

		Joe.dibuja(15); //rutina para dibujar a Joe
		delay(delay_time);
		Joe.dibuja(0);
	}
	closegraph();
}