#! /usr/bin/perl -w
# idleloop (idleloop -AT- yahoo.com), 20070729
#
# D-LINK DSL-G624T (and probably others), behaves in a very strange mode:
# as soon as a counter reaches 999999999 (1GByte), it start counting in
# increments of 10 Bytes, starting in 100000000 (10**8 instead of 10**9).
# This function tries to patch this behaviour, returning the correct value
# (multiplying by 10 if it's required), aided by a txt file which logs 
# previous values for each counter...
#
# NOTE: obviously, this script doesn't work if mrtg starts *after* the router
# reaches its 1GByte mark in any counter... in this case, open $LOG_FILE, 
# and just multiply by 10 the desired counter, and it'll work.
#
# A question that arises is what will occur when the router reaches again
# its 10**9 value? (=> 10GByte transmitted) ... if someone knows the answer,
# let me know, in order to accordingly modify this script ;)
#
# ($inlast,$outlast)=@{&manage_DLINK_SNMP_behaviour($router,$inlast,$outlast)}; # idleloop, 20070729
#
use strict;

sub manage_DLINK_SNMP_behaviour {

	my ($router,$inlast,$outlast)=@_;

	my $LOG_FILE='./manage_DLINK_SNMP_behaviour.log';

	my (%log_file_lines,$line,$difference,$i);
	my $parameters=[$inlast,$outlast];

	# if log file doesn't exist, create it,
	# in order for next check not to fail.
	if (!-e $LOG_FILE ||
		# also, if this file hasn't been written for long (2 times interval...),
		# values stored in log file aren't significant
		-M $LOG_FILE > 0.007 # > 10min (default interval=5min).
		) {
		open fLog, "> $LOG_FILE" || return $parameters;
		close fLog;
	}

	# read log file values
	open fLog, $LOG_FILE || return $parameters;
	while ($line=<fLog>) {
		if ($line !~ /^([^=]+)=(\d+);(\d+)/) { # admits 'garbage' after last number
			last; # ok, or error (so later there won't be the hash value)
		}
		$log_file_lines{$1}[0]=$2;
		$log_file_lines{$1}[1]=$3;
	}
	close fLog;

	# may be the file doesn't contain yet this counter
	if (!defined $log_file_lines{$router}) {
		$log_file_lines{$router}[0]=$$parameters[0];
		$log_file_lines{$router}[1]=$$parameters[1];
	}	

	# as $log_file_lines{$router} exists, continue trying to figure out if 1GB 
	# has been reached and the router is behaving the way this script expects...
	foreach $i (0..1) {
		$difference=$$parameters[$i]-$log_file_lines{$router}[$i];
		if ($difference<0 && $$parameters[$i]>10**8 && 
			 # a router reboot=> $$parameters[$i]<10**8, so it'd be handled ok.
			 # There are other type of counters which shouldn't be affected;
			 # modify here the conditions as required for your installation:
			 ($router=~/^\d+\.\d+\.\d+\.\d+/)
			 #($$parameters[$i]>10**4 && $log_file_lines{$router}[$i]>10**4) 
			) {
			$$parameters[$i]*=10;
		}
		$log_file_lines{$router}[$i]=$$parameters[$i]; # anyway, refresh counter.
	}

	# now, the log file must be written again, in order for next calls to
	# succesfully detect the strange behaviour (counter is now OK!)
	open fLog, "> $LOG_FILE" || return $parameters; # uhm...
	foreach (sort keys %log_file_lines) {
		print fLog $_.'='.$log_file_lines{$_}[0].';'.$log_file_lines{$_}[1]."\n";
	}
	close fLog;

	return $parameters;

}

1;
