#!/usr/bin/perl

###                         PRIMARY UBB SCRIPT                ##
#
# Ultimate Bulletin Board is copyright Infopop Corporation, 1998-2000.
#
#       ------------ postings.cgi -------------
#
#  This file contains the functionality for the UBB
#  postings (new topics, replies, etc.).
#
#  Infopop Corporation offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");

eval {

 ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "Date.pl";
require "mail-lib.pl";
require "mods.file";
require "ubb_library.pl";
require "ubb_library2.pl";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

use Socket;

&ReadParse;

$DisableSmiliesWording = qq(<INPUT TYPE="CHECKBOX" NAME="DisableSmilies" VALUE="yes"> <b>Disable Smilies in This Post</b>.);
$SmiliesLink = qq(<A HREF="$NonCGIURL/smilies.html" target=_blank>Smilies Legend</A>);
foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "forum") {
		$Forum = $Value;
		$Forum =~ s/\/\\//g;
		$ForumCoded = &HTMLIFY($Forum);
		$ForumCoded =~ tr/ /+/;
		$Forum = &UNHTMLIFY($Forum);
	}
	if ($Name eq "TopicSubject") {
		$TopicSubject = $Value;
		$TopicSubject =~ s/<.+?>//g;
		$TopicSubject = &UNHTMLIFY($TopicSubject);
	}
		if ($Name eq "UserName") {
		$UserName = $Value;
		$UserNameFile = $UserName;
		$UserNameFile =~ s/ /_/g; #remove spaces
	}
	if ($Name eq "BypassCookie") {
		$BypassCookie = $Value;
	}
	if ($Name eq "category") {
		$category = $Value;
	}
	if ($Name eq "PasswordConfirm") {
		$PasswordConfirm = $Value;
	}

	if ($Name eq "number") {
		$number = $Value;
		$number =~ s/\D//g;
	}
	if ($Name eq "DaysPrune") {
		$DaysPrune = $Value;
	}
	if ($Name eq "topic") {
		$topic = $Value;
	}

	if ($Name eq "Email") {
		$Email = $Value;
		$Email =~tr/A-Z/a-z/; 
	}
	if ($Name eq "URL") {
		$URL = &CleanThis($Value);
		$URL = &PipeCleaner($URL);
	}
	if ($Name eq "Permissions") {
		$Permissions = $Value;
	}
	if ($Name eq "Occupation") {
		$Occupation = &CleanThis($Value);
		$Occupation = &PipeCleaner($Occupation);
	}
	if ($Name eq "Location") {
		$Location = &CleanThis($Value);
		$Location = &PipeCleaner($Location);
	}
	if ($Name eq "TotalPosts") {
		$TotalPosts = $Value;
	}
	if ($Name eq "Status") {
		$Status = $Value;
	}
	if ($Name eq "Interests") {
		$Interests = &CleanThis($Value);
		$Interests = &PipeCleaner($Value);
	}
	if ($Name eq "sendto") {
		$sendto = $Value;
	}
}  # end FOREACH $row

if ($VariablesPath eq "") {
	$VariablesPath = $CGIPath;
}


if ($in{'action'} eq "doupdate") {
	if ($in{'UpdateForumChoice'} eq "ALL") {
		$number = 1;
	}  else {
		$number = $in{'UpdateForumChoice'};
		$number =~ s/\D//g;
	}
}


if (-e "$ForumsPath/Forum$number/forumstyles.file") {
require "$ForumsPath/Forum$number/forumstyles.file";
$use_forum_styles++;
}  else {
require "$VariablesPath/Styles.file";
}

$infopopcopy =~ s/\"\"/\"$CopyrightTextColor\"/; # fix missing copyright text color

if ($use_forum_styles) { # set above with -e

$Header = $ForumHeader unless ($ForumHeader eq '');
$Footer = $ForumFooter unless ($ForumFooter eq '');

}

if( ($Header ne '') || ($Footer ne '') ) {
	#create random numbers for headers/footers
	$RandomNumber = &MakeRandomNumber;
	$RandomNumber2 = $RandomNumber + 100074;

 if ($Header ne '') {
   $Header =~ s/UBBrandomX/$RandomNumber/isg;
   $Header =~ s/UBBrandomY/$RandomNumber2/isg;
 }
 if ($Footer ne '') {
   $Footer =~ s/UBBrandomX/$RandomNumber/isg;
   $Footer =~ s/UBBrandomY/$RandomNumber2/isg;
 }

} # end if header or footer



#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$NonCGIURL/$PageBackground");
}

if ($TableBorderColor ne ""){
$TableWidth2 = "100%";
$BorderTop = qq(<table border=0 cellpadding=0 cellspacing=0 width="$TableWidth"><TR><td bgcolor="$TableBorderColor">);
$BorderBottom = qq(</td></tr></table> );
}  else {
$TableWidth2 = $TableWidth;
$BorderTop = "";
$BorderBottom = "";
}


if ($in{'action'} eq "doupdate") {
&HackChecker;
&VerifyAdmin($UserName, $in{'Password'});

if ($Proceed eq "true") {
#determine number of total forums
@theforums = &OpenForumsFile;
$TotalForums = @theforums;

&ConvertForums2HTML("$number", "$TotalForums", "0");
}
} #end do update (threads) sr

if ($in{'action'} eq "ContinueUpdate") {
&ConfirmAdminCookie;
$number = $in{'number'};
$TotalForums = $in{'TotalForums'};
&ConvertForums2HTML("$number", "$TotalForums", "$in{'StartWith'}");
exit;
}
if ($BBStatus eq "OFF") {
&StandardHTML($BBClosedMessage);
exit;
}

$ReplyMessage = $in{'ReplyMessage'};
$Message = $in{'Message'};

@censored = split(/ /, $censorwords);

$TopicSubject = &CensorCheck("$TopicSubject");

$SubjectCoded = &HTMLIFY($TopicSubject);
$SubjectCoded =~ tr/ /+/;
	
if ($in{'action'} eq "reply") {
 &Reply;
 }  
if ($in{'action'} eq "postreply") {
 &PostReply;
 }  
  if ($in{'action'} eq "redoHTML") {
  
  @checkforprivate = &GetForumRecord($number);
  $LWA = $checkforprivate[6];
  $PrivateMax = $checkforprivate[13];
  $Forum = $checkforprivate[1];
  $Forum =~ s/\/\\//g;
	$ForumCoded = &HTMLIFY($Forum);
	$ForumCoded =~ tr/ /+/;
	$Forum = &UNHTMLIFY($Forum);
	
 &CreateThreadHTML("Forum$number", "$topic", "0", "1");
 
   $OldNumber = $in{'OldNumber'};
    @checkforprivateOLD = &GetForumRecord($OldNumber);
    $ForumOLD = $checkforprivateOLD[1];
&StandardHTML("Thank you!  We have transferred the topic as you requested.  You may proceed to either the original forum or the forum to which you transferred the topic.  Choose one:<P><A HREF=\"$CGIURL/forumdisplay.cgi?action=topics&number=$OldNumber\">$ForumOLD</a>  | <A HREF=\"$CGIURL/forumdisplay.cgi?action=topics&number=$number\">$Forum</A>");
exit;
 }
if ($in{'action'} eq "deletepost") {
 &DeletePost;
 } 
if ($in{'action'} eq "newtopic") {
 &NewTopic;
 }  
if ($in{'action'} eq "posttopic") {
 &PostTopic;
 }  
if ($in{'action'} eq "closethread") {
 &OpenCloseThread("close");
 }  
if ($in{'action'} eq "openthread") {
 &OpenCloseThread("open");
 }  
 if ($in{'action'} eq "processclose") {
 &ProcessClose;
 }  
if ($in{'action'} eq "editpost") {
@mess = &OpenThread("$topic");
$stats = $mess[0];
@statline = split(/\|\|/, $stats);

if ($statline[1] =~ /X/) {
	&StandardHTML("Sorry, but this thread is closed... you may not edit any posts in a closed thread.<P>Use your Back button.");
}  else {
 &EditPost;
 } 
 } #end editpost check
 
if ($in{'action'} eq "submitedit") {
 &SubmitEdit;
 } 
  
sub ForwardWithCookies {
my $URLwc = shift;
my $TEXTwc = shift;

&GetCookieInfo;
if ($SetCookies eq "DirectorySpecific") {
	$ExtraInfo = qq(domain=$TheDomain;path=/$ThePath;);
}  else {
	$ExtraInfo = "";
}
print <<CONFIRM;
<HTML><HEAD>
<meta http-equiv="Refresh" content="4; URL=$URLwc">
$HeaderInsert
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

expireDate = new Date;
if (expireDate.getYear() < 1900) {
expireDate.setYear(expireDate.getYear() + 1900 + 1);
} else {
expireDate.setYear(expireDate.getYear()+1);
}

var userName = getCookie("UserName");
var password = getCookie("Password");
var nameStorage = getCookie("NameStorage");

var CookieName = escape("$UserName");
var CookiePW = escape("$in{'Password'}");

if (CookiePW != null) {

	if ((nameStorage == "no") ||  (nameStorage == null)) {
	  	document.cookie = "UserName=" + CookieName + ";$ExtraInfo";
		document.cookie = "Password=" + CookiePW + ";$ExtraInfo";
	}
	if (nameStorage == "yes") {
	  	document.cookie = "UserName=" + CookieName + ";expires=" + expireDate.toGMTString() + ";$ExtraInfo";
document.cookie = "Password=" + CookiePW + ";expires=" + expireDate.toGMTString() + ";$ExtraInfo";
	}
}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor" marginheight=0 marginwidth=0 topmargin=0 leftmargin=0 rightmargin=0>
$Header
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
<B>$TEXTwc <p>Please wait while we create the new page ...
<br><br></font><FONT SIZE="1" FACE="$FontFace" COLOR="$LinkColor">
<A HREF="$URLwc">Click here if you do not want to wait any longer (or if your browser does not automatically forward you).</A>
</B>
</FONT>
</ul>
$Footer</body></html>
CONFIRM
}  ## END Forward With Cookies sr
 
sub Reply {
if ($in{'replyto'} =~ /[a-zA-Z\.]/) {
&StandardHTML("Sorry, you seem to be trying to hack this board.  This action is not permitted.");
exit;
}

#open thread message
@threadguts = &OpenThread("$topic");
$statline = $threadguts[0];
@stats = split(/\|\|/, $statline);

# if thread is closed, say so
if ($stats[1] =~ /X/) {
&StandardHTML("Sorry, but this thread is closed.  No additional replies are permitted on this topic.  You are free to start a new topic, however.<P>Use your back button to return.");
}  else {

@thisforum = &GetForumRecord($number);
$CustomTitle = $thisforum[9];
$PostPermissions = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);
$UBBCodeAllow = $thisforum[5];
if (($PostPermissions ne "private") && ($PostPermissions !~ /\&/)) {
&StandardHTML("We can not allow any new topics until your bulletin board administrator resets all control panel variables including the forum 'details'. This forum may be listed as 'Private' when it not or this board has not been completely updated yet.");
exit;
}

if ($PostPermissions eq "private") {
	$ReplyRestrict = "restrict";
}  else {
($junk, $ReplyRestrict) = split("&", $PostPermissions);
}

if ($ReplyRestrict eq "none") {
&StandardHTML("Sorry, replies to topics are not permitted in this forum.  Use your back button to return to the forum.");
exit;
}

#chomp the last field to remove carriage returns
$UBBImages = "$thisforum[10]";

if ($CustomTitle eq "") {
$CustomTitle = "$BBTitle";
}

&CheckCoding;

if ($ReplyRestrict eq "all") {
$RegistrationWording = qq(Registration is recommended, but not required, in order to post messages in this forum. Unless registered, you will not be able to edit messages after they are submitted.);
$RegistrationOffWording = qq(<tr $TableColorStrip><td colspan=2><FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor">If you are not registered, leave the password field below blank.</font></td></tr>);
}  else {
$RegistrationWording = qq(You must be registered in order to post a topic or reply in this forum.);
$RegistrationOffWording = "";
}
if ($DisplayRegistration eq "NO") {
$RegistrationOffWording = "";
}
	if (($AllowSignature eq "YES") && ($DisplayRegistration ne "NO")) {
	$ShowSignature = qq(<BR><INPUT TYPE="CHECKBOX" NAME="Signature" VALUE="yes"> <B>Show Signature:</B> include your profile  signature.  Only registered users may have signatures.);
	}  else {
	$ShowSignature = "";
	}
	
	
#check for direct reply
$ReplyTo = $in{'replyto'};

if (($ReplyTo ne "") && ($ReplyTo >= 0))  {
	$ReplyNumber = $ReplyTo;
	$ReplyNumber = $ReplyNumber + 0;
	$ReplyNumber = 	sprintf ("%6d", $ReplyNumber);
	$ReplyNumber =~tr/ /0/;
	FINDIT: foreach $checker(@threadguts) {
	@zline = split(/\|\|/, $checker);
	 if ($zline[1] eq "$ReplyNumber") {
		@PostFields = @zline;
		last FINDIT;
	}  else {
		@PostFields = @blank;
	}
	
	}
	$PostMess = $PostFields[6];
	$PostAuth = $PostFields[2];
	
	$CleanPostMess = &PrepForEdit($PostMess);
		## Get Rid of Previous Quotes
		$CleanPostMess =~ s/(\[QUOTE\])(.*)(\[\/QUOTE\]\n\r\n)//isg;
		
		## Strip off the Sig
		$CleanPostMess =~ s/------------------(.*)//isg;
		chomp($CleanPostMess);
		
	$InsertPostMess = "\[QUOTE\]Originally posted by $PostAuth:\n\[B\]$CleanPostMess\[/B\]\[/QUOTE\]"."\n\n";


}  else {
	$InsertPostMess = "";
}


#check to see if this forum is has restrictions on who can post to it-
if ($ReplyRestrict eq "restrict") {
	$LWADisclaimer = qq(Only administrators, moderators, and authorized registered users.);
$LWAField = qq(<tr $TableColorStrip><td colspan=2><B><FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">If you are an administrator or moderator, you do not need to type a forum password.  If you are not, you must supply the forum password in order to post a message in this forum, unless you have been given specific permission by your administrator.</FONT></B></td></tr><tr $TableColorStrip><td><FONT SIZE="$TextSize" FACE="$FontFace" color="$TableStripTextColor">Forum Password:</FONT></td><td><INPUT TYPE="TEXT" NAME="ForumPassword"
SIZE=10 MAXLENGTH=25></td></tr>);
	&ReplyFormHTML;
	} else {
	if ($ReplyRestrict eq "all") {
		$LWADisclaimer = "Anyone may post a reply.";
		$LWAField = "";
	}
		if ($ReplyRestrict eq "allreg") {
		$LWADisclaimer = "Any registered users may post a reply.";
		$LWAField = "";
	}
		&ReplyFormHTML;
}

($topicnum, $junk) = split(/\./, $topic);

if (($PostPermissions eq "private") && ($PrivateMax eq "yes")) {
	$GoTo = "$CGIURL/forumdisplay.cgi?action=displayprivate&number=$number&topic=$topicnum";
} else {
		$GoTo = "$NonCGIURL/$ExactPath/HTML/$topicnum.html";
}


&ReplyFormBottom;

} #end if/else thread is closed
}  ## END Reply SR #####

sub PrepForEdit {
my $Preppie = shift;
	&UNHTMLIFY($Preppie);
	$Preppie =~ s/<p>/\n\r\n/isg;
	$Preppie =~ s/<br>/\n/isg;
	$Preppie =~ s/<IMG SRC="$NonCGIURL\/smile.gif">/:\)/isg;
	$Preppie =~ s/<IMG SRC="$NonCGIURL\/frown.gif">/:\(/isg;
	$Preppie =~ s/<IMG SRC="$NonCGIURL\/biggrin.gif">/\:D/isg;
	$Preppie =~ s/<IMG SRC="$NonCGIURL\/wink.gif">/\;\)/isg;
	$Preppie =~ s/<IMG SRC="$NonCGIURL\/redface.gif">/\:o/isg;
$Preppie =~ s/<IMG SRC="$NonCGIURL\/tongue.gif">/:p/isg;
$Preppie =~ s/<IMG SRC="$NonCGIURL\/cool.gif">/:cool:/isg;
$Preppie =~ s/<IMG SRC="$NonCGIURL\/rolleyes.gif">/:rolleyes:/isg;
$Preppie =~ s/<IMG SRC="$NonCGIURL\/mad.gif">/:mad:/isg;
$Preppie =~ s/<IMG SRC="$NonCGIURL\/eek.gif">/:eek:/isg;
$Preppie =~ s/<IMG SRC="$NonCGIURL\/confused.gif">/:confused:/isg;

if ($UBBCodeAllow eq "is")  {
#convert UBB Code
$Preppie = &EditUBBConvert("$Preppie");
}
return($Preppie);
}

sub PostReply {
#&HackChecker;
@thisforum = &GetForumRecord($number);
$ThisForumName = $thisforum[1];
$ThisForumName = &decodeURL($ThisForumName);
$ThisForumName =~ s/"/&quot;/g;
$LWA = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);
$LWAPW = $thisforum[7];
$DIRPW= $LWAPW;
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
$ModNotify = $thisforum[11];
$ForumStatus = $thisforum[3];
chomp($ModNotify);

$CheckSubject = &decodeURL($in{'TopicSubject'});
if ($CheckSubject =~ /<.+>/) {
&StandardHTML("We cannot post this because it appears that you are tring to hack the topic subject.  Use your back button to try again.");
exit;
}

$CheckName = &decodeURL($in{'forum'});
			$CheckName =~ s/"/&quot;/g;

if ($CheckName ne "$ThisForumName") {
&StandardHTML("We cannot post this because the Forum Name being submitted does not match the forum name we have listed in our records.  Use your back button to try again.");
exit;
}

#Check IP Ban List--
#get user's IP number:
my $IPNumber = $ENV{'REMOTE_ADDR'};
my @IPbanlist = &OpenFile("$NonCGIPath/BanLists/IPBan.cgi");

if ($IPbanlist[0] ne "") {
my $bannum = "";
CheckIPBanList: for $bannum(@IPbanlist) {
	chomp($bannum);
	$bannum2 = quotemeta($bannum);
		if ($IPNumber =~ m/$bannum2/i) {
			&StandardHTML("Sorry, but your IP Number is currently banned in our forums.  You may not post or register on our site.  Your IP Number is: $IPNumber.<P>Please feel free to email us at $BBEmail if you have any questions.");
	exit;
		}
	}
} #if IPBan list is not empty


if ($LWA eq "private") {
	$ReplyRestrict = "restrict";
	&get_cookie;  #retrieves all current cookies
	$PasswordPrivate = "$cookie{PasswordPrivate}";
	$UserNamePrivate = "$cookie{UserNamePrivate}";
	$NumbersPrivate = "$cookie{ForumNumberPrivate}";
	&VerifyID;
	
	if ($ProceedNow ne "true") {
		&StandardHTML("This is a private forum and you have not been properly authorized to post to this forum.");
		exit;
	}
}  else {
	($junk, $ReplyRestrict) = split("&", $LWA);
}

if ($ReplyRestrict eq "none") {
&StandardHTML("Sorry, but replies are not permitted in this forum.  Use your back button to return to the forum.");
exit;
}

#verify that forum fields are complete

if (($in{'UserName'} eq "") || ($in{'ReplyMessage'} eq "") || ($topic eq "")) {
	&StandardHTML("You did not complete all required form fields! Please go back and re-enter.");
}
elsif (($ReplyRestrict ne "all") && ($in{'Password'} eq "")) {
		&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");

	}  else {

## See if this is an LWA Forum
if ($ReplyRestrict eq "restrict") {
$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {

	@theprofile = &OpenProfile("$ProfileNumber.cgi");
	if ($in{'Password'} eq "$theprofile[1]") {
		$Permission = "$theprofile[4]";
		($GenPerms, $SpecificPerms) = split(/\&/, $Permission);
		$Status = $theprofile[8];
		$EmailView = $theprofile[11];
		&CheckTheStatus;
		&CheckPermissions;
		$UserName = &decodeURL("$in{'UserName'}");
		&CheckModStatus("Forum$number", "$UserName");
		
		if ($SpecificPerms ne "") {
			chomp($specificPerms);
			@accessarray = split(",", $SpecificPerms);
			foreach $uno(@accessarray) {
				if ($uno eq "$number") {
					$PermissionGranted = "true";
				}
			}
		}
		#check forumpassword
		if (($in{'ForumPassword'} eq "$thisforum[12]") && ($thisforum[12] ne ""))  {
			$PermissionGranted = "true";
		}
	   	if (($AdminPermission eq "true") || ($ModMatch eq "yes")) {
	   &DoPostTheReply;
	   }
	   elsif ($PermissionGranted eq "true") {
	   &DoPostTheReply;
	   }  else {
	   &StandardHTML("Sorry, but you are not authorized to post a reply in this particular forum.  Only moderators, administrators, and users granted proper permission may post replies in this forum.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} else {
	   &DoPostTheReply;
	   
}#end if/else LWA = yes

} #end if/else field check
}  ## END Post Reply SR

sub DoPostTheReply {

#get current date/time
&GetDateTime;

##verify user name/password if necessary
$match = "no";
$verified = "false";

if (($ReplyRestrict eq "all") && ($in{'Password'} eq "")) {
#check to make sure they aren't using a registered name
&GetMemberListArray;
$lcthename = lc($UserName);

$_ = $lcthename;

if ((m/^\s/) || (m/\s$/) || (m/_{2,}/) || (m/\|\!/)) {
&StandardHTML("The User Name you attempted to use is illegal for one of the following reasons:<P><blockquote>1.  You may not begin or end a User Name with a space.  You may not have two or more consecutive spaces.<p>2.  You may not use a name with a pipestem followed by an exclamation point.</B></blockquote><p><CENTER>Use your back button to try again.</center>");
exit;
}

foreach $regname(@members) {
$lcregname = lc($regname);
if ($lcthename eq "$lcregname")  {
&StandardHTML("Sorry, but the name you attempted to use has been reserved by a registered member.  You do not have to register, but you must use a different name.  Please use your back button to try again.");
exit;
}
}

$match = "yes";
$verified = "true";
$PermissionToWrite = "true";
$UserNameRegister = "false";
}  else {

$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$match = "yes";
} else {
	$match = "no";
}

if ($match eq "yes") {
	@profilestats2 = &OpenProfile("$ProfileNumber.cgi");
	if ($profilestats2[1] eq "$in{'Password'}") {
				$verified = "true";
				$Email = "$profilestats2[2]";
				$Status = "$profilestats2[8]";
				$TotalPosts = "$profilestats2[7]";
				$Permission = "$profilestats2[4]";
				$EmailView = "$profilestats2[11]";
				$Signature = "$profilestats2[12]";
	}  #END IF profilestats
} #END IF match eq yes
	
if ($match eq "no") {
&StandardHTML("Sorry, but we have no one registered with the UserName you typed ($UserName).  Please try again.  Use your Back button.");
}

if ($match eq "yes" && $verified eq "false") {
&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}
} #end if/else lwa =includenonreg

if (($match eq "yes") && ($verified eq "true")) {

if ($in{'Password'} ne "") {
&CheckPermissions;
}

   if ($PermissionToWrite eq "true") {
   
   if ($FloodCheck eq "ON") {
#floodcheck courtesy of Michael Farris
   &floodcheck unless (($Status eq "Administrator") || ($Status eq "Moderator"));
   }
##create filenumber for reply 
@replier = &OpenThread("$topic");
@revreplier = reverse(@replier);

$statline = $replier[0];
$fatherline = $replier[1];
@papa = split(/\|\|/, $fatherline);
@stats = split(/\|\|/, $statline);

if ($stats[1] eq "X") {
&StandardHTML("You are attempting to post a reply to a thread that is now closed.");
exit;
}  

$replytotal = $stats[2];
$replytotal++;               #add one to reply total

$lastpost = $revreplier[0];
@lastpost = split(/\|\|/, $lastpost);

$lastnumber = $lastpost[1];
$lastnumber++;  #add 1 to last post number
$newreplynum = sprintf("%6d", $lastnumber);
$newreplynum =~tr/ /0/;

#now we have to add the new message to the thread file

## IF HTML is not allowed, render HTML useless
if ($HTMLAllow eq "is not") {
		$ReplyMessage =~ s/</&lt;/g;
		$ReplyMessage =~ s/>/&gt;/g;
} else {
#don't allow HTML SCRIPT TAGS
$ReplyMessage =~ s/<.*SCRIPT.*?<\/SCRIPT>//ig;

}
 
$ReplyMessage = &CensorCheck("$ReplyMessage");
$ReplyMessage2 = "$ReplyMessage";
$ReplyMessage = &Truncate("$ReplyMessage");
#Smiley/Frown conversion---

if ($in{'DisableSmilies'} ne "yes") {
$ReplyMessage = &Smilies("$ReplyMessage");
}
#UBB Code-ify (if allowed)
if ($UBBCodeAllow eq "is") {
$ReplyMessage = &UBBCode("$ReplyMessage");
} #END UBB CODE 

#convert newlines/carriage returns to HTML
$ReplyMessage = &ConvertReturns("$ReplyMessage");

#Check for Signature
if ($UserNameRegister ne "false") {
if (($AllowSignature eq "YES") && ($in{'Signature'} eq "yes")) {
$ReplyMessage .= ("<P>------------------<BR>$Signature");
}
}

$ReplyMessage= &PipeCleaner("$ReplyMessage"); 

#check for excess images-
if ($ReplyMessage =~ m/(.*\<img.+src=.*\.){8,}/i) {
	&StandardHTML("We cannot process your posting, because you have exceeded the maximum number of images allowed per post.  The current maximum is 8. ");
	exit;
}

($ThreadNo, $junk) = split(/\./, $topic);

## if email should not be displayed, don't
if (($EmailBlock eq "ON") || ($EmailView eq "no") || ($UserNameRegister eq "false")) {
$PostEmail = "";
}  else {
$PostEmail = "$Email";
}

#Get IP Number if IP logging is on
if (($IP eq "ON") || ($IP eq "LOGONLY")) {
	$IPNumber = $ENV{'REMOTE_ADDR'};
}


if (($ReplyRestrict eq "all") && ($UserNameRegister eq "true")) {
	$RegStatus = "reg";
}
elsif (($ReplyRestrict eq "all") && ($UserNameRegister eq "false")) {
$RegStatus = "unreg";
}  else {
$RegStatus = "reg";
}
## ICONS IDEA PROVIDED BY KOMBAT03- Thanks KOMBAT!
# ICON GRAPHICS AND SOME CODE PROVIDED BY KOMBAT03

my $MsgIcon = $in{'MsgIcon'};
if ($MsgIcon !~ /(\d|\d\d)/) {
	$MsgIcon = "";
}

$ReplyLine = ("Z||$newreplynum||$UserName||$HyphenDate||$Time||$PostEmail||$ReplyMessage||$IPNumber||$RegStatus||$MsgIcon");

push(@replier, $ReplyLine);

foreach $line(@replier) {
chomp($line);
if ($line =~ /^A/) {
	chomp($stats[4]);
	chomp($stats[5]);
	chomp($stats[6]);
	chomp($stats[7]);
	
	$newstats = "A||$stats[1]||$replytotal||$stats[3]||$stats[4]||$stats[5]||$stats[6]||$stats[7]";
	push(@updated, $newstats);
} else {
	push(@updated, $line);
}
}

#check to make sure files are writeable!!
if ($RegStatus eq "reg") {
unless (-w "$MembersPath/$ProfileNumber.cgi") {
chmod (0777, "$MembersPath/$ProfileNumber.cgi");
}
}

unless (-w "$ForumsPath/$ExactPath/$topic")  {
chmod (0777, "$ForumsPath/$ExactPath/$topic");
}

if (-w "$ForumsPath/$ExactPath/$topic")  {
#if topic file is writeable---

if (($LWA eq "private") && ($PrivateMax eq "yes")) {
	$GoTo = "$CGIURL/forumdisplay.cgi?action=displayprivate&number=$number&topic=$ThreadNo";
	$FileExt = "cgi";
} else {
		$GoTo = "$NonCGIURL/$ExactPath/HTML/$ThreadNo.html";
		$FileExt = "html";
	}
&ForwardWithCookies("$GoTo", "Thanks for posting your message, $UserName!  We are now sending you back automatically to this topic.");

&Lock("lock.file");
open (REPLY, ">$ForumsPath/$ExactPath/$topic");
foreach $post(@updated) {
chomp($post);
print REPLY ("$post\n");
}
close (REPLY);
&Unlock("lock.file");
chmod (0666, "$ForumsPath/$ExactPath/$topic");

if ($RegStatus eq "reg") {
##Add reply to user's profile (total posts)
$TotalPosts++;
#Bump user up to Member if Total Posts reaches $MemberMinimum
if (($TotalPosts >= $MemberMinimum)  && ($Status eq "Junior Member")) {
$profilestats2[8] = "Member";
} 

$profilestats2[7] = $TotalPosts;
&Lock("lock.file");
open (MEMBERSHIP, ">$MembersPath/$ProfileNumber.cgi") or die( &StandardHTML("Unable to open a file for writing in the Members directory. $!") );
foreach $instance(@profilestats2) {
	chomp($instance);
	print MEMBERSHIP ("$instance\n");
}
close (MEMBERSHIP);
&Unlock("lock.file");
chmod (0777, "$MembersPath/$ProfileNumber.cgi");
}

#update last time file
&Lock("lock.file");
open (LASTTIME, ">$ForumsPath/$ExactPath/lasttime.file") or die( &StandardHTML("Unable to open LastTime.file $!"));
print LASTTIME ("$HyphenDate\n");
print LASTTIME ("$Time\n");
close (LASTTIME);
&Unlock("lock.file");
chmod (0666, "$ForumsPath/$ExactPath/lasttime.file");

#update threads summary file
&CurrentDate;
if (-e "$ForumsPath/$ExactPath/forum$number.threads") {
&UpdateForumSummary($number, $topic);
}  else {
&ForumSummary($number);
}


##CREATE HTML FILE FOR NEW THREAD
&CreateThreadHTML("Forum$number", "$topic", "0", "1");

$Message = "$ReplyMessage";

if ($LWA eq "private") {
		&AppendPrivateIndex("$number", "$topic", "$LWAPW");
} else {
	if ($IndexMethod eq "ONEFILE") {
			&AppendIndex("$number", "$topic");
	} else {
			&AppendIndex2("$number", "$topic");
	}
}

##determine last topic number and increment by 1
@forumcounter = &OpenFile("$ForumsPath/$ExactPath/lastnumber.file");
$lastthreadnum = $forumcounter[0];
chomp($lastthreadnum);
$totthreadcount = $forumcounter[1];
chomp($totthreadcount);
$totpostcount = $forumcounter[2];
chomp($totpostcount);

$totpostcount++;

&Lock("lock.file");
open (FORUMCOUNT, ">$ForumsPath/$ExactPath/lastnumber.file"); 
print FORUMCOUNT ("$lastthreadnum\n");
print FORUMCOUNT ("$totthreadcount\n");
print FORUMCOUNT ("$totpostcount\n");
close (FORUMCOUNT);
&Unlock("lock.file");
chmod (0666, "$ForumsPath/$ExactPath/lastnumber.file");

($topicnum, $junk) = split(/\./, $topic);

# If Forum is set to Moderator Notify,
# need to send notification to forum moderator
if ($ModNotify eq "yes") {
$ModName = ("Forum" . "$number" . "Moderator");
$ModName = $$ModName;

#split up Mod var
@mods = split(/\|\|\^\|\|/, $ModName);

foreach $unomod(@mods) {

if ($unomod ne "") {
chomp($unomod);
$ProfNumber = &GetUserNumber($unomod);
@ModProfile = &OpenProfile("$ProfNumber.cgi");
$sendto = $ModProfile[2];
chomp($sendto);
$subject = "Moderator Notification: New Post in $Forum";

if ($sendto =~ /\S+\@\S+\.\S+/) {
$ReplyMessage =~ s/<BR>/\n/ig;
$ReplyMessage =~ s/<P>/\n\r\n/ig;
$ReplyMessage =~ s/<.+?>//g;

$message = "Hello, $unomod!  \n\r\n$UserName has just replied to the topic entitled - $TopicSubject - in the $Forum forum of $BBName. \n\r\nThis topic is located at $GoTo\n\r\nHere is what the user posted:\n\r\n$ReplyMessage";

if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}

}
} #if email is in valid format
} # end moderator name check- if blank, do not send email
} #end mod notify block

## IF TOPIC SET TO NOTIFY, THEN WE NEED TO GENERATE AN
## EMAIL MESSAGE TO SEND TO THE AUTHOR OF THE TOPIC

if ($stats[1] =~ /N/) {
$TopicWriter = $papa[2];
	#don't send if person replying is same as topic writer
	if ($TopicWriter ne "$UserName") {
	$ProfNum = &GetUserNumber($TopicWriter);
@topicw = &OpenProfile("$ProfNum.cgi");

$sendto = "$topicw[2]";
chomp($sendto);
$subject = "Notification: Reply to Your BB Topic";
$message = "Hello, \n\r\n $UserName has just replied to your topic entitled - $TopicSubject - in the $Forum forum of $BBName. \n\r\n This topic is located at $GoTo";
if ($sendto =~ /\S+\@\S+\.\S+/) {
if ($SMTPEmail eq "On") {
&SendEmail;
	}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
	}
}
	} #end if topic writer ne username
}  # end if extension = n

}  else {
#if topic file is still not writeable,
# then web host may be preventing writing new files-- don't process then

&StandardHTML("Sorry, we could not post your reply to this topic.  Contact your bulletin board administrator and inform them that they may have may run out of available disk space.  Their web host may be preventing them from posting new files.");
}

} else {
	if ($COPPAStatus eq 'true'){
	&StandardHTML("<p>Sorry, but you do not have permission to reply to this topic.</p><p>An Approval from your Parent or Guardian for your registration has not been received by the Administrator or your posting privileges have been removed.</p><p>You may also be trying to post to a forum where you do not have permission to post.</p>");
	}
	else {
	&StandardHTML("<p>Sorry, but you do not have permission to reply to this topic.</p><p>Your registration request may not yet may have been approved by the Administrator or your posting privileges have been removed.</p><p>You may also be trying to post to a forum where you do not have permission to post.</p>");
	}
} #END Check Permission block
}
} # end Do Post The Reply

sub NewTopic {
@thisforum = &GetForumRecord($number);
$CustomTitle = "$thisforum[9]";
$UBBImages = "$thisforum[10]";
$PostPermissions = $thisforum[6];


if ($PostPermissions eq "private") {
	$TopicRestrict = "restrict";
}  else {
($TopicRestrict, $junk) = split(/\&/, $PostPermissions);
}

if (($PostPermissions ne "private") && ($PostPermissions !~ /\&/)) {
&StandardHTML("We can not allow any new topics until your bulletin board administrator resets all control panel variables including the forum 'details'. This board has not been completely updated yet.");
exit;
}
if ($CustomTitle eq "") {
$CustomTitle = "$BBTitle";
}

&CheckCoding;

if ($TopicRestrict eq "all") {
$RegistrationWording = qq(Registration is recommended, but not required, in order to post messages in this forum. Unless registered, you will not be able to edit messages after they are submitted.);
$RegistrationOffWording = qq(<tr $TableColorStrip><td colspan=2><FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor">If you are not registered, leave the password field below blank.</font></td></tr>);
}  else {
$RegistrationWording = qq(You must be registered in order to post a topic or reply in this forum.);
$RegistrationOffWording = "";
}

if ($DisplayRegistration eq "NO") {
$RegistrationOffWording = "";
}
## if email is enabled, show notification wording

	if (($UseEmail eq "ON") && ($DisplayRegistration ne "NO"))  {
	$EmailNotificationHTML = qq(<INPUT TYPE="CHECKBOX" NAME="EmailNotification" VALUE="yes"> <B>Email Notification:</B> emails sent to you whenever someone replies. Only registered users are eligible.);
	}  else {
	$EmailNotificationHTML = "";
	}
	
	if (($AllowSignature eq "YES") && ($DisplayRegistration ne "NO")) {
	$ShowSignature = qq(<BR><INPUT TYPE="CHECKBOX" NAME="Signature" VALUE="yes"> <B>Show Signature:</B> include your profile  signature.  Only registered users may have signatures.);
	}  else {
	$ShowSignature = "";
	}

#check to see if this forum is there are posting restrictions
if ($TopicRestrict eq "restrict") {
$LWADisclaimer = qq(Only administrators, moderators, and authorized registered users.);
$LWAField = qq(<tr $TableColorStrip><td colspan=2><B><FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">If you are an administrator or moderator, you do not need to type a forum password.  If you are not, you must supply the forum password in order to post a message in this forum, unless you have been given specific permission by your administrator.</FONT></B></td></tr><tr $TableColorStrip><td><FONT SIZE="$TextSize" FACE="$FontFace" color="$TableStripTextColor">Forum Password:</FONT></td><td><INPUT TYPE="TEXT" NAME="ForumPassword"
SIZE=10 MAXLENGTH=25></td></tr>);
	} else {
	if ($TopicRestrict eq "all") {
		$LWADisclaimer = "Anyone may post a topic.";
		$LWAField = "";
	}
		if ($TopicRestrict eq "allreg") {
		$LWADisclaimer = "Any registered users may post a topic.";
		$LWAField = "";
	}
}
	&TopicFormHTML;
}  ## END NEWTOPIC SR ##

sub PostTopic {
#&HackChecker;

if (($in{'TopicSubject'} !~ /[a-zA-Z0-9]/) && ($EnglishSubjectCheck eq "ON")){
&StandardHTML("We cannot post your topic because it does not contain at least one letter or number.  Use your back button to try again.");
exit;
}


if ( ($in{'TopicSubject'} =~ /<.*>/) || ($in{'TopicSubject'} =~ /</) ) {
&StandardHTML("We cannot post your topic because the subject contains &lt; or &gt;.  Subjects may not contain this combination of those characters.  Use your back button to try again.");
exit;
}

@thisforum = &GetForumRecord($number);
$ThisForumName = $thisforum[1];
$ThisForumName = &decodeURL($ThisForumName);
$ThisForumName =~ s/"/&quot;/g;
$LWA = $thisforum[6];
$LWAPassword = &decodeURL($thisforum[7]);
$DIRPW = $LWAPassword;
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
$ModNotify = $thisforum[11];
$ForumStatus = $thisforum[3];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);

$CheckName = &decodeURL($in{'forum'});
			$CheckName =~ s/"/&quot;/g;

if ($CheckName ne "$ThisForumName") {
&StandardHTML("We cannot post your topic because the Forum Name being submitted does not match the forum name we have listed in our records.  Use your back button to try again.");
exit;
}

#set proper path if forum is private
if ($LWA eq "private") {
	$ThisPath = "Forum$number/private-$LWAPassword";
}  else {
	$ThisPath = "Forum$number";
}

if ($LWA eq "private") {
	$TopicRestrict = "restrict";
	&get_cookie;  #retrieves all current cookies
	$PasswordPrivate = "$cookie{PasswordPrivate}";
	$UserNamePrivate = "$cookie{UserNamePrivate}";
	$NumbersPrivate = "$cookie{ForumNumberPrivate}";
	&VerifyID;
	
	if ($ProceedNow ne "true") {
		&StandardHTML("This is a private forum and you have not been properly authorized to post to this forum.");
		exit;
	}
}  else {
($TopicRestrict, $junk) = split("&", $LWA);
}

#Check IP Ban List--
#get user's IP number:
my $IPNumber = $ENV{'REMOTE_ADDR'};
my @IPbanlist = &OpenFile("$NonCGIPath/BanLists/IPBan.cgi");

if ($IPbanlist[0] ne "") {
my $bannum = "";
CheckIPBanList: for $bannum(@IPbanlist) {
	chomp($bannum);
	$bannum2 = quotemeta($bannum);
		if ($IPNumber =~ m/$bannum2/i) {
			&StandardHTML("Sorry, but your IP Number is currently banned in our forums.  You may not post or register on our site.  Your IP Number is: $IPNumber.<P>Please feel free to email us at $BBEmail if you have any questions.");
	exit;
		}
	}
} #if IPBan list is not empty


## Verify form input
if (($in{'UserName'} eq "") || ($in{'TopicSubject'} eq "") || ($in{'Message'} eq "")) {
		&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
}
elsif (($TopicRestrict ne "all") && ($in{'Password'} eq "")) {
		&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
	
	}  else {

if ($TopicRestrict eq "restrict")  {
$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {

	@theprofile = &OpenProfile("$ProfileNumber.cgi");
	if ($in{'Password'} eq "$theprofile[1]") {
		$Permission = "$theprofile[4]";
		($GenPerms, $SpecificPerms) = split(/\&/, $Permission);
		$Status = $theprofile[8];
		$EmailView = $theprofile[11];
		&CheckTheStatus;
		&CheckPermissions;
				$UserName = &decodeURL("$in{'UserName'}");
		&CheckModStatus("Forum$number", "$UserName");
		
		if ($SpecificPerms ne "") {
			chomp($specificPerms);
			@accessarray = split(",", $SpecificPerms);
			foreach $uno(@accessarray) {
				if ($uno eq "$number") {
					$PermissionGranted = "true";
				}
			}
		}
		#check forumpassword
		if (($in{'ForumPassword'} eq "$thisforum[12]") && ($thisforum[12] ne "")) {
			$PermissionGranted = "true";
		}
		
	   	if (($AdminPermission eq "true") || ($ModMatch eq "yes")) {
	   &DoPostTheTopic;
	   }
	   elsif ($PermissionGranted eq "true") {
	   &DoPostTheTopic;
	   }  else {
	   &StandardHTML("Sorry, but you are not authorized to post a new topic in this particular forum.  Only moderators, administrators, and authorized users may post new topics in this forum.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} else {
	   &DoPostTheTopic;
	   
}#end if/else LWA = yes

} #end if/else field check
}  ## END POST TOPIC SR ###
 
sub DoPostTheTopic {

##get current date/time
&GetDateTime;

##verify user name/password if necessary
$match = "no";
$verified = "false";

if (($TopicRestrict eq "all") && ($in{'Password'} eq "")) {
#check to make sure they aren't using a registered name
&GetMemberListArray;
$lcthename = lc($UserName);
$_ = $lcthename;
if ((m/^\s/) || (m/\s$/) || (m/_{2,}/) || (m/\|\!/)) {
&StandardHTML("The User Name you attempted to use is illegal for one of the following reasons:<P><blockquote>1.  You may not begin or end a User Name with a space.  You may not have two or more consecutive spaces.<p>2.  You may not use a name with a pipestem followed by an exclamation point.</B></blockquote><p><CENTER>Use your back button to try again.</center>");
exit;
}

foreach $regname(@members) {
$lcregname = lc($regname);
if ($lcthename eq "$lcregname") {
&StandardHTML("Sorry, but the name you attempted to use has been reserved by a registered member.  You do not have to register, but you must use a different name.  Please use your back button to try again.");
exit;
}
}

$match = "yes";
$verified = "true";
$PermissionToWrite = "true";
$UserNameRegister = "false";
}  else {

$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$match = "yes";
} else {
	$match = "no";
}
if ($match eq "yes") {
	@profilestats2 = &OpenProfile("$ProfileNumber.cgi");
		chomp($profilestats2[1]);
	if ($profilestats2[1] eq "$in{'Password'}") {
				$verified = "true";
				$Email = "$profilestats2[2]";
				$Status = "$profilestats2[8]";
				$EmailView = "$profilestats2[11]";
				$TotalPosts = "$profilestats2[7]";
				$Permission = "$profilestats2[4]";
				$EmailView = "$profilestats2[11]";
				$Signature = "$profilestats2[12]";
	}  #END IF profilestats
} #END IF match eq yes
	
if ($match eq "no") {
&StandardHTML("Sorry, but we have no one registered with the UserName you typed.  Please try again.  Use your Back button.");
}

if ($match eq "yes" && $verified eq "false") {
&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}
} #end if/else 

if (($match eq "yes") && ($verified eq "true")) {

if ($in{'Password'} ne "") {
&CheckPermissions;
}

if ($PermissionToWrite eq "true") {

   if ($FloodCheck eq "ON") {
#floodcheck courtesy of Michael Farris
   &floodcheck unless (($Status eq "Administrator") || ($Status eq "Moderator"));
   }
##determine last topic number and increment by 1
if (-e "$ForumsPath/$ThisPath/lastnumber.file") {
   @forumcounter = &OpenFile("$ForumsPath/$ThisPath/lastnumber.file");
$lastthreadnum = $forumcounter[0];
chomp($lastthreadnum);
$totthreadcount = $forumcounter[1];
chomp($totthreadcount);
$totpostcount = $forumcounter[2];
chomp($totpostcount);
}  else {
$lastthreadnum = 0;
$totthreadcount = 0;
$totpostcount = 0;
}

$count = $lastthreadnum + 0;

if (($in{'EmailNotification'} eq "yes")  && ($UserNameRegister ne "false")) {
	$Notes = "N";
}  else {
	$Notes = "";
}

if ($count > 0) {
$lastthreadnum++;
$newtopic = sprintf("%6d", $lastthreadnum);
$newtopic =~tr/ /0/;
}  else {
$newtopic = "000001";
}
##create filenumber for new topic
$newtopicfile = ("$newtopic.cgi");

#now we have to add the message to the forum directory

## IF HTML is not allowed, render HTML useless
if ($HTMLAllow eq "is not") {
		$Message =~ s/</&lt;/g;
		$Message =~ s/>/&gt;/g;
}  else {
#don't allow HTML SCRIPT TAGS
$Message =~ s/<.*SCRIPT.*?<\/SCRIPT>//ig;

}

$Message = &CensorCheck("$Message");
$Message = &Truncate("$Message");
if ($in{'DisableSmilies'} ne "yes") {
$Message = &Smilies("$Message");
}

#UBB Code-ify (if allowed)
if ($UBBCodeAllow eq "is") {
$Message = &UBBCode("$Message");
} #end if UBB Code allowed

#convert newlines/carriage returns to <br> and <p> html tags
$Message = &ConvertReturns("$Message");


#Check for Signature
if ($UserNameRegister ne "false") {
if (($AllowSignature eq "YES") && ($in{'Signature'} eq "yes")) {
$Message .= ("<P>------------------<BR>$Signature");
}
}

$Message= &PipeCleaner("$Message"); 

#check for excess images-
if ($Message =~ m/(.*\<img.+src.*\.){8,}/i) { 
	&StandardHTML("We cannot process your posting, because you have exceeded the maximum number of images allowed per post.  The current maximum is 8. ");
	exit;
}

## if email should not be displayed, don't

if (($EmailBlock eq "ON") || ($EmailView eq "no") || ($TopicRestrict eq "any" && $UserNameRegister eq "false")) {
$PostEmail = "";
}  else {
$PostEmail = "$Email";
}

$TopicSubject =~ s/\|/&#0124;/sg;

#Get IP Number if IP logging is on
if (($IP eq "ON") || ($IP eq "LOGONLY")) {
	$IPNumber = $ENV{'REMOTE_ADDR'};
}

## ICONS IDEA PROVIDED By KOMBAT03- Thanks KOMBAT!
# ICON GRAPHICS AND SOME CODE PROVIDED BY KOMBAT03
$MsgIcon = $in{'MsgIcon'};
if ($MsgIcon !~ /(\d|\d\d)/) {
	$MsgIcon = "";
}
#create file lines
$StatsLine = "A||$Notes||0||$UserName||$TopicSubject||||$MsgIcon||";

if (($TopicRestrict eq "all") && ($UserNameRegister eq "true")) {
	$RegStatus = "reg";
}
elsif (($TopicRestrict eq "all") && ($UserNameRegister eq "false")) {
$RegStatus = "unreg";
}  else {
$RegStatus = "reg";
}

$FatherLine = "Z||000000||$UserName||$HyphenDate||$Time||$PostEmail||$Message||$IPNumber||$RegStatus||$MsgIcon";

### test to make sure member file is writeable!
if ($RegStatus eq "reg") {
unless (-w "$MembersPath/$ProfileNumber.cgi") {
chmod (0777, "$MembersPath/$ProfileNumber.cgi");
}
}

&ForwardWithCookies("$CGIURL/forumdisplay.cgi?action=topics&forum=$ForumCoded&number=$number&DaysPrune=$DaysPrune", "Thanks for posting your message, $UserName!  We are now taking you back automatically to the topic list for $Forum.");

&Lock("lock.file");
open (FORUM, ">$ForumsPath/$ThisPath/$newtopicfile"); 
print FORUM ("$StatsLine\n");
print FORUM ("$FatherLine\n");
close (FORUM);
&Unlock("lock.file");

chmod (0666, "$ForumsPath/$ThisPath/$newtopicfile");
if ($RegStatus ne "unreg") {
##Add reply to user's profile (total posts)
$TotalPosts++;
#Bump user up to Member if Total Posts reaches $MemberMinimum
if (($TotalPosts >= $MemberMinimum)  && ($Status eq "Junior Member")) {
$profilestats2[8] = "Member";
}

$profilestats2[7] = $TotalPosts;

&Lock("lock.file");
open (MEMBERS, ">$MembersPath/$ProfileNumber.cgi") or die( &StandardHTML("Unable to open Members directory. $!") );
foreach $instance(@profilestats2) {
	chomp($instance);
	print MEMBERS ("$instance\n");
}
close (MEMBERS);
&Unlock("lock.file");
chmod (0777, "$MembersPath/$ProfileNumber.cgi");
}  # end includenonreg check


##CREATE HTML FILE FOR NEW THREAD
&CreateThreadHTML("Forum$number", "$newtopicfile", "0", "1");

#update last time file
&Lock("lock.file");
open (LASTTIME, ">$ForumsPath/$ThisPath/lasttime.file") or die( &StandardHTML("Unable to open LastTime.file in $ThisPath : $!"));
print LASTTIME ("$HyphenDate\n");
print LASTTIME ("$Time\n");
close (LASTTIME);
&Unlock ("lock.file");
chmod (0666, "$ForumsPath/$ThisPath/lasttime.file");

#update last number file for forum
$totthreadcount++;
$totpostcount++;

&Lock("lock.file");
open (FORUMCOUNT, ">$ForumsPath/$ThisPath/lastnumber.file"); 
print FORUMCOUNT ("$newtopic\n");
print FORUMCOUNT ("$totthreadcount\n");
print FORUMCOUNT ("$totpostcount\n");
close (FORUMCOUNT);
&Unlock ("lock.file");
chmod (0666, "$ForumsPath/$ThisPath/lastnumber.file");


#update threads summary file
&CurrentDate;
if (-e "$ForumsPath/$ThisPath/forum$number.threads") {
@checkthis = &OpenFile("$ForumsPath/$ThisPath/forum$number.threads");
$TotalCheck = @checkthis;
$PreCount = $totthreadcount - 1;
if ($TotalCheck == $PreCount) {
&AppendForumSummary($number, $newtopicfile);
} else {
&ForumSummary($number);
}
}  else {
&ForumSummary($number);
}

if ($LWA eq "private") {
		&AppendPrivateIndex("$number", "$newtopicfile", "$LWAPW");
} else {
	if ($IndexMethod eq "ONEFILE") {
			&AppendIndex("$number", "$newtopicfile");
	} else {
			&AppendIndex2("$number", "$newtopicfile");
	}
}


# If Forum is set to Moderator Notify,
# need to send notification to forum moderator
if ($ModNotify eq "yes") {
$ModName = ("Forum" . "$number" . "Moderator");
$ModName = $$ModName;
#split up Mod var
@mods = split(/\|\|\^\|\|/, $ModName);

foreach $unomod(@mods) {

if ($unomod ne "") {
chomp($unomod);
$ProfNumber = &GetUserNumber($unomod);
@ModProfile = &OpenProfile("$ProfNumber.cgi");
$sendto = $ModProfile[2];
chomp($sendto);
$subject = "Moderator Notification: New Topic in $Forum";
$message = "Hello, $unomod!  \n\r\n$UserName has just created a new topic entitled - $TopicSubject - in the $Forum forum of $BBName. \n\r\n This BB is located at $CGIURL/Ultimate.cgi";

if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
} # end check for moderator name
} #end mod notify block
}


} else { # no permission to write

	if ($COPPAStatus eq 'true'){
	&StandardHTML("<p>Sorry, but you do not have permission to post a topic.</p>An Approval from your Parent or Guardian for your registration has not been received by the Administrator or your posting privileges have been removed.</p><p>You may also be trying to post to a forum where you do not have permission to post.</p>");
	}
	else {
	&StandardHTML("<p>Sorry, but you do not have permission to post a topic.</p><p>Your registration request may not yet may have been approved by the Administrator or your posting privileges have been removed.</p><p>You may also be trying to post to a forum where you do not have permission to post.</p>");
	}
}

}


} #end do post the topic sr


sub SubmitEdit {
#&HackChecker;
#verify that forum fields are complete

if (($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'EditedMessage'} eq "")) {
		&StandardHTML("You did not complete all required form fields! Remember that only registered users may edit their own posts.  Please go back and re-enter.");
	}  else {

## check UBB and HTML status for this forum
@thisforum = &GetForumRecord($number);
$ThisForumName = $thisforum[1];
$ThisForumName = &decodeURL($ThisForumName);
$ThisForumName =~ s/"/&quot;/g;

$DIRPW = $thisforum[7];
 chomp($thisforum[10]);
 ##
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
 
 ##
$ForumStatus = "$thisforum[3]";
$LWA = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);

$CheckSubject = &decodeURL($in{'TopicSubject'});
if ($CheckSubject =~ /</) {
&StandardHTML("We cannot post this because it appears that you are tring to hack the topic subject.  Use your back button to try again.");
exit;
}

$CheckName = &decodeURL($in{'forum'});
			$CheckName =~ s/"/&quot;/g;

if ($CheckName ne "$ThisForumName") {
&StandardHTML("We cannot post your topic because the Forum Name being submitted does not match the forum name we have listed in our records.  Use your back button to try again.");
exit;
}

if ($LWA eq "private") {
	&get_cookie;  #retrieves all current cookies
	$PasswordPrivate = "$cookie{PasswordPrivate}";
	$UserNamePrivate = "$cookie{UserNamePrivate}";
	$NumbersPrivate = "$cookie{ForumNumberPrivate}";
	&VerifyID;
	
	if ($ProceedNow ne "true") {
		&StandardHTML("This is a private forum and you have not been properly authorized to edit posts in this forum.");
		exit;
	}
}
&CheckCoding;

$Moderator = ("Forum" . "$number" . "Moderator");
$Moderator = $$Moderator;
#split up Mod var
@mods = split(/\|\|\^\|\|/, $Moderator);

$ModMatch = "";
foreach $unomod(@mods) {
if ($unomod eq "$UserName") {
	$ModMatch = "true";
}
}

## Get current message from file
@editthread = &OpenThread("$topic");
@stats = split(/\|\|/, $editthread[0]);
$TotReplies = $stats[2];
$TopicSubject = $stats[4];
chomp($TopicSubject);
$ArchiveNotes = $stats[5];
chomp($ArchiveNotes);
$TopicMsgIcon = $stats[6];
chomp($TopicMsgIcon);
$CloseNotes = $stats[7];
chomp($CloseNotes);

GETAUTHOR: foreach $line(@editthread) {
chomp($line);
#locate proper post within thread --
	if ($line =~ /^Z\|\|$in{'ReplyNum'}/) {
		@editline = split(/\|\|/, $line);
		$postUserName = $editline[2];
		last GETAUTHOR;
	}
} #end loop through thread

$postdate = $editline[3];
$posttime = $editline[4];
$postemail = $editline[5];
$origmessage = $editline[6];
$IPnum = $editline[7];
$regstatus = $editline[8];
chomp($regstatus);
chomp($origmessage);
$MsgIcon = $editline[9];
chomp($MsgIcon);

$Password = &decodeURL($in{'Password'});

$ProfileNumber = &GetUserNumber($UserName);
@profileinfo = &OpenProfile("$ProfileNumber.cgi");   

	
if (($postUserName eq "$UserName")  || ($ModMatch eq "true") || ($profileinfo[4] =~ m/Admin/)) {
#check password
	if ($profileinfo[1] eq "$Password") {
		&DoTheEdit;
	}  else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}

}  else {
&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
}
} #end Missing fields check if/else
}  #end SubmitEdit sr

sub DoTheEdit {

($ThreadNumber, $junk) = split(/\./, $topic);

if (($LWA eq "private") && ($PrivateMax eq "yes")) {
$FileExt = "cgi";
	$GoTo = "$CGIURL/forumdisplay.cgi?action=displayprivate&number=$number&topic=$ThreadNumber";
} else {
$FileExt = "html";
$GoTo = "$NonCGIURL/$ExactPath/HTML/$ThreadNumber.html";
}


if ($in{'DeletePost'} eq "yes") {

#check to make sure user is permitted--

unless ($EditOption eq "ON")  {
unless (($profileinfo[8] eq "Administrator")  || ($ModMatch eq "true")) {
&StandardHTML("Sorry, but only forum leaders are permitted to delete posts.");
exit;
}
} 

$GoTo2 = "$CGIURL/forumdisplay.cgi?action=topics&forum=$ForumCoded&number=$number";

$ThisThreadNumber = $ThreadNumber;

if ($in{'ReplyNum'} eq "000000") {
#delete entire topic/HTML page
unlink ("$ForumsPath/$ExactPath/$topic");
unlink ("$ForumsPath/$ExactPath/HTML/$ThreadNumber.$FileExt");
#update forum summary file and lasttime file
&UpdateForumDetails($number);

#update lastnumber.file
$TotReplies = $TotReplies + 0;
$TotThreadPosts = $TotReplies + 1;
&UpdateForumTotals("$number", 1, $TotThreadPosts, "yes");

#Don't remove from index- it is too process consuming
#&RemoveThreadFromIndex($number, $ThisThreadNumber);

#print to screen
&Forward("$GoTo2", "Thanks for deleting this topic, $UserName!  We are now sending you back automatically to the topic list for this forum.");
exit;
}  else {
#delete just this post
#subtract one from reply total
$ReplyTotal = $stats[2];
$ReplyTotal--;

#create revised stat line for thread
$newstatline = "A||$stats[1]||$ReplyTotal||$stats[3]||$TopicSubject||$ArchiveNotes||$TopicMsgIcon||$CloseNotes";

@newthread = @blank;
#loop thru thread, remove deleted post
foreach $uno(@editthread) {
	chomp($uno);
	if ($uno =~ m/^A/) {
		push(@newthread, $newstatline);
	} 
	elsif ($uno !~ m/^Z\|\|$in{'ReplyNum'}/) {
		push(@newthread, $uno);
	}  else {
	#don't add it
	}
}

#write new thread to file
&Lock("lock.file");

&CheckBadChars($in{'topic'});

open (NEWBIE, ">$ForumsPath/$ExactPath/$in{'topic'}");
for $theline(@newthread) {
chomp($theline);
print NEWBIE "$theline\n";
}
close(NEWBIE);
&Unlock("lock.file");

##CREATE HTML FILE FOR Revised THREAD
&CreateThreadHTML("Forum$number", "$topic", "0", "1");

#update forum summary file and threads file
&UpdateForumDetails($number);

#update total post total on lastnumber.file
&UpdateForumTotals("$number", 0, 1, "no");

}
#print to screen
&Forward("$GoTo", "Thanks for deleting the post, $UserName!  We are now sending you back automatically to the page you just modified.");


}  

elsif ($in{'IPDisplay'} eq "yes") {

unless ( ($ModMatch eq "true") || ($profileinfo[4] =~ m/Admin/)) {
&StandardHTML("Sorry, you are not permitted to view IP Numbers.");
exit;
}
@thistopic = &OpenFile("$ForumsPath/$ExactPath/$topic");

foreach $uno(@thistopic) {
@thisline = split(/\|\|/, $uno);
	if ($thisline[1] eq "$in{'ReplyNum'}") {
		$ThisIP = "$thisline[7]";
		$ThisName = "$thisline[2]";
		$ThisMessage = "$thisline[6]";
	}  
}

if ($ThisIP eq "") {
&StandardHTML("Sorry, we could not find a record for that post.  Perhaps someone recently deleted it.");
exit;
}
print<<CLOSE;
<HTML><HEAD><TITLE>IP Display</TITLE>
$HeaderInsert
</HEAD>
<BODY $PageBackground $BGColor Text="$TextColor" LINK="$LinkColor" alink="$ActiveLinkColor" VLINK="$VisitedLinkColor" marginheight=0 marginwidth=0 topmargin=0 leftmargin=0 rightmargin=0><FONT FACE="$FontFace" SIZE="$TextSize" COLOR="$TextColor">
$Header
<P>
<center>
I P &nbsp;&nbsp;&nbsp;&nbsp; D I S P L A Y
<P><FONT FACE="$FontFace" SIZE="1" COLOR="$TextColor">
Return to: <A HREF="$CGIURL/forumdisplay.cgi?action=topics&forum=$ForumCoded&number=$number">Forum</A> | <A HREF="$GoTo">Topic</A></font>
<P>
$BorderTop
<table border=0 cellpadding=4 border=0 cellspacing=1 width=$TableWidth2>
<TR $TableColorStrip><TD colspan=2><FONT FACE="$FontFace" SIZE="$TextSize" COLOR="$TableStripTextColor"><b>Here is the requested IP number:</FONT></B></td></tr>
<TR $AltColumnColor1><TD><B><FONT FACE="$FontFace" SIZE="$TextSize">IP Number</B></FONT></TD><TD>
<B><FONT FACE="$FontFace" SIZE="$TextSize">$ThisIP</FONT></B>
</td></tr>
<TR $AltColumnColor2><TD valign=top><B><FONT FACE="$FontFace" SIZE="$TextSize">
<B>Post:</B></FONT>
</B></TD>
<TD><FONT FACE="$FontFace" SIZE="1">posted by $ThisName</font><HR><FONT FACE="$FontFace" SIZE="$TextSize">
$ThisMessage</FONT>
</td></tr></TABLE>
$BorderBottom
<P>
</CENTER>
<p><BR><BR>
$Footer
</font>
</BODY></HTML>
CLOSE


}  else {
## format the edited message
$EditedMessage = $in{'EditedMessage'};

## IF HTML is not allowed, render HTML useless
if ($HTMLAllowed eq "no") {
		$EditedMessage =~ s/</&lt;/g;
		$EditedMessage =~ s/>/&gt;/g;
} else {
#don't allow HTML SCRIPT TAGS
$EditedMessage =~ s/<SCRIPT.*?<\/SCRIPT>//ig;
}
 
$EditedMessage = &CensorCheck("$EditedMessage");
#truncate extra long words
$EditedMessage = &Truncate("$EditedMessage");
#Smiley/Frown conversion---
if ($in{'DisableSmilies'} ne "yes") {
$EditedMessage = &Smilies("$EditedMessage");
}
#UBB Code-ify (if allowed)
if ($UBBCodeAllow eq "is") {
$EditedMessage = &UBBCode("$EditedMessage");
} #END UBB CODE 

#convert newlines/carriage returns to HTML
$EditedMessage = &ConvertReturns("$EditedMessage");

&GetDateTime;

if ($DateFormat eq "US") {
	$EditDate = $HyphenDate;
}
elsif ($DateFormat eq "Euro") {
	$EditDate = "$EuroDate"
}
elsif ($DateFormat eq "USX") {
	$EditDate = &DateFormat("$HyphenDate", "USExpanded");
} else {
	$EditDate = &DateFormat("$HyphenDate", "EuroExpanded");
}

# append edit note to the message
$EditedMessage .= qq(<p>[This message has been edited by $UserName (edited $EditDate).]);

$EditedMessage= &PipeCleaner("$EditedMessage"); 

#check for excess images-
if ($EditedMessage =~ m/(.*\<img.+src=.*\.){8,}/i) {
	&StandardHTML("We cannot process your posting, because you have exceeded the maximum number of images allowed per post.  The current maximum is 8. ");
	exit;
}

$EditLine = "Z||$in{'ReplyNum'}||$postUserName||$postdate||$posttime||$postemail||$EditedMessage||$IPnum||$regstatus||$MsgIcon";

foreach $one(@editthread) {
	chomp($one);
		if ($one =~ /^Z\|\|$in{'ReplyNum'}/) {
			push (@revised, $EditLine);
		}  else {
			push (@revised, $one);
		}
}

#open thread for writing

&Lock("lock.file");

&CheckBadChars($topic);

open (POST, ">$ForumsPath/$ExactPath/$topic");
foreach $thisone(@revised) {
chomp($thisone);
print POST ("$thisone\n");
}
close(POST);
&Unlock("lock.file");

($TopicNum, $junk) = split(/\./, $topic);

&Forward("$GoTo", "Thanks for editing the message, $UserName!  We are now sending you back automatically to the topic page.");

chomp($origmessage);
$OrigText = &Indexify("$origmessage");

##CREATE HTML FILE FOR Revised THREAD
&CreateThreadHTML("Forum$number", "$topic", "0", "1");
}  #end if/else
}  # end DoTheEdit sr

sub ReplyFormHTML {
if ($DisplayRegistration eq "NO") {
$WantRegWording = "";
$ForgetPW = "";
$ForgotPW2 = "";
$RegWordingField = "";
$PWField = "";
$CookieStuff = qq%document.REPLIER.UserName.focus();%;
} else {
$WantRegWording = qq(<FONT SIZE="1" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=agree">Want to register?</a></FONT>);
$ForgetPW = qq(<FONT SIZE="1" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=lostpw">Forget your password?</A></font>);
$ForgotPW2 = qq(If you have previously registered, but forgotten your password, <A HREF="$CGIURL/Ultimate.cgi?action=lostpw">click here</A>.);
$RegWordingField = qq(
<tr $TableColorStrip>
<td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
About Registration
</font></td><td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
$RegistrationWording</font></td></tr>);
$PWField = qq(
<tr $AltColumnColor2>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your Password:</B></FONT></td>
<td valign=top><INPUT TYPE="PASSWORD" NAME="Password" VALUE="" SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;$ForgetPW</td></tr>);
$CookieStuff = qq%document.REPLIER.UserName.value = getCookie("UserName");
document.REPLIER.Password.value = getCookie("Password");
document.REPLIER.ReplyMessage.focus();%;
}

if ($AllowIcons eq "TRUE") {
$IconWording = &IconFieldHTML;
}  else {
$IconWording = "";
}
print <<REPLYFORM;
<HTML><HEAD><TITLE>$BBName - Reply to Topic</TITLE>
$HeaderInsert
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor" marginheight=0 marginwidth=0 topmargin=0 leftmargin=0 rightmargin=0>
<FONT SIZE="$TextSize" FACE="$FontFace">
$Header
</font>
<table border=0 width=$TableWidth align=center>
<TR><TD>
<A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$CustomTitle"  BORDER=0></A></td>
<td align=center>
<table border=0>
<TR><TD><FONT Face="$FontFace" size="$TextSize"><B>Forum:</B></font></td><TD><FONT Face="$FontFace" size="$TextSize">$Forum</FONT></td></tr>
<TR><TD><FONT Face="$FontFace" size="$TextSize"><B>Topic:</B></font></td><TD><FONT Face="$FontFace" size="$TextSize">$TopicSubject</FONT></td></tr></table>
</td></tr>
<tr><td colspan=2>$WantRegWording
</td></tr>
</table>
<FORM ACTION="$CGIURL/postings.cgi" NAME="REPLIER" METHOD="POST">
<center>
$BorderTop
<table border=0 cellpadding=4 cellspacing=1 width=$TableWidth2>
<tr $TableColorStrip>
<td valign=top>
<FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
Who Can Post?
</font>
</td>
<td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
$LWADisclaimer
</font>
</td></tr>
$RegWordingField
<tr $AltColumnColor2><td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your UserName:</B></FONT></td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="UserName" VALUE="" SIZE=25 MAXLENGTH=25>
</td>
</tr>
$RegistrationOffWording
$PWField
$LWAField
$IconWording
<TR $AltColumnColor2><TD valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your Reply:</B></FONT>
<p><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
<A HREF="$NonCGIURL/ubbcode.html" target=_blank>$ISUBB</A><BR>
$UBBImagesWording<p>$SmiliesLink</font>
</td>
<td>
<TEXTAREA NAME="ReplyMessage" ROWS=10 COLS=45 WRAP="VIRTUAL">$InsertPostMess</TEXTAREA>
</td></tr>
<TR $AltColumnColor2>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">
<B>Options</B>
</FONT></td>
<td valign=top><FONT SIZE="1" FACE="$FontFace">
$DisableSmiliesWording $ShowSignature
</font>
</td>
</tr>
<tr $TableColorStrip><td colspan=2>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">*If HTML and/or UBB Code are enabled, this means you can use HTML and/or UBB Code in your message.</FONT>
</td></tr>
</table>
$BorderBottom
</center>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="postreply">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<CENTER>
<p>
<INPUT TYPE="Submit" NAME="SUBMIT" VALUE="Submit Reply">
<INPUT TYPE="RESET" NAME="RESET" VALUE="Clear Fields">
</form>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
<P>
$ForgotPW2
</font>

REPLYFORM
} # end ReplyFormHTML


sub ReplyFormBottom {
$IFRAMEalt = &BuildTopicReview;

if ($InlineFrame eq "TRUE")  {
$IFRAME = qq(<IFRAME FRAMEBORDER=1 ALIGN=CENTER width=100% HEIGHT=200 SCROLLING=YES SRC="$GoTo">
$IFRAMEalt
</IFRAME>);
} else {
$IFRAME = $IFRAMEalt;
}

print<<REPLYFORMBOTTOM;
<P><FONT SIZE="$TextSize" FACE="$FontFace">
$IFRAME
</FONT>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var dc = document.cookie;
var testUserName = getCookie("UserName");
var testPassword = getCookie("Password");

if (document.cookie) {

	if (testUserName == null) {  
document.REPLIER.UserName.focus();
	} else {
$CookieStuff
	}
}  else {
document.REPLIER.UserName.focus();
}
function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
<P><center>
REPLYFORMBOTTOM

&PageBottomHTML;
}  ## END Reply Form Bottom sr

sub BuildTopicReview {
@thistopic = &OpenFile("$ForumsPath/Forum$number/$topic");
@sorttopic = sort(@thistopic);
$TotalPosts = @sorttopic;
if (($TotalPosts > 26)  || ($PostPermissions eq "private")) {
$Summary = qq(<A HREF="$GoTo" target=_blank> *** Click here to review this topic. ***</A>);
} else {
$Summary = qq($BorderTop<TABLE BORDER=0 cellpadding=4 border=0 cellspacing=1 WIDTH="$TableWidth2"><TR $TableColorStrip><TD COLSPAN=2><CENTER><FONT SIZE="$TextSize" COLOR="$TableStripTextColor" FACE="$FontFace">T O P I C  &nbsp;&nbsp;&nbsp; R E V I E W</font></CENTER></TD></TR>);

$AltColumnColor = "$AltColumnColor2";

foreach $row(@sorttopic) {
if ($AltColumnColor eq "$AltColumnColor1") {
	$AltColumnColor = "$AltColumnColor2";
}  else {
	$AltColumnColor = "$AltColumnColor1";
}
if ($row !~ /^A/) {
	@posted = split(/\|\|/, $row);
	$Summary .= qq(<TR $AltColumnColor><TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace">$posted[2]</FONT></TD><TD><FONT SIZE="$TextSize" FACE="$FontFace">$posted[6]</FONT></TD></TR>);
}

}
$Summary .= "</TABLE>$BorderBottom";
}
return($Summary);

}


sub TopicFormHTML {
if ($DisplayRegistration eq "NO") {
$WantRegWording = "";
$ForgotPWWording = "";
$LostPWWording = "";
$PWField = "";
$RegWordingField = "";
$CookieStuff = qq%document.PostTopic.UserName.focus();%;
}  else {
$WantRegWording = qq(<FONT SIZE="1" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=agree">Want to register?</a></FONT>);
$ForgotPWWording = qq(If you have previously registered, but forgotten your password, <A HREF="$CGIURL/Ultimate.cgi?action=lostpw">click here</A>.);
$LostPWWording = qq(<FONT SIZE="1" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=lostpw">Forget your password?</A></font>);
$PWField = qq(<tr $AltColumnColor2>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your Password:</B></FONT></td><td><INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;$LostPWWording</td></tr>);
$RegWordingField = qq(<tr $TableColorStrip>
<td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
About Registration</font>
</td><td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
$RegistrationWording</font></td></tr>);
$CookieStuff = qq%document.PostTopic.UserName.value = getCookie("UserName");
document.PostTopic.Password.value = getCookie("Password");
document.PostTopic.TopicSubject.focus();%;
}

if ($AllowIcons eq "TRUE") {
$IconWording = &IconFieldHTML;
}  else {
$IconWording = "";
}

print <<FORM;
<HTML>
<HEAD>
<TITLE>$BBName - Post New Topic</TITLE>
$HeaderInsert
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor" marginheight=0 marginwidth=0 topmargin=0 leftmargin=0 rightmargin=0>
$Header
<table border=0 width=$TableWidth align=center cellpadding=0 cellspacing=0 align=center>
<TR><TD>
<A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$CustomTitle"  BORDER=0></A></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace">
<B>Post New Topic for Forum:<br>&nbsp;&nbsp;&nbsp;<FONT COLOR="$LinkColor">$Forum</FONT></FONT></B>
</td></tr>
<tr><td colspan=2>$WantRegWording
</td></tr>
</table>
<FORM ACTION="$CGIURL/postings.cgi" METHOD="POST" NAME="PostTopic">
<center>
$BorderTop
<table border=0 cellpadding=4 cellspacing=1 width=$TableWidth2>
<tr $TableColorStrip>
<td valign=top>
<FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
Who Can Post?
</font>
</td>
<td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
$LWADisclaimer
</font>
</td></tr>
$RegWordingField

<tr $AltColumnColor2>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your UserName:</B></FONT></td><td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td></tr>
$RegistrationOffWording
$PWField
$LWAField

<TR $AltColumnColor2>
<td NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Subject:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="TopicSubject" VALUE="" SIZE=40 MAXLENGTH=85></td></tr>
$IconWording
<tr $AltColumnColor2>
<td valign=top NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Message:</B></FONT>
<p><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
<A HREF="$NonCGIURL/ubbcode.html" target=_blank>$ISUBB</A><BR>$UBBImagesWording<p>$SmiliesLink</font>
</td>
<td>
<TEXTAREA NAME="Message" ROWS=10 COLS=45 WRAP="VIRTUAL">
</TEXTAREA></td></tr>

<TR $AltColumnColor2>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">
<B>Options</B>
</FONT></td>
<td valign=top><FONT SIZE="1" FACE="$FontFace">
$EmailNotificationHTML
<BR>$DisableSmiliesWording 
$ShowSignature</font>
</td></tr>
<tr $TableColorStrip><td colspan=2>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">*If HTML and/or UBB Code are enabled, this means you can use HTML and/or UBB Code in your message.</FONT>
</td></tr>
</table>
$BorderBottom
</center>

<P>
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="posttopic">
<CENTER>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit New Topic">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Clear Fields">
</form></center>
<br>

<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var dc = document.cookie;
var testUserName = getCookie("UserName");
var testPassword = getCookie("Password");

if (document.cookie) {

	if (testPassword == null) {  
document.PostTopic.UserName.focus();
	} else {
$CookieStuff
	}
}  else {
document.PostTopic.UserName.focus();
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>

<center>

<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
$ForgotPWWording
</ul>
<P>
FORM
&PageBottomHTML;
}  ## END Topic Form LWA HTML


sub OpenCloseThread {
my $which = shift;	
my $whichcap = ucfirst($which);

if ($whichcap eq "Close") {
$TheRunner = qq(C L O S E &nbsp;&nbsp;&nbsp;&nbsp; T O P I C);
}  else {
$TheRunner = qq(R E - O P E N &nbsp;&nbsp;&nbsp;&nbsp; T O P I C);
}
$TheTitle = qq($BBName - Request to $whichcap Thread);
$TheIntro = qq(Request to $whichcap Thread: $TopicSubject );

$HiddenStuff = qq(<FORM ACTION="$CGIURL/postings.cgi" NAME="Authorize" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="processclose">
<INPUT TYPE="HIDDEN" NAME="which" VALUE="$which">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">);

&AuthorizeCheck($TheTitle, $TheIntro, $HiddenStuff, $TheRunner);
}

sub EditPost {
#check to make sure edit post is ON
if (($EditOption eq "ON") || ($EditOption eq "NODELETE")) {
## check UBB and HTML status for this forum
@thisforum = &GetForumRecord($number);

$LWA = $thisforum[6];
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
#if private... do not display without checking to make sure that the user has permission

if ($LWA eq "private") {
#check for private cookies to see if we can proceed immediately
&get_cookie;  #retrieves all current cookies
	$PasswordPrivate = "$cookie{PasswordPrivate}";
	$UserNamePrivate = "$cookie{UserNamePrivate}";
	$NumbersPrivate = "$cookie{ForumNumberPrivate}";
	
$DIRPW = "$thisforum[7]";
$ExactPath = "Forum$number/private-$DIRPW";
if ($NumbersPrivate ne "") {
&VerifyID;

	if (($ForumPW ne "") && ($ProceedNow ne "true")) {
		&ConfirmIdentity;
		exit;
	}
	
} else {
&StandardHTML("Either your browser does not support cookies or you have turned cookies off in your browser.  Unfortunately, we require that cookies be used in order to allow editing of messages in private forums.  Thus, we cannot process your request to edit this message.");
exit;
}

}  else {
$DIRPW = "";
$ExactPath = "Forum$number";
$ProceedNow = "true";
}

####

if ($ProceedNow eq "true") {

   chomp($thisforum[10]);
$UBBImages = "$thisforum[10]";

&CheckCoding;

## open thread file
@thisthread = &OpenThread("$topic");

## grab the proper message
@matcher = grep(/^Z\|\|$in{'ReplyNum'}/, @thisthread);

$matched = $matcher[0];
@thispost = split(/\|\|/, $matched);

$message = $thispost[6];
chomp($message);
$author = $thispost[2];
chomp($author);
$postdate = $thispost[3];
chomp($postdate);
$posttime = $thispost[4];
chomp($posttime);

	$message = &PrepForEdit($message);

if ($EditOption eq "NODELETE") {
	$DeleteWarn = qq%Only forum leaders ($AdminTitle, $ModeratorTitle) or the person that posted this message may edit this message (and only registered users may edit/delete posts)<P>Note: Only forum leaders may delete posts.%;
}  else {

$DeleteWarn = qq%Only forum leaders ($AdminTitle, $ModeratorTitle) or the person that posted this message may edit or delete this message.  Only registered users may edit/delete posts!%;
}

if ($in{'ReplyNum'} eq "000000") {
	$WarningWords = "Note: deleting this post will result in the deletion of the entire topic, since this post is the first post in the topic.";
}

print <<EditFORM;
<HTML><HEAD>
<TITLE>
$BBName - Edit this post
</TITLE>
$HeaderInsert
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor" marginheight=0 marginwidth=0 topmargin=0 leftmargin=0 rightmargin=0>
$Header
<table border=0 cellpadding=0 border=0 cellspacing=1 width=$TableWidth align=center>
<TR><TD>
<A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></td>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
<B>
Forum: <FONT COLOR="$VisitedLinkColor">$Forum </FONT>
<BR>
Topic: <FONT COLOR="$VisitedLinkColor">$TopicSubject</FONT>
</B>
</FONT>

</td></tr></table>
<center>
<FORM ACTION="$CGIURL/postings.cgi" NAME="REPLIER" METHOD="POST">
$BorderTop
<table border=0 cellpadding=4 border=0 cellspacing=1 width=$TableWidth2 align=center>
<tr $TableColorStrip><TD COLSPAN=2>
<FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor"><B>$DeleteWarn</B></FONT></td></tr>
<TR $AltColumnColor1><TD colspan=2><FONT SIZE="1" FACE="$FontFace" COLOR="$TextColor">
<INPUT TYPE="CHECKBOX" NAME="DeletePost" VALUE="yes"><b>Delete?</b>  To delete this post, check this box.<BR>$WarningWords</font>
</td></tr>
<tr $AltColumnColor2><td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><b>Your UserName:</b></FONT></td>
<td>
<INPUT TYPE="TEXT" NAME="UserName" VALUE="" SIZE=25 MAXLENGTH=25>
</td></tr>
<tr $AltColumnColor1>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><b>Your Password:</b></FONT></td>
<td><INPUT TYPE="PASSWORD" NAME="Password" VALUE=""  SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=lostpw">Forget your password?</A></font>
</td></tr>
<TR $AltColumnColor2><TD valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><b>Message to Edit:</b></FONT><p>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
$ISUBB<BR>
$UBBImagesWording<p>$SmiliesLink</font></td>
<td><FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">Originally posted by $author on $postdate $posttime<BR></FONT>
<TEXTAREA NAME="EditedMessage" ROWS=10 COLS=45 WRAP="VIRTUAL">$message</TEXTAREA>
</td></tr>
<tr $AltColumnColor1><td>&nbsp;</td>
<td>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TextColor">
$DisableSmiliesWording
</FONT>
</td></tr>
<tr $TableColorStrip><td colspan=2>
<FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor">
*If HTML and/or UBB Code are enabled, this means you can use HTML and/or UBB Code in your message. 
</font>
</td></tr>
</table>
$BorderBottom
<p>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="submitedit">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="ReplyNum" VALUE="$in{'ReplyNum'}">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">

 <FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">

</font>
<p>
<INPUT TYPE="Submit" NAME="SUBMIT" VALUE="Submit Now">
<INPUT TYPE="RESET" NAME="RESET" VALUE="Clear Fields">
</form>
<P>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var dc = document.cookie;
var testUserName = getCookie("UserName");
var testPassword = getCookie("Password");

if (document.cookie) {

	if (testUserName == null) {  
document.REPLIER.UserName.focus();
	} else {
	document.REPLIER.UserName.value = getCookie("UserName");
document.REPLIER.Password.value = getCookie("Password");
document.REPLIER.EditedMessage.focus();
	}
}  else {
document.REPLIER.UserName.focus();
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>

<P>
EditFORM

&PageBottomHTML;
} else {
&StandardHTML("Sorry, but the edit option has been disabled by your bulletin board administrator.");
}

}  else {
&StandardHTML("Sorry, but you are not authorized to edit any posts in this forum.");
}

}  # end edit display

sub CheckCoding {

if ($thisforum[4] eq "is") {
	$ISHTML = "*HTML is ON";
	$HTMLAllowed = "yes";
}  else {
	$ISHTML = "*HTML is OFF";
	$HTMLAllowed = "no";
}
 
if ($thisforum[5] eq "is") {
	$ISUBB = "*UBB Code is ON";
	$UBBAllowed = "yes";
}  else {
	$ISUBB = "*UBB Code is OFF";
	$UBBAllowed = "no";
}

if (($UBBImages eq "OFF") && ($UBBAllowed eq "yes")) {
	$UBBImagesWording = "\[IMG\] UBB Code Not Allowed!";
}

}


sub VerifyID {
##check ID using username set as cookie
$NameFound = "no";
$ProfileNumber = &GetUserNumber($UserNamePrivate);

if ($NumbersPrivate ne "") {
	if ($NumbersPrivate =~ /\:\:/) {
	@CheckAccess = split(/\:\:/, $NumbersPrivate);
	}  else {
		@CheckAccess = $NumbersPrivate;
	}
	
	CHECKER: foreach $checker(@CheckAccess) {
		chomp($checker);
		($checknum, $checkdir) = split(/\:/, $checker);
		if ($checknum eq "$number") {
			if ($checkdir eq "$DIRPW") {
			$ProceedNow = "true";
			last CHECKER;
			}  else {
				&StandardHTML("We cannot confirm your identity.");
				exit;
			} #if checkdir
		}# if checknum
	} #foreach
}  #if np

if ($ProceedNow ne "true") {

	if ($ProfileNumber ne "") {
		$NameFound = "yes";
		} else {
		$NameFound = "no";
	}
	
		@thisprofile = &OpenProfile("$ProfileNumber.cgi");
if ($PasswordPrivate eq "$thisprofile[1]") {
		$Permission = "$thisprofile[4]";
		$Status = $thisprofile[8];
		($GenPerms, $SpecificPerms) = split(/\&/, $Permission);
		
		if (($Status eq "Administrator") || ($Status eq "Moderator")) {
	  		$ProceedNow = "true";
	   }
		if (($SpecificPerms ne "") && ($ProceedNow ne "true")){
			chomp($specificPerms);
			@accessarray = split(",", $SpecificPerms);
			CHECKARRAY: foreach $uno(@accessarray) {
				if ($uno eq "$number") {
					$ProceedNow = "true";
					last CHECKARRAY;
				}
			}
		}
	}
}

} #end VerifyID

sub DeletePost {
my $DeleteTitle = qq($BBName - Delete this post);
my $DeleteRunner = qq(D E L E T E &nbsp;&nbsp;&nbsp;&nbsp;T O P I C);
my $DeleteIntro = qq(To delete this entire topic, identify yourself below.  Do not press the SUBMIT button unless you are positive that you want to delete this entire topic!<P>Topic: $TopicSubject);
$DeleteHidden = qq(<FORM ACTION="$CGIURL/postings.cgi" NAME="Authorize" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="DeletePost" VALUE="yes">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="submitedit">
<INPUT TYPE="HIDDEN" NAME="EditedMessage" VALUE="none">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="ReplyNum" VALUE="000000">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">);

&AuthorizeCheck($DeleteTitle, $DeleteIntro, $DeleteHidden, $DeleteRunner);
}  # end delete display


sub ProcessClose {

	if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") )  {
			&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
		} else {
# verify admin or mod status


$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$ProfileNumber.cgi");
	
	if ($in{'Password'} eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	
	#get moderator for this forum
	$Moderator = ("Forum" . "$number" . "Moderator");
	$Moderator = $$Moderator;
	@mods = split(/\|\|\^\|\|/, $Moderator);
	
$ModMatch = "";
foreach $unomod(@mods) {
if ($unomod eq "$UserName") {
	$ModMatch = "true";
}
}
	   if (($AdminStatus eq "true") || ($ModMatch eq "true")) {

@thisforum = &GetForumRecord($number);
$LWA = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);

#open ubb file
@thisthread = &OpenThread("$topic");
@stats = split(/\|\|/, $thisthread[0]);
$Notes = $stats[1];
chomp($stats[4]);
chomp($stats[5]);
chomp($stats[6]);
chomp($stats[7]);

if ($Notes =~ /N/) {
	$AddN = "N";
}  else {
	$AddN = "";
}

chomp($stats[7]);
#prepare new stats line
if ($in{'which'} eq "open") {
$StatsLine = "A||$AddN||$stats[2]||$stats[3]||$stats[4]||$stats[5]||$stats[6]||$stats[7]";
$about = "reopened";
}  else {
$StatsLine = "A||X$AddN||$stats[2]||$stats[3]||$stats[4]||$stats[5]||$stats[6]||$stats[7]";
$about = "closed";
}

foreach $row(@thisthread) {
chomp($row);
if ($row =~ m/^A/) {
	push(@revised, $StatsLine);
}  else {
	push(@revised, $row);
}
}

# update ubb file
&Lock("lock.file");

&CheckBadChars($topic);

open (FORUM, ">$ForumsPath/$ExactPath/$topic"); 
foreach $ubbline(@revised) {
chomp($ubbline);
print FORUM ("$ubbline\n");
}
close (FORUM);
&Unlock("lock.file");
chmod(0666, "$ForumsPath/$ExactPath/$topic");

# Send confirmation screen
&Forward("$CGIURL/forumdisplay.cgi?action=topics&DaysPrune=$DaysPrune&number=$number&forum=$ForumCoded", "The following thread has been $about:<P>
<font color=\"$LinkColor\"></FONT>$TopicSubject<P>You are being automatically transported to the $Forum forum.");

# re-do the HTML page associated with this file
&CreateThreadHTML("Forum$number", "$topic", "0", "1");

#update threads summary file
&CurrentDate;
if (-e "$ForumsPath/$ExactPath/forum$number.threads") {
&AdjustForClose($number, $topic, $in{'which'});
}  else {
&ForumSummary($number);
}

	   }  else  {
	   &StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
	   }
	   
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
	
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} # end missing fields check
} # end process close sr

sub floodcheck { # blocks multiple posting in a short period
#floodcheck sr written by Michael Farris!

#$wait_between_posts = "1.0"; #  edit in the default number of minutes to wait
$lastpost_list_length = 80; # edit in the number of records to keep 
	
my $IPNumber  = $ENV{'REMOTE_ADDR'}; # the IP address
my $this_post_time = time(); # secs since 1970
open(LASTPOST, "$NonCGIPath/BanLists/Floodcheck.cgi"); # don't bother with error code if it doesn't exist
  @last_post_list = <LASTPOST>;
close(LASTPOST);

foreach (@last_post_list) { # check if this user has posted already
	if (/^$IPNumber/){
	  ($junk,$last_post_time) = split(/\|!!\|/,$_);
	  chomp($last_post_time);
	  last;	
	}	
} # end foreach

# $FloodCheckSpan (in seconds) is set in General Settings

if ( int(($this_post_time - $last_post_time) < $FloodCheckSpan)){
	&StandardHTML("Sorry! We have flood-control activated.  You cannot post within $FloodCheckSpan seconds of your last post.  Please try again after this period of time elapses.");
	exit;
}
else { # add the IP and posting time to the list
	if (unshift(@last_post_list, "$IPNumber|!!|$this_post_time\n") > $lastpost_list_length){
	$#last_post_list = $lastpost_list_length; # limit length of list
	}
	chmod(0666, "$NonCGIPath/BanLists/Floodcheck.cgi");
open(LASTPOST, ">$NonCGIPath/BanLists/Floodcheck.cgi") || die(&StandardHTML("Permission problem writing new file in BanList Dir $!"));
	print LASTPOST @last_post_list;
close(LASTPOST);

} #  end else

return 1;
} # end SR

exit(0); # comply with SafePerl


