#!/usr/bin/perl

#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Infopop Corporation, 1997-2000.
#
#       ------------ cpanel4.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  NOTE: you MAY NOT redistribute this script under any
#  circumstance.  This means that you may not sell, trade, or in
#  any other way give this script to another user who is not
#  licensed to use it.  Infopop Corporation offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "mods.file";
require "UltBB.setup";
require "ubb_library.pl";
require "ubb_library2.pl";
require "Date.pl";
require "Styles.file";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

use Socket;


#create random numbers for headers/footers
$RandomNumber = &MakeRandomNumber;
$RandomNumber2 = $RandomNumber + 100074;
if (-e "$ForumsPath/Forum$number/forumstyles.file") {

if ($ForumHeader ne "") {
$Header = $ForumHeader;
$Header =~ s/UBBrandomX/$RandomNumber/isg;
$Header =~ s/UBBrandomY/$RandomNumber2/isg;
}  else {
if ($Header ne "") {
$Header =~ s/UBBrandomX/$RandomNumber/isg;
$Header =~ s/UBBrandomY/$RandomNumber2/isg;
}
}

if ($ForumFooter ne "") {
$Footer = $ForumFooter;
$Footer =~ s/UBBrandomX/$RandomNumber/isg;
$Footer =~ s/UBBrandomY/$RandomNumber2/isg;
}  else {
if ($Footer ne "") {
$Footer =~ s/UBBrandomX/$RandomNumber/isg;
$Footer =~ s/UBBrandomY/$RandomNumber2/isg;
}
}

}  else {
if ($Header ne "") {
$Header =~ s/UBBrandomX/$RandomNumber/isg;
$Header =~ s/UBBrandomY/$RandomNumber2/isg;
}
if ($Footer ne "") {
$Footer =~ s/UBBrandomX/$RandomNumber/isg;
$Footer =~ s/UBBrandomY/$RandomNumber2/isg;
}

}

#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$NonCGIURL/$PageBackground");
}

if ($TableBorderColor ne ""){
$TableWidth2 = "100%";
$BorderTop = qq(<table border=0 cellpadding=0 cellspacing=0 width="$TableWidth"><TR><td bgcolor="$TableBorderColor">);
$BorderBottom = qq(</td></tr></table> );
}  else {
$TableWidth2 = $TableWidth;
$BorderTop = "";
$BorderBottom = "";
}
&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "number") {
		$number = $Value;
		$number =~ s/\D//sg;
	}
	if ($Name eq "UserNumber") {
		$UserNumber = $Value;
		$UserNumber =~ s/\D//sg;
	}
	if ($Name eq "RegNumber") {
		$RegNumber = $Value;
		$RegNumber =~ s/\D//sg;
	}
	if ($Name eq "Email") {
		$Email = $Value;
	}
	if ($Name eq "ViewEntire") {
		$ViewEntire = $Value;
	}
	if ($Name eq "NN") {
		$SearchName = $Value;
		$SearchName =~tr/A-Z/a-z/; 
		$SearchNameCoded = $SearchName;
		$SearchNameCoded =~ tr/ /+/;
	}
	if ($Name eq "UserNameCheck") {
		$UserNameCheck = $Value;
		$UserNameCheckFile = $UserNameCheck;
		$UserNameCheckFile =~ s/ /_/g; #remove spaces
	}

	if ($Name eq "UserName") {
		$UserName = $Value;
		$UserName = &UNHTMLIFY($UserName);
		$UserNameFile = $UserName;
		$UserNameFile =~ s/ /_/g; #remove spaces
	}
	if ($Name eq "Password") {
		$Password = $Value;
		$Password = &UNHTMLIFY($Password);
	}
	if ($Name eq "PasswordCheck") {
		$PasswordCheck = $Value;
	}
	if ($Name eq "action") {
		$action = $Value;
	}
			
} #end foreach loop

if ($action eq "misc") {
&Misc;
}

if ($action eq "ContinueRemoveHTML") {
&ConfirmAdminCookie;
&RemoveHTML;
}

if ($action eq "ContinueMemberUpdate") {
#verify admin
&ConfirmAdminCookie;
&DoRebuildMembers;
}

if ($action eq "getmatches") {
&GetMatches;
}

if ($action eq "modregs"){
&modregs;	
}
if ($action eq "getbio4admin") {

&GetBio4Admin($UserNumber);
}

if ($action eq "updatepermissforums") {
&UpdatePermissForums;
exit;
}

if ($action eq "updatepermiss") {
&UpdatePermiss;
exit;
}
if ($action eq "updates") {
&UpdateVersion;
exit;
}


# end 
exit(0);




sub Misc {
#verify admin
$ProfileNumber = &GetUserNumber($in{'UserName'});

@theprofile = &OpenProfile("$ProfileNumber.cgi");

if ($in{'Password'} eq "$theprofile[1]") {
	$Status = "$theprofile[8]";
	   if ($Status eq "Administrator") {
			&DoMisc;
		}  else {
			&StandardHTMLCP("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		} #end if adminstatus is true 
}  else {
&StandardHTMLCP("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}

}

sub DoMisc {
$Choice= $in{'Choice'};

if ($Choice eq "0") {
&StandardHTMLCP("Sorry, but failed to provide a valid selection.  Please try again.  Use your Back button.");
}
elsif ($Choice eq "1") {
&RemoveHTML;
exit;
}  else {
&DoRebuildMembers;
exit;
} 

}


sub RemoveHTML {
#remove old HTML files left over from deleted multi-HTML page topics

#confirm identity
if ($action = "ContinueRemoveHTML") {
&get_cookie;  #retrieves all current cookies
if ($cookie{UserNameCP}) {
$CheckUserName = "$cookie{UserNameCP}";
$CheckPassword = "$cookie{PasswordCP}";
}
elsif ($in{'UserName'}) {
$CheckUserName = $in{'UserName'};
$CheckPassword = $in{'Password'};
}  else {
$PageTitle = "R E M O V E  &nbsp; D E A D  &nbsp; H T M L  &nbsp; F I L E S";
$PageIntro = "In order to perform this function, you must first identify yourself.  You will not have to do this each time if you allow cookies to be set from your browser.";
$HiddenFields = qq(<INPUT TYPE="HIDDEN" NAME="action" VALUE="misc"><INPUT TYPE="HIDDEN" NAME="Choice" VALUE="1">
);# end qq
&QueryForID;
exit;
}

#confirm permission to read forum data
&VerifyAdminCP($CheckUserName, $CheckPassword);
}

@sortforums = &OpenForumsFile;
$TotalForums = @sortforums;

if ($number eq "") {
$number = "1";
}

@thisforum = &GetForumRecord($number);
$x = "$thisforum[8]";
$ForumName = $thisforum[1];
if ($thisforum[6] eq "private") {
	$ExactPath = "Forum$x/private-$thisforum[7]";
	if ($thisforum[13] eq "yes") {
	$Ext  = "cgi";
	}  else {
	$Ext  = "html";
	}
} else {
	$ExactPath = "Forum$x";
	$Ext  = "html";
}


opendir (FORUMDIR, "$ForumsPath/$ExactPath/HTML"); 
    @HTMLfiles = readdir(FORUMDIR);
closedir (FORUMDIR);

@multipagers = grep(/-/, @HTMLfiles);

$RemoveCount = 0;

foreach $multi(@multipagers) {
chomp($multi);
	($topicnum, $junk) = split(/-/, $multi);
	$OrigTopic = ("$topicnum"  . "."  . "$Ext");
	unless (-e "$ForumsPath/$ExactPath/HTML/$OrigTopic") {
	$RemoveCount++;
			unlink("$ForumsPath/$ExactPath/HTML/$multi");
	}
	
}


if ($x < $TotalForums) {
$NextForum = $x + 1;
$ActionWording = qq(We are removing any unnecessary files from the HTML directories.  <P>We just finished processing <FONT FACE="Verdana" SIZE="2" COLOR="Navy">Forum$x - $ForumName </font>.<P> HTML Files deleted in that forum: <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$RemoveCount</FONT>. <b>Please wait as we continue processing!</B></FONT>);
$ForwardURL = "$CGIURL/cpanel4.cgi?action=ContinueRemoveHTML&number=$NextForum";
&ContinueThis($ForwardURL, $ActionWording);
}  else {
&StandardHTMLCP("Thank you.  We have finished processing this request.");
}

}  #end RemoveHTML sr



sub CloseForums {
open(STATUS, ">$MembersPath/status.file");
print STATUS "closed";
close(STATUS);
chmod(0666, "$MembersPath/status.file");
}

sub OpenForums {
unlink("$MembersPath/memholder.cgi");
open(STATUS, ">$MembersPath/status.file");
print STATUS "open";
close(STATUS);
unlink("$MembersPath/status.file");
}

sub DoRebuildMembers {
$StartPoint = $in{'StartPoint'};
#$StartPoint =~/\D//sg;

#confirm identity
if ($action eq "ContinueMemberUpdate") {
&get_cookie;  #retrieves all current cookies
if ($cookie{UserNameCP}) {
$CheckUserName = "$cookie{UserNameCP}";
$CheckPassword = "$cookie{PasswordCP}";
}
elsif ($in{'UserName'}) {
$CheckUserName = $in{'UserName'};
$CheckPassword = $in{'Password'};
}  else {
$PageTitle = "R E B U I L D  &nbsp;&nbsp;&nbsp;&nbsp; M E M B E R S";
$PageIntro = "In order to perform this function, you must first identify yourself.  You will not have to do this each time if you allow cookies to be set from your browser.";
$HiddenFields = qq(<INPUT TYPE="HIDDEN" NAME="action" VALUE="getbio4admin"><INPUT TYPE="HIDDEN" NAME="UserNumber" VALUE="$ProfileNum">
 );
&QueryForID;
exit;
}

#confirm permission to read forum data
&VerifyAdminCP($CheckUserName, $CheckPassword);
}

if ($in{'Finalize'} eq "true") {
open (MEMFILE, "$MembersPath/memberslist2.cgi");
@memlist = <MEMFILE>;
close (MEMFILE);

open (EMAILFILE, "$MembersPath/emailfile2.cgi");
@emlist =<EMAILFILE>;
close (EMAILFILE);

&CloseForums;  #temporarily

open (MEMFILE, ">$MembersPath/memberslist.cgi");
foreach $member(@memlist) {
chomp($member);
print MEMFILE "$member\n";
}
close (MEMFILE);

open (EMAILFILE, ">$MembersPath/emailfile.cgi");
foreach $emfile(@emlist) {
chomp($emfile);
print EMAILFILE "$emfile\n";
}
close (EMAILFILE);

chmod (0666, "$MembersPath/emailfile.cgi");
chmod (0666, "$MembersPath/memberslist.cgi");
unlink("$MembersPath/emailfile2.cgi");
unlink("$MembersPath/memberslist2.cgi");

&OpenForums;
&StandardHTMLCP("Thank you, we have finished reconciling your member records!");
exit;

}

if ($StartPoint eq "") {
opendir(MEMS , "$MembersPath");
@themems = readdir(MEMS);
closedir(MEMS);
@thesemems = grep(/^\d{8}\.cgi$/, @themems);
@mems = sort (@thesemems);

open(MEMHOLDER, ">$MembersPath/memholder.cgi");
foreach $memo(@mems) {
chomp($memo);
print MEMHOLDER "$memo\n";
}
close(MEMHOLDER);
chmod(0666, "$MembersPath/memholder.cgi");

}  else {
#open temp file if it exists...
open(MEMHOLDER, "$MembersPath/memholder.cgi");
@thesemems = <MEMHOLDER>;
close(MEMHOLDER);
@mems = sort (@thesemems);
}

$TotalMembers = @mems;
#process member files in chunks of 5

my $MaxDisplay = 125;  
if ($StartPoint eq "") {
	$StartPoint = 1;
	if ($TotalMembers <= $MaxDisplay) {
		$EndPoint = $TotalMembers;
		$Done = "true";
	} else {
	$Done = "";
	$EndPoint = $MaxDisplay;
	}
	$EP = $EndPoint - 1;

} else {

$EndPoint = $StartPoint + $MaxDisplay;
$EndPoint = $EndPoint - 1;
	if ($TotalMembers <= $EndPoint) {
		$EndPoint = $TotalMembers;
		$Done = "true";
	}  else {
		$Done = "";
	}

}

$SP = $StartPoint - 1;
$EP = $EndPoint - 1;
@finalmems = @mems[$SP..$EP];

foreach $uno(@finalmems) {
chomp($uno);

my @memfile = &OpenFile("$MembersPath/$uno");
chomp($memfile[0]);
chomp($memfile[2]);

if (($memfile[0] ne "") && ($memfile[2] ne "")) {
($memnum, $junk) = split(/\./, $uno);

#append memberslist
$MemLine = ("$memfile[0]" . "|!!|" . "$memnum");
push(@memfile2, $MemLine);

#append emailfile
$EmailLine = ("$memfile[2]" . "||" . "$memnum");
push(@emailfile, $EmailLine);

}
}


if ($in{'action'} eq "ContinueMemberUpdate") {

open (MEM2, ">>$MembersPath/memberslist2.cgi");
foreach $mem5(@memfile2) {
print MEM2 "$mem5\n";
}
close (MEM2);

open (EM2, ">>$MembersPath/emailfile2.cgi");
foreach $emfile(@emailfile) {
print EM2 "$emfile\n";
}
close (EM2);

}  else {

open (MEMFILE, ">$MembersPath/memberslist2.cgi");
foreach $mem6(@memfile2) {
print MEMFILE "$mem6\n";
}
close (MEMFILE);

open (EMAILFILE, ">$MembersPath/emailfile2.cgi");
foreach $emfile(@emailfile) {
print EMAILFILE "$emfile\n";
}
close (EMAILFILE);

chmod (0777, "$MembersPath/emailfile2.cgi");
chmod (0777, "$MembersPath/memberslist2.cgi");
}


if ($Done ne "true") {
$NextStart = $EndPoint + 1;
$ActionWording = qq(We are reconciling your registered member database.  Please wait as we continue procesing.  <P>We just finished processing members <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$StartPoint - $EndPoint</font>.<P><b>Please wait as we continue processing!</B></FONT>);
$ForwardURL = "$CGIURL/cpanel4.cgi?action=ContinueMemberUpdate&StartPoint=$NextStart";
&ContinueThis($ForwardURL, $ActionWording);
exit;
} else {
$NextStart = $EndPoint + 1;
$ActionWording = qq(We are econciling your registered member database.  Please wait as we continue procesing.  <P>We just finished processing members <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$StartPoint - $EndPoint</font>.<P><b>Please wait as we continue processing!</B></FONT>);
$ForwardURL = "$CGIURL/cpanel4.cgi?action=ContinueMemberUpdate&StartPoint=$NextStart&Finalize=true";
&ContinueThis($ForwardURL, $ActionWording);
exit;

}


} #end dorebuildmems


sub GetMatches {
if ($in{'StartPoint'} eq "") {
&VerifyAdminCP($UserName, $Password);
}  else {
	&ConfirmAdminCookie;
	$Proceed = "true";
}

if ($Proceed eq "true") {	   	   

	if ($ViewEntire eq "Yes") {
		&GetAll;
	} else {
		&DoSearch;
	}
}
}  #end GetMatches SR ###


sub DoSearch {


unless ( ($in{'Status'} eq 'COPPA') || ($in{'PrivateForum'} ne '') ){
	$ProfileIndex = 8; # status
}else {
	$ProfileIndex = 4; # perms
}


my @themembers = &OpenFile("$MembersPath/memberslist.cgi");
my @theemails = &OpenFile("$MembersPath/emailfile.cgi");


foreach $dos(@themembers) {
($thename, $thenum) = split(/\|\!\!\|/, $dos);
chomp($thenum);
$Line = ("$thenum" . "|||" .  "$thename");
push(@sortmems, $Line);
}

foreach $dos2(@theemails) {
($theemail, $thenum) = split(/\|\|/, $dos2);
chomp($thenum);
$Line = ("$thenum" . "|||" . "$theemail");
push(@sortemails, $Line);
}




$TotalMembers = @sortmems;
$CheckEmail = "$in{'Email'}";
$Search = 0;
$arraycount = 0;





foreach $memberinfo(@sortmems) {
($junk, $member) = split(/\|\|\|/, $memberinfo);
chomp($member);
$CleanMember = quotemeta($member);

my @searchfile = @blank;
my $ProfileOpened = "";
my $bad = "no";

#start UserName check block
	if ($SearchName ne "") {
		$CleanName = quotemeta($SearchName);
		unless ($member =~ /$CleanName/i) {
			$bad = "yes";
		}
	} 
	#do email check
	if (($CheckEmail ne "") && ($bad ne "yes")) {
	$ThisEmailRow = $sortemails[$arraycount];
	($junk, $thisemail) = split(/\|\|\|/, $ThisEmailRow);
chomp($thisemail);
		unless ($thisemail =~ /$CheckEmail/i) {
			$bad = "yes";
		}
	} #end if do check of email






	# Check number of posts
	
	if (($in{'Posts'} ne "") && ($bad ne "yes")) {
		$ProfileNumber = &GetUserNumber($member);
		@searchfile = &OpenProfile("$ProfileNumber.cgi");
		$ProfileOpened = "true";
		$PostNumber = $searchfile[7];
		$Math = $in{'Math'};
		if ($Math eq "GT") {
			unless ($PostNumber >= $in{'Posts'}) {
				$bad = "yes";
		}
		}
		if ($Math eq "LT") {
			unless ($PostNumber <= $in{'Posts'}) {
				$bad = "yes";	
			}  
		}
		if ($Math eq "EQ") {
			unless ($PostNumber == $in{'Posts'}) {
				$bad = "yes";
			}
		}
		
	} 


	if (($in{'Status'} ne "") && ($bad ne "yes")) {
		$ProfileNumber = &GetUserNumber($member) unless ($ProfileOpened eq "true");
		@searchfile = &OpenProfile("$ProfileNumber.cgi")unless ($ProfileOpened eq "true");	
		$ProfileOpened = "true";
		$StatusType = $searchfile[$ProfileIndex];
		$StatusFind = $in{'Status'};
			unless ($StatusType =~ m/$StatusFind/io){
				$bad = "yes";
			}
	}


	if (($in{'PrivateForum'} ne "") && ($bad ne "yes")) {
		$ProfileNumber = &GetUserNumber($member) unless ($ProfileOpened eq "true");
		@searchfile = &OpenProfile("$ProfileNumber.cgi")unless ($ProfileOpened eq "true");	
		$ProfileOpened = "true";
		$PrivateList = $searchfile[4];
		$PrivateFind = $in{'PrivateForum'};
			unless ($PrivateList =~ m/\D$PrivateFind/){
				$bad = "yes";
			}
	}









#start validation block

$arraycount++;
if ($bad ne "yes")  {
$Search++;

if ($ProfileOpened ne "true") {
		$ProfileNumber = &GetUserNumber($member);
		@searchfile = &OpenProfile("$ProfileNumber.cgi");
}

$line = ("$searchfile[0]" .  "|||" .  "$searchfile[2]" .  "|||"  . "$searchfile[4]" . "|||" . "$searchfile[8]" . "|||" . "$searchfile[7]" . "|||" . "$searchfile[10]" . "|||" . "$ProfileNumber");
push (@thefinal, $line);
}  
#close validation block

}  #end FOREACH $member


if ($Search > 0) {	

@final = sort(@thefinal);

	$TotalProfiles = @final;
	
## ONLY DISPLAY 50 at a time--
my $MaxDisplay = 50;  #maximum number to view per screen
if ($in{'StartPoint'} eq "") {
	$StartPoint = 1;
	if ($TotalProfiles <= $MaxDisplay) {
		$EndPoint = $TotalProfiles;
		$Done = "true";
	} else {
	$Done = "";
	$EndPoint = $MaxDisplay;
	}
	$EP = $EndPoint - 1;


} else {

$StartPoint = $in{'StartPoint'};
$EndPoint = $StartPoint + $MaxDisplay;
$EndPoint = $EndPoint - 1;
	if ($TotalProfiles <= $EndPoint) {
		$EndPoint = $TotalProfiles;
		$Done = "true";
	}  else {
		$Done = "";
	}

}

$SP = $StartPoint - 1;
$EP = $EndPoint - 1;
@final = @final[$SP..$EP];

if ($Done ne "true") {
$NextStart = $EndPoint + 1;
$NextWording = qq(<A HREF="cpanel4.cgi?action=getmatches&StartPoint=$NextStart&NN=$SearchNameCoded&Email=$in{'Email'}&Math=$in{'Math'}&Posts=$in{'Posts'}&ViewEntire=$in{'ViewEntire'}">[Next Matches]</A>);
} else {
$NextWording = "";
}
if ($TotalProfiles == 0) {
$StartPoint = 0;
}

&PermissionsTopHTML;

&UserInfoRows; # supply @final

print <<ENDHTML;
</table>
</td></tr></table>
<br>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER><P>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Permission Changes Now">
</form><FONT COLOR="#C0C0C0">
<BR><BR>$infopopcopy<BR>
Ultimate Bulletin Board $Version<BR><BR></CENTER>
</FONT>
</FONT>
</body>
</html>
ENDHTML
}  else {
&StandardHTMLCP("Sorry, but we couldn't find any users that matched your search criteria.  Please go back and try again!");
}
}  ##END DOSEARCH SR ###



sub UserInfoRows{

foreach $line2(@final) {
		
@searchrow = split (/\|\|\|/, $line2);
	
$UNCoded = $searchrow[0];
$UNCoded =~ tr/ /+/;

$Permission = $searchrow[2];
$DateReg = $searchrow[5];
$ProfileNum = $searchrow[6];
chomp($ProfileNum);

if ($searchrow[3] eq "Administrator") {
	$ThisStatus = "$AdminTitle";
}
elsif ($searchrow[3] eq "Moderator") {
	$ThisStatus = "$ModeratorTitle";
}
elsif ($searchrow[3] eq "Member") {
	$ThisStatus = "$MemberTitle";
}  else {
	$ThisStatus = "$JrMemberTitle";
}

&CheckPermissions;
$WriteYes = "";
$WriteNo = "";
$AdminYes="";
$AdminNo="";

if ($AdminWrite eq "true") {
   $WriteYes = "CHECKED";
}  else {
   $WriteNo = "CHECKED";
}
if ($AdminPermission eq "true") {
   $AdminYes = "CHECKED";
}  else {
   $AdminNo = "CHECKED";
}
if ($AltColor eq "") {
	$AltColor = "#dedfdf";
}
if ($AltColor eq "#f7f7f7") {
	$AltColor = "#dedfdf";
} else {
$AltColor = "#f7f7f7"
}

print <<GUTS;
<tr bgcolor=$AltColor>
<td align=center>
<INPUT TYPE="CHECKBOX" NAME="Delete::$ProfileNum" VALUE="yes">
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><A HREF="cpanel4.cgi?action=getbio4admin&UserNumber=$ProfileNum" target=_blank>$searchrow[0]</A><BR>$ProfileNum<BR>$DateReg</font></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminWrite::$ProfileNum" VALUE="true" $WriteYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminWrite::$ProfileNum" VALUE="false" $WriteNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminPermission::$ProfileNum" VALUE="true" $AdminYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminPermission::$ProfileNum" VALUE="false" $AdminNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$ThisStatus</FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$searchrow[4]</FONT></td></tr>
GUTS

} #end FOREACH


} # end UserInfoRows








sub GetAll {
&GetMemberListArray; #returns @members array

@themembers = sort(@members);
$TotalProfiles = @themembers;
	
my $MaxDisplay = 50;  
if ($in{'StartPoint'} eq "") {
	$StartPoint = 1;
	if ($TotalProfiles <= $MaxDisplay) {
		$EndPoint = $TotalProfiles;
		$Done = "true";
	} else {
	$Done = "";
	$EndPoint = $MaxDisplay;
	}
	$EP = $EndPoint - 1;

} else {

$StartPoint = $in{'StartPoint'};
$EndPoint = $StartPoint + $MaxDisplay;
$EndPoint = $EndPoint - 1;
	if ($TotalProfiles <= $EndPoint) {
		$EndPoint = $TotalProfiles;
		$Done = "true";
	}  else {
		$Done = "";
	}

}

$SP = $StartPoint - 1;
$EP = $EndPoint - 1;
@themembers = @themembers[$SP..$EP];

if ($Done ne "true") {
$NextStart = $EndPoint + 1;
$NextWording = qq(<A HREF="cpanel4.cgi?action=getmatches&StartPoint=$NextStart&NN=$SearchNameCoded&Email=$in{'Email'}&Math=$in{'Math'}&Posts=$in{'Posts'}&ViewEntire=$in{'ViewEntire'}">[Next Matches]</A>);
} else {
$NextWording = "";
}
if ($TotalProfiles == 0) {
$StartPoint = 0;
}
	
if ($TotalProfiles > 0) {	

&PermissionsTopHTML;

for $line(@themembers) {
$ProfileNumber = &GetUserNumber($line);
@searchrow = &OpenProfile("$ProfileNumber.cgi");

$UNCoded = $searchrow[0];
$UNCoded =~ tr/ /+/;
$Posts = $searchrow[7];
$Permission = $searchrow[4];
&CheckPermissions;
$DateReg = $searchrow[10];
$WriteYes = "";
$WriteNo = "";
$AdminYes="";
$AdminNo="";

if ($searchrow[8] eq "Administrator") {
	$ThisStatus = "$AdminTitle";
}
elsif ($searchrow[8] eq "Moderator") {
	$ThisStatus = "$ModeratorTitle";
}
elsif ($searchrow[8] eq "Member") {
	$ThisStatus = "$MemberTitle";
}  else {
	$ThisStatus = "$JrMemberTitle";
}
if ($AdminWrite eq "true") {
   $WriteYes = "CHECKED";
}  else {
   $WriteNo = "CHECKED";
}
if ($AdminPermission eq "true") {
   $AdminYes = "CHECKED";
}  else {
   $AdminNo = "CHECKED";
}

if ($AltColor eq "") {
	$AltColor = "#dedfdf";
}
if ($AltColor eq "#f7f7f7") {
	$AltColor = "#dedfdf";
}  else {
$AltColor = "#f7f7f7";
}

print <<GUTS;
<tr bgcolor="$AltColor">
<td align=center>
<INPUT TYPE="CHECKBOX" NAME="Delete::$ProfileNumber" VALUE="yes">
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><A HREF="cpanel4.cgi?action=getbio4admin&UserNumber=$ProfileNumber" target=_blank>$searchrow[0]</A><BR>$ProfileNumber<BR>$DateReg</font></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminWrite::$ProfileNumber" VALUE="true" $WriteYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminWrite::$ProfileNumber" VALUE="false" $WriteNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminPermission::$ProfileNumber" VALUE="true" $AdminYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminPermission::$ProfileNumber" VALUE="false" $AdminNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$ThisStatus</FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$searchrow[7]</FONT></td>
</tr>
GUTS

####
} #end FOREACH

print <<ENDHTML;
</table>
</td></tr></table>
</center>
<br>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER>
<p>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Permission Changes Now">
</form><FONT COLOR="#C0C0C0">
<BR><BR>$infopopcopy<BR>
Ultimate Bulletin Board $Version<BR><BR></CENTER>
</FONT>
</FONT>
</body>
</html>
ENDHTML
}  else {
&StandardHTMLCP("Sorry, but we couldn't find any users that matched your search criteria.  Please go back and try again!");
}
}  ## END GET ALL SR ##

sub GetBio4Admin {
$ProfileNum = shift;

&get_cookie;  #retrieves all current cookies
if ($cookie{UserNameCP}) {
$CheckUserName = "$cookie{UserNameCP}";
$CheckPassword = "$cookie{PasswordCP}";
}
elsif ($in{'UserName'}) {
$CheckUserName = $in{'UserName'};
$CheckPassword = $in{'Password'};
}  else {
$PageTitle = "P R O F I L E &nbsp;&nbsp;&nbsp;&nbsp; V I E W";
$PageIntro = "In order to view this person's profile, you must first identify yourself.  You will not have to do this each time if you allow cookies to be set from your browser.";
$HiddenFields = qq(<INPUT TYPE="HIDDEN" NAME="action" VALUE="getbio4admin"><INPUT TYPE="HIDDEN" NAME="UserNumber" VALUE="$ProfileNum">
 );
&QueryForID("cpanel4.cgi");
exit;
}


#confirm permission to read forum data
&VerifyAdmin($CheckUserName, $CheckPassword);

&log_admin_activity ("GetBio4Admin $CheckUserName $ProfileNum") if ($log_admin_activity eq 'YES');
#confirm identity

if ($Proceed eq "true") {
@thisprofile = &OpenProfile("$ProfileNum.cgi");

$EmailField = qq(<A HREF="mailto:$thisprofile[2]">$thisprofile[2]</A>);

$Permissions = $thisprofile[4];
$Status = $thisprofile[8];

if ($Status eq "Administrator") {
	$Status = "$AdminTitle";
}
elsif ($Status eq "Moderator") {
	$Status = "$ModeratorTitle";
}
elsif ($Status eq "Member") {
	$Status = "$MemberTitle";
}  else {
	$Status = "$JrMemberTitle";
}

($standard, $specific) = split(/\&/, $Permissions);


&ViewBioCPHTML;
}  else {
&StandardHTMLCP("Sorry, you do not have permission to view this person's profile.");
}
}  ## END GET BIO sr


sub ViewBioCPHTML {

$NameCoded = $thisprofile[0];
$NameCoded = &HTMLIFY($NameCoded);
$NameCoded =~ tr/ /+/;

	#check to see if mass mail is allowed
	open (MEMBERLIST, "$MembersPath/memberslist.cgi"); 
    	my @themembers = <MEMBERLIST>;
	close (MEMBERLIST);

	foreach $thisline(@themembers) {
	my @profiles = split(/\|\!\!\|/, $thisline);
	$GetName = $UserName;
	$GetName =~ s/([\^|\.|\$|\*\|\?|\(|\)|\{|\}|\[|\]|\\|\&|\%|\@])/\\$1/isg;
	if ($thisline =~ /^$GetName\|\!\!\|/) {
		chomp($profiles[3]);
		$AllowMassMail = $profiles[3];
	}
}
	
if ($AllowMassMail eq "") {
	$AllowMassMail = "yes";
}

print<<BioHTML;
<HTML>
<HEAD><TITLE>
Ultimate Bulletin Board - Set Permissions</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

function SetCursor() {
var thisUserNameCP = getCookie("UserNameCP");
var thisPasswordCP = getCookie("PasswordCP");

if (thisUserNameCP != null) {  
thisUserNameCP = unescape(thisUserNameCP);
thisPasswordCP = unescape(thisPasswordCP);

	document.PERMISS.UserNameCheck.value = thisUserNameCP;
document.PERMISS.PasswordCheck.value = thisPasswordCP;
	}  else {
	document.PERMISS.UserNameCheck.focus();
	}
}

function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to complete one or more of the form fields.");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
<body bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<FONT Size="2" FACE="Verdana, Arial">
<center>
S E T &nbsp;&nbsp;&nbsp;&nbsp; U S E R &nbsp;&nbsp;&nbsp;&nbsp; P E R M I S S I O N S
<p>
<BR>
<table border=0 cellpadding=0 cellspacing=0 width="90%"><TR><td bgcolor="#000000">

<table cellpadding=4 cellspacing=1 border=0  width=100%>
<TR bgcolor="#C6CFA0">
<TD><FONT SIZE="2" FACE="Verdana, Arial">
<IMG SRC="$NonCGIURL/profile.gif" WIDTH=22 HEIGHT=11 BORDER=0 ALT="Profile"> &nbsp;&nbsp;&nbsp;Profile for $thisprofile[0] 
</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial"><A HREF="$CGIURL/search.cgi?action=simplesearch&ForumChoice=ALL&SearchUser=$NameCoded&ExactName=yes">View Posts By This User</A></font></td></tr>
<tr bgcolor="#C6CFA0"><td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Date Registered:</B></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[10] &nbsp;</FONT>
</td></tr>
<tr bgcolor="#C6CFA0"><td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Status:</B></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$Status &nbsp;</FONT>
</td></tr>
<tr bgcolor="#C6CFA0"><td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Total Posts:</B></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[7] &nbsp;</FONT>
</td></tr>
<tr bgcolor="#C6CFA0"><td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Current Email:</B></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$EmailField &nbsp;</FONT>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Homepage:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$thisprofile[3]" target=_top>$thisprofile[3]</A> &nbsp;</font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Occupation:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[5] &nbsp;</font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Location:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[6] &nbsp;</font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Interests:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[9] &nbsp;</font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>ICQ Number:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[13] &nbsp;</font>
</td></tr>


<tr bgcolor="#C6CFA0">
<td valign=top><FONT SIZE="2" FACE="Verdana, Arial"><B>
Signature</FONT></B>
</td>
<td>
<TEXTAREA NAME="Signature" ROWS=3 COLS=25>$Signature
</TEXTAREA>
</td></tr>

 <TR bgcolor="#C6CFA0">
	<TD><FONT SIZE="2" FACE="Verdana, Arial"><B>Allow Bulletin Board Administrators and Moderators To Send User Email Notices?</B></FONT></TD>
	<TD><FONT SIZE="2" FACE="Verdana, Arial">$AllowMassMail</FONT>
 </TD></tr>
 

</table>

</td></tr></table>
<P>
Permissions for this User in Private or Restricted Access Forums:<P>
BioHTML


my $NoAccess = "";
my $DoList = "";
#get users current forum permissions--
if ($Permissions =~ m/Admin/) {
	print "This user is an administrator and thus has permission to view and post to all forums.";
}  
elsif ($Status eq "Moderator") {
print "This user is a Moderator.  Moderators have complete access to all forums for which they moderate.  For forums for which the user is Moderator, full access may not be removed.  We have summarized this user's access in the following private or restricted-access forums.";
}  

print<<ACCESS;
<BR>
<FORM ACTION="$CGIURL/cpanel4.cgi" METHOD="POST" NAME="PERMISS">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="updatepermissforums">
<INPUT TYPE="HIDDEN" NAME="regnumber" VALUE="$ProfileNum">
<table border=0 width=95%>
<tr bgcolor="#d5d2bb">
<TD><FONT SIZE="1" FACE="Verdana, Arial">Forum Name</font></td><td><FONT SIZE="1" FACE="Verdana, Arial">Forum Status</font></td><td><FONT SIZE="1" FACE="Verdana, Arial">Grant User Permission in this Forum?</font></td></tr>
ACCESS

if  (($specific ne "") || ($Status eq "Administrator") || ($Status eq "Moderator"))  {
@forumaccess = split(",", $specific);
} else {
$NoAccess = "true";
}

#get forum info- find private or limited write forums
@forums = &OpenForumsFile;
@sortfor = sort(@forums);
@sortforums = reverse(@sortfor);

for $each2(@sortforums) {
	@ForumLine = split(/\|/, $each2);
	
		if (($ForumLine[6] eq "private") || ($ForumLine[6] =~ /restrict/)) {
if ($ForumLine[6] eq "private") {
	$StatusWord = "Private";
	$Describe1 = "Grant access for this user.";
}  else {
	$StatusWord = "Restriction on Writing Posts and/or Replies";
	$Describe1 = "Allow this user to post new topics and/or replies in this forum.";
} 

my $ThisMod = "";

if ($Status eq "Moderator") {
$Moderator = ("Forum" . "$ForumLine[8]" . "Moderator");
$Moderator = $$Moderator;
@mods = split(/\|\|\^\|\|/, $Moderator);

foreach $unomod(@mods) {
	if ($unomod eq "$thisprofile[0]") {
		$ThisMod = "true";
	}
}
}

if ($NoAccess eq "true") {
$CheckMark = "";
}  else {

$CheckMark = "";

foreach $uno(@forumaccess) {
chomp($uno);
$uno =~ tr/ //;
	if ($uno eq "$ForumLine[8]") {
	$CheckMark = "CHECKED";
	}
}

}
if ($Permissions =~ m/Admin/) {
print<<SelectHTML;
<TR>
<TD><FONT SIZE="1" FACE="Verdana, Arial">$ForumLine[1]</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">$StatusWord</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">User is Administrator!  Unrestricted Access/Permissions in this forum.</font></td></tr>
SelectHTML
}
elsif ($ThisMod eq "true") {
print<<SelectHTML;
<TR>
<TD><FONT SIZE="1" FACE="Verdana, Arial">$ForumLine[1]</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">$StatusWord</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">User is Moderator!  Unrestricted Access/Permissions in this forum.</font></td></tr>
SelectHTML
}  else {
print<<SelectHTML;
<TR>
<TD><FONT SIZE="1" FACE="Verdana, Arial">$ForumLine[1]</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">$StatusWord</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial"><INPUT TYPE="CHECKBOX" NAME="Access" VALUE="$ForumLine[8]" $CheckMark>
$Describe1</font></td></tr>
SelectHTML
}
}
	
}  #end for loop

print<<theend;
</table>
theend


print<<BioHTML2;
<P>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B>
<P>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Permission Changes For This User">
</CENTER>
</form>
</font>
</BODY></HTML>
BioHTML2
}  ## END View BIO HTML sr


sub UpdatePermiss {

&log_admin_activity("UpdatePermiss") if ($log_admin_activity eq 'YES');

 if ($in{'UserName'}) { # process the request the usual way if it is from the control panel
	
	$ProfileNumber = &GetUserNumber($in{'UserNameCheck'});
	$ProfileNumber =~ s/\D//sg;

	@theprofile = &OpenProfile("$ProfileNumber.cgi");

	if ($in{'PasswordCheck'} eq "$theprofile[1]") {
	  $Status = "$theprofile[8]";
	   if ($Status eq "Administrator") {
			&UpdateThePermissions;
	   }  else {
			&StandardHTMLCP("Sorry, but you are not authorized to perform this function.  Use your Back button.");
	   } #end if admin status is true 
	}  else {
		&StandardHTMLCP("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
 }else { # process based on admin cookie if it is from a direct link.
	&ConfirmAdminCookie;	
	&UpdateThePermissions;
 }
}  ## END UPdatePermiss SR ###


sub UpdateThePermissions {

@deletefile = @blank;

foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
		$matchAW = $row2 =~ m/AdminWrite/;
		if ($matchAW eq "1")  {
		    ($type, $UserNumber) = split(/::/, $Name);
			if ($Value eq "true") {
			       $Value = "Write";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserNumber|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserNumber") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserNumber|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1

		$matchAP = $row2 =~ m/AdminPermission/;
		if ($matchAP eq "1")  {
		    ($type, $UserNumber) = split(/::/, $Name);
			if ($Value eq "true") {
			       $Value = "Admin";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserNumber|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserNumber") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserNumber|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1

	$matchDelete = $row2 =~ m/Delete/;
		if ($matchDelete eq "1")  {
		    ($type, $UserNumber) = split(/::/, $Name);
			if ($Value eq "yes") {
			       $Value = "Delete";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserNumber|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserNumber") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserNumber|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1
	}  # end foreach row2

##have array of changes now
##open each profile to make changes
@deletefile = @blank;
foreach $updatename(@changes) {
($thisnumber, $ThisPerm) = split(/\|/, $updatename);
chomp($ThisPermission);
chomp($thisnumber);

	if ($ThisPerm =~ m/Delete/) {
	push(@deletelist, $thisnumber);		unlink("$MembersPath/$thisnumber.cgi");
	}  else {
		#in case file permissions are off...
		@theprofile = @blank;
		chmod (0777, "$MembersPath/$thisnumber.cgi");
		@theprofile = &OpenProfile("$thisnumber.cgi");    
	chomp($theprofile[0]);
		chomp($theprofile[1]);
			chomp($theprofile[2]);
				chomp($theprofile[3]);
					chomp($theprofile[5]);
						chomp($theprofile[7]);
							chomp($theprofile[9]);
								chomp($theprofile[10]);
chomp($theprofile[14]);
chomp($theprofile[13]);
chomp($theprofile[12]);
chomp($theprofile[11]);
						
		if ($ThisPerm =~ m/Admin/) {
			$UserStatus = "Administrator";
		} else { 
		@modslist = &OpenFile("$VariablesPath/mods.file");
		$ModsTotal = @modslist;
		@modsarray = @blank;
			for ($x = 1; $x <= $ModsTotal; $x++) {
				$GetModerator = ("Forum" . "$x" . "Moderator");
				$Moderator = $$GetModerator;
				@mods = split(/\|\|\^\|\|/, $Moderator);
				@modsarray = (@modsarray, @mods);
			}
	$Modfound = "";
			CHECKMODS: foreach $uno(@modsarray) {
			chomp($uno);
				if ($uno eq "$theprofile[0]") {
					$UserStatus = "Moderator";
					$Modfound = "yes";
					last CHECKMODS;
				}
			}
		if ($Modfound ne "yes") {
			if ($theprofile[7] < $MemberMinimum) {
				$UserStatus = "Junior Member";
				}  else {
				$UserStatus = "Member";
				}
		}
	} # end if/else admin
chomp($theprofile[4]);
($junk, $currentaccess) = split(/\&/, $theprofile[4]);
chomp($currentaccess);
$PermissionLine = ("$ThisPerm" . "&" . "$currentaccess");
&Lock("lock.file");
	open (MEMBERSHIP, ">$MembersPath/$thisnumber.cgi") or die(&StandardHTML("Unable to open the members file. Here is the error message $!<p>Check directory paths and permissions") );

	print MEMBERSHIP ("$theprofile[0]\n");
	print MEMBERSHIP ("$theprofile[1]\n");
	print MEMBERSHIP ("$theprofile[2]\n");
	print MEMBERSHIP ("$theprofile[3]\n");
	print MEMBERSHIP ("$PermissionLine\n");
	print MEMBERSHIP ("$theprofile[5]\n");
	print MEMBERSHIP ("$theprofile[6]\n");
	print MEMBERSHIP ("$theprofile[7]\n");
	print MEMBERSHIP ("$UserStatus\n");
	print MEMBERSHIP ("$theprofile[9]\n");
	print MEMBERSHIP ("$theprofile[10]\n");
	print MEMBERSHIP ("$theprofile[11]\n");
	print MEMBERSHIP ("$theprofile[12]\n");
	print MEMBERSHIP ("$theprofile[13]\n");
	print MEMBERSHIP ("$theprofile[14]\n");
close (MEMBERSHIP);
&Unlock("lock.file");
chmod (0777, "$MembersPath/$thisnumber.cgi");
}  # END IF match del
}  ## FOREACH

#update the memberslist.cgi file
if ($deletelist[0] ne "") {
&UpdateMembersList;
}

&notify_user('posting') if ($in{'RemoteUpdate'} eq 'TRUE');

&EndUpdate("U S E R S &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "<center>Thank you!  We have made the user changes that you requested.</center>");


} # End UpdateThePermissions sr


sub PermissionsTopHTML {
print <<PermissionsTop;
<HTML>
<HEAD><TITLE>
Ultimate Bulletin Board - Set Permissions</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}
function SetCursor() {
var thisUserNameCP = getCookie("UserNameCP");
var thisPasswordCP = getCookie("PasswordCP");

if (thisUserNameCP != null) {  
thisUserNameCP = unescape(thisUserNameCP);
thisPasswordCP = unescape(thisPasswordCP);

	document.PERMISS.UserNameCheck.value = thisUserNameCP;
	document.PERMISS.PasswordCheck.value = thisPasswordCP;
	}  else {
	document.PERMISS.UserNameCheck.focus();
	}
}

function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to complete one or more of the form fields.");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
<body bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<FONT Size="2" FACE="Verdana, Arial">
<center>
S E T &nbsp;&nbsp;&nbsp;&nbsp; U S E R &nbsp;&nbsp;&nbsp;&nbsp; P E R M I S S I O N S</center>
<p>
There are currently $TotalProfiles registered bulletin board members.
Make any changes necessary and then click on "Submit" to modify any/all user records.  Check the delete box on the left for all registrations you want deleted.<P>

<FORM ACTION="cpanel4.cgi" METHOD="POST" NAME="PERMISS" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="updatepermiss">
<center>
Click on name for profile details and advanced permission settings.
<BR>
<table border=0 cellpadding=0 cellspacing=0 width="95%"><TR><td bgcolor="#000000">

<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>
<TR bgcolor="#FFFFFF">
<TD colspan=6><FONT FACE="Verdana, Arial" SIZE="1">Displaying Matches $StartPoint - $EndPoint ($TotalProfiles total) &nbsp;&nbsp;&nbsp;&nbsp; $NextWording</FONT>
</td>
</tr>
<tr bgcolor="#B0BB9D">
<td valign=bottom>
<FONT SIZE="1" FACE="Verdana, Arial">
<B>Delete?</B></font>
</td>
<td valign=bottom width=140><FONT SIZE="1" FACE="Verdana, Arial"><B>User Name<BR>Reg. Number<BR>Date Registered</B></FONT></td>
<td valign=bottom ><FONT SIZE="1" FACE="Verdana, Arial"><B>Able to post notes?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Authorized Administrator?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Status</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Total Posts</B></FONT></td>
</tr>
PermissionsTop

} # end Permissions Top

sub CheckStatus {
		if ($Status =~ m/Administrator/) {
			$AdminStatus = "true";
			} else {
			$AdminStatus = "false";
		}
		if ($Status =~ m/Moderator/) {
			$ModStatus = "true";
		} else {
			$ModStatus = "false";
		}
		if ($Permission =~ m/Write/) {
			$AdminWrite = "true";
		} else {
			$AdminWrite = "false";
		}
} #end CheckStatus

sub UpdatePermissForums {

$ProfileNumber = &GetUserNumber($in{'UserNameCheck'});

&log_admin_activity ("UpdatePermissForums $ProfileNumber") if ($log_admin_activity eq 'YES');

@adminprofile = &OpenProfile("$ProfileNumber.cgi");

if ($in{'PasswordCheck'} eq "$adminprofile[1]") {
	$Status = "$adminprofile[8]";
	   if ($Status eq "Administrator") {
			&UpdateThePermForums;
		}  else {
			&StandardHTMLCP("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		} #end if adminstatus is true 
}  else {
&StandardHTMLCP("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}

} #end update permiss forums



sub UpdateThePermForums {

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
		if ($Name eq "Access") {
			  push(@accessarray, $Value)
		}
}

if (@accessarray) {
$AccessLine = join(",", @accessarray);
}  else {
$AccessLine = "";
}
$profilenum = $in{'regnumber'};
 
@theprofile = &OpenProfile("$profilenum.cgi");
$OldPermission = $theprofile[4];
($general, $specific) = split(/\&/, $OldPermission);
$NewPermission = ("$general" . "&" . "$AccessLine");
$theprofile[4] = $NewPermission;

&Lock("lock.file");
open (MEMBERSHIP, ">$MembersPath/$profilenum.cgi") or die( &StandardHTML("Unable to open Members directory. $!") );

foreach $one(@theprofile) {
chomp($one);
	print MEMBERSHIP ("$one\n");
}
close (MEMBERSHIP);
&Unlock("lock.file");
chmod (0777, "$MembersPath/$profilenum.cgi");
		&EndUpdate("U S E R &nbsp;&nbsp;&nbsp;&nbsp; P E R M I S S I O N S  &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "Thank you.  We have made the changes you requested.");

&notify_user('private') if  ($UseEmail eq 'ON');

}  #end updatethepermforums


sub UpdateMembersList {


 my @thesemembers = &OpenFile("$MembersPath/memberslist.cgi");

foreach $thisline(@thesemembers) {
	chomp($thisline);
	my @thisprofile = split(/\|\!\!\|/, $thisline);
	$DeleteLine = "";
	
	foreach $deletenum(@deletelist) {
		chomp($deletenum);
		if ($deletenum eq "$thisprofile[1]") {
			$DeleteLine = "true";
		}
	}
	if ($DeleteLine ne "true") {
		push(@newlist, $thisline);
	}

}

&Lock("lock.file");
open (LIST, ">$MembersPath/memberslist.cgi");
	foreach $uno(@newlist) {
		chomp($uno);
		print LIST "$uno\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0777, "$MembersPath/memberslist.cgi");

#update email file too
  my @doemails = &OpenFile("$MembersPath/emailfile.cgi");

foreach $thisline2(@doemails) {
	chomp($thisline2);
	my @profiles2 = split(/\|\|/, $thisline2);
	$DeleteLine = "";
	
	foreach $deletenum(@deletelist) {
		chomp($deletenum);
		if ($deletenum eq "$profiles2[1]") {
			$DeleteLine = "true";
		}
	}
	if ($DeleteLine ne "true") {
		push(@emaillist, $thisline2);
	}

}

&Lock("lock.file");
open (LIST, ">$MembersPath/emailfile.cgi");
	foreach $uno2(@emaillist) {
		chomp($uno2);
		print LIST "$uno2\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0777, "$MembersPath/emailfile.cgi");
unlink("$MembersPath/temp.file");
}  #end update Members List



sub modregs {

&get_cookie;  #retrieves all current cookies


if ($in{'UserName'}) {
$CheckUserName = $in{'UserName'};
$CheckPassword = $in{'Password'};
}elsif ($cookie{UserNameCP}) {
$CheckUserName = "$cookie{UserNameCP}";
$CheckPassword = "$cookie{PasswordCP}";
}

#confirm permission to read forum data
&VerifyAdminCP($CheckUserName, $CheckPassword);

&log_admin_activity("modregs $in{'matchon'} $CheckUserName ");

$matchon = $in{'matchon'};

opendir (MEMS, "$MembersPath");
@thememberarray = readdir(MEMS);
closedir (MEMS);
@memberarray = grep(/^\d{8}\.cgi$/, @thememberarray);


$TotalProfiles = ($#memberarray + 1);
@memberarray = reverse(@memberarray);

if ( ($in{'searchback'} > $#memberarray) || ($in{'searchback'} eq 'all') ){ $in{'searchback'} = $#memberarray};

$in{'searchback'} =~ s/\D//g;

for ($i=0;$i <= $in{'searchback'};$i++) {
	@searchfile = &OpenProfile("$memberarray[$i]");
	if($searchfile[4] =~ m/$matchon/o){
	 $ProfileNumber = substr($memberarray[$i],0,8);
	 $line = ("$searchfile[0]" .  "|||" .  "$searchfile[2]" .  "|||"  . "$searchfile[4]" . "|||" . "$searchfile[8]" . "|||" . "$searchfile[7]" . "|||" . "$searchfile[10]" . "|||" . "$ProfileNumber");
	 push (@final, $line);
	}
}

if (@final) {

&PermissionsTopHTML;
&UserInfoRows; # supply @final

print <<ENDHTML;
</table>
</td></tr></table>
<br>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER><P>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Permission Changes Now">
</form><FONT COLOR="#C0C0C0">
<BR><BR>$infopopcopy<BR>
Ultimate Bulletin Board $Version<BR><BR>.</CENTER>
</FONT>
</FONT>
</body>
</html>
ENDHTML

} # end if (@final)

else {
&StandardHTMLCP("Sorry, but we couldn't find any users within the last $in{'searchback'} registrations that match your search.  Please go back and try again!");	
}
	
	
} # end modregs


sub log_admin_activity {
	
my $admin_action = shift;
open(ADMINLOG, ">>$NonCGIPath/BanLists/adminlog.cgi");
print ADMINLOG localtime() . " $admin_action $in{'UserName'}$in{'UserNameCheck'} $ENV{'REMOTE_ADDR'} $ENV{'REMOTE_HOST'} $ENV{'HTTP_USER_AGENT'} $ENV{'HTTP_REFERER'}\n";
close(ADMINLOG);
chmod (0777, "$NonCGIPath/BanLists/adminlog.cgi");
return 1;
} # end SR




sub notify_user {
	
my $notifytype = shift;

$sendto = $theprofile[2];
$ReplyTo = $RegsAdminEmail;

if ($notifytype eq 'posting') {

$subject = "Your Posting Privileges Active";

$message = qq(

Hello $theprofile[0]

We have activated your posting privileges at $BBName

$CGIURL/Ultimate.cgi

 Your username is $theprofile[0]
 
 Your password is $theprofile[1]

Thanks for registering and welcome!

Questions about your registration? Contact $RegsAdminEmail




); # end qq

} # end if notifytype = posting



elsif ($notifytype eq 'private')  {

$subject = "Your Access to a Private Forum";

$message = qq(

Hello $theprofile[0]

We have given you access to private forum\(s\) [ xx]  at $BBName

$CGIURL/Ultimate.cgi

Questions about your registration? Contact $OnRegsAdmin	

); # end qq
	
}

else { # no command - do nothing
return 1;	
} 

require "mail-lib.pl";

# send the email
$BBEmail = $ReplyTo; # make email return properly

if ($SMTPEmail eq "On") {
	&SendEmail;
}else {
	&send_mail("$ReplyTo", "$sendto", "$subject", "$message");
}


} # end SR

sub UpdateVersion {

print <<VERSIONHTML
<html>
<head>
<title>Update Your License</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>

<body bgcolor="#FFFFFF" text="#000000" link="#0000FF" vlink="#0000FF" alink="#FF6633">
<p align="center"><font face="Verdana, Arial, Helvetica, sans-serif" size="2"><br>
  U P D A T E S</font></p>
<blockquote><font face="Verdana, Arial, Helvetica, sans-serif" size="2">To check 
  the status of your UBB License or to update your license records, type your 
  license number and password below. Remember that you must list the name of your 
  bulletin board and the URL for your UBB for each license you possess, including 
  leased licenses. To view the UBB License Agreement, <a 
  href="http://www.ultimatebb.com/home/licenseagree.html">click here</a>. </font></blockquote>
<form method="post" action="http://www.ultimatebb.com/home/license.cgi">
  <table border=0 cellpadding=0 cellspacing=0 width="65%" align=center><TR><td bgcolor="#000000">
        <table width="100%" border="0" cellspacing="1" cellpadding="4" align="center">
          <tr> 
            <td width="32%" bgcolor="#b0bb9d"><b><font size="2" face="Verdana, Arial, Helvetica, sans-serif">License 
              number:</font></b></td>
            <td width="68%" bgcolor="#b0bb9d"> 
              <input type="text" name="LicenseNumber">
      </td>
    </tr>
          <tr> 
            <td width="32%" bgcolor="#b0bb9d"><b><font size="2" face="Verdana, Arial, Helvetica, sans-serif">License 
              password:</font></b></td>
            <td width="68%" bgcolor="#b0bb9d"> 
              <input type="password" name="LicensePassword">
      </td>
    </tr>
          <tr bgcolor="#b0bb9d"> 
            <td width="31%">&nbsp;</td>
            <td width="68%"><font size="2" face="Arial, Helvetica, sans-serif">Remember 
              that both license number and password are case-sensitive.</font></td>
    </tr>
          <tr bgcolor="#b0bb9d"> 
            <td width="31%" bgcolor="#b0bb9d">&nbsp;</td>
            <td width="68%"><font face="Verdana, Arial, Helvetica, sans-serif" size=2> 
              <input name=action type=hidden 
  value=getlicense>
              <input name=Submit type=submit value="Check My License Info">
              <input name=Reset type=reset value="Clear">
        </font></td>
    </tr>
  </table></td></tr></table>
</form>
<blockquote>
  <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Lost your license 
    information? Please open a <a href="http://www.ultimatebb.com/home/lostlicense.html"> 
    Lost License Request Ticket</a>.</font></p>
  <form method="post" action="http://www.ultimatebb.com/home/version.cgi" name="versioncheck">
    <table border=0 cellpadding=0 cellspacing=0 width="65%" align=center>
      <tr>
        <td bgcolor="#000000"> 
          <table width="100%" border="0" cellspacing="1" cellpadding="4" align="center">
            <tr> 
              <td width="31%" bgcolor="#b0bb9d"><b><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Your 
                Current Version:</font></b></td>
              <td width="69%" bgcolor="#b0bb9d"> <font face="Verdana, Arial, Helvetica, sans-serif"><b><font size="2">$Version</font></b></font></td>
            </tr>
            <tr bgcolor="#b0bb9d"> 
              <td width="31%">&nbsp;</td>
              <td width="69%"><font face="Verdana, Arial, Helvetica, sans-serif" size=2> 
                <input name=action type=hidden 
  value=getlicense>
                </font><font face="Verdana, Arial" size="2"> 
                <input type="hidden" name="Yours" value="$VersionNumber">
                <input name=Submit22 type=submit value="Check for the Latest Version Now!">
                </font><font face="Verdana, Arial, Helvetica, sans-serif" size=2> 
                </font></td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </form>

    
  <p><font face="Verdana, Arial, Helvetica, sans-serif" size="2">All updates and 
    new versions of the Ultimate Bulletin Board can be downloaded in the <a href="http://www.ultimatebb.com/ubbmembers/ubbmembers.shtml">Members 
    Area</a>.</font></p>
  <form method="post" action="">
    <table border=0 cellpadding=0 cellspacing=0 width="65%" align=center>
      <tr> 
        <td bgcolor="#000000"> 
          <table width="100%" border="0" cellspacing="1" cellpadding="4" align="center">
            <tr> 
              <td width="31%" bgcolor="#b0bb9d"><b><font size="2" face="Verdana, Arial, Helvetica, sans-serif">OpenTopic:</font></b></td>
              <td width="69%" bgcolor="#b0bb9d"> <font face="Verdana, Arial, Helvetica, sans-serif" size="2"><a href="http://beta.infopop.net">http://beta.infopop.net</a> 
                (OpenTopic Beta) </font></td>
            </tr>
            <tr bgcolor="#b0bb9d"> 
              <td width="31%">&nbsp;</td>
              <td width="69%"> 
                <p><font face="Verdana, Arial, Helvetica, sans-serif" size=2> 
                  </font><font face="Verdana, Arial" size="2"> </font><font face="Verdana, Arial, Helvetica, sans-serif" size=2> 
                  Are you looking for a scalable, enterprise-level discussion 
                  solution? OpenTopic, our next generation community platform, 
                  is an outsourcing solution for sites needing extra power and 
                  reliability. </font></p>
                <p><font size="2" face="Verdana, Arial, Helvetica, sans-serif">Using 
                  OpenTopic, your site will benefit with additional features such 
                  as<b> ratings</b>, <b>polls</b>, <b>attachments</b>, <b>faster 
                  search</b> capabilities, <b>community analysis</b> tools and 
                  <b>XML</b> data that will enable you to easily promote user-generated 
                  content elsewhere on your site. To learn more about OpenTopic,fill 
                  out <a href="http://www.infopop.com/home/form.html">this form</a> and 
                  someone will contact you shortly.</font></p>
                </td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </form>
  <p>&nbsp;</p>
  <center><BR><BR>$infopopcopy<BR>
<font face="Verdana, Arial, Helvetica, sans-serif" size=1>Ultimate Bulletin Board $Version<BR><BR>
</font></p></center>
</blockquote>
</body>
</html>

VERSIONHTML
	
} # end SR










exit(0); # comply with SafePerl

