#!/usr/bin/perl

#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Infopop Corporation, 1997, 1998, 1999, 2000.
#
#       ------------ cpanel2.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  NOTE: you MAY NOT distribute this script under any
#  circumstance.  This means that you may not sell, trade, or in
#  any other way give this script to another user who is not
#  licensed to use it.  Infopop Corporation offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "mods.file";
require "Date.pl";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";
};


if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);

if ($Name eq "action") {
		$action = $Value;
}

if ($action eq 'setgenvars') { # only process for this routine

	&checkpathlock; # see if paths are locked

	if ($Name eq "BBEmail") {
		$BBEmail = $Value;
		$BBEmail =~ s/@/\\@/;
	}
			
	if ($Name eq "BBRules") {
		$BBRules = $Value;
		$BBRules =~ s/"/&quot;/g;
		$BBRules =~ s/\@/\\@/g;
		$BBRules = &ConvertReturns($BBRules);
	}
		
	if ($Name eq "COPPAWording") {
		$COPPAWording = $Value;
		$COPPAWording =~ s/"/&quot;/g;
		$COPPAWording =~ s/\@/\\@/g;
		$COPPAWording = &ConvertReturns($COPPAWording);
	}
	if ($Name eq "COPPAInstructions") {
		$COPPAInstructions = $Value;
		$COPPAInstructions =~ s/"/&quot;/g;
		$COPPAInstructions =~ s/\@/\\@/g;
		$COPPAInstructions = &ConvertReturns($COPPAInstructions);
	}	
	
	if ($Name eq "BBClosedMessage") {
		$BBClosedMessage = $Value;
		$BBClosedMessage =~ s/"/&quot;/g;
		$BBClosedMessage =~ s/\@/\\@/g;
		$BBClosedMessage = &ConvertReturns($BBClosedMessage);
	}		
		
	if ($Name eq "censorwords") {
		$censorwords = $Value;
		$censorwords = &EliminateReturns($censorwords);
		$censorwords =~ s/<BR>//ig;
		$censorwords =~ s/<P>//ig;
		$censorwords =~ s/"/&quot;/g;
		$censorwords =~ s/\@/\\@/g;
	}
	if ($Name eq "EmailBan") {
		$EmailBan = $Value;
		$EmailBan = &EliminateReturns($EmailBan);
		$EmailBan =~ s/<BR>//ig;
		$EmailBan =~ s/<P>//ig;
		$EmailBan =~ s/"/&quot;/g;
		$EmailBan =~ s/\@/\\@/g;
	}
	if ($Name eq "YourCopyrightNotice") {
		$YourCopyrightNotice = $Value;
		$YourCopyrightNotice = &EliminateReturns($YourCopyrightNotice);
		$YourCopyrightNotice =~ s/"/&quot;/g;
		$YourCopyrightNotice =~ s/<BR>//ig;
		$YourCopyrightNotice =~ s/<P>//ig;
		$YourCopyrightNotice =~ s/\@/\\@/g;
	}
	if ($Name eq "Header") {
		$Header = $Value;
		$Header = &LimitReturns($Header);
	}
	if ($Name eq "Footer") {
		$Footer = $Value;
		$Footer = &LimitReturns($Footer);
	}
	if ($Name eq "MyHomePage") {
		$MyHomePage = $Value;
	}
	if ($Name eq "HomePageURL") {
		$HomePageURL = $Value;
	}
	if ($Name eq "BBName") {
		$BBName = $Value;
	}
	if ($Name eq "ForumsPath") {
		$ForumsPath = $Value;
	}
	if ($Name eq "MembersPath") {
		$MembersPath = $Value;
	}
	if ($Name eq "CGIPath") {
		$CGIPath = $Value;
	}
	if ($Name eq "VariablesPath") {
		$VariablesPath = $Value;
	}
	if ($Name eq "NonCGIPath") {
		$NonCGIPath = $Value;
	}
	if ($Name eq "CGIURL") {
		$CGIURL = $Value;
	}
	if ($Name eq "NonCGIURL") {
		$NonCGIURL = $Value;
	}
} # end if action = setgenvars

	if ($Name eq "UserNameCheck") {
		$UserNameCheck = $Value;
		$UserNameCheckFile = $UserNameCheck;
		$UserNameCheckFile =~ s/ /_/g; #remove spaces
	}
	if ($Name eq "UserName") {
		$UserName = $Value;
		$UserName = &UNHTMLIFY($UserName);
		$UserNameFile = $UserName;
		$UserNameFile =~ s/ /_/g; #remove spaces
		$UserNameCoded = $UserName;
		$UserNameCoded = &HTMLIFY($UserNameCoded);
		$UserNameCoded =~ tr/ /+/;
	}
	if ($Name eq "Password") {
		$Password = $Value;
		$PasswordCoded = $Password;
		$PasswordCoded =~ tr/ /+/;
		}
	if ($Name eq "PasswordCheck") {
		$PasswordCheck = $Value;
		$PasswordCheckCoded = $PasswordCheck;
		$PasswordCheckCoded =~ tr/ /+/;
	}
	if ($Name eq "number") {
		$number = $Value;
		$number =~ s/\D//sg;
	}
	if ($Name eq "UpdateType") {
		$UpdateType = $Value;
	}		
	if ($Name eq "TotalForums") {
		$TotalForums = $Value;
	}
} #end foreach loop


#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$NonCGIURL/$PageBackground");
}

if ($TableBorderColor ne ""){
$TableWidth2 = "100%";
$BorderTop = qq(<table border=0 cellpadding=0 cellspacing=0 width="$TableWidth"><TR><td bgcolor="$TableBorderColor">);
$BorderBottom = qq(</td></tr></table> );
}  else {
$TableWidth2 = $TableWidth;
$BorderTop = "";
$BorderBottom = "";
}

if ($action eq "mods") {
	&Mods;
	exit;
}

if ($action eq "setgenvars") {
	&SetGenVars;
	exit;
}
if ($action eq "doindex") {
	&DoIndex;
   	exit;
}

if ($action eq "sendstyle") {
	&SendStyle;
	exit;
}

if ($action eq "sendvarID") {
	&SendVarID;
	exit;
}

if ($action eq "continueMC") {
	$OldFormat = $in{'OldFormat'};
	if (-e "$MembersPath/holdmems.cgi") {
		&ContinueMC($in{'startwith'}, $OldFormat);
	}  else {
		&StandardHTMLCP("We cannot convert any members - nothing to convert.");
	}
}

if ($action eq "DoGenVars") {
	&DoGenVars;
	exit;
}

if ($action eq "ContinueIndexing") {
	&ConfirmAdminModCookie;

	if ($IndexMethod eq "ONEFILE") {
	&ReIndex("$in{'start'}", "$in{'threadpoint'}");
	}  else {
	&ReIndex2("$in{'start'}", "$in{'threadpoint'}");
	}
	exit;
}


# end
exit(0);

sub SendVarID {
##verify that this user is an administrator
#check to see which Member Format is in place, process accordingly
if (-e "$MembersPath/memberslist.cgi") {

$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

}  else {

$ProfileNumber = $UserNameFile;


$NameFound = "no";
  if (-e "$MembersPath/$ProfileNumber.cgi") {
      $NameFound = "yes";
    } 
}

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$ProfileNumber.cgi");
	chomp($theprofile[1]);
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
		chomp($Permission);
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoGenVars;
	   }  else {
	    &StandardHTMLCP("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTMLCP("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTMLCP("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

} # end SendVarsID sr


sub DoGenVars { # show general settings only for the first time install or authorized admins
if (($AdminPermission ne "true") && (-e "$CGIPath/edit.cgi") && (-e "$MembersPath/memberslist.cgi")  && (-d "$NonCGIPath/Forum3") ) {
	&StandardHTMLCP("Your UBB paths are configured.  You must login through the control panel before making any changes.");
	exit;
}  else {
	
	$BBRules =~ s/&quot;/"/ig;
	$BBRules =~ s/<BR>/\n/ig;
	$BBRules =~ s/<p>/\n\n/ig;

	$COPPAWording =~ s/&quot;/"/ig;
	$COPPAWording =~ s/<BR>/\n/ig;
	$COPPAWording =~ s/<p>/\n\n/ig;

	$COPPAInstructions =~ s/&quot;/"/ig;
	$COPPAInstructions =~ s/<BR>/\n/ig;
	$COPPAInstructions =~ s/<p>/\n\n/ig;

	$Header =~ s/\\@/\@/sg;
	#$Header =~ s/\\"/\"/sg;
	$Footer =~ s/\\@/\@/sg;
	#$Footer =~ s/\\"/\"/sg;	

	$BBClosedMessage =~ s/&quot;/"/ig;
	$BBClosedMessage =~ s/<BR>/\n/ig;
	$BBClosedMessage =~ s/<p>/\n\n/ig;

if ($ForumDisplayMax eq "") {
	$FDM40 = "SELECTED";
}
elsif ($ForumDisplayMax == 25) {
	$FDM25 = "SELECTED";
}
elsif ($ForumDisplayMax == 35) {
	$FDM35 = "SELECTED";
}
elsif ($ForumDisplayMax == 40) {
	$FDM40 = "SELECTED";
}
elsif ($ForumDisplayMax == 50) {
	$FDM50 = "SELECTED";
}
elsif ($ForumDisplayMax == 75) {
	$FDM75 = "SELECTED";
}  else {
	$FDMNONE = "SELECTED";
}

if ($HTMLDisplayMax eq "") {
	$HDM40 = "SELECTED";
}
elsif ($HTMLDisplayMax == 15) {
	$HDM15 = "SELECTED";
}
elsif ($HTMLDisplayMax == 25) {
	$HDM25 = "SELECTED";
}
elsif ($HTMLDisplayMax == 35) {
	$HDM35 = "SELECTED";
}
elsif ($HTMLDisplayMax == 40) {
	$HDM40 = "SELECTED";
}
elsif ($HTMLDisplayMax == 50) {
	$HDM50 = "SELECTED";
}
elsif ($HTMLDisplayMax == 75) {
	$HDM75 = "SELECTED";
}  else {
	$HDMNONE = "SELECTED";
}
if ($DaysPruneDefault eq "") {
	$Days20 = "SELECTED";
}
elsif ($DaysPruneDefault == 1) {
	$Days1 = "SELECTED";
}
elsif ($DaysPruneDefault == 2) {
	$Days2 = "SELECTED";
}
elsif ($DaysPruneDefault == 5) {
	$Days5 = "SELECTED";
}
elsif ($DaysPruneDefault == 10) {
	$Days10 = "SELECTED";
}
elsif ($DaysPruneDefault == 20) {
	$Days20 = "SELECTED";
}
elsif ($DaysPruneDefault == 30) {
	$Days30 = "SELECTED";
}
elsif ($DaysPruneDefault == 45) {
	$Days45 = "SELECTED";
}
elsif ($DaysPruneDefault == 60) {
	$Days60 = "SELECTED";
}
elsif ($DaysPruneDefault == 75) {
	$Days75 = "SELECTED";
}
elsif ($DaysPruneDefault == 100) {
	$Days100 = "SELECTED";
}
elsif ($DaysPruneDefault == 1000) {
	$Days1000 = "SELECTED";
}  else {
	$Days365 = "SELECTED";
}
		
if ($CategoryView eq "yes") {
	$CategoryViewOn = "CHECKED";
}  else {
	$CategoryViewOff = "CHECKED";
}
if ($AllowSearch eq "FALSE") {
	$AllowSearchOff = "CHECKED";
}  else {
	$AllowSearchOn = "CHECKED";
}
if ($showcopytype eq "text") {
	$showcopytypeTEXT = "CHECKED";
}  else {
	$showcopytypeIMAGE = "CHECKED";
}

if ($AllowTotalSearch eq "FALSE") {
	$AllowTotalSearchOff = "CHECKED";
}  else {
	$AllowTotalSearchOn = "CHECKED";
}

if ($IndexMethod eq "ONEFILE") {
	$IndexMethodOne = "CHECKED";
}  else {
	$IndexMethodPer = "CHECKED";
}
if ($AllowIcons eq "TRUE") {
	$IconsOn = "CHECKED";
}  else {
	$IconsOff = "CHECKED";
}

if ($ReplyQuote eq "NO") {
	$ReplyQuoteOff = "CHECKED";
}  else {
	$ReplyQuoteOn = "CHECKED";
}

if ($InlineFrame eq "TRUE") {
	$InlineOn = "CHECKED";
}  else {
	$InlineOff = "CHECKED";
}
if ($CategoriesOnly eq "true") {
	$CategoriesOnlyOn = "CHECKED";
}  else {
	$CategoriesOnlyOff = "CHECKED";
}		

if ($EmailVerify eq "ON") {
	$EmailVerifyOn = "CHECKED";
}  else {
	$EmailVerifyOff = "CHECKED";
}

if ($EditOption eq "ON") {
	$EditOptionOn = "CHECKED";
}
elsif ($EditOption eq "OFF") {
	$EditOptionOff = "CHECKED";
}  else {
	$EditOptionND = "CHECKED";
}
					
if ($ForumDescriptions eq "yes") {
	$ForumDescriptionsOn = "CHECKED";
}  else {
	$ForumDescriptionsOff = "CHECKED";
}
		
if ($IP eq "ON") {
	$IPOn = "CHECKED";
}
elsif ($IP eq "LOGONLY") {
	$IPLO = "CHECKED";
}  else {
	$IPOff = "CHECKED";
}

if ($log_admin_activity eq 'YES') {
	$log_admin_activityON = 'CHECKED';	
}else {
	$log_admin_activityOFF = 'CHECKED';	
}	
if ($Censor eq "ON") {
	$CensorOn = "CHECKED";
}  else {
	$CensorOff = "CHECKED";
}
if ($FloodCheck eq "ON") {
	$FloodOn = "CHECKED";
}  else {
	$FloodOff = "CHECKED";
}

if ($FloodCheckSpan eq "") {
	$FloodCheckSpan = "60";
}

if ($AdminTitle eq "") {
	$AdminTitle = "Administrator";
}
if ($ModeratorTitle eq "") {
	$ModeratorTitle = "Moderator";
}		
if ($MemberTitle eq "") {
	$MemberTitle = "Member";
}
if ($JrMemberTitle eq "") {
	$JrMemberTitle = "Junior Member";
}

if ($DisplayMemberTotal eq "true") {
	$MemberTotalOn = "CHECKED";
}  else {
	$MemberTotalOff = "CHECKED";
}		
if ($BBStatus eq "OFF") {
	$BBStatusOff = "CHECKED";
}  else {
	$BBStatusOn = "CHECKED";
}

if ($BBClosedMessage eq '') {
	$BBClosedMessage = "Sorry, this bulletin board is temporarily unavailable, while we perform some routine maintenance. Please try back again later.";
}

if ($SetCookies eq "DirectorySpecific") {
	$COOKIESDS = "CHECKED";
}  else {
	$COOKIESBroad = "CHECKED";
}
if ($SuspendRegister eq "true") {
	$SRTrue = "CHECKED";
}  else {
	$SRFalse = "CHECKED";
}
if ($ForumTotalOption eq "Both") {
	$FTOBoth = "CHECKED";
}
elsif  ($ForumTotalOption eq "Topics"){
	$FTOTopics = "CHECKED";
}	else {
	$FTOPosts = "CHECKED";
}


if ($DisplayRegistration eq "NO") {
	$DisplayRegNo = "CHECKED";
}  else {
	$DisplayRegYes = "CHECKED";
}	

if ($AllowSignature eq "YES") {
	$AllowSigYes = "CHECKED";
}  else {
	$AllowSigNo = "CHECKED";
}	

if ($AllowSignatureImage eq "YES") {
	$AllowSigImageYes = "CHECKED";
}  else {
	$AllowSigImageNo = "CHECKED";
}	

if ($UseEmail eq "ON") {
	$EmailOn = "CHECKED";
}  else {
	$EmailOff = "CHECKED";
}		
		
if ($HotIcons eq "OFF")  {
	$HotIconsOff = "CHECKED";
}  else {
	$HotIconsOn = "CHECKED";
}	

if ($HotCount eq "") {
	$HotCount = "15";
}	

if ($EmailBlock eq "ON") {
	$EmailBlockOn = "CHECKED";
}  else {
	$EmailBlockOff = "CHECKED";
}		

if ($EnglishSubjectCheck eq "ON") {
	$ESCON = "CHECKED";
}  else {
	$ESCOFF = "CHECKED";
}		
		
if ($ReverseThreads eq "TRUE") {
	$ReverseThreadOn = "CHECKED";
}  else {
	$ReverseThreadOff = "CHECKED";
}		
if ($TimeFormat eq "24HR") {
	$Time24HR = "CHECKED";
}  else {
	$TimeAMPM = "CHECKED";
}		
if ($DateFormat eq "Euro") {
	$DateEuro = "CHECKED";
}
elsif ($DateFormat eq "EuroX") {
	$DateEuroX = "CHECKED";
}
elsif ($DateFormat eq "USX") {
	$DateUSX = "CHECKED";
}  else {
	$DateUS = "CHECKED";
}

if ($AuthorColumn eq "Location") {
	$LocationAC = "CHECKED";
}
elsif ($AuthorColumn eq "PostTotal") {
	$PostTotalAC = "CHECKED";
}  else {
	$MinimumAC = "CHECKED";
}

if ($EmailCheck eq "true") {
	$EmailTrue = "CHECKED";
}  else {
	$EmailFalse = "CHECKED";
}
if ($CGIPath eq '') {
	if($ENV{'SCRIPT_FILENAME'}){ #*nix
	 	$thiscgipath = $ENV{'SCRIPT_FILENAME'};	
	} elsif ($ENV{'PATH_TRANSLATED'}) { # Win32
		$thiscgipath = $ENV{'PATH_TRANSLATED'};
		$thiscgipath =~ s/\\/\//g; 
	}
	@cgipath = split(/\//, $thiscgipath);
	pop(@cgipath);
	$CGIPath = join("\/", @cgipath);
	$VariablesPath = $CGIPath;
	$MembersPath = ("$CGIPath" . "/Members");
	$cgiext = pop(@cgipath);
}
if ($NonCGIPath eq '') {
	$NonCGIPath = "$ENV{'DOCUMENT_ROOT'}/ubb";
	$ForumsPath = "$ENV{'DOCUMENT_ROOT'}/ubb";
}

if ($NonCGIURL eq '') {
	$NonCGIURL = "http://$ENV{'HTTP_HOST'}/ubb";
}
if ($CGIURL eq '') {
	$CGIURL = "http://$ENV{'HTTP_HOST'}/$cgiext";
}
if ($HomePageURL eq '') {
	$HomePageURL = "http://$ENV{'HTTP_HOST'}";
}
if ($BBEmail eq '') {
	$BBEmail = "$ENV{'SERVER_ADMIN'}";
}



if ($MemberMinimum eq "") {
	$MemberMinimum = "31";
}

if ($TimeZoneOffset eq "") {
	$TimeZoneOffset = "0";
}

#new options 03-03-00

if ($UBBFriendUSE eq "OFF") {
	$UBBFriendOFF = "CHECKED";
}
elsif ($UBBFriendUSE eq "RegUsers") {
	$UBBFriendREGONLY = "CHECKED";
}  else {
	$UBBFriendON = "CHECKED";
}

if ($ModerateRegs eq "ON") {
	$ModerateRegsON = "CHECKED";
}
elsif ($MemberNotify eq "COPPA") {
	$ModerateRegsCOPPA = "CHECKED";
}  else {
	$ModerateRegsOFF  = "CHECKED";
}

if ($COPPACheck eq "ON") {
	$COPPACheckON = "CHECKED";
}
   else {
	$COPPACheckOFF  = "CHECKED";
}

if ($COPPAFormOnly eq 'YES') {
	$COPPAFormOnlyOn = "CHECKED";	
}

if ($OnRegsNotifyAdmin eq "ON") {
	$OnRegsNotifyAdminON = "CHECKED";
}
elsif ($OnRegsNotifyAdmin eq "COPPA") {
	$OnRegsNotifyAdminCOPPA = "CHECKED";
}
   else {
	$OnRegsNotifyAdminOFF  = "CHECKED";
}

if ($ShowPrivacyLink eq 'ON'){
$ShowPrivacyLinkON = 'CHECKED';
}
else {
$ShowPrivacyLinkOFF = 'CHECKED';	
}

if ($COPPAWording eq '') {
	$COPPAWording = "You must supply a description of your own COPPA policy.";	
}
if ($COPPAInstructions eq '') {
	$COPPAInstructions = "Your need to supply exact instructions for how to mail or fax the COPPA permission form to you";	
}

# check email availability and default to sendmail on *nix

if ($SendMailLocation eq "") {
	if (-e "/usr/bin/sendmail") {
		$SendMailLocation = "/usr/bin/sendmail";
	}
	elsif (-e "/usr/sbin/sendmail") {
		$SendMailLocation = "/usr/sbin/sendmail";
	}
	elsif (-e "/usr/lib/sendmail") {
	$SendMailLocation = "/usr/lib/sendmail";
	} 
}

if ($SMTPEmail eq "On") {
	$SMTPOn = "CHECKED";
} 
elsif ($SendMailLocation ne '')  {
	$SMTPOff = "CHECKED"; # this means sendmail is on
}
else {
	$SMTPOn = "CHECKED";
}

if (-e "$MembersPath/emailfile.cgi") {
$DiagnosticWording = qq[<INPUT TYPE="CHECKBOX" NAME="Diagnostic" VALUE="yes" CHECKED> <B>Check here to rebuild the forum thread files, recount topics and replies and reset the last post times. This is not necessary unless you think your forums do not show correct lists of topics or have incorrect counts.];
$EmailFile = "";
}  else {
$EmailFile = qq(<INPUT TYPE="HIDDEN" NAME="EmailFile" VALUE="add">);
$DiagnosticWording = "";
}

$PageTitle = "G E N E R A L &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S";
&HEADERHTML;

print<<THIS;
To check your environmental variables, <A HREF="cpanel.cgi?action=env">click here</A>.
<P>
Socket Test: To check to see if the Socket module is included on the Perl installation on your web server, <A HREF="ubbmisc.cgi?action=sockettest">click here</A>. If you receive an error or a blank page, then Socket may not be installed (<A HREF="http://www.ultimatebb.com/home/faq.html#socket" target="_blank">Read This</A>, if Socket is not installed.)
<HR>
<P>
<FORM ACTION="cpanel2.cgi" NAME="THEFORM" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="setgenvars">
<INPUT TYPE="HIDDEN" NAME="EmailBan" VALUE="$EmailBan">
$EmailFile
<table border=0 cellpadding=0 cellspacing=0   width=100%><TR><td bgcolor="#000000">

<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00"><br>absolute paths</FONT></B>
</TD></TR>
<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Absolute paths reflect the physical locations of directories on a server.  They are the complete locations, not the locations from the web root, but from the server root.  Absolute paths on Win32/NT servers are displayed differently than on UNIX systems.  For instance, note the following samples for UNIX and NT:
<p>
For UNIX servers:  &nbsp;&nbsp;&nbsp;&nbsp;<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">/usr/home/yourdomain/www/cgi-bin</font>
<BR>
For Win32/NT servers:&nbsp;&nbsp;&nbsp;&nbsp; <FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">C:/home/yourdomain/cgi-bin</FONT>
<P>
Note: the paths listed above are examples, not your actual paths.
<P>
If you are installing on Win32/NT, be sure to use the format above for your absolute paths (note the forward slashes, rather than backward slashes).
<BR>
If you are installing for the first time, the UBB will attempt to provide complete or partial absolute paths for you.  These paths may not be accurate or complete, but they will give you a headstart.  All absolute path fields MUST be provided for your UBB to run.</B></FONT></p>
</td></tr>
THIS

&InputTextRow("#dedfdf", "<p>Absolute Path for your UBB CGI DIRECTORY</p>", "" , "CGIPath", "40", "250");
&InputTextRow("#f7f7f7", "<p>Absolute Path for your UBB NON CGI DIRECTORY</p>", "" , "NonCGIPath", "40", "250");
&InputTextRow("#dedfdf", "<p>Absolute Path to Members Directory", "This path should end in /Members (as in \"/usr/home/yourdomain/www/cgi-bin/Members\")" , "MembersPath", "40", "250");
&InputTextRow("#f7f7f7", "<p>Absolute Path to Directory Where Your Custom Variable Files  Reside", "<B>You should use the same absolute path that you used for your CGI directory above</B>.  If for some reason you cannot write to files in your CGI directory, however, you should place these files (UltBB.setup, forums.cgi, mods.file, Styles.file) in a directory below the web root so that they cannot be accessed by anyone from the browser.</p>", "VariablesPath", "40", "250");

print<<THIS2;
</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">URLs</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Please provide the following complete hyperlinks.  Use complete hyperlinks, such as http://www.yourdomain.com/cgi-bin, rather than relative links such as "/cgi-bin"</B></FONT>
</td></tr>
THIS2

&InputTextRow("#dedfdf", "URL for your UBB CGI Directory", "", "CGIURL", "40", "250");
&InputTextRow("#f7f7f7", "URL for your UBB Non CGI Directory", "", "NonCGIURL", "40", "250");
&InputTextRow("#dedfdf", "<p>Your Home Page URL", "The complete URL for your home page (not the bulletin board).  This will be used for links back to your homepage.</p>", "HomePageURL", "40", "250");
&InputTextRow("#f7f7f7", "<p>Your Privacy Statement", "The complete URL for your web site's privacy statement.  This will be used to describe your policies concerning user information.</p>", "PrivacyURL", "40", "250");


print<<THIS3;
</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Display Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Please complete the following fields, which provide information such as your BB Name, the name of your home page, the email address to be displayed, headers and footers to use on each page, etc.</B></FONT>
</td></tr>
THIS3

&InputTextRow("#dedfdf", "<p>Your Email Address</p>", "", "BBEmail", "30", "250");
&InputTextRow("#f7f7f7", "<p>Name of Your Bulletin Board</p>", "", "BBName", "30", "250");
&InputTextRow("#dedfdf", "<p>Name of Your Home Page", "</b>The name of your homepage, which will listed for links back to your homepage.</p>", "MyHomePage", "30", "250");

print<<THIS4;
<TR bgcolor="#f7f7f7">
<td width=50%>
<p><FONT SIZE="2" FACE="Verdana, Arial"><B>Default Topic View (Days)</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial">The default number of days for the "Show Topics Going Back X Days" option.  Users are able to customize this through preferences, but this is the default that will be given, otherwise.  Recommended: 20.</FONT></p>
</td>
<td width=50% valign=top>
<SELECT NAME="DaysPruneDefault">
	<OPTION value="1" $Days1>Show topics from last day
	<OPTION value="2" $Days2>Show topics from last 2 days
	<OPTION value="5" $Days5>Show topics from last 5 days
	<OPTION value="10" $Days10>Show topics from last 10 days
	<OPTION value="20" $Days20>Show topics from last 20 days
	<OPTION value="30" $Days30>Show topics from last 30 days
	<OPTION value="45" $Days45>Show topics from last 45 days
	<OPTION value="60" $Days60>Show topics from last 60 days
	<OPTION value="75" $Days75>Show topics from last 75 days
	<OPTION value="100" $Days100>Show topics from last 100 days
	<OPTION value="365" $Days365>Show topics from the last year
	<OPTION value="1000" $Days1000>Show all topics
</SELECT>
</td></tr>
THIS4

&InputAreaRow("#dedfdf", "<p>Header", "You can add your own customized header graphic, ad banner, text, etc.  This header will appear at the top of each primary UBB page.  This is completely optional.  Leave this field blank if you don't need to use it.</p>", "Header", "30", "5");

&InputAreaRow("#f7f7f7", "<p>Footer", "You can add your own customized header graphic, ad banner, text, etc.  This header will appear at the bottom of each primary UBB page.  This is completely optional.  Leave this field blank if you don't need to use it.</p>", "Footer", "30", "5");

&InputRadioRow("#dedfdf", "<p>Category Display Option", "</b>If you are using categories, you can have your forums displayed under each category when users first enter your UBB.  To elect to display categories on your introductory page, select YES.  You MUST have categories defined in the Forums control panel BEFORE you select this option.</p>", "<INPUT TYPE=\"RADIO\" NAME=\"CategoryView\" VALUE=\"yes\" $CategoryViewOn> Yes<br>
<INPUT TYPE=\"RADIO\" NAME=\"CategoryView\" VALUE=\"no\" $CategoryViewOff> No");

&InputRadioRow("#f7f7f7", "<p>Display Only the Categories on First Page?", "</b>If you have numerous forums and/or categories, you may want to have a list of CATEGORIES ONLY when users first enter your UBB. <B>The individual forums, which normally appear first, would thus be suppressed.  Users would click on the category of choice to be taken to the list of forums within that forum.   In order to start with the category list only, click YES to the right.</p>", "<INPUT TYPE=\"RADIO\" NAME=\"CategoriesOnly\" VALUE=\"true\" $CategoriesOnlyOn> Yes<br>
<INPUT TYPE=\"RADIO\" NAME=\"CategoriesOnly\" VALUE=\"false\" $CategoriesOnlyOff> No");

&InputRadioRow("#dedfdf", "<p>Display Forum Descriptions?", "</b>If you have many forums, you may not want to display your forum descriptions.  If not, check no.<p>", "<INPUT TYPE=\"RADIO\" NAME=\"ForumDescriptions\" VALUE=\"yes\" $ForumDescriptionsOn> Yes<br>
<INPUT TYPE=\"RADIO\" NAME=\"ForumDescriptions\" VALUE=\"no\" $ForumDescriptionsOff> No");

&InputRadioRow("#f7f7f7", "<p>Display Privacy Statement Link ?", "</b>You can display a link to your Privacy Statement on every UBB page.  Check yes to include it. Note: if you check no, your Privacy URL will still appear in any Children's Online Protection routines.</p>", "<INPUT TYPE=\"RADIO\" NAME=\"ShowPrivacyLink\" VALUE=\"ON\" $ShowPrivacyLinkON> Yes<br>
<INPUT TYPE=\"RADIO\" NAME=\"ShowPrivacyLink\" VALUE=\"OFF\" $ShowPrivacyLinkOFF> No");

&InputAreaRow("#dedfdf", "<p>Bulletin Board Rules", "You can customize the exact wording for your bulletin board's rules.  Just edit the wording in the box to the right.</p>", "BBRules", "35", "8");
&InputAreaRow("#f7f7f7", "<p>Children's Online Protection Policy Wording", "If you use the Age Check option below you need to provide an explanation of the registration process for those under the age of 13. This wording will appear before the registration form is displayed.</p>", "COPPAWording", "35", "8");
&InputAreaRow("#dedfdf", "<p>Children's Online Protection Policy Instructions", "This text will go in the email sent to registrants under 13 and/or the parent or guardian. Be sure to include exact instructions including the necessary address, telephone, fax and email contact information.</p>", "COPPAInstructions", "35", "8");
&InputAreaRow("#f7f7f7", "Your Copyright Wording", "This wording will appear in smaller print directly above the copyright wording concerning the UBB program itself. You can leave this blank or provide any wording you like.</p>", "YourCopyrightNotice", "30", "3");

&InputRadioRow("#dedfdf", "Infopop Copyright Type", "The UBB license agreement requires that the 'Powered by Infopop Ultimate Bulletin Board' notice remain intact and visible on all pages. You can choose either a clickable image or a regular link text.", "<INPUT TYPE=\"RADIO\" NAME=\"showcopytype\" VALUE=\"image\" $showcopytypeIMAGE> image<br>
<INPUT TYPE=\"RADIO\" NAME=\"showcopytype\" VALUE=\"text\" $showcopytypeTEXT> text");

&InputRadioRow("#f7f7f7", "Block Public Display of User Email Addresses?", "The default option is to have registered user's email addresses viewable on the pages for which the user has posted a note.  You may prevent all user email addresses from being displayed by selecting \"Block Public Display of User Email Addresses\" in the field to the right.  These addresses will still be available to you if you check the user's info in the \"User Info/Permissions\" area of the Control Panel.", "<INPUT TYPE=\"RADIO\" NAME=\"EmailBlock\" VALUE=\"ON\" $EmailBlockOn> Block Public Display of User Email Addresses<BR>
<INPUT TYPE=\"RADIO\" NAME=\"EmailBlock\" VALUE=\"OFF\" $EmailBlockOff> Show User Email Addresses");

&InputRadioRow("#dedfdf", "Allow Signatures?", "You may allow your users to use their own unique signatures when they post messages.  Note: your users will be permitted to use UBB Code (but not HTML) in their signature files.  The UBB Code Image tag will be blocked unless you enable it below.", "<INPUT TYPE=\"RADIO\" NAME=\"AllowSignature\" VALUE=\"YES\" $AllowSigYes> Allow Signatures<BR>
<INPUT TYPE=\"RADIO\" NAME=\"AllowSignature\" VALUE=\"NO\" $AllowSigNo> Don't Allow Signatures");

&InputRadioRow("#f7f7f7", "Allow Images in Signatures?", "You may allow your users to put UBB code images in their signature. But this is not advised unless you are sure users will not abuse the right", "<INPUT TYPE=\"RADIO\" NAME=\"AllowSignatureImage\" VALUE=\"YES\" $AllowSigImageYes> Allow Images in Signatures<BR>
<INPUT TYPE=\"RADIO\" NAME=\"AllowSignatureImage\" VALUE=\"no\" $AllowSigImageNo> Don't Allow Images in Signatures");


&InputRadioRow("#dedfdf", "Show Total Topics/Posts/Both?", "On the first UBB display page that lists all of your forums, you may display either the total topics within each forum, the total posts within each forum, or both the total topics and total posts.", "<INPUT TYPE=\"RADIO\" NAME=\"ForumTotalOption\" VALUE=\"Topics\" $FTOTopics> Show Total Topics Only<BR>
<INPUT TYPE=\"RADIO\" NAME=\"ForumTotalOption\" VALUE=\"Posts\" $FTOPosts> Show Total Posts Only<BR>
<INPUT TYPE=\"RADIO\" NAME=\"ForumTotalOption\" VALUE=\"Both\" $FTOBoth> Show Both Total Topics and Total Posts");

&InputRadioRow("#f7f7f7", "Reverse Thread Order?", "The standard (recommended) way to display threads is chronologically from original topic to the latest reply.  You can reverse this, if you prefer, to have threads displayed in reverse, from latest post to oldest post.  This is for the HTML thread pages only.", "<INPUT TYPE=\"RADIO\" NAME=\"ReverseThreads\" VALUE=\"FALSE\" $ReverseThreadOff> Keep Preferred Order<BR>
<INPUT TYPE=\"RADIO\" NAME=\"ReverseThreads\" VALUE=\"TRUE\" $ReverseThreadOn> Reverse Thread Order");


&InputRadioRow("#dedfdf", "Display Member Total?", "You may add a counter to your UBB intro page (the first page visitors see when the enter your UBB) that displays the total number of registered users on your UBB.", "<INPUT TYPE=\"RADIO\" NAME=\"DisplayMemberTotal\" VALUE=\"true\" $MemberTotalOn> Display Member Total<BR>
<INPUT TYPE=\"RADIO\" NAME=\"DisplayMemberTotal\" VALUE=\"false\" $MemberTotalOff> Do Not Display Member Total");

&InputAreaRow("#f7f7f7", "Header Insert", "You can insert your own code to appear in the HEAD tags of most displayed UBB pages.  This is useful for adding your own META tags, Style Sheets, etc.  Remember that the code you add in this field will be inserted inside the HTML HEAD brackets- so you must abide by normal HTML rules for code within the &lt;HEAD&gt; tags. Do not add HTTP-EQUIV=\"Pragma\", since the UBB already includes those.  Leave the field blank if you do not wish to add any custom code to your headers.", "HeaderInsert", "30", "5");


&InputRadioRow("#dedfdf", "Allow Posting Icons?", "You can allow your users to associate an icon with each post they make.  These icons (which include a note, a smiley face, a warning, a thumbs up, and more) are a nice way of graphically showing the purpose of each post.", "<INPUT TYPE=\"RADIO\" NAME=\"AllowIcons\" VALUE=\"TRUE\" $IconsOn> Yes, allow icons.<BR>
<INPUT TYPE=\"RADIO\" NAME=\"AllowIcons\" VALUE=\"FALSE\" $IconsOff> No, don't allow icons.");

&InputRadioRow("#f7f7f7", "Use Reply with Quote?", "You can display a 'Reply with Quote' icon beside each message. This will allow a user to quote an individual message in a reply ", "<INPUT TYPE=\"RADIO\" NAME=\"ReplyQuote\" VALUE=\"YES\" $ReplyQuoteOn> Yes<BR>
<INPUT TYPE=\"RADIO\" NAME=\"ReplyQuote\" VALUE=\"NO\" $ReplyQuoteOff> No");


&InputRadioRow("#dedfdf", "Include Inline Frame View of Topic on Reply Page?", "To make things easier for users replying to topics, you may include an inline frame on the reply page that shows the complete topic the user is replying to.  Note that some browsers do not support inline frames (those users will instead be provided with a link to the topic page).", "<INPUT TYPE=\"RADIO\" NAME=\"InlineFrame\" VALUE=\"TRUE\" $InlineOn> Show Inline Frame on Reply Page<BR>
<INPUT TYPE=\"RADIO\" NAME=\"InlineFrame\" VALUE=\"FALSE\" $InlineOff> Do Not Show Inline Frame on Reply Page");

print<<THIS5;
<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Maximum Topics Displayed Per Page</B><BR></FONT>
</td><td width=50% valign=top>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Select one of the options below.<BR><SELECT NAME="ForumDisplayMax">
	<OPTION value="25" $FDM25>25 Topics Maximum Per Page
	<OPTION value="35" $FDM35>35 Topics Maximum Per Page
	<OPTION value="40" $FDM40>40 Topics Maximum Per Page
	<OPTION value="50" $FDM50>50 Topics Maximum Per Page
	<OPTION value="75" $FDM75>75 Topics Maximum Per Page
	<OPTION value="NONE" $FDMNONE>No Maximum Per Page

</SELECT>
</FONT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Maximum Number of Posts Displayed Per Topic (HTML) Page</B><BR></FONT>
</td><td width=50% valign=top>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Select one of the options below.<BR><SELECT NAME="HTMLDisplayMax">
	<OPTION value="15" $HDM15>15 Posts Maximum Per Page
	<OPTION value="25" $HDM25>25 Posts Maximum Per Page
	<OPTION value="35" $HDM35>35 Posts Maximum Per Page
	<OPTION value="40" $HDM40>40 Posts Maximum Per Page
	<OPTION value="50" $HDM50>50 Posts Maximum Per Page
	<OPTION value="75" $HDM75>75 Posts Maximum Per Page
	<OPTION value="NONE" $HDMNONE>No Maximum Per Page

</SELECT>
</FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Display Hot Topic Icons?</B><BR>
<font size="1" face="Verdana, Arial">Hot icons indicate topics with alot of activity.  The icons are animated to show a folder on fire.  If you are not interested in this feature, turn it off below.  If you are interested, you can adjust the number of replies necessary to qualify as "hot" to the right.</font>
<P>
<input type="radio" name="HotIcons" value="ON" $HotIconsOn> Display Hot Icons
<BR>
<input type="radio" name="HotIcons" value="OFF" $HotIconsOff> Don't Display Hot Icons
</FONT>
</td><td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><b>Number of Replies to Qualify as Hot Topic?</b><P>
<center><b>Minimum Replies:</b> <input type="text" name="HotCount" value="$HotCount" size="2" maxlength="3"></center>
</FONT>
</td></tr>

</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Search Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B><p>The UBB includes a built-in search engine that allows your visitors to search through the stored posts.  Searching can be a server-intensive process, however.  Thus, you may decide you do not want to allow your visitors to search at all.  The UBB uses index files for the search process.  There are two methods the UBB can use to store these index files- either as one large file for all forums, or as separate files for each forum.  There are pros and cons for each method- if you have many forums but not many posts overall, you may want to try the "one index file" approach.  If you don't have too many forums, but you have a lot of posts, you will most likely prefer the "per forum index file" approach.  You are not locked into either approach.  If you ever change your index file approach, however, you must recreate your index (using the Index control panel feature)- otherwise the index files the UBB uses to search will not be accurate and search results will be erroneous.</B></p></FONT>
</td></tr>
THIS5

&InputRadioRow("#f7f7f7", "Allow Searches?", "If you do not want your visitors to be able to search through your forums, make sure you turn this option off.  The search link will not appear if you have this option turned off.", "<INPUT TYPE=\"RADIO\" NAME=\"AllowSearch\" VALUE=\"TRUE\" $AllowSearchOn> Display/Allow Searches<BR>
<INPUT TYPE=\"RADIO\" NAME=\"AllowSearch\" VALUE=\"FALSE\" $AllowSearchOff> Remove Search Option");


&InputRadioRow("#dedfdf", "Allow Searching of All Forums?", "Searching through all forums at once can drain your server, though it is convenient for your users.  You can elect to turn off the ability to search through all forums at once, if you like.  Your users will still be able to search, but only one forum at a time.", "<INPUT TYPE=\"RADIO\" NAME=\"AllowTotalSearch\" VALUE=\"TRUE\" $AllowTotalSearchOn> Allow Search of All Forums<BR>
<INPUT TYPE=\"RADIO\" NAME=\"AllowTotalSearch\" VALUE=\"FALSE\" $AllowTotalSearchOff> Don't Allow Search of All Forums");

&InputRadioRow("#f7f7f7", "Index File Method", "The default method is to create separate index files for each forum in your UBB.  If you have a board with a limited number of posts, however, you may want to have the index file stored as one file.  If you ever change this setting, you MUST recreate your index (click on the Index link in your UBB control panel after you make the change).", "<INPUT TYPE=\"RADIO\" NAME=\"IndexMethod\" VALUE=\"PERFORUM\" $IndexMethodPer> Create Index Files For Each Forum <BR>
<INPUT TYPE=\"RADIO\" NAME=\"IndexMethod\" VALUE=\"ONEFILE\" $IndexMethodOne> Create One Index File");

print<<THIS58;
</TABLE>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Email Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<p><B>The UBB provides two methods for handling all functions that involve email: Sendmail for Unix/Linux based servers and SMTP for Win32 servers.  Sendmail is installed on most Unix/Linux servers by default. The SMTP option for Win32 requires you to have an SMTP email server that will allow email relay from your domain.  You must also have the standard Perl 5 Socket module installed (Some service providers do not intall it. Use the socket test at the top of this page).</B></FONT></p>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><p><B>Email On/Off</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">To enable all functions that send email to users, set this field to on. UBB features that require email include Lost Password, Email Verification, Digests, Bulk mailing and several Notification routines. It is important to set the email configuration correctly.  If email services are not available for your server, you must turn this option off.</p></FONT>

</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><INPUT TYPE="RADIO" NAME="UseEmail" VALUE="ON" $EmailOn> Email features On<BR>
<INPUT TYPE="RADIO" NAME="UseEmail" VALUE="OFF" $EmailOff> Email features Off</FONT>
</td></tr>


<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><p><B>Email Service to Use</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Unix/Linux users will find sendmail the easiest process.  Win32 users must choose the SMTP option and provide the name of an SMTP server that will accept relay from your domain. Contact your ISP for details.</p></FONT>

</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="SMTPEmail" VALUE="Off" $SMTPOff> SendMail [Unix/Linux Only]<br>
<INPUT TYPE="RADIO" NAME="SMTPEmail" VALUE="On" $SMTPOn> SMTP Email [Win32]</FONT>

</td></tr>



<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><p><B>Sendmail Location [Unix/Linux Only]</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You must list the absolute path to the sendmail program.  For example, your sendmail location may be: /usr/bin/sendmail</font></p>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="SendMailLocation" VALUE="$SendMailLocation" SIZE=25 MAXLENGTH=50>
</td></tr>


<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><p><B>SMTP Server Name [Win32]</B></FONT><br>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">To use this option you must list the name of your SMTP server.  It may be something like smtp.yourdomain.com or mail.yourdomain.com.  It may also be your domain name alone, an IP address or a server your ISP has set up for this purpose. Contact your internet provider for an exact name.</font></p>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<INPUT TYPE="TEXT" NAME="EmailServer" VALUE="$EmailServer" SIZE=25 MAXLENGTH=50>
</td></tr>


<tr bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><p><B>UBBFriend</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Select whether you want to include the option to allow users to email someone a link to a UBB topic.  Note: email options must be turned on above and an email process must be properly configured.</p></FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080">
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><INPUT TYPE="RADIO" NAME="UBBFriendUSE" VALUE="ON" $UBBFriendON> On <BR>
<FONT SIZE="2" FACE="Verdana, Arial"><INPUT TYPE="RADIO" NAME="UBBFriendUSE" VALUE="OFF" $UBBFriendOFF> Off </FONT><br>
<FONT SIZE="2" FACE="Verdana, Arial"><INPUT TYPE="RADIO" NAME="UBBFriendUSE" VALUE="RegUsers" $UBBFriendREGONLY> Open to Registered Users Only</FONT>
</CENTER>
</td></tr>

</table>
<P>

<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Date/Time Display Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<p><B>The UBB can display dates and times in a number of different formats.  Remember that the times listed are based on the location of your web server, which may be different than the time zone where you reside/work.  You can change the time zone displayed by using the Time Zone Offset field.  For instance, if you are on the East Coast of the US, but your server is on the West Coast of the US, you could use EST as your Time Zone to display, but you would have to offset the server time to reflect that (by typing a 3 in the Time Zone Offset field, reflecting the 3 hours difference).  If the Time Zone difference is negative, use a negative number (as in -2).</B></FONT></p>
</td></tr>
THIS58

&InputTextRow("#dedfdf", "<p>Time Zone", "</b>The time of each posting is based on the time zone where your server is located.  If you want your users to know the time zone, provide it here (e.g., ET, CT, PT, etc.).  You may also leave this blank if you would prefer not to show a time zone.  You may type a different time zone than your server uses, but if you do so be sure to provide a time zone offset in the next field.</p>", "TimeZone", "20", "35");

&InputTextRow("#f7f7f7", "<p>Server Time Zone Offset", "</b>You can offset the time drawn from your web server.  For instance, if your server time is EST (US), but you want all time to reflect Pacific Time (US), you would have to offset your server time by placing the time zone difference in this field (for this example, that would be -3.  You would place -3 in this field).  The default is for there to be no server time zone offset (0).</p>", "TimeZoneOffset", "3", "4");

&InputRadioRow("#dedfdf", "Date Format", "European Format is DD-MM-YR, while US format is MM-DD-YR.  Expanded formats include full month name.", "<INPUT TYPE=\"RADIO\" NAME=\"DateFormat\" VALUE=\"US\" $DateUS> US Format (e.g., 04-25-98)<BR>
<INPUT TYPE=\"RADIO\" NAME=\"DateFormat\" VALUE=\"USX\" $DateUSX> Expanded US Format (e.g., April 25, 1998)<BR>
<INPUT TYPE=\"RADIO\" NAME=\"DateFormat\" VALUE=\"Euro\" $DateEuro> European Format (e.g., 25-04-98)<BR>
<INPUT TYPE=\"RADIO\" NAME=\"DateFormat\" VALUE=\"EuroX\" $DateEuroX> Expanded European Format (e.g., 25 April 1998)");

&InputRadioRow("#f7f7f7", "Time Format", "You can have time displayed in AM/PM format, or in 24-hour format.", "
<INPUT TYPE=\"RADIO\" NAME=\"TimeFormat\" VALUE=\"AMPM\" $TimeAMPM> Use AM/PM Time Format<BR>
<INPUT TYPE=\"RADIO\" NAME=\"TimeFormat\" VALUE=\"24HR\" $Time24HR> User 24-Hour Format Time (eg, 23:15)");


print<<THIS6;
</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Registration Options</FONT></B>
</TD></TR>
<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Below are registration options for your UBB.</B></FONT>
</td></tr>
THIS6

&InputRadioRow("#dedfdf", "Verify User Email Address During Registration?", "For tighter security, you may want to require that your registered users have valid email addresses.  This is accomplished by mailing their password to them at the email address they register.  To enable email verification during registration, click YES in the field to the right.", "<INPUT TYPE=\"RADIO\" NAME=\"EmailVerify\" VALUE=\"ON\" $EmailVerifyOn> Yes<br>
<INPUT TYPE=\"RADIO\" NAME=\"EmailVerify\" VALUE=\"OFF\" $EmailVerifyOff> No");

&InputRadioRow("#F7F7F7", "Email Duplicate Check", "The default option is to require unique email addresses for each registered user.  This means that no two users can have the same email address. You can disable this requirement by checking the \"Unique Email Not Required\" box.", "<INPUT TYPE=\"RADIO\" NAME=\"EmailCheck\" VALUE=\"true\" $EmailTrue> Unique Email Required<br>
<INPUT TYPE=\"RADIO\" NAME=\"EmailCheck\" VALUE=\"false\" $EmailFalse> Unique Email Not Required");

&InputRadioRow("#dedfdf", "Children's Online Privacy Protection [COPPA]", "This option must be used by all sites which expect to register users under the age of 13. Though this is an American law, it may affect non-US sites too.  Consult competent legal advice. Activating this option will ask the user's age and send him/her to a special registration page.", "<INPUT TYPE=\"RADIO\" NAME=\"COPPACheck\" VALUE=\"ON\" $COPPACheckON>  Age Check Required<br><INPUT TYPE=\"RADIO\" NAME=\"COPPACheck\" VALUE=\"OFF\" $COPPACheckOFF> Age Check Not Required");

&InputRadioRow("#dedfdf", "Show Permission Form Only", "Use this option to show only the printable permission form.", "<INPUT TYPE=\"checkbox\" NAME=\"COPPAFormOnly\" VALUE=\"YES\" $COPPAFormOnlyOn>  Show Only the Printable Permission Form");

&InputRadioRow("#F7F7F7", "Moderate Registration Requests", "The default setting allows any user to register without approval.  If you require registration approval, the user may register but will not have posting privileges until you grant them though the control panel 'User Info & Permissions'.", "<INPUT TYPE=\"RADIO\" NAME=\"ModerateRegs\" VALUE=\"ON\" $ModerateRegsON> Registration Approval Required<br>
<INPUT TYPE=\"RADIO\" NAME=\"ModerateRegs\" VALUE=\"OFF\" $ModerateRegsOFF> Registration Approval Not Required");

&InputRadioRow("#dedfdf", "Notify Admin of New Registrations", "You can be notified by email when someone registers at your Board or only when someone registers under the age of 13.  Busy sites with many only adultregistrations will likely leave this option off.</p>", "<INPUT TYPE=\"RADIO\" NAME=\"OnRegsNotifyAdmin\" VALUE=\"ON\" $OnRegsNotifyAdminON> Notify Admin of all Registrations<br>
<INPUT TYPE=\"RADIO\" NAME=\"OnRegsNotifyAdmin\" VALUE=\"OFF\" $OnRegsNotifyAdminOFF> No Notification<br><INPUT TYPE=\"RADIO\" NAME=\"OnRegsNotifyAdmin\" VALUE=\"COPPA\" $OnRegsNotifyAdminCOPPA> Notification only for Members Under Age 13");

&InputTextRow("#f7f7f7", "<p>Email Address used for Notification", "</b>The email address where where all registration notification messages will go.  This address will also be use as the contact email for any registration questions.</p>", "RegsAdminEmail", "40", "88");

&InputRadioRow("#dedfdf", "Suspend Registration", "If you would like to temporarily (or permanently) prevent anyone new from registering, you can do so. Anyone attempting to register will be told that you are not accepting new registrations at this time.</p>", "<INPUT TYPE=\"RADIO\" NAME=\"SuspendRegister\" VALUE=\"true\" $SRTrue> Do not accept new registrations.<br>
<INPUT TYPE=\"RADIO\" NAME=\"SuspendRegister\" VALUE=\"false\" $SRFalse> Allow new registrations.");
&InputRadioRow("#f7f7f7", "Use Registration Fields for Your BB", "Always leave this option set to Yes unless <u>none</u> of your forums require registration.  If you do not plan to use registration options anywhere, you may set this to NO.</p>", "<INPUT TYPE=\"RADIO\" NAME=\"DisplayRegistration\" VALUE=\"YES\" $DisplayRegYes> Yes<BR>
<INPUT TYPE=\"RADIO\" NAME=\"DisplayRegistration\" VALUE=\"NO\" $DisplayRegNo> No");

print<<THIS7;
</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Miscellaneous Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Below are numerous configuration options for your UBB.</B></FONT>
</td></tr>
THIS7

&InputRadioRow("#dedfdf", "Turn Your UBB Off?", "From time to time, you may want to turn your bulletin board off to the public while you perform maintenance, update versions, etc.  When you turn your BB off, visitors will receive a message that states that the bulletin board is temporarily unavailable.", "<INPUT TYPE=\"RADIO\" NAME=\"BBStatus\" VALUE=\"ON\" $BBStatusOn> Bulletin Board Open
<BR>
<INPUT TYPE=\"RADIO\" NAME=\"BBStatus\" VALUE=\"OFF\" $BBStatusOff> Bulletin Board Closed");

&InputAreaRow("#f7f7f7", "<p>Bulletin Board Closed Message", "You can customize the exact wording for the message when your board is closed.  Edit the wording in the box to the right.</p>", "BBClosedMessage", "35", "8");

&InputTextRow("#f7f7f7", "<p>Minimum Number of Messages For Full Member Status", "</b>Registered users are initially called Junior Members.  After a certain number of postings, the member will be automatically upgraded to full Member.  The default is 31 messages, but you can reset this value here.</p>", "MemberMinimum", "5", "5");

print<<THIS8;
<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><p><B>Use Alternate User Titles?</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">There are four status options for users: administrators, moderators, members, and junior members.  You can have these four user classes appear as alternate titles, if you like.  For instance, if you have a Star Trek site, you may want your administrators to be called "Star Fleet Captain", your moderators to be called "First Mate", your Members to be called "Lieutenant" and your Junior Members to be called "Ensign".</FONT></p>
</td>
<td width=50% valign=top>
<FONT SIZE="1" FACE="Verdana, Arial">
Administrator:<BR>
<INPUT TYPE="TEXT" NAME="AdminTitle" VALUE="$AdminTitle" SIZE=20 MAXLENGTH=60>
<P>
Moderator:<BR>
<INPUT TYPE="TEXT" NAME="ModeratorTitle" VALUE="$ModeratorTitle" SIZE=20 MAXLENGTH=60>
<P>
Member:<BR>
<INPUT TYPE="TEXT" NAME="MemberTitle" VALUE="$MemberTitle" SIZE=20 MAXLENGTH=60>
<P>
Junior Member:</font>
<BR><INPUT TYPE="TEXT" NAME="JrMemberTitle" VALUE="$JrMemberTitle" SIZE=20 MAXLENGTH=60>
</td></tr>
<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Censor Option</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You may have certain words censored on your BB.  Words you choose to censor will be replaced by asterisks.  All subjects and messages will be affected. To activate the censor function, check the "yes" button below.  To deactivate, press the "no" button.  List all censored words in the field to the right.</p><p>Please follow the directions on the right for formatting the words correctly.</p></FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="Censor" VALUE="ON" $CensorOn> yes
<INPUT TYPE="RADIO" NAME="Censor" VALUE="OFF" $CensorOff> no
</FONT></CENTER>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Censor Words</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Type all words you want censored in the field below.  Do not use commas to separate words, just use spaces.  For example, type "dog cat boy", rather than "dog, cat, boy."  If you type "dog", all words containing the string "dog" would be censored (dogma, for instance, would appear as "***ma").  To censor more accurately, you can require that censors occur only for exact words.  You can do this by placing a censor word in curly braces, as in {dog}.  Signifying "dog" in the curly braces would mean that dogma would appear as dogma, but dog would appear as "***".  Thus your censor list may appear as: cat {dog} {barn} barn<BR>Do not use quotation marks and make sure you use curly braces, not parentheses, when specifying exact words. Do not put two words in the brackets {dog cat} or leave empty brackets {}.
</FONT><BR>
<TEXTAREA NAME="censorwords" ROWS=3 COLS=30 WRAP="VIRTUAL">$censorwords
</TEXTAREA>
</td></tr>
THIS8

&InputRadioRow("#dedfdf", "Allow User Editing of Messages?", "Administrators and moderators can always edit and delete messages.  You may want to allow your users to edit and delete their own messages, too.  They will not be able to edit other users' messages.  To do so, select YES to the right.  If you want to allow user's to edit their own messages, but not allow them to delete them, select the second option.", "<FONT SIZE=\"2\" FACE=\"Verdana, Arial\"><INPUT TYPE=\"RADIO\" NAME=\"EditOption\" VALUE=\"ON\" $EditOptionOn> Yes<BR>
<INPUT TYPE=\"RADIO\" NAME=\"EditOption\" VALUE=\"NODELETE\" $EditOptionND> Yes, but don't allow them to delete<BR>
<INPUT TYPE=\"RADIO\" NAME=\"EditOption\" VALUE=\"OFF\" $EditOptionOff> No</FONT>
");

&InputRadioRow("#f7f7f7", "Log/Display IP Numbers For Posts?", "For security reasons, you may wish to display the IP number of the person posting a message. The default is OFF.  You may log the IP to file only- in which case the IP number is not viewable on the bulletin board, but is logged, or you may have the IP numbers logged and displayed publicly on the bulletin board.", "<INPUT TYPE=\"RADIO\" NAME=\"IP\" VALUE=\"ON\" $IPOn> IP Logged & Displayed on BB <BR>
<INPUT TYPE=\"RADIO\" NAME=\"IP\" VALUE=\"LOGONLY\" $IPLO> IP Logged But Not Displayed On BB<BR>
<INPUT TYPE=\"RADIO\" NAME=\"IP\" VALUE=\"OFF\" $IPOff> IP Log/Display Off");

&InputRadioRow("#dedfdf", "Administrative Activity Log", "For security reasons, you may wish to track administrative activities on your bulletin board. Records are kept in the NonCGI Banlists directory. The default setting is Off.", "<INPUT TYPE=\"RADIO\" NAME=\"log_admin_activity\" VALUE=\"YES\" $log_admin_activityON> On<BR>
<INPUT TYPE=\"RADIO\" NAME=\"log_admin_activity\" VALUE=\"NO\" $log_admin_activityOFF> Off");

&InputRadioRow("#f7f7f7", "Cookie Option", "If you are setting up more than one UBB on a domain, you should elect to have cookies set to the precise directory that that UBB is running in.  If you are only running one UBB on your domain, then you can set your cookies more broadly.  The default is to set BROADLY.", "<INPUT TYPE=\"RADIO\" NAME=\"SetCookies\" VALUE=\"DirectorySpecific\" $COOKIESDS> Set Cookies to This UBB CGI Directory Only<BR>
<INPUT TYPE=\"RADIO\" NAME=\"SetCookies\" VALUE=\"Broad\" $COOKIESBroad> Set Cookies Broadly - Entire Domain");

&InputRadioRow("#dedfdf", "Author Column Display", "For each post, you can determine what information to display in the left column associated with the author of the post.  The default is to only show the person's username and member status.", "<INPUT TYPE=\"RADIO\" NAME=\"AuthorColumn\" VALUE=\"Minimum\" $MinimumAC> Show username and status only.<BR>
<INPUT TYPE=\"RADIO\" NAME=\"AuthorColumn\" VALUE=\"PostTotal\" $PostTotalAC> Show username, status, registration date, post total.<BR><INPUT TYPE=\"RADIO\" NAME=\"AuthorColumn\" VALUE=\"Location\" $LocationAC> All of above plus location.<BR>");

&InputRadioRow("#f7f7f7", "Require English Letter or Number in Subject?", "For each topic subject, you may require that there be at least one English language letter or number in order to permit the topic to be posted.  This will prevent users from posting blank subjects.  If there is a likelihood that some of your users would be using a non-English language, you may not want to use require this.", "<INPUT TYPE=\"RADIO\" NAME=\"EnglishSubjectCheck\" VALUE=\"ON\" $ESCON> Yes, require at least one English Letter or Number<BR>
<INPUT TYPE=\"RADIO\" NAME=\"EnglishSubjectCheck\" VALUE=\"OFF\" $ESCOFF> Do not require this.");

print qq(
<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><p><B>Flood Check?</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial">You may prevent your users from flooding your board with posts by activating this feature.  By enabling floodcheck, you disallow users from posting within a given time span of their last post.  In other words, if you set a floodcheck time span of 60 seconds, a user may not post a note within 60 seconds of his last post.  Administrators and moderators are exempt from floodcheck.</p></FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial"><INPUT TYPE="RADIO" NAME="FloodCheck" VALUE="ON" $FloodOn> FloodCheck On
<INPUT TYPE="RADIO" NAME="FloodCheck" VALUE="OFF" $FloodOff> FloodCheck Off
</FONT></CENTER>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>FloodCheck Time Span</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial">Set the amount of time in seconds used by FloodCheck to prevent post flooding.  Recommended: 60.  Type the number of seconds only.
</FONT><BR>
<center><input type="text" name="FloodCheckSpan" value="$FloodCheckSpan" size="3" maxlength="4"></center>
</td></tr>
); # end qq

print<<THIS10
</table>
</td></tr></table>
<P>
<FONT SIZE="1" FACE="Verdana, Arial">
$DiagnosticWording</FONT></B>
<P>
<br>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter your UserName & Password:</font>
<P>
<FONT Size="1" FACE="Verdana, Arial" COLOR="#808000">(NOTE: if you are configuring your BB for the first time, type your default UserName and Password here)</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER>
<p><center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit General Settings Now"></center>
</form>
</BODY></HTML>
THIS10
}
} #end do genvars


sub SendStyle {
&VerifyAdminCP($UserName, $Password);
if ($Proceed eq "true") {
	 &DoProcessStyle;
}  
}

sub DoProcessStyle {
	
&log_admin_activity ("DoProcessStyle") if ($log_admin_activity eq 'YES');
	
open (FILE, ">$VariablesPath/Styles.file") or die( &StandardHTML("Unable to open Styles.file for writing. $!") );

foreach $one(@in) {
	($Name, $Value) = split ("=", $one);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	$Value =~ s/\@/\\@/g;
	$Value =~ s/"/\\"/g;
		if (($Name ne "UserName") && ($Name ne "Password")) {
	print FILE ("\$$Name = \"$Value\";\n");
	}
}

	print FILE ("1;\n");
close (FILE);
chmod (0777, "$VariablesPath/Styles.file");

$ConfirmLine = "The Ultimate Bulletin Board Style variables have been updated.<P>Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<br>";
&ConfirmHTML2;

} ## END DO PROCESS VARS




sub SetGenVars {

&HackChecker;

### CHECK USERNAME - must be an admin
##verify that this user is an administrator

#check to see which Member Format is in place, process accordingly
if (-e "$MembersPath/memberslist.cgi") {
$ProfileNumber = &GetUserNumber($in{'UserNameCheck'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}
}  else {

$ProfileNumber = $UserNameCheckFile;

$NameFound = "no";
  if (-e "$MembersPath/$ProfileNumber.cgi") {
      $NameFound = "yes";
    } 
}

####

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$ProfileNumber.cgi");
			chomp($profilestats[1]);
	if ($in{'PasswordCheck'} eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	chomp($Permission);
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcessGenVars;
	   }  else {
	    &StandardHTMLCP("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTMLCP("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {

	unless(-d "$MembersPath") {
		&StandardHTMLCP("The absolute path to the Members directory is not correct.<p>Click back to try again.");	
	}
	else {
		&StandardHTMLCP("Sorry, but we couldn't find the UserName you entered.<p>Check the spelling and case.<p>Click your Back button to try again.<p>Is this a first time Installation?<p>Be sure you use the default name: Admin5.  Check also that the Admin5.cgi file is uploaded to the Members directory and is spelled correctly.<P>Use your Back button to try again.");
	}


}  ##END IF/ELSE NAME CHECK BLOCK

}  ##END Set Gen Vars

sub DoProcessGenVars {
if ((-e "$in{'NonCGIPath'}/ubbcode.html") && (-e "$in{'CGIPath'}/cpanel.cgi")) {

if ($in{'CategoriesOnly'} eq "true") {
	$in{'CategoryView'} = "yes";
}

$ForumsPath = ($ForumsPath || $NonCGIPath); # make sure it is defined for initial configuration

&log_admin_activity ("DoProcessGenVars") if ($log_admin_activity eq 'YES');

&CheckBadChars("$VariablesPath $MembersPath $CGIPath $NonCGIPath $in{'SendMailLocation'}"); # check for invalid chars

open (FILE, ">$VariablesPath/UltBB.setup") or die( &StandardHTMLCP("Unable to open UltBB.setup file for writing. Here is the error:</p>$!</p><p>Check:</p><ul><li>that the path $VariablesPath exists</li><li>[Unix/Linux] That you chmod'ed UltBB.setup 777.</li><li>[Windows NT] That directory permissions for $VariablesPath and $NonCGIPath are 'Change' or RWXD for the IUSR_$ENV{'COMPUTERNAME'} user. An NT Admin must make this change.</li></ul></p>") );

foreach $one(@in) {
	($Name, $Value) = split ("=", $one);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	$Value =~ s/\(/\\(/g;
	$Value =~ s/\)/\\)/g;
	$Value =~ s/\@/\\@/g unless (($Name eq "Header") || ($Name eq "Footer")) ;
	$Value =~ s/"/\\"/g unless (($Name eq "Header") || ($Name eq "Footer"));
	
	if (($Name eq "HeaderInsert")  || ($Name eq "Header") || ($Name eq "Footer")) {
	$Value = &LimitReturns($Value);
	}

	if (($Name eq "$YourCopyrightNotice") || ($Name eq "BBEmail") || ($Name eq "censorwords")) {
	$Value = &EliminateReturns($Value);
 	}

	if (($Name eq "BBRules") || ($Name eq "COPPAWording") || ($Name eq "COPPAInstructions") || ($Name eq "BBClosedMessage"))  {
	$Value = &ConvertReturns($Value);
	}

	if ( ($Name ne "Header") && ($Name ne "Footer") && ($Name ne "UserNameCheck") && ($Name ne "PasswordCheck") && ($Name ne "Submit") && ($Name ne "EmailBan")) {
	print FILE ("\$$Name = qq\($Value\);\n");
	}
	if (($Name eq "Header") ||  ($Name eq "Footer")) {
	print FILE ("\$$Name = q\($Value\);\n"); # q = no interpolation
	}

	
} # end foreach

	print FILE ('$ForumsPath = ' . '"' . $NonCGIPath . '";');
	print FILE ("\n1;\n");
close (FILE);

#check for banlist files
unless (-d "$NonCGIPath/BanLists") {
mkdir ("$NonCGIPath/BanLists", 0777) || die (&StandardHTML("Unable to make a directory in $NonCGIPath Here is the error:</p><p>$!</p><p>Check that that the NonCGI directory has correct permissions</p>") );
chmod(0777, "$NonCGIPath/BanLists");
}

if ($in{'EmailBan'} ne "") {
	$EmailBanList = &EliminateReturns($in{'EmailBan'});
	@BanList = split(/\s/, $EmailBanList);
	open(BAN, ">$NonCGIPath/BanLists/EmailBan.cgi");
	foreach $uno(@BanList) {
		chomp($uno);
		print BAN "$uno\n";
	}
	close(BAN);
	chmod(0777, "$NonCGIPath/BanLists/EmailBan.cgi");
}


# create forum directories and set permissions on directories
unless (-e "$NonCGIPath/Forum7") {
chmod(0777, "$NonCGIPath");
chmod(0755, "$CGIPath");
chmod(0777, "$MembersPath");
chmod(0777, "$MembersPath/Admin5.cgi");

mkdir ("$NonCGIPath/Forum1", 0777) || ($mkdirerror .= "Forum1, ");
chmod(0777, "$NonCGIPath/Forum1");
mkdir ("$NonCGIPath/Forum2", 0777) || ($mkdirerror .= "Forum2, ");
chmod(0777, "$NonCGIPath/Forum2");
mkdir ("$NonCGIPath/Forum3", 0777) || ($mkdirerror .= "Forum3, ");
chmod(0777, "$NonCGIPath/Forum3");
mkdir ("$NonCGIPath/Forum4", 0777) || ($mkdirerror .= "Forum4, ");
chmod(0777, "$NonCGIPath/Forum4");
mkdir ("$NonCGIPath/Forum5", 0777) || ($mkdirerror .= "Forum5, ");
chmod(0777, "$NonCGIPath/Forum5");
mkdir ("$NonCGIPath/Forum6", 0777) || ($mkdirerror .= "Forum6, ");
chmod(0777, "$NonCGIPath/Forum6");
mkdir ("$NonCGIPath/Forum7", 0777) || ($mkdirerror .= "Forum7, ");
chmod(0777, "$NonCGIPath/Forum7");
mkdir ("$NonCGIPath/Forum8", 0777) || ($mkdirerror .= "Forum8, ");
chmod(0777, "$NonCGIPath/Forum8");
mkdir ("$NonCGIPath/Forum9", 0777) || ($mkdirerror .= "Forum9  ");
chmod(0777, "$NonCGIPath/Forum9");

if ($mkdirerror) { die(&StandardHTMLCP("<p>Unable to make new directories [ $mkdirerror ] in $NonCGIPath</p><p>Here is the error:</p><p>$!</p><p>Check paths and permissions</p>") )};

}

###############################################
## Perform diagnostic checks/update if necessary
if (-e "$NonCGIPath/ubbdiagnostic.file") {
@diag = &OpenFile("$NonCGIPath/ubbdiagnostic.file");

foreach $diagline(@diag) {
	if ($diagline =~ m/SetLastTimes/) {
		$SLT = "true";
	}
	if ($diagline =~ m/ConvertAnnouncements/) {
		$CA = "true";
	}
	if ($diagline =~ m/ConvertToUBBFiles/) {
		$CTUF = "true";
	}
	if ($diagline =~ m/CreateLastForumNums/) {
		$CLFN = "true";
	}
}


if ($CTUF ne "true") {
	&RenameMess;
}

if ($CA ne "true") {
	&MoveAnnc;
}

if ($SLT ne "true") {
	&SetLastTimes;
}

if ($CLFN ne "true") {
	&SetLastThreadNums;
}

}  else {

$DidIt = "true";
#convert message files to ubb files
&RenameMess;
#move announcements to ANNC subdirectories
&MoveAnnc;
#reset last time files
&SetLastTimes;
#create last thread number file in each forum
&SetLastThreadNums;

#create ubbdiagnostic file--
open(DIAG, ">$NonCGIPath/ubbdiagnostic.file");
print DIAG ("SetLastTimes\n");
print DIAG ("ConvertAnnouncements\n");
print DIAG ("ConvertToUBBFiles\n");
print DIAG ("CreateLastForumNums\n");
close(DIAG);
chmod (0777, "$NonCGIPath/ubbdiagnostic.file");
}

if (($in{'Diagnostic'} eq "yes") && ($DidIt ne "true")) {
&SetLastTimesCycle;
}  else {

## END DIAGNOSTIC CHECK/UPDATE
#check to see if members are in proper format
&ConvertMembers;

$UserName = "$UserNameCheck";
$UserName =~ tr/ /+/;
$Password = "$PasswordCheck";
$Password =~ tr/ /+/;
unlink("$MembersPath/holdmems.cgi");
unlink("$NonCGIPath/temp.file");
unlink("$MembersPath/temp.file");

$ConfirmLine = "The Ultimate Bulletin Board General Variables have been updated.<P>
Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<P>";
&ConfirmHTML2;
exit;
}

}  else { # parse the error message further

	$setup_message = "<p>Sorry! Your General Settings were not accepted</p><p>Here is what UBB found:";

	unless (-e "$CGIPath") {
		$setup_message .= "<p>The Absolute CGI Path you entered:<p>$CGIPath</p><p>can't be found.</p><p>Check the spelling, case and that the slashes are forward '/'.</p>";
		$setup_help = "<p>Click back to try a corrected path.<br>You can also check the <A HREF=cpanel.cgi?action=env>Environmental Variables</a> for help.</p>";
	}
	elsif ( !(-e "$CGIPath/Ultimate.cgi") )  {
		$setup_message .= "<p>Did you upload all the script files in the correct case to $CGIPath ?</p>";		
		$setup_help .= "<p>Try this: Upload all the files with the correct case.</p>";
	}

	unless (-e "$NonCGIPath"){
		$setup_message .= "<p>The Absolute Non CGI path you entered</p><p>$NonCGIPath</p><p>can't be found.</p><p> Check the spelling, case and that the slashes are forward '/'.</p>";
		$setup_help = "<p>Click back to try a corrected path.<br>You can also check the <A HREF=cpanel.cgi?action=env>Environmental Variables</a> for help.</p>";
	}
	elsif ( !(-e "$NonCGIPath/ubbcode.html") )  {
		$setup_message .= "<p>Did you upload all the NonCGI files to $NonCGIPath ?</p><p>Be sure your FTP software did not convert the .html extensions to .htm</p>";	
		$setup_help .= "<p>Try this: Upload all the files with the correct .html extension.</p>";
	}
	&StandardHTMLCP("$setup_message $setup_help");
}
} ## END DO PROCESS GENERAL VARS SR

sub DoIndex {
&VerifyAdminModCP($UserName, $Password);

&log_admin_activity ("DoIndex") if ($log_admin_activity eq 'YES');

if ($Proceed eq "true") {
	if ($IndexMethod eq "ONEFILE") {
		&ReIndex("1", "0");
	}  else {
		&ReIndex2("1", "0");
	}
} 
} # end DoIndex sr


sub Mods {
&VerifyAdminCP($UserName, $Password);

if ($Proceed eq "true") {
  &DoProcessMods;
  exit;
}  
} 

sub DoProcessMods {

&log_admin_activity ("DoProcessMods") if ($log_admin_activity eq 'YES');

&GetMemberListArray;  #returns @members array

## now we have our current Member list (in filename format)
@GoodMods = @blank;
@namecheck = @blank;
foreach $row(@in) {
	$row = decodeURL($row);
	($Name, $Value) = split ("=", $row);
	if ($Name =~ m/NewMod/) {
	$QValue = quotemeta($Value);
	#place name in list to check for validity first
	if ($Value ne "") {
	push(@namecheck, $Value);
	}
	#place name in mods array
	($Trash, $ArrayNumber) = split(/Mod/, $Name);
	$ArrayNumber--;
	if ($GoodMods[$ArrayNumber] eq "") {
		$GoodMods[$ArrayNumber] = "$QValue";
	}  else {
	$GoodMods[$ArrayNumber] .= "||^||$QValue";
	}
	}
} # end foreach $row

#check for validity of each mod name first
foreach $checker(@namecheck) {
$nameok = "false";
if ($checker ne "") {
	for $matcher(@members) {
		chomp($matcher);
		if ($matcher eq "$checker") {
			$nameok = "true";
		}
	}
}  else {
	$nameok = "true";
}
if ($nameok eq "false") {
	&StandardHTMLCP("Sorry, we cannot process your moderator settings request for the following reason:<P>The following name is not registered:<P><CENTER>$checker</CENTER><P>You may only create create Moderators using registered names.");
exit;
}
}

#update mods.file
$ForumNum = 0;
&Lock("lock.file");
open (MODS, ">$VariablesPath/mods.file") || die( &StandardHTML("Unable to open mods.file. Here is the error: $! Check paths and permissions") );
for $eachrow(@GoodMods) {
$ForumNum++;
$modline = ('$Forum' . "$ForumNum" . 'Moderator = "' . "$eachrow" . '"' . ";\n");
print MODS "$modline";
}
print MODS ("1;\n");
close(MODS);
&Unlock("lock.file");

#remove dupes from namecheck list-- move to goodlist array
@goodlist = &RemoveDupes(@namecheck);

## UPDATE MEMBER PROFILES FOR ALL MODERATORS

foreach $ModName(@goodlist) {
	chomp($ModName);
	$ProfileNumber = &GetUserNumber($ModName);
	@modprof = &OpenProfile("$ProfileNumber.cgi");
	$Status = $modprof[8];
	&CheckStatus;
	if ($AdminStatus ne "true") {
		$modprof[8] = "Moderator";
		&Lock("lock.file");
		open (UPDATE, ">$MembersPath/$ProfileNumber.cgi");
			foreach $thisline(@modprof) {
				chomp($thisline);
				print UPDATE ("$thisline\n");
			}
		close (UPDATE);
		&Unlock("lock.file");
	}  ## END IF not admin
} # end for


## Delete Moderator status from users who are no longer Moderators

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	if ($Name =~ m/OldMod/) {
	if ($Value ne "") {
	@alloldmods = split(/\|\|\^\|\|/, $Value);
	foreach $unomod(@alloldmods) {
	chomp($unomod);
	push (@OldMods, $unomod);
	}
	}
	}
} # end foreach $row

#delete dupes from old mods
@FinalOldMods = &RemoveDupes(@OldMods);

for $oldie(@FinalOldMods) {
	$SaveOldie = "no";
	chomp($oldie);
	for $checkthis(@goodlist) {
		chomp($checkthis);
		if ($oldie eq "$checkthis") {
		$SaveOldie = "yes";
		}
	}
	if (($SaveOldie ne "yes") && ($oldie ne "")) {
		$ProfileNumber = &GetUserNumber($oldie);
		@oldmod = &OpenProfile("$ProfileNumber.cgi");  
			$Status = $oldmod[8];
			$TotalPosts = $oldmod[7];
			&CheckStatus;
			
			if ($AdminStatus ne "true") {
				if ($TotalPosts < $MemberMinimum) {
					$Status = "Junior Member";
				}  else {
					$Status = "Member";
				}
				$oldmod[8] = "$Status";
				&Lock("lock.file");
				open (UPDATE, ">$MembersPath/$ProfileNumber.cgi");
				foreach $separate(@oldmod) {
					chomp($separate);
					print UPDATE ("$separate\n");
				}
				close (UPDATE);
				&Unlock("lock.file");
		}  ## END IF ADMIN status ne true
	}

} 

$ConfirmLine = "The forum moderators have been successfully updated.";
&ConfirmHTML2;

}  ## END DO PROCESS SR

sub CheckStatus {
		if ($Status =~ m/Administrator/) {
			$AdminStatus = "true";
			} else {
			$AdminStatus = "false";
		}
		if ($Status =~ m/Moderator/) {
			$ModStatus = "true";
		} else {
			$ModStatus = "false";
		}
		if ($Permission =~ m/Write/) {
			$AdminWrite = "true";
		} else {
			$AdminWrite = "false";
		}
} #end CheckStatus



sub RenameMess {

#convert old files to new files--- (new in 5.10)
@sortforums = &OpenForumsFile;

for (@sortforums) {

@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

opendir (FORUMDIR, "$ForumsPath/Forum$x"); 
    @thesefiles = readdir(FORUMDIR);
closedir (FORUMDIR);

@thefiles = grep(/\.(n|m)/, @thesefiles);
@files = sort(@thefiles);
$oldfiletotal = @files;

foreach $one(@files) {
$Notes = "";

if ($one =~ /^\d\d\d\d\d\d-000000/) {
#it is a father
@father = &OpenFile("$ForumsPath/Forum$x/$one");
($threadnum, $junk, $junk2, $replies) = split(/-/, $one);
($replies, $junk3) = split(/\./, $replies);
$TotReplies = substr($replies, 0, 6);
$TotReplies = $TotReplies + 0;

if ($one =~ /X/) {
	$Notes = "X";
	}
if ($one =~ /n/) {
	$Notes .= "N";
	}

chomp($father[0]);
chomp($father[1]);
chomp($father[2]);
$Subject = $father[3];
chomp($Subject);
$email = $father[4];
chomp($email);
chomp($father[5]);

$StatsLine = "A||$Notes||$TotReplies||$father[0]||$Subject";

$NewFatherName = "$threadnum.cgi";
$FatherLine = "Z||000000||$father[0]||$father[1]||$father[2]||$email||$father[5]";

open (RENAMEPOP, ">$ForumsPath/Forum$x/$NewFatherName");
print RENAMEPOP ("$StatsLine\n");
print RENAMEPOP ("$FatherLine\n");
close (RENAMEPOP);


chmod (0666, "$ForumsPath/Forum$x/$NewFatherName");
unlink "$ForumsPath/Forum$x/$one";


}  else {
#add to reply file
@reply = &OpenFile("$ForumsPath/Forum$x/$one");
($threadnum, $replynum, $junk, $junk2) = split(/-/, $one);
$NewReplyName = "$threadnum.cgi";

#put reply info on one line
$UName = $reply[0];
chomp($UName);
$Date = $reply[1];
chomp($Date);
$TheTime = $reply[2];
chomp($TheTime);
$Subject = $reply[3];
chomp($Subject);
$Email = $reply[4];
chomp($Email);
$Message = $reply[5];
chomp($Message);
$ReplyLine = ("Z||$replynum||$UName||$Date||$TheTime||$Email||$Message");

open (RENAMEPOP, ">>$ForumsPath/Forum$x/$NewReplyName");
print RENAMEPOP ("$ReplyLine\n");
close (RENAMEPOP);

chmod (0666, "$ForumsPath/Forum$x/$NewReplyName");
unlink "$ForumsPath/Forum$x/$one";
}
}

}  # end for each forum
}  # end Rename Mess sr

sub MoveAnnc {
#move annc to sep. ANNC directories- new in 5.10
@sortforums = &OpenForumsFile;

for (@sortforums) {

@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

opendir (FORUMDIR, "$ForumsPath/Forum$x"); 
    @files = readdir(FORUMDIR);
closedir (FORUMDIR);

@annc = grep(/\.annc/, @files);

mkdir("$ForumsPath/Forum$x/ANNC", 0777) ;
chmod (0777, "$ForumsPath/Forum$x/ANNC");


foreach $one(@annc) {
@thisann = &OpenFile("$ForumsPath/Forum$x/$one");
	
open (ANNC, ">$ForumsPath/Forum$x/ANNC/$one");
foreach $line(@thisann) {
chomp($line);
print ANNC ("$line\n");
}
close (ANNC);
chmod (0777, "$ForumsPath/Forum$x/ANNC/$one");
}
}  # end for each forum

}  # end Move Annc sr (new in 5.10)

sub SetLastThreadNums {

# set thread number info to lastnumber.file
# new in 5.10
@sortforums = &OpenForumsFile;

for (@sortforums) {
@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

if ($thisforum[6] eq "private") {
	$ExactPath = "Forum$x/private-$thisforum[7]";
	} else {
	$ExactPath = "Forum$x";
	}

opendir (FORUMDIR, "$ForumsPath/$ExactPath"); 
    @files = readdir(FORUMDIR);
closedir (FORUMDIR);

@theubbfiles = grep(/\.[cgi|ubb]/, @files);
$topiccount = @theubbfiles;
#sort the ubb files
@sortubbfiles = sort(@theubbfiles);
#reverse array so that largest number is first
@ubbfiles = reverse(@sortubbfiles);
my $lastnumber = $ubbfiles[0];
($lastnumber, $junk) = split(/\./, $lastnumber);

$ThreadTotal = 0;
#determine number of total posts
foreach $threadfile(@ubbfiles) {
@thecountit = &OpenFile("$ForumsPath/$ExactPath/$threadfile");
@countit = grep(/^Z/, @thecountit);
$ThisTotal = @countit;
$ThreadTotal = $ThreadTotal + $ThisTotal;
}

if (-e "$ForumsPath/$ExactPath/lastnumber.file") {
chmod (0666, "$ForumsPath/$ExactPath/lastnumber.file");
}

#print number to lastnumber.file
open (UBB, ">$ForumsPath/$ExactPath/lastnumber.file");
print UBB ("$lastnumber\n");
print UBB ("$topiccount\n");
print UBB ("$ThreadTotal\n");
close (UBB);

chmod (0666, "$ForumsPath/$ExactPath/lastnumber.file");
}  # end for each forum
} #end SetLastThreadNums sr


sub ConvertMembers {

#check to see if memberlist.cgi exists - if not, create it
if (-e "$MembersPath/memberslist.cgi") {
	$ConversionOne = "done";
}
if (-e "$MembersPath/emailfile.cgi") {
	$ConversionTwo = "done";
}

if ($ConversionOne ne "done") {
	$OldFormat = "true";
}

if ($ConversionTwo ne "done") {

open (TEMP, ">$NonCGIPath/temp.file");
print TEMP "temp closure - delete this file if you have problems with your UBB";
close(TEMP);
chmod(0777, "$NonCGIPath/temp.file");

#create private index directory
mkdir ("$MembersPath/pindex", 0777) || die ( &StandardHTML("Cannot make pindex directory inside Members directory: $! <P>Check paths and permissions for the Members directory") );
chmod(0777, "$MembersPath/pindex");

mkdir ("$MembersPath/OldMembers", 0777);
chmod(0777, "$MembersPath/OldMembers");

#batch old members files to memberslist.cgi
opendir (MEMS, "$MembersPath");
@thememberarray = readdir(MEMS);
closedir (MEMS);
if ($OldFormat eq "true") {
@memberarray = grep(/\.cgi/, @thememberarray);
}  else {
@memberarray = grep(/\d\d\.cgi/, @thememberarray);
}

@sortmems = sort(@memberarray);

#store names/numbers in a temporary file
open (MEM, ">$MembersPath/holdmems.cgi");
foreach $memone(@sortmems) {
chomp($memone);
print MEM ("$memone\n");
}
close (MEM);
chmod (0777, "$MembersPath/holdmems.cgi");

my $Count = 0;
my $thisnumber = 0;
$SubTotal = @sortmems;
$MemTotal = $SubTotal - 1;

$Maximum = 39;
if ($MemTotal > $Maximum) {
$Max = $Maximum;
$Continue = "true";
$StartWith = $Maximum + 1;
$StartDisplay = 1;
$EndDisplay = $StartWith;
}  else {
$Max = $MemTotal;
}
	@adjmembers = @sortmems[0... $Max];
	
foreach $oneeach(@adjmembers) {
$Count++;
$thisnumber = sprintf("%8d", $Count);
$thisnumber =~tr/ /0/;
	@thismember = &OpenFile("$MembersPath/$oneeach");
	$memberline = $thismember[0];
	chomp($memberline);

if ($OldFormat eq "true") {
@memberstats = split(/\|/, $memberline);
}  else {
$OldFormat = "false";
@memberstats = @thismember;
}

$ThisEmail = $memberstats[2];
$ThisName = $memberstats[0];
chomp($ThisEmail);
chomp($ThisName);

if ($OldFormat ne "true") {
($thisnumber, $junk) = split(/\./, $oneeach);
}

$thisline = ("$ThisName|!!|$thisnumber");
$thisline2 = ("$ThisEmail||$thisnumber");
push (@memberlist, $thisline);
push (@emailfile, $thisline2);

#rename old members files

rename("$MembersPath/$oneeach", "$MembersPath/OldMembers/$oneeach");

if (-e "$MembersPath/$oneeach") {
unlink("$MembersPath/$oneeach");
}
&Lock ("lock.file");
open (THISONE, ">$MembersPath/$thisnumber.cgi");
foreach $line(@memberstats) {
chomp($line);
	print THISONE "$line\n";
}
close (THISONE);
&Unlock ("lock.file");
chmod (0777, "$MembersPath/$thisnumber.cgi");

}
&Lock ("lock.file");
open (LIST, ">$MembersPath/memberslist.cgi");
	foreach $uno(@memberlist) {
		chomp($uno);
		print LIST "$uno\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0777, "$MembersPath/memberslist.cgi");

&Lock ("lock.file");
open (LIST, ">$MembersPath/emailfile.cgi");
	foreach $dos(@emailfile) {
		chomp($dos);
		print LIST "$dos\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0777, "$MembersPath/emailfile.cgi");

if ($Continue eq "true") {
&ContinueMCWording("$OldFormat");
exit;
}


}  else {

$UserName = "$UserNameCheck";
$UserName =~ tr/ /+/;
$Password = "$PasswordCheck";
$Password =~ tr/ /+/;
unlink("$MembersPath/holdmems.cgi");
$ConfirmLine = "The Ultimate Bulletin Board General Variables have been updated.<P>
Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<P>";
&ConfirmHTML2;
exit;
}

} #end ConvertMembers

sub ContinueMCWording {
my $ThisOldFormat = shift;

$UserNameCheckCoded = $in{'UserNameCheck'};
$UserNameCheckCoded =~ tr/ /+/;
print<<TheMail;
<HTML><HEAD>
<meta http-equiv="Refresh" content="2; URL=$CGIURL/cpanel2.cgi?action=continueMC&startwith=$StartWith&UserName=$UserNameCheckCoded&Password=$PasswordCheckCoded&OldFormat=$ThisOldFormat">
</head>
<BODY bgcolor=#FFFFFF>
<center>
<FONT FACE="Verdana, Arial" SIZE="2"><B>
<FONT FACE="Courier New" SIZE="5" COLOR="Maroon"><B>Processing....Please Wait!</B></FONT>
<P>
We are converting all of your old Member files to a new format.  Please be patient!
<P>
We just converted Members <FONT FACE="Verdana" SIZE="3" COLOR="Navy">$StartDisplay</font> to <FONT FACE="Verdana" SIZE="3" COLOR="Navy">$EndDisplay</font>...
<P><FONT FACE="Courier New" SIZE="5" COLOR="Maroon"><B>
PLEASE WAIT - WE ARE STILL PROCESSING... Do Not Interrupt The Process Yet!</B></FONT>
</center>
</FONT>
</BODY>
</HTML>
TheMail
}

sub ContinueMC {
$StartWith = shift;
$OldFormat = shift;
@members = &OpenFile("$MembersPath/holdmems.cgi");
@sortmems = sort(@members);

$MemTotal = @sortmems;
$MemTotal--;

$StartWith = $StartWith + 0;
$Maximum = 249;
$MaximumNumber = $StartWith + $Maximum;

if ($MemTotal > $MaximumNumber) {
$Max = $MaximumNumber;
$Continue = "true";
$StartDisplay = $StartWith + 1;
$EndDisplay = $Max + 1;
}  else {
$Max = $MemTotal;
}
	@adjmembers = @sortmems[$StartWith... $Max];
	
	$Count = $StartWith; #arraynumber
	
foreach $thisuno(@adjmembers) {
chomp($thisuno);
$Count++;
if ($OldFormat eq "true") {
$thisnumber = sprintf("%8d", $Count);
$thisnumber =~tr/ /0/;
}
@thismember = &OpenFile("$MembersPath/$thisuno");
rename("$MembersPath/$thisuno", "$MembersPath/OldMembers/$thisuno");

if (-e "$MembersPath/$thisuno") {
unlink("$MembersPath/$thisuno");
}

$memberline = $thismember[0];
chomp($memberline);
if ($OldFormat eq "true") {
@memberstats = split(/\|/, $memberline);
}  else {
@memberstats = @thismember;
($thisnumber, $junk) = split(/\./, $thisuno);
}

$ThisEmail = $memberstats[2];
$ThisName = $memberstats[0];
chomp($ThisEmail);
chomp($ThisName);

$thisline = ("$ThisName|!!|$thisnumber");
push (@memberlist, $thisline);
$thisline2 = ("$ThisEmail||$thisnumber");
push (@emailfile, $thisline2);
#rename old members files
&Lock ("lock.file");
open (THISONE, ">$MembersPath/$thisnumber.cgi");
foreach $line(@memberstats) {
chomp($line);
	print THISONE "$line\n";
}
close (THISONE);
&Unlock ("lock.file");
chmod (0777, "$MembersPath/$thisnumber.cgi");

}
&Lock ("lock.file");
open (LIST, ">>$MembersPath/memberslist.cgi");
	foreach $uno(@memberlist) {
		chomp($uno);
		print LIST "$uno\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0666, "$MembersPath/memberslist.cgi");

&Lock ("lock.file");
open (LIST, ">>$MembersPath/emailfile.cgi");
	foreach $uno2(@emailfile) {
		chomp($uno2);
		print LIST "$uno2\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0666, "$MembersPath/emailfile.cgi");
if ($Continue eq "true") {
$StartWith = $EndDisplay;
&ContinueMCWording($OldFormat);;
exit;
}  else {

$UserName = "$UserName";
$UserName =~ tr/ /+/;
$Password = "$Password";
$Password =~ tr/ /+/;

unlink("$MembersPath/temp.file");
unlink("$MembersPath/holdmems.cgi");
unlink("$NonCGIPath/temp.file");
$ConfirmLine = "The Ultimate Bulletin Board General Variables have been updated.<P>
Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<P>";
&ConfirmHTML2;
exit;
}
}  # end continue MC

sub InputTextRow {
my $RowColor = shift;
my $FieldName = shift;
my $Notes = shift;
my $InputField = shift;
my $Size = shift;
my $MaxSize = shift;
if ($Notes ne "") {
	$Notes = "<BR>$Notes";
}
print<<ROW;
<tr bgcolor="$RowColor">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>$FieldName</B></FONT>
<FONT SIZE="1" FACE="Verdana, Arial"><B>$Notes</B></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="$InputField" VALUE="$$InputField" SIZE=$Size MAXLENGTH=$MaxSize>
</td></tr>
ROW
}


sub log_admin_activity {
	
my $admin_action = shift;
open(ADMINLOG, ">>$NonCGIPath/BanLists/adminlog.cgi");
print ADMINLOG localtime() . " $admin_action $in{'UserName'}$in{'UserNameCheck'} $ENV{'REMOTE_ADDR'} $ENV{'REMOTE_HOST'} $ENV{'HTTP_USER_AGENT'} $ENV{'HTTP_REFERER'}\n";
close(ADMINLOG);
chmod (0777, "$NonCGIPath/BanLists/adminlog.cgi");
return 1;
} # end SR


sub checkpathlock { # don't process change to paths if the BB is locked

if ( (-e "$NonCGIPath/BanLists/ubbpathlock.cgi") &&  (-e "$CGIPath/edit.cgi") && (-e "$MembersPath/memberslist.cgi") && (-e "$VariablesPath/UltBB.setup")  ) {
	if ($CGIPath ne $in{'CGIPath'}) {
	  $change = " $in{'CGIPath'}";	
	}	
	if ($NonCGIPath ne $in{'NonCGIPath'}) {
	  $change .= " $in{'NonCGIPath'}";	
	}	
	if ($MembersPath ne $in{'MembersPath'}) {
	  $change .= " $in{'MembersPath'}";	
	}	
	if ($VariablesPath ne $in{'VariablesPath'}) {
	  $change .= " $in{'VariablesPath'}";	
	}	
	if ($change) {
	  &log_admin_activity ("Change Locked Path to $change");	
	  &PostHackDetails;
	  &StandardHTMLCP("Sorry! All paths are locked on this board. The Owner of the site must remove the ubbpathlock.cgi file manually before you can change paths. <p>Your attempt has been logged.<p>Click back.");
	  exit;
	}
}	
else {
	return 1;	
}	
} # end SR

exit(0); # comply with SafePerl
