#!/usr/bin/perl
#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Infopop Corporation, 1998-2000.
#
#       ------------ cpanel.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  Infopop Corporation offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "mods.file";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";
};

if ($@) {
    print "<HTML><BODY><p>Error including the required files:</p>";
    print "<p>Be sure you uploaded UltBB.setup, Styles.file, mods.file and forums.cgi in ASCII/Text mode to your CGI directory. [This is a manual setting on your FTP software]</p><p>Make sure spelling and case are correct: UltBB.setup not ultbb.setup.</p>\n\n";
    print "<p>Here is the message returned from UBB:</p><p>$@</p>\n\n</BODY></HTML>";
 exit;
}

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);

	if ($Name eq "action") {
			$action = $Value;
	}
	if ($Name eq "Email") {
			$Email = $Value;
			$Email =~tr/A-Z/a-z/;  
		}
	if ($Name eq "UserName") {
			$UserName = $Value;
		}
	if ($Name eq "Password") {
			$Password = $Value;
		}
} #end foreach loop

if ($VariablesPath eq "") {
	$VariablesPath = $CGIPath;
}

if ($action eq "setmods") {
   &SetMods;
}
if ($action eq "UpdateThreads") {
   &UpdateThreads;
}
if ($action eq "prune") {
   &Prune;
}
if ($action eq "digest") {
   &Digest;
}
if ($action eq "index") {
   &Index;
}
if ($action eq "archives") {
   &Archives;
}
if ($action eq "addforums") {
   &AddForums;
}
if ($action eq "banlists") {
   &BanLists;
}
if ($action eq "variables") {
   &Variables;
}

if ($action eq "permissions") {
   &Permissions;
}

if ($action eq "env") {
   &Env;
}
if ($action eq "misc") {
   &Misc;
}
if ($action eq "mail") {
   &Mail;
}
if ($action eq "style") {
   &Styles;
}

if ($action eq "logintoforums") {
   &LogIntoForums;
}

sub Styles {
if ($profilegif eq "") {
	$profilegif = "profile.gif";
}
if ($mailgif eq "") {
	$mailgif = "email.gif";
}
if ($CopyrightTextColor eq "") {
	$CopyrightTextColor = "#C0C0C0";
}
if ($TextSize eq "") {
	$TextSize = "2";
}
if ($TextColor eq "") {
	$TextColor = "#000000";
}
if ($LinkColor eq "") {
	$LinkColor = "#000080";
}
if ($VisitedLinkColor eq "") {
	$VisitedLinkColor = "#808000";
}
if ($ActiveLinkColor eq "") {
	$ActiveLinkColor = "#800000";
}
if ($TableStripTextColor eq "") {
	$TableStripTextColor = "#000080";
}
if ($CategoryStripTextColor eq "") {
	$CategoryStripTextColor = "#000000";
}

if ($BBTitle eq "") {
	$BBTitle = "bbtitle1.jpg";
}
if ($BBTopic eq "") {
	$BBTopic = "topic1.jpg";
}
if ($BBReply eq "") {
	$BBReply = "reply1.jpg";
}
if ($ThreadClosed eq "") {
	$ThreadClosed = "threadclose1.jpg";
}
if ($TableWidth eq "") {
	$TableWidth = "95%";
}
if ($FDTextSize eq "") {
	$FDTextSize = "1";
}
if ($TimeColor eq "") {
	$TimeColor = "#800080";
}
if ($BBTitleFontColor eq "") {
	$BBTitleFontColor = "#800000";
}

$PageTitle = " S E T &nbsp;&nbsp;&nbsp;&nbsp; S T Y L E S";
&HEADERHTML1;

print<<StyleHTML;
You can easily change the font face and/or color, graphics, and background colors used throughout your bulletin board using this control panel page.  Note: these changes affect only the bulletin board pages, not any of the control panel pages.  For all colors, we recommend using hexadecimal codes (e.g., #FFFFFF for "white", etc.).  The settings below are your overall style settings.  You can customize these settings for individual forums in the Forum Settings area.
</FONT>
<P>
<FORM ACTION="$CGIURL/cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendstyle">
<center>
<table border=0 cellpadding=0 cellspacing=0 width="95%"><TR><td bgcolor="#000000">

<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>
<TR bgcolor="#B0BB9D">
<TD colspan=4>
<FONT FACE="Verdana" SIZE="2"><B>Color Options</B></FONT></TD></TR>
StyleHTML

&ColorRow("Page Background Color", "Format - #FFFFFF", "BGColor", "#C7C6BA");
&ColorRow("Text Color", "", "TextColor", "#D5D2BB");
&ColorRow("Link Color", "", "LinkColor", "#C7C6BA");
&ColorRow("Active Link Color", "", "ActiveLinkColor", "#D5D2BB");
&ColorRow("Visited Link Color", "", "VisitedLinkColor", "#C7C6BA");
&ColorRow("Table Border Color", "", "TableBorderColor", "#D5D2BB");
&ColorRow("Table Header Strip Text Color", "", "TableStripTextColor", "#C7C6BA");
&ColorRow("Table Header Strip Background Color", "", "TableColorStrip", "#D5D2BB");
&ColorRow("Time Color", "This color is used for the time field on the main forum summary page and the forum pages and for the \"posted by\" line for each post.", "TimeColor", "#C7C6BA");
&ColorRow("First Alternating Table Column Color", "", "AltColumnColor1", "#D5D2BB");
&ColorRow("Second Alternating Table Column Color", "", "AltColumnColor2", "#C7C6BA");
&ColorRow("Category Strip Background Color", "", "CategoryStripColor", "#D5D2BB");
&ColorRow("Category Strip Text Color", "", "CategoryStripTextColor", "#C7C6BA");
&ColorRow("Copyright Text Color", "", "CopyrightTextColor", "#D5D2BB");
&ColorRow("BB Title Font Color", "", "BBTitleFontColor", "#C7C6BA");

print<<Style12;
<tr bgcolor="#B0BB9D">
<td colspan=4><B><FONT FACE="Verdana" SIZE="2">Miscellaneous Graphic Options</FONT></B></TD>
</TR>
<tr bgcolor="#D5D2BB">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Font Face (e.g., Verdana)</B></FONT><br><FONT SIZE="1" FACE="Verdana, Arial">We recommend you use a backup font as well.  For example: to use Verdana as your first choice, with Arial as a conditional font for those users that don't have Verdana as a font on their system, you would type "Verdana, Arial")</FONT><br>
</td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="FontFace" VALUE="$FontFace" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Width</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">You may use either exact pixels (recommended: 600) or a percentage (recommended: 90%)</FONT>
</td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="TableWidth" VALUE="$TableWidth" SIZE=5 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Text Size</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">We recommend using size 2... but depending on your font face, you may want to alter this.</FONT>
</td>
<td valign=top  colspan="3">
<INPUT TYPE="TEXT" NAME="TextSize" VALUE="$TextSize" SIZE=1 MAXLENGTH=1>
</td></tr>

<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Forum Description Text Size</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">The default setting is for the Forum Description wording to appear as your standard Text Size (which you set above).  You may set the size for the forum descriptions to another size, however, if you prefer. For example, setting the size to 1, when the normal text size is 2 will make the Forum Names appear more prominent.</FONT>
</td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="FDTextSize" VALUE="$FDTextSize" SIZE=1 MAXLENGTH=1>
</td></tr>

<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Page Background Graphic</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">Not recommended to be used, but you can add a background graphic to your pages.  If you do so, you should upload the graphic into your NON CGI directory and place the name of the background graphic in this field.  For example, background.gif.</FONT>
</td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="PageBackground" VALUE="$PageBackground" SIZE=30 MAXLENGTH=200>
</td></tr>
<tr bgcolor="#B0BB9D">
<td colspan=4><b><FONT FACE="Verdana" SIZE="2"> Graphic Images</b></b>
<P><FONT FACE="Verdana" SIZE="2">
You can choose from 6 coordinated graphic sets, or substitute your own graphics. There are 3 main graphics used- the title or logo graphic that appears at the top of most pages, a "Post New Topic" graphic, a "Post Reply" graphic, and a "Closed Thread" graphic.  Many of the available graphics were created by the very talented Karen Vail.  Some recent smilies were created by<a href="mailto:mystery\@ablithora.net"> Venus</a> and Amy Medina of <a href="http://www.something-fishy.com">Something Fishy</a>.
<P>
The graphic sets are pictured <A HREF="$NonCGIURL/graphicsets.html">here</A>.  To use one of these graphics, just type in the name of the graphic in the corresponding field.  To use one of your own graphics, type in its own unique name in the corresponding field.  Also, if you use your own graphics, be sure to FTP the images into your Non CGI directory.
<P>
Recommended graphic sizes: if you are creating your own graphics, we recommend that the following sizes (in pixels) be used (in order to fit with layout of the BB): <ul>
<LI> Title/logo graphic- 300 wide by 75 high 
<LI> Post New Topic graphic - 80 wide by 17 high
<LI> Post Reply graphic - 75 wide by 17 high
<LI> Thread Close graphic - 75 wide by 17 high
</ul><br>
Don't forget: if you are using your own custom graphics instead of one of the standard graphics shown above, be sure to upload (FTP) your custom graphics to your UBB NON CGI directory.  You may want to check out the <A HREF="http://www.ultimatebb.com/home/graphics.shtml">UBB Graphics Shop</A> to see graphics created by others for use on the Ultimate Bulletin Board.
</FONT></TD>
</TR>
<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Title Graphic:</B></FONT></td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="BBTitle" VALUE="$BBTitle" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post New Topic Graphic:</B></FONT>
</td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="BBTopic" VALUE="$BBTopic" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post Reply Graphic:</B></FONT>
</td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="BBReply" VALUE="$BBReply" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Thread Closed Graphic:</B></FONT>
</td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="ThreadClosed" VALUE="$ThreadClosed" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Profile Graphic:</B></FONT>
</td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="profilegif" VALUE="$profilegif" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Graphic:</B></FONT>
</td>
<td valign=top colspan="3">
<INPUT TYPE="TEXT" NAME="mailgif" VALUE="$mailgif" SIZE=25 MAXLENGTH=50>
</td></tr>
<TR bgcolor="#B0BB9D"><TD colspan="4">
<CENTER><FONT COLOR="#000000" face="Verdana, Arial" Size="2">Verify Your Identity<BR>ONLY ADMINISTRATORS CAN SET STYLES</FONT></CENTER>
</td></tr>
<TR bgcolor="#FFFFF">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td colspan="3"><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR bgcolor="#FFFFF">
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td colspan="3">
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td></tr></table>
</td></tr></table>
<P>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Style Changes Now">
</FORM>
<P><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Powered by: Infopop &copy; 2000<br>Ultimate Bulletin Board $Version</FONT></CENTER>
</BODY>
</HTML>
Style12
}  ## END Styles subroutine

sub UpdateThreads {
$PageTitle = "U P D A T E &nbsp;&nbsp;&nbsp;&nbsp; T H R E A D S";
&HEADERHTML1;

print<<Threads;
<FONT SIZE="1" FACE="Verdana, Arial">Note: only administrators may update HTML threads. <P>
After you make changes to your control panel settings, these changes take affect immediately for all new pages.  Older HTML pages, however, are not updated until you update them here.  You should run this function after you have made all changes to your control panel settings.
</FONT>
<FORM ACTION="$CGIURL/postings.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="doupdate">
<center>
<table border=0 cellpadding=0 cellspacing=0 width="90%"><TR><td bgcolor="#000000">
<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>
<tr bgcolor="#FFFFFF">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td></tr>
<TR bgcolor="#FFFFFF">
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td></tr>

<TR bgcolor="#B0BB9D">
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Specify Forums To Update:</FONT></B><BR><FONT SIZE="1" FACE="Verdana, Arial">If you are upgrading, you should update all forums.  If you made style changes on one particular forum, however, you may only want to update the topics in that forum only.</FONT>
</td>
<td valign=top>
<SELECT NAME="UpdateForumChoice">
	<OPTION VALUE="ALL" SELECTED>All Forums
Threads

@forumfile = &OpenFile("$VariablesPath/forums.cgi");
foreach $one(@forumfile) {
@thisforum = split(/\|/, $one);
$ForumNumber = $thisforum[8];
$ForumName = $thisforum[1];
print qq(<OPTION VALUE="$ForumNumber">$ForumName);
}

print<<Threads2;
</SELECT>
</td></tr>
<TR bgcolor="#FFFFFF">
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Update Cycle Rate</FONT></B><BR><FONT SIZE="1" FACE="Verdana, Arial">Depending on your server and the number of messages you have stored, you can determine whether to have the UBB update your topic pages (threads) in large chunks or small chunks.  The default setting is 150 topics at a time, per forum.  If you are unable to complete the update process, you may want to try lowering the cycle rate.  Conversely, if you have no trouble at 150, you may want to try setting the rate higher to reduce the amount of time spent on the update.</FONT>
</td>
<td valign=top>
<SELECT NAME="Cycle">
	<OPTION>30
	<OPTION>60
	<OPTION>100
	<OPTION SELECTED>150
	<OPTION>200
	<OPTION>230
	<OPTION>300
</SELECT>
</td></tr>
</table>
</td></tr></table>
<p>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Update Threads Now!">
</CENTER>

</FORM>
</BODY></HTML>
Threads2

}  ## END UpdateThreads SR ##


sub Archives {
$PageTitle = "A R C H I V E S";
&HEADERHTML1;

print<<Threads;
Archives are <B>read-only</B> sections of your UBB that store topics that were previously posted to forums.  Archives are completely separate from forums.  The purpose of archives is to store topics that were posted in a forum in your UBB that you want to "keep" for use as a FAQ, "Best Of", or reference area.  
<P>
Archives do not have to correspond to forums, but they are populated by forum topics.  For instance, if you have 9 forums, each concerning a different aspect of your company, you may want to set up one archive where you can store the most frequently asked questions in all forums- you could call that archive your Frequently Asked Questions archive.  There are a number of possible uses for archives- just keep in mind that any topic you move into an archive will be strictly read-only in the archive.  
<P>
Topics are transferred into archives by clicking on the "MOVE/ARCHIVE" link on the actual topic page.  <P>
To create/delete/modify an archive, identify yourself below.  Note: only administrators may create or modify archives. You may create up to 40 archives.<P>
<FORM ACTION="$CGIURL/archive.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="enterarchive">
<center>
Threads

&IDTable;

print<<ArchiveBottom;
<p>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Enter Archives Center Now!">
</CENTER>
</FORM>
</BODY></HTML>
ArchiveBottom
}  ## END Archives SR ##

sub Index {
$PageTitle = "C R E A T E / U P D A T E &nbsp;&nbsp;&nbsp;&nbsp; I N D E X";
&HEADERHTML1;

print<<Index;
<CENTER><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Only administrators or moderators may set or update the index.</FONT></CENTER>
<P>
The index is used for all searches.  If you are upgrading from a version that did not have a search engine included, you MUST create your index before any searches will work.  Just click on the button below!  If you ever have problems, or if your index becomes corrupted for some reason, you can easily create it again here.
<P>
You should recreate your index here each time after you prune/delete posts in the control panel.  This will not be done by the UBB automatically.
<P>
<FORM ACTION="$CGIURL/cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="doindex">
<center>
Index

&IDTable;

print<<Index2;
<p>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Create/Update Index Now!">
</CENTER>
</FORM>
</BODY></HTML>
Index2

}  ## END INDEX SR ##

sub LogIntoForums {
&AssembleCats;
$PageTitle = "F O R U M &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S";
&HEADERHTML1;

print<<ForumLoginHTML;
<center>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">You must be an administrator to change forum settings.</FONT>
<P>
<FORM ACTION="$CGIURL/cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
ForumLoginHTML

&IDTable;

print<<ENDIT;
<P></font>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="forums">
<INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="0">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial">Powered by: Infopop &copy; 2000<br>Ultimate Bulletin Board $Version
</FONT>
</CENTER></BODY></HTML>
ENDIT
}  # end logintoforums sr


sub BanLists {
$PageTitle = "B A N &nbsp;&nbsp;&nbsp;&nbsp; L I S T S";
&HEADERHTML1;

print<<ForumLoginHTML;
<center>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">You must be an administrator to add users to your list<BR>of banned email addresses or IP numbers.</FONT>
<P>
</center>
<FONT SIZE="1" FACE="Verdana, Arial">
Note: if you are upgrading from a version before 5.38, be sure to reset your general settings prior to setting the new Ban Lists (doing so will preserve your prior ban lists set before 5.38).</font><center>
<P>
<FORM ACTION="$CGIURL/cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
ForumLoginHTML

&IDTable;

print<<ENDIT;
<P></font>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="viewbanlist">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial">Powered by: Infopop &copy; 2000<br>Ultimate Bulletin Board $Version
</FONT>
</CENTER></BODY></HTML>
ENDIT
}  # end banlists sr

sub Env {
if ( (-e "$CGIPath/edit.cgi") && (-e "$MembersPath/memberslist.cgi")  && (-d "$NonCGIPath/Forum3") ) {
	&get_cookie;
	if($cookie{'UserNameCP'}) {
		&VerifyAdminCP($cookie{'UserNameCP'},$cookie{'PasswordCP'}); # make sure they logged in
		unless ($Proceed eq "true") {	
		  &StandardHTMLCP("Sorry you have not been verified as an administrator.  Login through the control panel 'General Settings'.");
		  exit;	
		}
	} else {&StandardHTML("Your bulletin board paths have already been configured correctly.<p>For security, Environmental Variables are available only to Administrators.<br>Submit your 'General Settings' to verify your status.");
	  exit;
	}
}	
	
	
print<<TOP;
<HTML><BODY BGCOLOR="#FFFFFF">
<BR><BR>
<CENTER><FONT SIZE="5" FACE="Courier New" ><B>Your Environmental Variables</b></FONT></CENTER>
<P>
<font face="Verdana, Arial" size="2">
Use these to help you figure out your absolute file paths, and other system information.<P>
<FONT face="Verdana, Arial" size="2" COLOR="#800000"><B>Perl Info:</b></FONT><BR>
You are using <b>Perl Version $]</b>
<P>
<FONT face-"Verdana, Arial" size="2" COLOR="#800000"><B>Your Environmental Variables:</b></FONT>
<BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#008080">Note: "DOCUMENT_ROOT" shows your absolute path to your root web directory.  "SCRIPT_FILENAME" shows you absolute path of your CGI directory.  If your SCRIPT_FILENAME shows "/www/whatever/whatever/cgi-bin/cpanel.cgi", your Absolute Path variable for your CGI directory would be "/www/whatever/whatever/cgi-bin". On some servers this value is called PATH_TRANSLATED.</FONT><P>
TOP
for $key (keys(%ENV)) {
printf("%-10.20s: <b>$ENV{$key}</B><BR>", $key);
}

print<<BOTTOM;
</FONT></BODY></HTML>
BOTTOM
}  # END ENV SR

sub AddForums {

# check to see how many forums are currently listed
@forums = &OpenForumsFile;
$ForumTotal = @forums;
$ForumCounter = $ForumTotal + 1;

my @CATEGORIES = &OpenFile("$NonCGIPath/categories.file");
my $CategoryDropDown = qq(<SELECT NAME="Category">);
$CategoryDropDown .= qq(<OPTION Value="" SELECTED>Select One:);
$CategoryDropDown .= qq(<OPTION Value="">No Category);
$Count = 0;
foreach $cat(@CATEGORIES) {
$Count++;
($Junk, $CatName, $CatNumber) = split(/\|\|\|/, $cat);
chomp($CatNumber);
$CategoryDropDown .= qq(<OPTION value="$CatNumber">$CatName);
}

if ($Count == 0) {
$CategoryDropDown .= qq(<OPTION value="">No Categories Created Yet);
}
$CategoryDropDown .= "</SELECT>";

$PageTitle = "A D D &nbsp;&nbsp;&nbsp;&nbsp; N E W &nbsp;&nbsp;&nbsp;&nbsp; F O R U M";
&HEADERHTML1;

print<<ForumHTML;
<B>
You can add a new forum by completing the form below.  You currently have $ForumTotal forums.  
<P>
</B>
<P>
<FORM ACTION="$CGIURL/cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<FONT FACE="VERDANA, ARIAL">First Identify Yourself (only administrators can add new forums)</FONT><BR>
<table border=0><TR><TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td><td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td></tr>
<TR><td><B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td><td><INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td></tr></table>
<hr>
<table border=0 width=95%><TR bgcolor="#FFFFFF"><TD>
<B><FONT SIZE="3" FACE="Verdana, Arial" COLOR="#800000">Create New Forum  Below</FONT></B></td>
<TD align=center><FONT SIZE="2" FACE="Verdana, Arial">[<A HREF="$NonCGIURL/forumterms.html" target=_new>forum variable terms</A>]</FONT></td></TR></table>
<P>
<TABLE BORDER=0 cellspacing=0 cellpadding=0 width=95%><TR><td bgcolor="#000000">
<table border=0 width=100%>
<tr bgcolor="#D3CE87">
<td colspan=4 valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Forum $ForumCounter</B></td></tr>
<TR bgcolor="#c7c6ba">
<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Name:</B></FONT></td>
<td colspan=3><INPUT TYPE="TEXT" NAME="Namer" VALUE="Forum Name Here" SIZE=30 MAXLENGTH=100></td></tr>
<tr bgcolor="#d5d2bb"><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Category:</B></FONT></td>
<td colspan=3>$CategoryDropDown</td></tr>

<TR bgcolor="#C7C6BA"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Status:</B></FONT></td>
<td colspan=3><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="Status" VALUE="On" CHECKED> On &nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="Status" VALUE="Off"> Off</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>HTML Allowed?</B></FONT></td><TD colspan=3><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="HTML" VALUE="is"> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="HTML" VALUE="is not" CHECKED> No</B></FONT></td></tr>

<TR bgcolor="#C7C6BA"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Allowed?</B></FONT></td><TD colspan=3><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBB" VALUE="is" CHECKED> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBB" VALUE="is not"> No</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Images Allowed?</B></FONT></td><TD colspan=3><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBBImages" VALUE="ON" CHECKED> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBBImages" VALUE="OFF"> No</B></FONT></td></tr>

<TR bgcolor="#C7C6BA" ><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Moderator Notification? <BR></B><FONT SIZE="1" FACE="Verdana, Arial">If yes, an email will be sent to the moderator every time someone posts a note to the forum (not recommended!)</FONT></FONT></td><TD colspan=3 valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="ModNotify" VALUE="yes"> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="ModNotify" VALUE="no" CHECKED> No</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial" color="#800000"><B>Access Limits</B></font><BR><FONT SIZE="1" FACE="Verdana, Arial">You may make the forum completely private- which means that only admins, moderators and those that you grant permission to view (using the User Permissions area in this control panel) may view and post notes in the forum.  If you set a forum password, you can also grant access to private forums and other restricted access forums to those that know the forum password.
<P>
If you do not need to make the forum completely private, you may still restrict posting permissions in various ways. 
<P>
<BR><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Forum Password:</font> <INPUT TYPE="TEXT" NAME="forumpw" VALUE="" SIZE=12 MAXLENGTH=12>
</FONT></td><TD colspan=3 valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B>
<CENTER>Completely Private - Read/Write</CENTER><P>
<INPUT TYPE="CHECKBOX" NAME="Private" VALUE="private">
Restrict Viewing and Writing of Posts To Admins, Moderators and other authorized<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">*</FONT> users
<P>
If private, you can select maximum privacy, which means that all topics are displayed dynamically, checking user identification before displaying any page, or minimum privacy, which means that topics are stored as HTML (not dynamcially created) for improved server performance, but at a security risk.
<blockquote>
<INPUT TYPE="RADIO" NAME="PrivateMax" VALUE="yes" CHECKED>Maximum Security<BR>
<INPUT TYPE="RADIO" NAME="PrivateMax" VALUE="no">Minimum Security
</blockquote>
<HR>
<BR>
<CENTER>Posting Restrictions (With Viewing of Posts Open to All)</CENTER>
<P>
If forum is not completely private, you can determine which users can post topics and replies within the forum.
<P>
Who Can Post Topics?
<BR>
<SELECT NAME="TopicRestrict">
<option value="restrict">Only admins, moderators and authorized users
<option value="allreg" SELECTED>Any registered users
<option value="all">Any users (including unregistered)
</SELECT>
<P>

Who Can Post Replies?
<BR>
<SELECT NAME="ReplyRestrict">
<option value="restrict">Only admins, moderators and authorized users 
<option value="allreg" SELECTED>Any registered users
<option value="all">Any users (including unregistered)
<option value="none">No one can post replies
</SELECT>

</B></FONT>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">* An authorized user is someone who is not an administrator or moderator who has either been given specific authority to use a private forum or otherwise-restricted forum.  Administrators can give this permission to a user by either specifically assigning the permission to the user in the control panel User Permissions area or by giving the user the Forum Password to gain entrance.  You can set a forum password in the field to the left.</FONT>
</td></tr>

<TR bgcolor="#c7c6ba" ><TD valign=top><FONT SIZE="2" FACE="Verdana, Arial"><B>Forum Description:</B></FONT><BR><FONT SIZE="1" FACE="Verdana, Arial">This is displayed on your the intro page that summarizes all forums when users visit.  Be sure to set Forum Descriptions "on" in the General Variables section, if you want your visitors to see this description.</font></td><td  colspan=3 valign=top><TEXTAREA NAME="Description" ROWS=3 COLS=30 wrap="VIRTUAL"></TEXTAREA></td></tr>


<TR bgcolor="#d5d2bb"><td valign=top><p><FONT SIZE="2" FACE="Verdana, Arial"><b>Custom Header</b></font><br>
<FONT SIZE="1" FACE="Verdana, Arial">You can add your own customized header graphic, ad banner, text, etc. for this forum.  This header will appear at the top of each UBB forum page.  The Header you set in your main Style settings will be used if you keep this field blank.  Thus, only complete this field if you want to replace the default Header.</p></font>
</td><td colspan=3><TEXTAREA NAME="ForumHeader" ROWS=5 COLS=30 wrap="VIRTUAL"></TEXTAREA></td></tr>

<TR bgcolor="#d5d2bb"><td valign=top><p><FONT SIZE="2" FACE="Verdana, Arial"><b>Custom Header</b></font><br>
<FONT SIZE="1" FACE="Verdana, Arial">You can add your own customized header graphic, ad banner, text, etc. for this forum.  This footer will appear at the top of each UBB forum page.  The Footer you set in your main Style settings will be used if you keep this field blank.  Thus, only complete this field if you want to replace the default Footer.</p></font>
</td><td colspan=3><TEXTAREA NAME="ForumFooter" ROWS=5 COLS=30 wrap="VIRTUAL"></TEXTAREA></td></tr>

ForumHTML


print<<MoreForumGuts;
<TR bgcolor="#D3CE87">
<td colspan=4 valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Forum Display Options</B><P>Note: The default values are the values you declare in your overall Styles Settings.  You can change those values for this forum below.  You can also change the default Header and Footer variables for this forum below.  The values you place below will override the general style settings.If you are adding new graphics, be sure to upload them into your UBB NON CGI directory.  Simply place the file name in the graphic field (as in email.gif).</font></td></tr>
MoreForumGuts

&ColorRow("Page Background Color", "Format - #FFFFFF", "BGColor", "#D5D2BB","colspan=2");
&ColorRow("Text Color", "", "TextColor", "#C7C6BA","colspan=2");
&ColorRow("Link Color", "", "LinkColor", "#D5D2BB","colspan=2");
&ColorRow("Active Link Color", "", "ActiveLinkColor", "#C7C6BA","colspan=2");
&ColorRow("Visited Link Color", "", "VisitedLinkColor", "#D5D2BB","colspan=2");
&ColorRow("Table Border Color", "", "TableBorderColor", "#C7C6BA","colspan=2");
&ColorRow("Table Header Strip Text Color", "", "TableStripTextColor", "#D5D2BB","colspan=2");
&ColorRow("Table Header Strip Background Color", "", "TableColorStrip", "#C7C6BA","colspan=2");
&ColorRow("Time Color", "This color is used for the time field on the main forum summary page and the forum pages and for the \"posted by\" line for each post.", "TimeColor", "#D5D2BB","colspan=2");
&ColorRow("First Alternating Table Column Color", "", "AltColumnColor1", "#C7C6BA","colspan=2");
&ColorRow("Second Alternating Table Column Color", "", "AltColumnColor2", "#D5D2BB","colspan=2");
&ColorRow("Category Strip Background Color", "", "CategoryStripColor", "#C7C6BA","colspan=2");
&ColorRow("Category Strip Text Color", "", "CategoryStripTextColor", "#D5D2BB","colspan=2");
&ColorRow("Copyright Text Color", "", "CopyrightTextColor", "#C7C6BA","colspan=2");

print<<ForumGuts;
<tr bgcolor="#d5d2bb">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Font Face (e.g., Verdana)</B></FONT><br><FONT SIZE="1" FACE="Verdana, Arial">We recommend you use a backup font as well.  For example: to use Verdana as your first choice, with Arial as a conditional font for those users that don't have Verdana as a font on their system, you would type "Verdana, Arial")</FONT><br>
</td>
<td colspan=2 valign=top>
<INPUT TYPE="TEXT" NAME="FontFace" VALUE="$FontFace" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Width</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">You may use either exact pixels (recommended: 600) or a percentage (recommended: 90%)</FONT>
</td>
<td colspan=2 valign=top>
<INPUT TYPE="TEXT" NAME="TableWidth" VALUE="$TableWidth" SIZE=5 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#d5d2bb">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Text Size</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">We recommend using size 2... but depending on your font face, you may want to alter this.</FONT>
</td>
<td colspan=2 valign=top>
<INPUT TYPE="TEXT" NAME="TextSize" VALUE="$TextSize" SIZE=1 MAXLENGTH=1>
</td></tr>

<tr bgcolor="#c7c6ba">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><p><B>Page Background Graphic</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">Not recommended to be used, but you can add a background graphic to your pages.  If you do so, you should upload the graphic into your NON CGI directory and place the name of the background graphic in this field.  For example, background.gif.</FONT></p>
</td>
<td colspan=2 valign=top>
<INPUT TYPE="TEXT" NAME="PageBackground" VALUE="$PageBackground" SIZE=30 MAXLENGTH=200>
</td></tr>

<tr bgcolor="#d5d2bb">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Forum Title Graphic:</B></FONT></td>
<td colspan=2 valign=top>
<INPUT TYPE="TEXT" NAME="BBTitle" VALUE="$BBTitle" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post New Topic Graphic:</B></FONT>
</td>
<td colspan=2 valign=top>
<INPUT TYPE="TEXT" NAME="BBTopic" VALUE="$BBTopic" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#d5d2bb">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post Reply Graphic:</B></FONT>
</td>
<td colspan=2 valign=top>
<INPUT TYPE="TEXT" NAME="BBReply" VALUE="$BBReply" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Thread Closed Graphic:</B></FONT>
</td>
<td colspan=2 valign=top>
<INPUT TYPE="TEXT" NAME="ThreadClosed" VALUE="$ThreadClosed" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#d5d2bb">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Profile Graphic:</B></FONT>
</td>
<td valign=top colspan=2>
<INPUT TYPE="TEXT" NAME="profilegif" VALUE="$profilegif" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Graphic:</B></FONT>
</td>
<td valign=top colspan=2>
<INPUT TYPE="TEXT" NAME="mailgif" VALUE="$mailgif" SIZE=25 MAXLENGTH=50>
</td></tr>
</table>
</td></tr></table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="addnewforum">
<INPUT TYPE="HIDDEN" NAME="Number" VALUE="$ForumCounter">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Add New Forum Now">
</FORM>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Powered by: Infopop &copy; 2000<br>Ultimate Bulletin Board $Version</FONT>
</CENTER></font>
</BODY>
</HTML>
ForumGuts
}  ## END AddForums

sub Permissions {
$PageTitle = "U S E R &nbsp;&nbsp;&nbsp;&nbsp; I N F O &nbsp;&nbsp;&nbsp; & &nbsp;&nbsp;&nbsp;&nbsp; P E R M I S S I O N S";
&HEADERHTML1;

print<<permissHTML;
If you are an authorized administrator, you can change the access permissions for any registered BB user.  You may add/remove posting permission or designate registered users as Administrators.  
<P>
<A HREF="$CGIURL/Ultimate.cgi?action=register">If you need to register a new user, click here.</A>


<FORM action=$CGIURL/cpanel4.cgi method=post name=THEFORM2 onsubmit="return Check(this)">
  <CENTER>
    <TABLE border=1 width="85%">
      <TBODY> 
      <TR bgColor=#8ea3b7> 
        <TD colSpan=2><FONT face="Verdana, Arial" size=2><B>Moderate Registration Requests</B></FONT> 
        </TD>
      </TR>
      <TR bgColor=#8ea3b7> 
        <TD><FONT face="Verdana, Arial" size=1><B>Admin UserName: </B></FONT><BR>
          <INPUT maxLength=25 name=UserName size=25>
        </TD>
        <TD><FONT face="Verdana, Arial" size=1><B>Admin Password:</B></FONT><BR>
          <INPUT maxLength=15 name=Password size=15 
      type=password>
        </TD>
      </TR>
      <TR bgColor=#c6cfa0> 
        <TD vAlign=top width=200 colspan="2">&nbsp;</TD>
      </TR>
      <TR bgColor=#c6cfa0> 
        <TD width=200 align="right"><font face="Verdana, Arial" size=1><b>Display</font></b></font> 
        </TD>
        <TD><font size=1><font face="Verdana, Arial size="1"> 
          <input type="radio" name="matchon" value="">
          All registrations 
          <input type="radio" name="matchon" value="^&" checked>
          All Users without posting rights 
          <input type="radio" name="matchon" value="COPPA">
          Under 13</font></TD>
      </TR>
      <TR bgColor=#c6cfa0> 
        <TD width=200 align="right"><b><font size="1" face="Verdana, Arial">Search 
          in the last &nbsp;</font></b></TD>
        <TD>
          <SELECT name=searchback>
            <option value="10" selected>10</option>
            <option value="25">25</option>
            <option value="50">50</option>
            <option value="100">100</option>
            <option value="250">250</option>
            <option value="500">500</option>
            <option value="all">all</option>
          </SELECT>
           <b><font size="1"face="Verdana, Arial">&nbsp;registrations </font></b></TD>
      </TR>
      <TR bgColor=#c6cfa0> 
        <TD vAlign=top width=200>&nbsp;</TD>
        <TD>&nbsp;</TD>
      </TR>
      <TR bgColor=#c6cfa0> 
        <TD>&nbsp; </TD>
        <TD>&nbsp; </TD>
      </TR>
      </TBODY> 
    </TABLE>
    <BR>
    <input type="hidden" name="action" value="modregs">
    <INPUT name=Submit type=submit value="Retrieve Registration Info Now"> 
<INPUT name=Reset type=reset value="Erase Fields"> </center></FORM><CENTER>
  <P><BR>
  </P>
</CENTER></FONT>

<P>


<FORM ACTION="$CGIURL/cpanel4.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="getmatches">
<center>
<table border=1 width="85%">
<tr bgcolor="#8EA3B7"><TD colspan=2><FONT SIZE="2" FACE="Verdana, Arial">
<B>Search for Registered Users:</B></font>
</td></tr>
<tr bgcolor="#8EA3B7"><td><FONT SIZE="1" FACE="Verdana, Arial"><B>Admin UserName: </B></FONT><BR><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Admin Password:</B></FONT><BR><INPUT TYPE="PASSWORD" NAME="Password" SIZE=15 MAXLENGTH=15></td>
</tr>

<TR bgcolor="#C6CFA0" >
<TD colspan=2>&nbsp;</td></tr>

<TR  bgcolor="#C6CFA0">
<TD WIDTH=200 VALIGN=TOP><FONT SIZE="1" FACE="Verdana, Arial"><B>User Name</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="NN" VALUE="" SIZE=25 MAXLENGTH=25></td></tr>
<TR bgColor=#c6cfa0>
        <TD vAlign=top width=200><b><font size="1" FACE="Verdana, Arial">Status</font></b></TD>
        <TD> 
          <select name="Status">
            <option selected value=''>Select</option>
            <option value="Admin">Administrators</option>
            <option value="Mod">Moderators</option>
            <option value="COPPA">Under 13</option>
          </select>
        </TD>
      </TR>
permissHTML



# get Private Forum select List
@forumlist = &OpenForumsFile;

foreach(@forumlist){
	if (/\|private\|/){
	@privateforum = split(/\|/,"$_");
	$privateforumnumber = $privateforum[14];
	$privateforumnumber *= 1;
	$selectlist .= "<option value=\"$privateforumnumber\">$privateforum[1]</option>\n";
	}	
}

if ($selectlist) {
print "<tr bgColor=#c6cfa0><td><b><font size=\"1\" FACE=\"Verdana, Arial\">Access to Private Forums</font></b></td><td>\n";
print "<select name=\"PrivateForum\">\n<OPTION VALUE='' SELECTED>Select\n$selectlist\n </select></td></tr>";
}

print<<permissHTML;
<TR  bgcolor="#C6CFA0">
<TD WIDTH=200 VALIGN=TOP><FONT SIZE="1" FACE="Verdana, Arial"><B>Email Address</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Email" VALUE="" SIZE=30 MAXLENGTH=70></td></tr>
<TR  bgcolor="#C6CFA0">
<TD WIDTH=200 VALIGN=TOP><FONT SIZE="1" FACE="Verdana, Arial"><B>Number of Posts</B></FONT></td>
<td><SELECT NAME="Math">
	<OPTION VALUE="GT"> \>=
	<OPTION VALUE="LT"> \<=
	<OPTION VALUE="EQ"> ==

</SELECT>
<INPUT TYPE="TEXT" NAME="Posts" VALUE="" SIZE=3 MAXLENGTH=5></td></tr>
<TR bgcolor="#C6CFA0">
<TD>
<INPUT TYPE="CHECKBOX" NAME="ViewEntire" VALUE="Yes"><FONT SIZE="1" FACE="Verdana, Arial"><B> &nbsp;View all registered users.</b></font>
</td><td>&nbsp;</td></tr>

</table>
<BR>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Retrieve User Info Now">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Erase Fields">
</form>
<p>
<B><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A>  |  <A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></B>
<br><br><FONT SIZE="1" FACE="Verdana" COLOR="#000000">Powered by: Infopop &copy; 2000<br>Ultimate Bulletin Board $Version
</FONT></CENTER>
</FONT>
</BODY>
</HTML>
permissHTML
} ## END Permissions ##

sub Variables {

$PageTitle = "G E N E R A L &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S";


if ( (-e "$CGIPath/edit.cgi") && (-e "$MembersPath/memberslist.cgi")  && (-d "$NonCGIPath/Forum3") ) {

&HEADERHTML1;
print<<VARHTML;
<p><FONT SIZE="2" FACE="Verdana, Arial">Your UBB paths are already configured. Identify yourself by filling in the UserName and Password fields below!</B></FONT>
<p>
<center>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
VARHTML

&IDTable;

print<<BOTTOM;
<p>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendvarID">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</FORM></center>
<p><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000"><B>Are you Upgrading your UBB?</B> You MUST always reset your system in the following order: GENERAL settings, STYLE settings, FORUM settings and Moderators settings. You do not have to make any changes to those settings, just press the submit button for each and allow all processing to take place. Then UPDATE THREADS and INDEX.</FONT>
</p>
<BR><BR><BR>
<center><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Powered by: Infopop &copy; 2000<br>Ultimate Bulletin Board $Version
</FONT></CENTER></BODY></HTML>
BOTTOM


}

else { # UBB is not set up yet
print<<VARHTML;

<HTML><HEAD><TITLE>Configuration Needed</TITLE></HEAD>
<BODY bgcolor="#FFFFFF" text="#000000" >

<p>&nbsp;</p>
<p align=center><FONT SIZE="2" FACE="Verdana, Arial"><b>Your absolute paths need to be configured before you use the bulletin board.</b></FONT>
<P>

<p align=center><FONT SIZE="2" FACE="Verdana, Arial"><B>Please <A HREF="cpanel2.cgi?action=DoGenVars">click here now.</a></b>
</p>
<BR><BR><BR>
<center><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Ultimate Bulletin Board $Version<br>Powered by Infopop &copy; 2000.
</FONT></CENTER></BODY></HTML>
VARHTML

} # end else
}# end SR


sub SetMods {
$PageTitle = "S E T &nbsp;&nbsp;&nbsp;&nbsp; M O D E R A T O R S";
&HEADERHTML1;

print<<ModTOP;
<CENTER><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Note: only administrators may set moderators.</FONT></CENTER>
<P>
<FONT SIZE="2" FACE="Verdana, Arial">
You may set up to four moderators per forum.  Assign/change your forum moderators below.</FONT>
<FORM ACTION="$CGIURL/cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="mods">
<center>
<table border=0 cellpadding=0 cellspacing=0 width="90%">
<TR><td bgcolor="#000000">
<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>
<tr bgcolor="#8C9A7A">

<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Your User Name</B></FONT><BR><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<td>
<B><FONT SIZE="1" FACE="Verdana, Arial">Your Password</FONT></B><BR><INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</tr>

<TR bgcolor="#B0BB9D">
<TD>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><B>Forum Name</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><B>Moderators:</B></FONT>
</td></tr>
ModTOP

#get current moderator info
$ForumTotal = &GetTotalForums;

for ($x = 1; $x <= $ForumTotal; $x++) {

@thisforum = &GetForumRecord($x);

$ForumName = "$thisforum[1]";
my $Moderator = ("Forum" . "$x" . "Moderator");
$Moderator = $$Moderator;
my ($Mod1, $Mod2, $Mod3, $Mod4) = split(/\|\|\^\|\|/, $Moderator);

print<<MIDMOD;
<TR bgcolor="#C7C6BA">
<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>$ForumName</B></FONT>
</td>
<td>
<INPUT TYPE="HIDDEN" NAME="OldMod$x" VALUE="$Moderator">
<INPUT TYPE="TEXT" NAME="1NewMod$x" VALUE="$Mod1" SIZE=18 MAXLENGTH=25>
<INPUT TYPE="TEXT" NAME="2NewMod$x" VALUE="$Mod2" SIZE=18 MAXLENGTH=25>
<INPUT TYPE="TEXT" NAME="3NewMod$x" VALUE="$Mod3" SIZE=18 MAXLENGTH=25>
<INPUT TYPE="TEXT" NAME="4NewMod$x" VALUE="$Mod4" SIZE=18 MAXLENGTH=25>
</td></tr>
MIDMOD

} ##END FOREACH $line


print<<TRUEBOTTOM;
<tr bgcolor="#B0BB9D">
<TD colspan=3 align=center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Moderator Changes">
</td></tr>
</table>
</td></tr></table>
<P>
</FORM>
<BR>
<FONT SIZE="1" FACE="Verdana, Arial">Powered by: Infopop &copy; 2000<br>Ultimate Bulletin Board $Version</FONT></font></CENTER>
</BODY></HTML>
TRUEBOTTOM

}  ## END SET MODS SR ##


sub Prune {
$PageTitle = "E D I T / D E L E T E &nbsp;&nbsp;&nbsp;&nbsp; M E S S A G E S";
&HEADERHTML1;

print<<PruneHTML;
<B><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000">Note: only moderators and administrators may edit or prune messages.  Moderators may only make changes for their particular forums.  Identify yourself below.</FONT></B>
<FORM ACTION="$CGIURL/edit.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<center>
<table border=0 cellpadding=0 cellspacing=0 width=90%>
<TR><TD bgcolor="#000000">

<table border=0 width=100%>
<tr bgcolor="#8EA3B7"><TD colspan=3><FONT SIZE="2" FACE="Verdana, Arial">
<B>Administrator/Moderator Identification:</B></font>
</td></tr>
<tr bgcolor="#8EA3B7">
<td width=25>&nbsp;</td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><B>User Name: </B></FONT><BR><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Password:</B></FONT><BR><INPUT TYPE="PASSWORD" NAME="Password" SIZE=15 MAXLENGTH=15></td>
</tr>
<TR bgcolor="#C6CFA0">
<TD width=25>
<INPUT TYPE="RADIO" NAME="EditFunction" VALUE="Prune" CHECKED></td>
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Prune By Date</FONT><FONT SIZE="1" FACE="Verdana, Arial"> - a mass-delete function that will delete all messages from a forum or forums based on a time-period cut-off that you select.</B></FONT>
</b></font>
</td></tr>
<TR bgcolor="#C6CFA0">
<TD width=25 valign=top>
<INPUT TYPE="RADIO" NAME="EditFunction" VALUE="PruneUser"></td>
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Prune By User</FONT><FONT SIZE="1" FACE="Verdana, Arial"> - a mass-delete function that will delete all messages posted by a user.
<P>
If you are deleting a <font color="#800000">registered</font> user's posts, you may type all or part of the user's name and we will retreive a list of matching names.  If you are deleting an <font color="#800000">unregistered</font> user's posts, however, you must type the complete name exactly below.
<P>
User Name: &nbsp;&nbsp;&nbsp; <INPUT TYPE="TEXT" NAME="DeleteName" SIZE=20 MAXLENGTH=25>
<BR>
Is the name registered? <INPUT TYPE="RADIO" NAME="DeleteRegName" VALUE="yes"> 
Registered <INPUT TYPE="RADIO" NAME="DeleteRegName" VALUE="no"> Not registered

</B></FONT>
</b></font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td width=25>
<INPUT TYPE="RADIO" NAME="EditFunction" VALUE="Edit">
</td>
<TD colspan=2><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Edit/Delete A Message</FONT><FONT SIZE="1" FACE="Verdana, Arial"> - edit or delete a particular message.  If you edit, a note will appear on the message that it has been altered by an administrator/moderator.</B></FONT>
</td></tr>
</table>
</td></tr></table>
<p>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Choice">
</form>
</center>
</BODY>
PruneHTML
}  ## END Prune SR

sub HEADERHTML1 {
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserName.value = getCookie("UserNameCP");
	document.THEFORM.Password.value = getCookie("PasswordCP");
	  if(document.THEFORM2){
	    document.THEFORM2.UserName.value = getCookie("UserNameCP");
	    document.THEFORM2.Password.value = getCookie("PasswordCP");
	  }
	}  else {
	document.THEFORM.UserName.focus();
}
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR><center>
<FONT SIZE="2" FACE="Verdana, Arial">$PageTitle</FONT>
</center><P><FONT SIZE="1" FACE="Verdana, Arial">
HEADER
} #end HEADERHTML sr

sub CheckStatus {

		if ($Status =~ m/Administrator/) {
			$AdminStatus = "true";
			} else {
			$AdminStatus = "false";
		}
		

		if ($Status =~ m/Moderator/) {
			$ModStatus = "true";
		} else {
			$ModStatus = "false";
		}
		if ($Permission =~ m/Write/) {
			$AdminWrite = "true";
		} else {
			$AdminWrite = "false";
		}

} #end CheckStatus


sub Mail {
$PageTitle = "E M A I L &nbsp;&nbsp;&nbsp;&nbsp; U S E R S";
&HEADERHTML1;

print<<Index;
<FONT SIZE="2" FACE="Verdana, Arial">Note: only administrators may send a mass email to all registered users.  Note that email will not be sent to registered users who elect not to receive it.  One profile option at your registered users' disposal is to not receive such mailings.
<P>
This email will be sent to each user separately (users will not receive a list of all email addresses).
<P>
If you prefer, you may also use your own bulk mail software program and simply generate a list of email addresses for your registered users (which you can then import into your bulk email program).  To do that instead, check the box under the message box below.</FONT>
<P>
<FORM ACTION="$CGIURL/ubbmail.cgi" METHOD="POST" NAME="THEFORM">
<INPUT TYPE="HIDDEN" NAME="start" VALUE="0">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="mailusers">
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td></tr>
<TR>
<td valign=top>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Email Subject:</FONT></B>
</td>
<td><INPUT TYPE="TEXT" NAME="Subject" SIZE=30 MAXLENGTH=90>
</td></tr>
<TR>
<td valign=top>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Email Message:</FONT></B>
</td>
<td><TEXTAREA NAME="Message" ROWS=10 COLS=25>
</TEXTAREA>
</td></tr>

</table>
<HR>
<FONT SIZE="1" FACE="Verdana, Arial"><INPUT TYPE="CHECKBOX" NAME="createlist" value="yes">&nbsp;&nbsp;
<B>Create Email List Instead: If you would rather simply create a list of registered users' email addresses, check this box (and leave the subject and message fields blank above).  You can then import that list into your own bulk email program.</B>
<CENTER><INPUT TYPE="RADIO" NAME="delimit" VALUE="comma">
Comma-delimited list  &nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="delimit" VALUE="line" CHECKED>Line return list</CENTER>
</FONT>
<HR>
<center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Send Email Now!">
</CENTER>

</FORM>
</BODY></HTML>
Index

}  ## END MAIL SR ##

sub Digest {
$PageTitle = "D I G E S T &nbsp;&nbsp;&nbsp;&nbsp; C E N T E R";
&HEADERHTML1;

print<<Index;
<P>
<FONT SIZE="2" FACE="Verdana, Arial">Note: only administrators or moderators may use the Digest Center.
<P>
Digests are summaries of topics posted to a given forum over a certain time period.  These digests will be emailed to a list of subscribers when you so designate.  You cannot have digests sent out automatically at a certain interval.  You must return to this center and select the "Send Digest To Subscribers" option below in order to send a digest.
</FONT>
<P>
<A NAME="currentdigests">Here is a list of your current digests:</A>
<P>
<table border=0 width=100%>
<TR bgcolor="#B0BB9D">
<TD><FONT SIZE="1" FACE="Verdana, Arial">Digest Name</FONT></td>
<TD><FONT SIZE="1" FACE="Verdana, Arial">Forum Number</FONT></td>
<TD><FONT SIZE="1" FACE="Verdana, Arial">Last Digest Sent</FONT></td></tr>
Index

#retrieve current digests...
if (-e "$NonCGIPath/digests/digestsummary.cgi") {
open (DIGESTS, "$NonCGIPath/digests/digestsummary.cgi");
@digestsummary = <DIGESTS>;
close(DIGESTS);

foreach $uno(@digestsummary) {
@thisone = split(/\|/, $uno);
@thisfor = &GetForumRecord($thisone[0]);
my $ForumName = $thisfor[1];
print qq(<tr bgcolor="#C7C6BA"><td><FONT SIZE="1" FACE="Verdana, Arial">$ForumName</font></td><td><FONT SIZE="1" FACE="Verdana, Arial">$thisone[0]</font></td><td><FONT SIZE="1" FACE="Verdana, Arial">$thisone[1]</font></td></tr>);
}

}  else {
	print qq(<tr bgcolor="#C7C6BA"><td align=center colspan=3><FONT SIZE="1" FACE="Verdana, Arial"><B>No Digests Have Been Created.</B></font></td></tr>);
}

print<<Index2;
</table>
<P>
<FORM ACTION="$CGIURL/ubbmail.cgi" METHOD="POST" NAME="THEFORM">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="digeststart">
<center>
<table border=0 width=95% cellpadding=0 cellspacing=0><TR><TD bgcolor="#000000">

<table border=0 width=100%>
<TR bgcolor="#B0BB9D">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR bgcolor="#B0BB9D">
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td></tr>
<TR bgcolor="#C7C6BA">
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">What Do You Want To Do?</FONT></B>
</td>
<td>
<SELECT NAME="DigestOption">
	<OPTION value="1">Create New Forum Digest
	<OPTION value="2">Delete Existing Forum Digest
	<OPTION value="3">Add/Remove Subscribers From Digest
	<OPTION value="4">Send Digest to Subscribers
</SELECT>
</td></tr>

</table>

</td></tr></table>
<P>

<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Request Now">
</form>
<P>
<FONT SIZE="1" FACE="Verdana, Arial">&copy <A HREF="http://www.infopop.com">Infopop Corporation.</a>), 2000.</FONT>
</CENTER>

</BODY></HTML>
Index2

}  ## END DIGEST SR ##


sub QueryForID {
print<<ForumLoginHTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserName.value = getCookie("UserNameCP");
document.THEFORM.Password.value = getCookie("PasswordCP");
	}  else {
	document.THEFORM.UserName.focus();
}
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR><center>
<FONT SIZE="2" FACE="Verdana, Arial">$PageTitle</FONT>
</center><P><FONT SIZE="1" FACE="Verdana, Arial">
<center>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">You must be an administrator to change forum settings.</FONT>
<P><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000">
$PageIntro</font>
<P>
<FORM ACTION="$CGIURL/cpanel.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
ForumLoginHTML

&IDTable;

print<<ENDIT;
<P></font>
$HiddenFields
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial">Copyright, Infopop Corporation, Inc.), 1998-2000.
</FONT>
</CENTER></BODY></HTML>
ENDIT
}


sub Misc {
$PageTitle = "M I S C E L L A N E O U S &nbsp;&nbsp;&nbsp;&nbsp; O P T I O N S<BR>D E B U G G I N G &nbsp;&nbsp;&nbsp;&nbsp; O P T I O N S";
&HEADERHTML1;

print<<ModTOP;
<CENTER><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Note: only administrators may perform the following tasks.   Note that you should only perform the following tasks if you are experiencing problems.<BR>  </FONT></CENTER>
<P>
<FORM ACTION="$CGIURL/cpanel4.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="misc">
<center>
<table border=0 cellpadding=0 cellspacing=0 width="90%">
<TR><td bgcolor="#000000">
<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>
<tr bgcolor="#8C9A7A">

<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Your User Name</B></FONT><BR><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<td>
<B><FONT SIZE="1" FACE="Verdana, Arial">Your Password</FONT></B><BR><INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</tr>

<TR bgcolor="#B0BB9D">
<TD colspan=2 align=center>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">
<SELECT NAME="Choice">
<OPTION value="0">Select One of the Following:
<OPTION value="0">-----------------------------------
	<OPTION value="1">Remove Dead HTML files
	<OPTION value="2">Rebuild Member files
</SELECT>
</FONT>
</td></tr>
ModTOP

print<<TRUEBOTTOM;
<tr bgcolor="#B0BB9D">
<TD colspan=3 align=center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Selection">
</td></tr>
</table>
</td></tr></table>
<P>
</FORM>
<BR>
<FONT SIZE="1" FACE="Verdana, Arial">Powered by: Infopop &copy; 2000<br>Ultimate Bulletin Board $Version</FONT></font></CENTER>
</BODY></HTML>
TRUEBOTTOM

}  ## END MISC SR ##


exit(0); # comply with SafePerl