#!/usr/bin/perl
# Early, crippled, incomplete viewnews.cgi.

# Name of style to use.
$VNStyle = 'Default News Style';

# Name of template to use
$VNTMPL = 'viewnews.tmpl';

# MICROSOFT IIS COMPATIBILITY
# Set the following variable to one of the following:
# $IIS = 0; # The default - auto-detect. Usually works fine.
# $IIS = 1; # You're on IIS -- do basic IIS compatibility.
# $IIS = 2; # You're on IIS, and you still had problems when $IIS was 1.
# $IIS = -1; # You're not on IIS - disable even the auto-detection.

$IIS = 0;

# END OF SETTINGS (unless you encounter problems - then fill out the next section)

# EXTRA SERVER INFORMATION
# Coranto tries to determine its path and URL automatically. This works in 90%
# of cases, but some servers aren't cooperative and don't allow this information
# to be found automatically. Though it won't hurt, there's no need to fill this out
# unless you encounter problems.
#
# If you encounter problems (particularly with incorrect URLs, or fatal error messages
# about files not being found), fill in the two variables below.

$abspath = '';
# Set the above to the absolute path to Coranto's directory, without
# a trailing slash. Example:
# $abspath = '/absolute/path/to/coranto';

#######
# START (Unless you know Perl, don't change anything after this point.)
#######

eval {
	main();
};
if ($@) {
	CRdie("Untrapped Error: $@");
}

sub main {
	# Try and be compatible with Microsoft IIS.
	if ($IIS >= 0) {
		if ($IIS == 0) {
			if ($ENV{'SERVER_SOFTWARE'} =~ /IIS/) {
				$IIS = 1; 
			}
		}
		if (($IIS) && ($0 =~ m!(.*)(\\|\/)!)) {
			chdir($1);
		}
		if ($IIS == 2) {
			print "HTTP/1.0 200 OK\n";
		}
	}

	# If extra server information was specified, use it.
	push(@INC, $abspath) if $abspath;	
	
	NeedFile('cruser.pl');
	NeedFile('crlib.pl');
	print header();
	NeedCFG();
	
	$CurrentTime = time;
	# Put the script's URL into $scripturl.
	# Don't if it was already set as a server problem workaround.
	unless ($scripturl) {
		$scripturl = GetScriptURL();
	}
	# Get form input
	ReadForm();
	
	# Read in settings
	
	ReadConfigInfo();
	$CConfig{'neverSave'} = 1;
	
	ReadProfileInfo();

	# Initialize the date-retrieval subroutines.
	InitGTD($CConfig{'DateFormat'}, 'GetTheDate');
	InitGTD($CConfig{'InternalDateFormat'}, 'GetTheDate_Internal');

	# compatibility
	if ($ENV{'QUERY_STRING'} =~ /newsid(\w+)$/) {
		$in{'id'} = $1;
	}
	
	if ($in{'id'}) {
		SingleItem($in{'id'});
	}
	else {
		CRdie('No parameters given.');
	}
}

sub SingleItem {
	my $id = shift;
	
	my $ndfh = CRopen("$CConfig{'htmlfile_path'}/newsdat.txt");
	$newsnum = 1;
	NCLOOP: while (<$ndfh>) {
		SplitDataFile($_);
		next NCLOOP unless $newsid eq $id;
		$FileName = 'viewnews';
		$ProfileName = 'viewnews';
		$Date = GetTheDate($newstime);
		my $style = $VNStyle;
		if ($style =~ /Default News Style$/i) {
			$style = 'Default';
		}
		elsif ($style =~ /Default Headline Style$/i) {
			$style = 'DefaultHeadline';
		}
		else {
			$style =~ s/ /_/g;
			$style = lc($style);
			$style =~ s/[^a-z0-9_]//g;
		}
		my $newshtml = &{"NewsStyle_$style"}();
		GenPage(\$newshtml, $Subject);
		close($ndfh);
		exit;
	}
	CRdie('Could not find that news item.');
}



# Gets our full URL. Needed for error messages.
sub GetScriptURL {
	my $url = 'http://' . ($ENV{'HTTP_HOST'} ? $ENV{'HTTP_HOST'} : $ENV{'SERVER_NAME'}) .  
	($ENV{'SERVER_PORT'} != 80 && $ENV{'HTTP_HOST'} !~ /:/ ? ":$ENV{'SERVER_PORT'}" : '') .
	$ENV{'SCRIPT_NAME'};
	return $url;
	
}

sub CRdie {
	print "Content-type: text/html\n\n" unless $HeaderPrinted;
	print "<html><body><h1>Error</h1>$_[0]</body></html>";
	exit;
}


sub GenPage {
	my ($content, $title) = @_;
	print ProcessTMPL("$CConfig{'admin_path'}/$VNTMPL", $content, $title, 0, 1);
}

sub AUTOLOAD {
	my $sub = $AUTOLOAD;
	# Get rid of package information.
	$sub =~ s/.+\:\://;
	if ($Subs{$sub}) {
		# Compile it.
		eval $Subs{$sub};
		if ($@) { die ("Subroutine $AUTOLOAD encountered a compile error during autoload: $@"); }
	}
	else {
		die("Subroutine $AUTOLOAD was called, but does not exist. (It isn't already loaded, and it isn't in the cache.)");
	}
	# Delete the source from memory, to save memory.
	delete $Subs{$sub};
	# Now switch to the just-compiled sub.
	goto &$AUTOLOAD;
}

sub CRopen ($;$$) {
	my $filename = shift;
	# Creates what is basically an anonymous filehandle.
	my $filehandle = do { local *FH };
	# Security checks.
	$filename = SecurePath($filename);
	open($filehandle, $filename) || CRdie("Could not open file $filename. $@");
	return $filehandle;
}

my %LoadedFiles;	
sub NeedFile {
	my $file = shift;
	unless ($LoadedFiles{$file}) {
		eval { require $file; };
		if ($@) {
			CRdie("Could not load file $file.");
		}
		$LoadedFiles{$file} = 1;
	}
}