#!/usr/bin/perl

# $Id: track.pl,v 1.2 1998/12/02 18:49:09 meltzek Exp meltzek $

# $Log: track.pl,v $
# Revision 1.2  1998/12/02 18:49:09  meltzek
# Removed reference to cgi-lib.pl
#
# Revision 1.1  1998/12/02 18:48:10  meltzek
# Added to RCS
#

##########################################################################
# Written by Kevin Meltzer kmeltz@cris.com | www.cris.com/~kmeltz        #
# Feel free to modify, hack, etc.. this script. But, please do not make  #
# any profit from it without letting me know :) And, please leave my name#
# and comments (credit where credit is due).                             #
#                                                                        #
# This script is good for keeping track of where people are going on your#
# site, or from your site. Also is handy for tracking the amount of times#
# your software, scripts, graphics, etc.. are downloaded from your site. #
#                                                                        #
# To set up:                                                             #
# 1. chmod this file to 755                                              #
# 2. set the $base variable. The $base is where the script looks to add  #
#    the page to be viewed. It should look like:                         #
#    $base = "http://your.site.com/";                                    #
# 3. set the $log variable. This is where you have your log file. The    #
#    file should be chmod to 777                                         #
# 4. set the $log_pswd variable. This is the password to use to view your#
#    log file. Of course, if you want everyone to see it, you would just #
#    make the link on a public page.                                     #
# 5. Make your links! This script can be called in 3 ways.               #
#    1. To call a page on your site it would look like this..            #
#        <a href="track.pl?p=some_page.htm">foo</a>                      #
#    2. To call an Outside Site, it would be..                           #
#        <a href="track.pl?os=www.somesite.com">bar</a>                  #
#       DO NOT add in the http:// since the script adds it for you.      #
#    3. To see the log file...                                           #
#        <a href="track.pl?log=yourpassword">blah</a>                    #
# 6. Next.. email me (kmeltz@cris.com) to let me know where this is being#
#    used :)                                                             #
#                                                                        #
# *Changes since above was written                                       #
# 5/28/97 - Added the ability to have log output as a graph. 2 new       #
# variables to set.                                                      #
#       $graph is set to 1 to show graph, 0 not to show                  #
#       $nums is set to 1 to show regular table, 0 not to show           #
# You can show either, or both. There are 8 (small) graphics for the     #
# graph included with this package. They incriment by 25 up to 100, and  #
# 50 up to 250, and red is over 250.                                     #
##########################################################################

$base = "http://www.yoursite.com";       # Your site
$log = 'track.log';                      # Path to the log
$log_pswd = 'foobar';                    # password to view log
$graph = 0;                              # To show graph or not (1 = yes 0 = no)
$nums = 1;                               # To show number table or not (1 = yes 0 = no)

$autoadd=1;

&ParseForm(*data);
#&ReadParse(*data);
$addnew=0;

open(DATA,"$log") || print "No log $!";
   @lines = <DATA>;
close(DATA);

##################### Look at the Log ######################

if ($data{'log'} eq $log_pswd) 
  {
	print "Content-type: text/html\n\n";
	print "<html>\n";
        print "<title>Log Viewer</title>\n";
        print "<body bgcolor=\"#FFFFFF\">\n";
        print "<!-- track.pl and logger/viewer by Kevin Meltzer kmeltz\@cris.com & www.cris.com/\~kmeltz -->\n";
        print "<center>\n";
        print "<h1>Log Viewer</h1>\n";

        ###################
        if ($nums eq '1') {
                print "<table border=2>\n";

                foreach $line (@lines) {
                        ($url, $count) = split(/\|/,$line);
                        print "<tr><td>$url</td><td>$count</td></tr>\n";
  	  }
       
	print "</table>\n";
	print "<hr>\n";
        }
        ###################
        if ($graph eq '1') {
                print "<table border=2>\n";
                foreach $foo (@lines) {
                        ($url, $count) = split(/\|/,$foo);
                        if ($count <= 25) {
                        $img = 'blue.gif';
                        }
                        elsif ($count >= 26 && $count <= 50 ) {
                        $img = 'green.gif';
                        }
                        elsif ($count >= 51 && $count <= 75) {
                        $img = 'pink.gif';
                        }
                        elsif ($count >= 76 && $count <= 100) {
                        $img = 'purple.gif';
                        }
                        elsif ($count >= 101 && $count <= 150) {
                        $img = 'aqua.gif';
                        }
                        elsif ($count >= 151 && $count <= 200) {
                        $img = 'yellow.gif';
                        }
                        elsif ($count >= 201 && $count <= 250) {
                        $img = 'dgreen.gif';
                        }
                        elsif ($count >= 251) {
                        $img = 'red.gif';
                        }
                        print "<tr><td>$url</td><td><img src=\"$img\" width=$count height=10>$count</td></tr>\n";
                }
            print "</table>\n";
        }
        ###################


        print "</center>\n";
	print "</body>\n";
	print "</html>\n";
  }  

	
##################### Up the count ######################

else
  {
        open(DATA,">$log");
	  foreach $line (@lines)
	  {
                ($url, $count) = split(/\|/,$line);
                if ($data{'p'} eq $url) 
		  {
                        $count++;
                        print DATA ("$url|$count\n");
		 	$addnew=1;
	  	  }
                elsif ($data{'os'} eq $url)
                  {
                        $count++;
                        print DATA ("$url|$count\n");
                        $addnew=1;
                  }

              else
	  	  {
			print DATA $line;
	  	  }
	  }

##################### Add new entry to log ######################

        if ($addnew == 0 && $autoadd == 1)  {
         if ($data{'p'} ne '') {
                print DATA ("$data{'p'}|1\n");
         }
         if ($data{'os'} ne '') {
                print DATA ("$data{'os'}|1\n");
         }
	  }


	close(DATA);



##################### Redirect to new page ######################
       
        if ($data{'os'} ne '') {
        print "Location: http://$data{'os'}\n\n";
        }

        print "Location: $base$data{'p'}\n\n";

  } #Closes Else for View Log

	exit;


##################### ParseForm subroutine ######################
sub ParseForm
{
local (*qs) = @_ if @_;

if ($ENV{'REQUEST_METHOD'} eq "GET")
        {
        $qs = $ENV{'QUERY_STRING'};
        }
elsif ($ENV{'REQUEST_METHOD'} eq "POST")
        {
        read(STDIN,$qs,$ENV{'CONTENT_LENGTH'});
        }

@qs = split(/&/,$qs);

foreach $i (0 .. $#qs)
        {
        $qs[$i] =~ s/\+/ /g;
        $qs[$i] =~ s/%(..)/pack("c",hex($1))/ge;

        ($name,$value) = split(/=/,$qs[$i],2);

        if($qs{$name} ne "")
                {
                $qs{$name} = "$qs{$name}:$value";
                }
        else
                {
                $qs{$name} = $value;
                }
        }

return 1;
}
