/*  XMMS plugin for dymanic noise filtering
 *  Kills the background tape hiss from old recordings.
 *  Copyright (C) 2001 by Rowland
 *  Structure cribbed from echo_plugin by Carl van Schaik,
 *  but the functional code is all mine.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "xmms/i18n.h"
#include <gtk/gtk.h>
#include "libxmms/util.h"
#include "libxmms/configfile.h"
#include "filter.h"

static const char filter_about_text[] =
N_("Dynamic Noise Filter Plugin " PVERSION "\n"
   "Kills the background tape hiss from old recordings.\n"
   "By Rowland 2001\n\n"
   );

static GtkWidget *conf_dialog = NULL;
static GtkObject  *filter_threshold_adj;

#ifdef LP_MODE
static int lp_mode= 0;
#endif

#ifdef SOFTSQUELCH
static int softsquelch= 0;
#endif

void filter_about(void)
{
  static GtkWidget *filter_about_dialog = NULL;
  
  if (filter_about_dialog != NULL)
    return;
  
  filter_about_dialog = xmms_show_message(_("About Filter Plugin"),
					_(filter_about_text), _("Ok"),
					FALSE, NULL, NULL);
  gtk_signal_connect(GTK_OBJECT(filter_about_dialog), "destroy",
		     GTK_SIGNAL_FUNC(gtk_widget_destroyed),
		     &filter_about_dialog);
}

static void apply_changes(void)
{
  ConfigFile *cfg;

  filter_threshold = GTK_ADJUSTMENT(filter_threshold_adj)->value;
  filter_set_threshold(filter_threshold); /* filter.c */
  
  cfg = xmms_cfg_open_default_file();
  xmms_cfg_write_int(cfg, "filter_plugin", "threshold", filter_threshold);
  xmms_cfg_write_default_file(cfg);
  xmms_cfg_free(cfg);
}

static void conf_ok_cb(GtkButton * button, gpointer data)
{
  apply_changes();
  gtk_widget_destroy(GTK_WIDGET(conf_dialog));
}

static void conf_cancel_cb(GtkButton * button, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(conf_dialog));
}

#ifdef LP_MODE
static void conf_apply_lpmode(GtkToggleButton * lpmode, gpointer data)
{
  lp_mode= gtk_toggle_button_get_active(lpmode);
  filter_lp_mode= lp_mode;
}
#endif

#ifdef SOFTSQUELCH
static void conf_apply_softsquelch(GtkToggleButton * tb, gpointer data)
{
  softsquelch= gtk_toggle_button_get_active(tb);
  filter_softsquelch= softsquelch;
}
#endif

static void conf_apply_cb(GtkButton * button, gpointer data)  {
#ifdef LP_MODE
  filter_lp_mode= lp_mode;
#endif
  apply_changes();
}

void filter_configure(void)  {
  GtkWidget *button, *table, *label, *hscale, *bbox;
#ifdef LP_MODE
  GtkWidget *lpmode;
#endif
  
#ifdef SOFTSQUELCH
  GtkWidget *softsquelch;
#endif
  if (conf_dialog != NULL)
    return;
  
  conf_dialog = gtk_dialog_new();
  gtk_signal_connect(GTK_OBJECT(conf_dialog), "destroy",
		     GTK_SIGNAL_FUNC(gtk_widget_destroyed), &conf_dialog);
  gtk_window_set_title(GTK_WINDOW(conf_dialog), _("Configure Filter"));
  filter_threshold_adj = gtk_adjustment_new(filter_threshold,
					    0, 25 + 10, 2, 10, 10);
  
  table = gtk_table_new(2, 3, FALSE);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(conf_dialog)->vbox), table,
		     TRUE, TRUE, 5);
  gtk_widget_show(table);
  

  label = gtk_label_new(_("Threshold: "));
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(label);
  
  
  hscale = gtk_hscale_new(GTK_ADJUSTMENT(filter_threshold_adj));
  gtk_widget_set_usize(hscale, 400, 35);
  gtk_scale_set_digits(GTK_SCALE(hscale), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), hscale, 1, 2, 2, 3);
  gtk_widget_show(hscale);
  
#ifdef LP_MODE
  lpmode = gtk_toggle_button_new_with_label("LP mode");
#endif
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
#ifdef LP_MODE
  gtk_table_attach(GTK_TABLE(table), lpmode, 3, 4, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(lpmode);
  gtk_signal_connect(GTK_OBJECT(lpmode), "clicked",
		     GTK_SIGNAL_FUNC(conf_apply_lpmode), NULL);
#endif  
  
#ifdef SOFTSQUELCH
  softsquelch = gtk_toggle_button_new_with_label("Softsquelch");
#endif
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
#ifdef SOFTSQUELCH
  gtk_table_attach(GTK_TABLE(table), softsquelch, 3, 4, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(softsquelch);
  gtk_signal_connect(GTK_OBJECT(softsquelch), "clicked",
		     GTK_SIGNAL_FUNC(conf_apply_softsquelch), NULL);
#endif  
  
  bbox = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
  gtk_box_pack_start(GTK_BOX((GTK_DIALOG(conf_dialog)->action_area)),
		     bbox, TRUE, TRUE, 0);
  
  
  button = gtk_button_new_with_label(_("Ok"));
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(bbox), button, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(conf_ok_cb), NULL);
  gtk_widget_grab_default(button);
  gtk_widget_show(button);
  
  button = gtk_button_new_with_label(_("Cancel"));
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(bbox), button, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(conf_cancel_cb), NULL);
  gtk_widget_show(button);
  
  button = gtk_button_new_with_label(_("Apply"));
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(bbox), button, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(conf_apply_cb), NULL);
  gtk_widget_show(button);
  gtk_widget_show(bbox);
  
  gtk_widget_show(conf_dialog);
}
