@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"

	
	
@macro exg RegisterA, RegisterB

	eor 	RegisterA, RegisterA, RegisterB
	eor 	RegisterB, RegisterB, RegisterA
	eor 	RegisterA, RegisterA, RegisterB

	@endm	

@macro exgne RegisterA, RegisterB

	eorne 	RegisterA, RegisterA, RegisterB
	eorne 	RegisterB, RegisterB, RegisterA
	eorne 	RegisterA, RegisterA, RegisterB

	@endm		

@macro exgle RegisterA, RegisterB

	eorle 	RegisterA, RegisterA, RegisterB
	eorle 	RegisterB, RegisterB, RegisterA
	eorle 	RegisterA, RegisterA, RegisterB

	@endm		
	
@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"vector test "		;spiel name (12 byte)
	@dcb	"vect"			;game code
	@dcb	"vt"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$03		;mode 3 bg 2	
	strh 	r1,[r6]			;store
			

	ldr	pc,[nochmaladr]
	
		
;*********************** Unterprogramme (extern) *******************

	@include	simple.s 
			
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Variablenadressen                                    **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************	
		      
mystackadr		@dcd	mystack	
nochmaladr		@dcd	nochmal

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

 
			@include	sin.s
		
endofromcode		
	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
		
	
sintabadr	@dcd	sintab

nochmal

	;****************************************************************
	;*los gehts
	;****************************************************************

	bl	generateDiffTab

loop	

	;****	rotate points	

	ldr	r0,[pointsadr]		
	ldr	r1,[pointscnt]		
	ldr	r2,[points2adr]		
	ldr	r10,[winkel_x]
	ldr	r11,[winkel_y]
	ldr	r12,[winkel_z]
	
	bl	rotatePoints

	;****   berechne Polygontiefen
	
	ldr	r10,[polycnt]
	ldr	r11,[points2adr]
	ldr	r12,[polysadr]
	
	bl	calcDepth

	;****   sortiere Polygontiefen
	
	ldr	r0,[polysadr]		;polygone
	ldr	r2,[polycnt]		
	
	mov	r1,#0			;start = 0
	sub	r2,r2,#1		;ende  = anzahl-1
	
	ldr	r10,[getcontadr]	;get[x]
	ldr	r11,[swapcontadr]	;swap[x]
	bl	qsort_back
	
	;**** 	zeichne Polygone

	ldr	r6,[polyzoom]
	ldr	r10,[polycnt]
	ldr	r11,[points2adr]
	ldr	r12,[polysadr]
	
	bl	drawPolyFlatMode3

	;****	ndere x,y,z winkel

	ldr	r10,[winkel_x]
	ldr	r11,[winkel_y]
	ldr	r12,[winkel_z]

	add	r10,r10,#8
	add	r11,r11,#8
	add	r12,r12,#8
	
	str	r10,[winkel_x]
	str	r11,[winkel_y]
	str	r12,[winkel_z]
 
	;****	kopiere auf Bildschirm,....

	;mov	r2,#160
	;bl	waiti
	bl	copyScreen

	ldr	r0,[polyzoom]
	
	mov	r10,#0x04000000
	orr	r10,r10,#$130
	ldrh	r11,[r10]	;alte taste	
	
	ands	r12,r11,#%1		;taste a
	addeq	r0,r0,#4		
	
	ands	r12,r11,#%10		;taste b
	subeq	r0,r0,#4			

	str	r0,[polyzoom]	

	b	loop
	
;*******************************************************************
;*
;* copyScreen	(Puffer ins Bild kopieren und Puffer initialisieren)
;*
;*******************************************************************

copyScreen

	; to vram

	ldr	r0,[gfxbufferadr]	
	mov	r1,#$4000000
	add	r1,r1,#$d4
	mov	r2,#$6000000		
	mov	r3,#$8400<<16
	orr	r3,r3,#240*160/2
	stmia	r1,{r0,r2,r3}		;dma 0 start
	
	; copy pic in buffer

	ldr	r0,[gfxbgradr]	
	mov	r1,#$4000000
	add	r1,r1,#$d4
	ldr	r2,[gfxbufferadr]		
	mov	r3,#$8400<<16
	orr	r3,r3,#240*160/2
	stmia	r1,{r0,r2,r3}		;dma 0 start

	mov	pc,lr	
	
;*******************************************************************
;*
;* waiti	(warte auf Zeile r2)
;*
;******************************************************************* 

waiti
	stmfd 	sp!,{r0,r1}

	mov	r1,#$4000000
        
waitvi	ldrh	r0,[r1,6]
	cmp	r0,r2
	bne	waitvi	 

	ldmfd	sp!,{r0,r1}
	move	pc,lr

;*******************************************************************
;*
;* includes
;*
;******************************************************************* 	

	@include	3d.s			;Punkt/Poly Funktionen
	@include	qsort.s			;qsort
	@include	polyDraw.s		;Zeichenfunktionen

;**************************** IRAM DATA ****************************

startofeiramdata
		
;**********************************

winkel_x	@dcd	0
winkel_y	@dcd	0
winkel_z	@dcd	0
polyzoom	@dcd	$280
	

gfxbufferadr	@dcd	gfxbuffera
gfxbgradr	@dcd	gfxbgr


@define	POLY_CNT	180
@define POINT_CNT	92

pointscnt	@dcd	POINT_CNT
pointsadr	@dcd	points
points2adr	@dcd	points2

polysadr	@dcd	polys
polycnt		@dcd	POLY_CNT

;**********************************		
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;


;****	Ball

		@include	ball.s

endofeiramdata
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

gfxbgr		@incbin		background.gfx
		
              
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000
		@dcb	"HALLO"
		@dup	dcd	4096,0
mystack		@DCD	0;	16k Byte Stack + (4Byte sec)

pfb_start	@dup	dcb	160,0
pfb_stop	@dup	dcb	160,0

pfb_y1		@dcw	0
pfb_y2		@dcw	0

diff_tab_r3	@dup	dcw	512,0
gfxbuffera	@dup	dcb	240*160*2,0

points2		@dup	dcd	(3*POINT_CNT),0	;polygone punkte	

		@endarea
endofewramcode




