pfb_startadr	@DCD	pfb_start
pfb_stopadr	@DCD	pfb_stop
	
pfb_y1adr	@dcd	pfb_y1
pfb_y2adr	@dcd	pfb_y2

polyadr		@dcd	poly	
poly		@dcw	0,0
		@dcw	0,0
		@dcw	0,0	

;***********************************************************
;*
;* drawPoly (wenn ein punkt aus Bild dann wird Poly nicht gezeichnet)
;*
;***********************************************************

drawPoly

	stmfd	sp!,{r0-r12,lr}

	ldr	r5,[polyadr]	
	
	ldrh	r0,[r5,0]
	ldrh	r1,[r5,2]
	ldrh	r2,[r5,4]
	ldrh	r3,[r5,6]
	
	cmp	r0,#240
	cmplt	r2,#240
	cmplt	r1,#160
	cmplt	r3,#160
	bge	drawPolyNot	
	
	bl	drawPolyLine
	
	ldrh	r0,[r5,4]
	ldrh	r1,[r5,6]
	ldrh	r2,[r5,8]
	ldrh	r3,[r5,10]
	
	cmp	r2,#240
	cmplt	r3,#160
	bge	drawPolyNot
	
	bl	drawPolyLine
	
	ldrh	r0,[r5,0]
	ldrh	r1,[r5,2]
	ldrh	r2,[r5,8]
	ldrh	r3,[r5,10]
	
	cmp	r2,#240
	cmplt	r3,#160
	bge	drawPolyNot
	
	bl	drawPolyLine
	
drawPolyNot
	
	ldmfd	sp!,{r0-r12,pc}

;***********************************************************
;*
;* fill polygon
;*
;* r7 = color 15bit
;*
;***********************************************************


fillPoly

	stmfd	sp!,{r0-r6,lr}

	ldr	r0,[pfb_startadr]
	ldr	r1,[pfb_stopadr]
	
	;**** flle polygon
	
	ldr	r6,[pfb_y1adr]
	ldr	r5,[pfb_y2adr]
		
	ldrh	r2,[r6]			;starty

	add	r0,r0,r2		;set start array offset
	add	r1,r1,r2		;set stop array offset
	
	ldrh	r6,[r5]
	mov	r6,#160
	
dlbu
	ldrb	r3,[r0],1
	ldrb	r4,[r1],1
	
	cmp	r3,#$ff
	beq	nov
	cmp	r4,#$ff
	moveq	r4,r3
	bl	drawHLine
	
nov
	cmp	r2,r6
	add	r2,r2,#1
	bne	dlbu		

	ldmfd	sp!,{r0-r6,pc}


;***********************************************************
;*	
;* init poly buffers (fill with 255)
;*
;***********************************************************

clearPolyBuffer
	
	stmfd	sp!,{r0-r6}
	
	;**** y Limits
	
	mov	r2,#60
	
	ldr	r0,[pfb_y1adr]
	ldr	r1,[pfb_y2adr]
	
	strh	r2,[r0],2
	strh	r2,[r1],2
	
	;**** x Arrays
	
	ldr	r0,[pfb_startadr]
	ldr	r1,[pfb_stopadr]
	
	mvn	r3,#$0
	mvn	r4,#$0
	mvn	r5,#$0
	mvn	r6,#$0
	
	mov	r2,#160/(4*4)
clbu
	stmia	r0!,{r3,r4,r5,r6}
	stmia	r1!,{r3,r4,r5,r6}

	subs	r2,r2,#1
	bne	clbu	
	
	ldmfd	sp!,{r0-r6}
	mov	pc,lr


;***********************************************************
;*	
;* draw HLine
;*
;* r2 		= y
;* r3 - r4	= x1 - x2
;*
;* r7 		= color
;*
;***********************************************************


drawHLine
	stmfd	sp!,{r3-r6,lr}	

	cmp	r4,r3		;x1 <= x1	
	exgle	r3,r4		;swap
	beq	endHLine	;0 len	
	
	ldr	r6,[gfxbufferadr]
	add	r6,r6,r3 lsl 1		;+x*2
	add	r6,r6,r2 lsl 9		;+y*256*2
	sub	r6,r6,r2 lsl 5		;-y*16*2
	
	sub	r3,r4,r3
	
	cmp	r3,#12
	bhi	fastHLine
	
dHPix
	strh	r7,[r6],2
	subs	r3,r3,#1
	bne	dhPix
		

endHLine
	ldmfd	sp!,{r3-r6,pc}
	
;r3 = lengt
;r6 = pos
	
fastHLine

	stmfd	sp!,{r7}		;store for dma and save color
	mov	r5,sp
	
	mov	r4,#$4000000
	add	r4,r4,#$d4
	
	orr	r7,r3,#$8100<<16
	stmia	r4,{r5,r6,r7}		;dma 0 start

	ldmfd	sp!,{r7}		;restore color

	ldmfd	sp!,{r3-r6,pc}

		

;***********************************************************
;*	
;* zeichne (errechne) polyline
;*
;* r0 = x1 , r1 = y1
;* r2 = x2 , r3 = y2
;*
;***********************************************************

drawPolyLine

	stmfd	sp!,{r0-r11,lr}
	
	ldr	r8,[pfb_y1adr]
	ldr	r9,[pfb_y2adr]
	
	cmp	r1,r3		;y1 == y2 
	beq	stopfor
	
	cmp	r1,r3
	ble	calcm
	
	exg	r1,r3
	exg	r0,r2
	
calcm
		
	;setze Grenzen fr min Y und max Y

	ldrh	r4,[r8]
	cmp	r1,r4
	strlth	r1,[r8]
	
	ldrh	r4,[r9]
	cmp	r3,r4
	strgth	r3,[r9]

	;r4 x, r5 y ,  r6 m

	mov	r4,r0 lsl 8	;x = x1 << 8
	
	mov	r8,r1		;r8 = y1 (save wegen div)
	mov	r9,r3		;r9 = y2 (save wegen div)
	
	sub	r0,r2,r0	;tx = x2 - x1		
	sub	r1,r3,r1	;ty = y2 - y1

	mov	r0,r0 lsl 8	;tx << 8

	swi	#$60000		;m (r0) = tx/ty
	
	add	r4,r4,r0	;x = x + m

	ldr	r10,[pfb_startadr]	
	ldr	r11,[pfb_stopadr]

	add	r5,r8,#1	;y = y1	+ 1
forpoly	cmp	r5,r9		;y > y2 stop
	bhi	stopfor
	
	;**** trage in polyliste ein
	
	mov	r7,r4 lsr 8		;x >> 8
	
	ldrb	r3,[r10,r5]		;
	cmp	r3,#255			;if startx[x] == 255
	streqb	r7,[r10,r5]		;startx[x]=y
	strneb	r7,[r11,r5]		;else endx[x]=y


	;mov	r3,#$6000000
	;add	r3,r3,r7 lsl 1		;+x
	;add	r3,r3,r5 lsl 9		;+y*256
	;sub	r3,r3,r5 lsl 5		;-y*16
	;mov	r8,#$1f<<5
	;strh	r8,[r3]


	add	r4,r4,r0	;x = x + m	
	add	r5,r5,#1	;y++
	b	forpoly
	
stopfor	
	
	ldmfd	sp!,{r0-r11,pc}
	
