getcontadr	@dcd	getcont		
swapcontadr	@dcd	swapcont
diff_tab_r3adr	@dcd	diff_tab_r3

;****************************************************************
;*
;* getcont 	(bekomme key an Stelle r3 von polygone liste r0)
;* 		fr qsort
;*
;* r0 = adr
;* r3 = pos
;* ret: r3 = cont
;*
;* r7,r12 for free use
;*
;****************************************************************
getcont
	mov	r7,r3 lsl 3
	add	r7,r7,#6
	ldrsh	r3,[r0,r7]

	mov	pc,lr

;****************************************************************
;*
;* swapcont 	(tausche polygon Stelle r3 von polygonliste r0)
;* 		fr qsort
;*
;* r0 = adr
;* r8 = i (tmp)
;* r9 = j (tmp)
;*
;* r7,r12 for free use
;*
;****************************************************************

swapcont
	
	add	r8,r0,r8 lsl 3
	add	r9,r0,r9 lsl 3
	
	ldr	r7,[r8]
	ldr	r12,[r9]
	str	r12,[r8],4
	str	r7,[r9],4
	
	ldr	r12,[r9]
	swp	r7,r12,[r8]
	str	r7,[r9]

	mov	pc,lr	

;****************************************************************
;*
;* calcDepth (Polygonetiefenberchnung)
;*
;* in:	r10 = polycnt
;* 	r11 = punkte
;*	r12 = polygone
;*
;* waste anything
;*
;*********************************************

calcDepth
		
depc
	ldrh	r0,[r12],2
	ldrh	r1,[r12],2
	ldrh	r2,[r12],2
	
	
	;* punkt 0
	mov	r3,r0 lsl 3	;*8
	add	r3,r3,r0 lsl 2	;*4
	add	r3,r3,#4*2	; 
	ldr	r4,[r11,r3]	;z1
	
	;* punkt 1
	mov	r3,r1 lsl 3	;*8
	add	r3,r3,r1 lsl 2	;*4
	add	r3,r3,#4*2	; 
	ldr	r5,[r11,r3]	;z2
	
	;* punkt 2
	mov	r3,r2 lsl 3	;*8
	add	r3,r3,r2 lsl 2	;*4
	add	r3,r3,#4*2	; 
	ldr	r6,[r11,r3]	;z3


	add	r4,r4,r5	
	add	r4,r4,r6
		
	mov	r4,r4 asr 2		;div 4 ist fast div 3 :)		
		
	strh	r4,[r12],2

	subs	r10,r10,#1
	bne	depc


	mov	pc,lr

;****************************************************************
;*
;* conv3dzu2d (konvertiert 3d Punkt zu 2d Punkt)
;*
;* in:	r6 = zoom
;*	r7 = x
;* 	r8 = y
;* 	r9 = z	(-256 bis 255)
;*
;* out: r4 = x
;*	r5 = y
;*
;*
;* no waste
;*
;****************************************************************

conv3dzu2d

	stmfd	sp!,{r0-r3,r6,lr}

@define X_OFF	120
@define Y_OFF	80
@define	Z_OFF	512	

	muls	r7,r7,r6 		;x zoom
	muls	r8,r8,r6		;y zoom
	
	;muls	r9,r9,r6		;z zoom

	mov	r7,r7 asr 8
	mov	r8,r8 asr 8
	mov	r9,r9 asr 8
			
	ldr	r3,[diff_tab_r3adr]	;get z+Z_OFF div
	add	r9,r9,#256
	add	r9,r9,r9
	ldrsh	r2,[r3,r9]
			
	muls	r0,r2,r7		;get x	
	mov	r0,r0 asr 16
	add	r4,r0,#X_OFF
		
	muls	r0,r2,r8		;get y	
	mov	r0,r0 asr 16
	add	r5,r0,#Y_OFF		
	

	ldmfd	sp!,{r0-r3,r6,pc}
	
;****************************************************************
;*
;* generateDiffTab (generiere diffTab fr 3d->2d Konvertierung)
;*
;****************************************************************
	
generateDiffTab

	stmfd	sp!,{r0-r6,lr}

; for(i=-256;i<256;i++)
;  {
;	65536/(i+512)
;  }
;
	ldr	r6,[diff_tab_r3adr]

	mvn	r5,#$ff
diffl	

	mov	r0,#65536
	add	r1,r5,#Z_OFF
	swi	$60000
		
	strh	r0,[r6],2
	
	cmp	r5,#255
	add	r5,r5,#1
	bne	diffl

	ldmfd	sp!,{r0-r6,pc}

;****************************************************************
;*
;* drawPoint3d (zeichne 3d Punkt im mode3)
;*
;* in:	r7  = x
;* 	r8  = y
;* 	r9  = z
;*	r10 = color

;* no waste
;*
;****************************************************************

drawPoint3d_mode3
	
	stmfd	sp!,{r4-r6,lr}
	
	bl	conv3dzu2d

	mov	r6,#$6000000
	add	r6,r6,r4 lsl 1
	add	r6,r6,r5 lsl 9
	sub	r6,r6,r5 lsl 5

	strh	r10,[r6]

	ldmfd	sp!,{r4-r6,pc}
	
	
	
;****************************************************************
;*
;* rotPoint3d (drehe 3d Punkt )
;*
;* in:	r7  = x
;* 	r8  = y
;* 	r9  = z
;*
;* 	r10 = xa
;* 	r11 = ya
;* 	r12 = za
;*
;* out:	r7  = x
;* 	r8  = y
;* 	r9  = z
;*
;* waste r7-r12
;*
;****************************************************************	

rotPoint3d

	stmfd	sp!,{r0-r6,lr}

	ldr	lr,[sintabadr]	;sin
   	
	
	mov	r0,#$ff			;nach 1023 wieder 0 (360 = 0 grad)
        orr	r0,r0,#$300		;
        
        and	r10,r10,r0		;
        and	r11,r11,r0		;
        and	r12,r12,r0		;
        
        ;**** x rotation
        
	add	r6,lr,r10 lsl 2		;adr
   	ldr	r0,[r6]			;cos
	ldr	r1,[r6,256*4]		;sin
	rsb	r3,r0,#$0		;-sin
 	   	
   	muls	r2,r1,r7		;r2=cos*x
   	mlas	r4,r3,r8,r2		;r3=sin*y
   	
   	muls	r2,r0,r7		;r2=sin*x
   	mlas	r5,r1,r8,r2		;r3=cos*x
   	
   	mov	r7,r4 asr 16		;y
   	mov	r8,r5 asr 16		;x
   	
   	;**** y rotation
   	
   	add	r6,lr,r11 lsl 2		;adr
   	ldr	r0,[r6]			;cos
	ldr	r1,[r6,256*4]		;sin
	rsb	r3,r0,#$0		;-sin	
   	
   	muls	r2,r1,r8		
   	mlas	r4,r3,r9,r2
   	
   	muls	r2,r0,r8		
   	mlas	r5,r1,r9,r2		;z
   	
   	mov	r8,r4 asr 16		;y
   	mov	r9,r5 asr 16		;z
   	
   	;**** z rotation
   	
   	add	r6,lr,r12 lsl 2		;adr
   	ldr	r0,[r6]			;cos
	ldr	r1,[r6,256*4]		;sin
	rsb	r3,r0,#$0		;-sin	
   	
   	muls	r2,r1,r7 
   	mlas	r4,r3,r9,r2		;x
   	
   	muls	r2,r0,r7
   	mlas	r5,r1,r9,r2		;z
   	
   	mov	r7,r4 asr 16
   	mov	r9,r5 asr 16
   	
	ldmfd	sp!,{r0-r6,pc}
	

	
;****************************************************************
;*
;* drawPolyFlatMode3 (zeichne Vectorobjekt im Mode3)
;*
;* in:	r6   = zoom
;*	r10  = polycnt
;*	r11  = &3dpunkteldr
;*	r12  = &polysadr	
;*
;* 	
;*
;* waste no
;*
;****************************************************************	

drawPolyFlatMode3

	stmfd	sp!,{r0-r12,lr}

	
nextfPoly

	;****************************************************************
	;* get/convert 3 points for poly
	;****************************************************************	
	
	ldrh	r5,[r12],2		;punkt 1	
	mov	r4,r5 lsl 3		;*8
	add	r4,r4,r5 lsl 2		;*4
	add	r4,r4,r11
	ldmia	r4,{r7,r8,r9}
	
	bl	conv3dzu2d
	mov	r0,r4			;r0=x1
	mov	r1,r5			;r1=y1
		
	ldrh	r5,[r12],2		;punkt 2	
	mov	r4,r5 lsl 3		;*8
	add	r4,r4,r5 lsl 2		;*4
	add	r4,r4,r11
	ldmia	r4,{r7,r8,r9}
	
	bl	conv3dzu2d
	mov	r2,r4  			;r2=x2
	mov	r3,r5                   ;r3=y2
	
	ldrh	r5,[r12],2		;punkt 2	
	mov	r4,r5 lsl 3		;*8
	add	r4,r4,r5 lsl 2		;*4
	add	r4,r4,r11
	ldmia	r4,{r7,r8,r9}
	
	bl	conv3dzu2d		;r3=x3
		                        ;r4=y3
		                        
	stmfd	sp!,{r6}		;save Polygonponiter		
	
	;****************************************************************
	;* Backface Culling
	;*
	;* wenn ((x2-x1)*(y3-y2) - (y2-y1) * (x3*x2)) negative Zeichne 
	;* Polygon, da richtige Seite 
	;*
	;****************************************************************	
	
	sub	r6,r2,r0
	sub	r7,r5,r3
	sub	r8,r3,r1
	sub	r9,r4,r2
	
	muls	r6,r6,r7
	muls	r8,r8,r9
	
	sub	r6,r6,r8
	
	cmp	r6,#0			; grsser 0
	addge	r12,r12,#2		; erhhe noch 3z von Polygon
	bge	backFace		; nicht Zeichnen

   
   	;****************************************************************
	;* starte zeichnen und fllen des Polygons
	;****************************************************************	
			
	ldr	r6,[polyadr]			;save 3*(x,y) Koordinaten
	strh	r0,[r6],2	
	strh	r1,[r6],2	
	strh	r2,[r6],2	
	strh	r3,[r6],2	
	strh	r4,[r6],2	
	strh	r5,[r6]	

	;*** errechne Polygonfarbe aus z Punkte durchschnitt

	ldrsh	r7,[r12],2			;z_all
	mov	r7,r7 lsr 9
	rsb	r7,r7,#$26

	;*** erzeuge Polygon

	bl	clearPolyBuffer			;lsche Zeilenpuffer,...
	bl	drawPoly			;berechne Polygon
	bl	fillPoly			;flle Polygone
	
backFace	
	ldmfd	sp!,{r6}			;restore Polygonponiter	
	
	subs	r10,r10,#1
	bne	nextfPoly			;nchstes	
	

	
	ldmfd	sp!,{r0-r12,pc}		
	

	
;****************************************************************
;*
;* rotatePoints (drehe mehrere Punkte)
;*
;* in:	r0 = &punkte 		(Quelle)
;*	r1 = punkteanzahl	
;*	r2 = &punkteziel	(Ziel)		
;*
;* 	r10 = xa
;*	r11 = ya
;*	r12 = za
;*
;* waste no
;*
;****************************************************************

rotatePoints
	
	stmfd	sp!,{r0-r2,r7-r12,lr}
ropo
	ldmia	r0!,{r7,r8,r9}
	bl	rotPoint3d	
	stmia	r2!,{r7,r8,r9}

	subs	r1,r1,#1
	bne	ropo
	
	ldmfd	sp!,{r0-r2,r7-r12,pc}




