
    	.global     _start
    	.align
    	.arm


;*****************************************************************************************************************
;*
;*	ROM start 
;*
;*****************************************************************************************************************

_start


	b	startofromcode		;skip header
	.include "nintendologo.i"
	.ascii	"tunnel      "		;spiel name (12 byte)
	.ascii	"tunn"			;game code
	.ascii	"tl"			;marer code :)
	.byte	$96			;must be $96
	.byte	0			;main unit code
	.byte	0			;device type
	.byte	0,0,0,0,0,0,0		;resv. area
	.byte	0			;software version
	.byte	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	.byte	0,0			;reserved area

;*****************************************************************************************************************
;*
;*	PRG start 
;*
;*****************************************************************************************************************

	
startofromcode



	;**** wichtige sachen

        mov     r0, #$12               	;supervisor
        mov     r1, #$1f               	;system 
        msr     cpsr, r0
        ldr     sp,=myirqstackend     	;myirqstack
        msr     cpsr, r1
	ldr	sp,=mystackend		;mystack	
	
	;**** schalte prefetch an
	
	ldr 	r6,=$4000204   		;dma
	ldr	r0,=$4317
	strh	r0,[r6]
	
	
	;**** lsche bss
	
	ldr     r1,=__bss_start
        ldr     r2,=__bss_end
        sub     r2,r2,r1
        bl      memclear32
	
	;**** kopiere iramcode       

	ldr	r0,=__iwram_lma
	ldr	r1,=__iwram_start
	ldr	r2,=__iwram_end
	sub	r2,r2,r1
	bl	dmacpy
	
	;**** kopiere wram 
	
	ldr	r0,=__ewram_lma
	ldr	r1,=__ewram_start
	ldr	r2,=__ewram_end
	sub	r2,r2,r1
	bl	dmacpy

	;**** kopiere data

	ldr     r0,=__data_lma
        ldr     r1,=__data_start
        ldr     r2,=__data_end
	sub	r2,r2,r1
	bl	dmacpy

	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	ldr	r1,=$0403
	strh 	r1,[r6]			;store

	;****

	ldr	r0,=rolle
	bx	r0

	.pool


;*****************************************************************************************************************
;*
;*	ROM DATA 
;*
;*****************************************************************************************************************

	.align	4

loops	.incbin	"loops.gfx"
	.incbin	"loops.gfx"

	.align	4
winkel	.incbin	"winkel.raw"

	.align	4
depth	.incbin	"depth.raw"


;*****************************************************************************************************************
;*
;*	IRAM 
;*
;*****************************************************************************************************************
	
	
  	.SECTION    .iwram,"ax"  
    	.ARM
    	.align		4

rolle	
	mov	r10,#0
	mov	r11,#0
	
	
rloop

	mov	r4,#$6000000
	ldr	r5,=loops
		
	mov	r6,r10,lsl #1
	add	r6,r6,r11,lsl #9
	
	mov	r6,r6, lsl #15
	mov	r6,r6, lsr #15
	
	add	r5,r5,r6
			
	ldr	r6,=winkel
	ldr	r7,=depth
	
	add 	r10,r10,#1		;x add
	add 	r11,r11,#5		;y add	


	mov	r0,#240*160/2		;x
xyl

	ldrb	r8,[r6],#1
	ldrb	r9,[r7],#1
		
	mov	r9,r9,lsl #9
	add	r9,r9,r8, lsl #1
	
	ldrh	r3,[r5,r9]
	
	ldrb	r8,[r6],#1
	ldrb	r9,[r7],#1
		
	mov	r9,r9,lsl #9
	add	r9,r9,r8, lsl #1
	
	ldrh	r12,[r5,r9]
	
	orr	r3,r3,r12,lsl #16
	str	r3,[r4],#4

	subs	r0,r0,#1
	bne	xyl	
	
	b	rloop

irq	

	stmfd	sp!,{lr}
	
	mov	r0,#$4000000
	add	r1,r0,#$100
	add	r2,r0,#$200
				
	;stop irq

	ldrh	r3,[r2,#2]		;irq lesen
	strh	r3,[r2,#2]		;irq ausschalten
	
	ldmfd	sp!,{lr}
	bx	lr

	
	.bss
		
myirqstack:	.zero	256			;irqstack
myirqstackend:	
	

;*****************************************************************************************************************
;*
;*	WRAM 
;*
;*****************************************************************************************************************

	.section    	.ewram,"ax"
	
 						;bss
    	.global		mystack
  	.global		mystackend
  	.global		stacksave
  	.global		stringbuffer	
  
stacksave	.long	0
mystack		.fill	1024/4,4,$abcddcba		;STACK
mystackend

	
		
	.end
		