@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"sram test   "		;spiel name (12 byte)
	@dcb	"sram"			;game code
	@dcb	"tt"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$00		;mode 2 bg 2	
	strh 	r1,[r6]			;store
	
	;**** setze gfx modes
	
	;mov	r2,$10c0		;256, 2048*16, MOSAIC
	;strh	r2,[r6,$c]		;reg_bg2
	
	
	;**** setze paletten
		
	
	mov	r1,#$5000000
	mov	r2,#$0
	mvn	r3,r2
	strh	r2,[r1]
	strh	r3,[r1,2]
	

	;******************** setze Tilemode
		
	mov	r2,#$8c0			;256c ;ta += 2048*8 ;+ MOSAIC
	orr	r2,r2,#$6000			;32 x 32 mode + Area Overflow
	strh	r2,[r6,$C]

	;**** kopiere grafik in vram
		
	mov	r1,#$6000000
	ldr	r0,[picadr]
	mov	r2,#$660*4
	bl	dmacpy	
		
	;**** speichere			
	
	bl	save_sram

	;**** lese aus sram
	
	mov 	r1,#$e000000
	mov	r2,#$6000000
	add	r2,r2,(2048*8)
	
read_loop

	ldrb	r3,[r1],1
	cmps	r3,#0
	sub	r3,r3,#32
	strh	r3,[r2],2
	
	bne	read_loop

loop	b	loop
	
	;**** speichere in sram
	
save_sram	

	mov 	r1,#$e000000
	ldr	r2,[textadr]
	
copyloop

	ldrb	r0,[r2],1	
	strb	r0,[r1],1
	cmp	r0,#0
	bne	copyloop
	
	mov	pc,lr

;*********************** Unterprogramme (extern) *******************


		@include	simple.s 	
			        
                 
mystackadr	@DCD	mystack	
picadr		@dcd	pic
textadr		@dcd	text

text		@dcb	"Hallo vom SRAM!",0 
 

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

endofromcode 

	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
	
;*****		

;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata


	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

		 
	
pic		@incbin 	font_gba.ord		
              
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000
		
		@endarea
endofewramcode




