@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


@define DMAMODE				;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"soft zoom   "		;spiel name (12 byte)
	@dcb	"zoom"			;game code
	@dcb	"sz"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** irqmaster
	
	mov	r0,#1
	mov 	r6,#$4000000   		;dma
	add	r5,r6,#$200
	strh	r0,[r5,8]		;irq master enable
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$04		;mode 4 bg 2	
	strh 	r1,[r6]			;store
	
	mov	r1,#1
	strh	r1,[r6,2]
	
	;**** setze paletten
		
	ldr	r0,[picpaladr]
	mov	r1,#$5000000
	mov	r2,#512			;256 colors
	bl	dmacpy
	

	;**** kopiere/decrunch grafik in wram
			
	ldr	r0,[picadr]
	ldr	r1,[picwramadr]
	swi 	$110000			;lz77dec
	
	
	;**** zoom auf normal
	
	mov	r1,#$100
	ldr	r2,[zoom_xadr]
	ldr	r3,[zoom_yadr]
		
	strh	r1,[r2]
	strh	r1,[r3]	
	
	;**** zoom loop

loop
	
	bl	ntscw			;warten blank
	bl	check_tasten
	
	add	lr,pc,4
	ldr	r0,[setgfxadr]
	mov	pc,r0

	b	loop
	
;***** check die tasten

check_tasten

	ldr	r11,[zoom_xadr]
	ldr	r12,[zoom_yadr]
		
	ldrh	r8,[r11]
	ldrh	r9,[r12]	

	ldr	r4,[keyadr]

	mov	r0,#0x04000000
	orr	r0,r0,#$130
	
	ldrh	r1,[r4]	;alte taste
	ldrh	r2,[r0]	;get key
	
	;cmp	r1,r2
	;beq	alteTaste
		
	
	ands	r3,r2,#%1		;taste a
	addeq	r8,r8,#3		
	addeq	r9,r9,#3
		
	ands	r3,r2,#%10		;taste b
	subeq	r8,r8,#2	
	subeq	r9,r9,#2
	
		
	strh	r2,[r4]			;merke taste
	
alteTaste

	cmp	r8,#0
	moveq	r8,#1
	
	cmp	r10,#$800
	movhi	r10,#$800

	strh	r8,[r11]
	strh	r9,[r12]

	mov	pc,lr


;**** ntscwait

ntscw	
	stmfd 	sp!,{r2,lr}
	mov	r2,#0
	bl	wait	
	ldmfd	sp!,{r2,lr}
	mov	pc,lr


;*********************** Unterprogramme (extern) *******************


		@include	simple.s 	
			        
                 
mystackadr	@DCD	mystack	
picwramadr	@dcd	picwram
picadr		@dcd	pic
picpaladr	@dcd	picpal   
setgfxadr	@dcd	setgfx
zoom_xadr	@dcd	zoom_x
zoom_yadr	@dcd	zoom_y
keyadr		@dcd	key
 

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

endofromcode 

	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
	
;*****		

picwramadri	@dcd	picwram	
zoom_xadri	@dcd	zoom_x
zoom_yadri	@dcd	zoom_y
stackstoreadr	@dcd	stackstrore

;*****	
		
setgfx
	stmfd	sp!,{lr}

	ldr	r0,[picwramadri]
	mov	r12,r0			;sichere quelle
	
	mov	r1,#$6000000
	mov	r14,r1
	
		
	ldr	r3,[zoom_xadri]
	ldr	r4,[zoom_yadri]
	
	ldrh	r2,[r3]			;x_zoom 8bit fract
	ldrh	r10,[r4]		;y_zoom 8bit fract
	
	mov	r9,#0			;y cntr
	mov	r4,#160			;160 lines
y_loop	

	mov	r11,#0			;x cntr
	mov	r3,#60			;60 * 4 pixel
x_loop
	
	ldrb	r5,[r0,r11 lsr 8]
	add	r11,r11,r2		;r11 + fract
		
	ldrb	r6,[r0,r11 lsr 8]	
	add	r11,r11,r2		;r11 + fract	
		
	ldrb	r7,[r0,r11 lsr 8]
	add	r11,r11,r2		;r11 + fract
		
	ldrb	r8,[r0,r11 lsr 8]	
	add	r11,r11,r2		;r11 + fract	
		
	orr	r5,r5,r6 lsl 8		;zu wort
	orr	r7,r7,r8 lsl 8		;zu wort
	orr	r6,r5,r7 lsl 16		;zu long
	
	cmp	r11,#240*256		;ber ram ?
	bhi	x_stop	
	
	str	r6,[r1],4
	
	subs	r3,r3,#1		
	bne	x_loop	
x_stop	
	
	add	r14,r14,#240
	mov	r1,r14
	
	mov	r5,r9 asr 8		;r5 = int(r9)	
	mov	r6,r5 lsl 8		;x*256
	sub	r6,r6,r5 lsl 4		;-x*16
			
	add	r0,r12,r6		;nchste zeile in Quelle
	add	r9,r9,r10		;r10 + fract
	
	cmp	r9,#160*256		;ber 240 ?
	bhi	y_stop
	
	subs	r4,r4,#1
	bne	y_loop

y_stop

	ldmfd	sp!,{lr}

	mov pc,lr	
	

;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + 4Byte (ed mode)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata


	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

		 
	
pic		@incbin 	test_pic_mode4_lz77.raw	;38400 mit lz77 comp
picpal		@incbin 	test_pic_mode4_2.pal	;512		
              
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000
	
key		@dcd	0
stackstrore	@dcd	0	
	
zoom_x		@dcw	$000	
zoom_y		@dcw	$000
	
picwram		@dup dcb 38400,0	
	
		@endarea
endofewramcode




