@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"softrotation"		;spiel name (12 byte)
	@dcb	"soft"			;game code
	@dcb	"sr"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$03		;mode 3 bg 2	
	strh 	r1,[r6]			;store
	
	ldr	r0,[picadr]
	mov	r1,#$6000000	
	mov	r2,#(160*120*2)
	;bl	dmacpy	
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Dein Programm                                        **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************
	
	;mov	r0,#$aa
	;mov	r1,#$c0
	;mov	r6,#$4000000
	;strh	r0,[r6,$20]
	;strh	r1,[r6,$26]
	
	ldr	r11,[zoomadr]
	mov	r10,#$1<<6
	str	r10,[r11]
	
	; zoom bild auf bildgrsse
	
	
loop	

	mov	r4,#$4000000
	ldr	r3,[r4,$130]

	ldr	r10,[winkeladr]
	ldr	r11,[zoomadr]
   	ldr	r8,[r10]
   	ldr	r9,[r11]
   	
   	
   	
   	ands	r4,r3,#$0040
	subeq	r9,r9,#1
	
	ands	r4,r3,#$0080
	addeq	r9,r9,#1
   	
	ands	r4,r3,#$0020
	subeq	r8,r8,#1
	
	ands	r4,r3,#$0010
	addeq	r8,r8,#1
	
	str	r8,[r10]
	str	r9,[r11]

	bl	berechne_rotval	
	
	mov	lr,pc
	ldr	pc,[rotiereBildadr]
	
	b	loop	
	
;***** berechne rotval

berechne_rotval
        
        ; pa =  cos(winkel)*zoom
   	; pb =  sin(winkel)*zoom
   	; pc = -sin(winkel)*zoom
   	; pd =  cos(winkel)*zoom

   	ldr	r3,[sinadr]	;sin
   	add	r4,r3,#256*4	;cos
   
   	ldr	r10,[winkeladr]
   	ldr	r0,[zoomadr]
   	
   	;mov	r9,#$1<<6		;zoom 1
   	ldr	r9,[r0]
                
        mov	r10,#$ff	;nach 1023 wieder 0 (360 = 0 grad)
        orr	r10,r10,#$300	;
        and	r8,r8,r10	;
        
	mov	r5,r8 lsl 2	;auf long
   
   	ldr	r0,[r4,r5]	;cos
	ldr	r1,[r3,r5]	;sin
	mvn	r2,r1		;-sin
        mov	r3,r0
	
	mov	r11,r1		;speichere sin fr spter
	mov	r12,r0		;speichere cos fr spter
      	
	muls	r0,r0,r9
	muls	r1,r1,r9
	muls	r2,r2,r9
		
	mov	r0,r0 asr 14	;
	mov	r1,r1 asr 14	;
	mov	r2,r2 asr 14	;
	   	   
	ldr	r5,[bgbuf2adr]
		
	strh	r0,[r5],2		;scale x
   	strh	r1,[r5],2		;shear x
	strh	r2,[r5],2		;shear y 
	strh	r0,[r5],2		;scale y  
	
	
	mov	pc,lr			
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Programmende                                         **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************


		
;*********************** Unterprogramme (extern) *******************

		@include	simple.s 
			
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Variablenadressen                                    **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************	
		      
mystackadr		@dcd	mystack	
picadr			@dcd	pic
winkeladr		@dcd	winkel
sinadr			@dcd	incsintab   
bgbuf2adr		@dcd	bgbuf2	
bgbufadr		@dcd	bgbuf
rotiereBildadr		@dcd	rotiereBild
zoomadr			@dcd	zoom

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

 

		
endofromcode		
	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
		

debugmemadr		@dcd	debugmem
bgbuf2adri		@dcd	bgbuf2	
picadri			@dcd	pic	
		
rotiereBild
	
	ldr	r0,[debugmemadr]
	stmia	r0,{r1-lr}
	
	ldr	r1,[bgbuf2adri]
	ldrsh	r2,[r1],2
	ldrsh	r6,[r1],2
	ldrsh	r7,[r1],2
	ldrsh	r3,[r1]
	
	
	;mov	r2,#$100	;mu
	;mov	r3,#$100	;mv	


	;mov	r6,#192		;msu
	;mov	r7,#-192	;msv
	
	;r8	;u
	;r9	;v
	
	;r10	;su
	;r11	;sv
	
	;pixel(u+su,v+vu)
	
	;u=u+mu
	;v=v+mv
	
	;su=su+msu
	;sv=sv+msv
	

	mov	r12,#$6000000
	ldr	r13,[picadri]
	
	mov	r10,#0			;su=0;
	mov	r9,#0			;v=0
	mov	r0,#160
cogeny	
		
	
		
	mov	r11,#0			;sv=0
	mov	r8,#0			;u=0;
	mov	r1,#240
	
	str	r0,[s0]
	
	mov	r0,#$00fe0000
	orr	r0,r0,#$ff000000
	orr	r0,r0,#1
	
cogenx	
		
	mov	r4,r11 lsr 8		;kill fract		
	add	r4,r8,r4 lsl 16		;x=u+sv*256*256	
	add	r4,r5,r4 lsr 7
	bic	r4,r4,r0		;clear fffe0001
	
	ldrh	r14,[r13,r4]	
	
	add	r8,r8,r2		;u=u+mu
	sub	r11,r11,r7		;sv=sv+msv
		
	strh	r14,[r12],2
	
	subs	r1,r1,#1
	bne	cogenx

	ldr	r0,[s0]
	
	;****
	
	mov	r5,r9 lsr 8		;lsche fract
	mov	r5,r5 lsl 9		;y=y+vu*256*2		
	
	sub	r5,r5,r10 lsr 7		;y=y+su:7:0
	bic	r5,r5,#1		

	;****
	
	add	r9,r9,r3		;v=v+mvs
	add	r10,r10,r6 		;su=su+msu

	;****

	subs	r0,r0,#1
	bne	cogeny

	ldr	r0,[debugmemadr]
	ldmia	r0,{r1-lr}
	mov	pc,lr


s0	@dcd	0

	
;*****		

;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata
	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

pic		@incbin 	Bild6.gfx		
		@include	sin.s		
              
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000

bgbuf2		@dcw	0
		@dcw	0
		@dcw	0
		@dcw	0

winkel		@dcd	0
zoom		@dcd	0

bgbuf		@dcd	0	;x
		@dcd	0	;y
		@dcd	0	;center x
		@dcd	0	;center y
		@dcd	0	;zoom x
		@dcd	0	;zoom y
		@dcd	0	;angel

		@endarea
endofewramcode




