@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"

@macro exg RegisterA, RegisterB, RegisterSave

	mov	RegisterSave,RegisterA
	mov	RegisterA,RegisterB
	mov	RegisterB,RegisterSave

	@endm
	
@macro exglt RegisterA, RegisterB, RegisterSave

	movlt	RegisterSave,RegisterA
	movlt	RegisterA,RegisterB
	movlt	RegisterB,RegisterSave

	@endm	
	
@macro exg2 RegisterA, RegisterB

	eor 	RegisterA, RegisterA, RegisterB
	eor 	RegisterB, RegisterB, RegisterA
	eor 	RegisterA, RegisterA, RegisterB

	@endm	

@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"bg test     "		;spiel name (12 byte)
	@dcb	"test"			;game code
	@dcb	"tt"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy		
	
	;**** irq
	
	mov 	r6,#$4000000   		;dma
	add	r5,r6,#$200
	mov	r0,#1
	strh	r0,[r5,8]		;irq master enable	     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$1400
	orr	r1,r1,#$01		;mode 1 bg 2,sprites
	strh 	r1,[r6]			;store
	
	;**** setze gfx modes
	
	mov	r2,#$4800
	orr	r2,r2,#$80		;256, 2048*8, 32x32
	strh	r2,[r6,$c]		;reg_bg2
	
	
	;**** setze paletten
		
	mov	r1,#$5000000
	ldr	r0,[erde_paladr]
	mov	r2,#512
	bl	dmacpy	
	
	;**** setze paletten sprite (16)
		
	mov	r1,#$5000000
	add	r1,r1,#$200
	ldr	r0,[knuckles_paladr]
	mov	r2,#16*2
	bl	dmacpy	
		
	;**** setze teile
	
	mov	r1,#$6000000
	ldr	r0,[erde_gfxadr]
	mov	r2,#16384
	bl	dmacpy	
	
	;**** setze spritegfx
	
	mov	r1,#$6000000
	add	r1,r1,#$10000
	ldr	r0,[knuckles_gfxadr]
	mov	r2,#32768
	bl	dmacpy	
	
	;**** setze map
	
	mov	r1,#$6000000
	add	r1,r1,#2048*8
	add	r1,r1,#8+(2*32)	;x-y offset
	
	ldr	r0,[erde_mapadr]
	
	mov	r2,#16
y_loop
	ldmia	r0!,{r3,r4,r5,r6}
	stmia	r1,{r3,r4,r5,r6}
	add	r1,r1,#32
		
	subs	r2,r2,#1
	bne	y_loop
		
		
	;*****************
	
	mov	r0,#120-32		;x
	mov	r1,#80-50		;y
	mov	r2,#0			;sprite 0
	mov	r5,#0			;tile
	bl	set_sprite
	
	mov	r0,#120-32+5		;x
	mov	r1,#80-50+64		;y
	mov	r2,#1			;sprite 0
	mov	r5,#8			;tile
	bl	set_sprite
		
		
	;rot/zoom bg2		
		
	mov	r11,#$0	
	mov	r10,#$0
loop	

	bl	ntscw
	mov	r1,#$5000000
	mov	r0,#$3f
	strh	r0,[r1]

	;sync

	mov	r8,#$400
iii	subs	r8,r8,#1
	bne	iii	

	
	ldr	r2,[bgbufadr]

	mov	r3,#120
	mov	r4,#80
	
	add	r10,r10,#$10	;zoom 3+8bit frakt
	add	r11,r11,#$b6/2	;rot  
	
	
	strh	r3,[r2,8]	;center x
	strh	r4,[r2,10]	;center y
	
	
	mov	r3,r3 lsl 8
	mov	r4,r4 lsl 8
	
	str	r3,[r2]		;x	
	str	r4,[r2,4]	;y
	
	mov	r0,r10 lsr 4
	
	strh	r0,[r2,12]	;zoom x
	strh	r0,[r2,14]	;zoom y
	
	mov	r1,r11
	strh	r1,[r2,16]	;angel
	
	
	mov	r0,r2
	mov	r1,#$4000000
	add	r1,r1,#$20	;bg2
	mov	r2,#1
	swi	#$e0000	
	

		
	
	mov	r1,#$5000000
	mov	r0,#$0
	strh	r0,[r1]
	
	
	b	loop
	
	
	
l	b	l	

;***** set_sprite

set_sprite

	mov	r6,#$7000000
	
	mov	r3,#$0000		;256 		 
        mov	r4,#$c000		;16x16, rotscal nummer 0
	
	orr	r3,r3,r1
	orr	r4,r4,r0
	
	add	r6,r6,r2 lsl 3
	
	strh	r3,[r6]
	strh	r4,[r6,2]
	strh	r5,[r6,4]

	mov 	pc,lr
	
;**** clear screen

clearScreen
	
	mov 	r12,#$6000000   		
	mov	r11,#9600/4
	mov	r10,#0
	mov	r9,#0
	mov	r8,#0
	mov	r7,#0
clSc
	stmia	r12!,[r7,r8,r9,r10]
	
	subs	r11,r11,#1
	bne	clSc


	mov	pc,lr


	

;**** ntscwait

ntscw	
	stmfd 	sp!,{r2,lr}
	mov	r2,#160
	bl	wait	
	ldmfd	sp!,{r2,lr}
	mov	pc,lr
forever	b	forever


;*********************** Unterprogramme (extern) *******************


		@include	simple.s 	
			        
                 
mystackadr	@DCD	mystack	

erde_gfxadr	@DCD	erde_gfx
erde_mapadr	@DCD	erde_map
erde_paladr	@DCD	erde_pal

knuckles_gfxadr	@dcd	knuckles_gfx
knuckles_paladr	@dcd	knuckles_pal

bgbufadr	@dcd	bgbuf
	
 

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

endofromcode 

	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
	
	




;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata


	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

erde_gfx	@incbin	gfx_erde.gfx
erde_map	@incbin	gfx_erde.map
erde_pal	@incbin	gfx_erde.pal

knuckles_gfx	@incbin	spr_censored.gfx
knuckles_pal	@incbin	spr_censored.pal
	
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000

bgbuf		@dcd	0	;x
		@dcd	0	;y
		@dcd	0	;center x
		@dcd	0	;center y
		@dcd	0	;zoom x
		@dcd	0	;zoom y
		@dcd	0	;angel
	
		@endarea
endofewramcode




