@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"

@macro exg	RegisterA, RegisterB

	eor 	RegisterA, RegisterA, RegisterB
	eor 	RegisterB, RegisterB, RegisterA
	eor 	RegisterA, RegisterA, RegisterB

	@endm	
	
@macro exgle	RegisterA, RegisterB

	eorle 	RegisterA, RegisterA, RegisterB
	eorle 	RegisterB, RegisterB, RegisterA
	eorle	RegisterA, RegisterA, RegisterB

	@endm	

@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"poly fill   "		;spiel name (12 byte)
	@dcb	"poly"			;game code
	@dcb	"pf"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$03		;mode 3 bg 2	
	strh 	r1,[r6]			;store
	
	ldr	pc,[startAlladr]

;ende	b	ende	
	
	

;*********************** Unterprogramme (extern) *******************


		@include	simple.s 	
			        
                 
mystackadr	@DCD	mystack	
startAlladr	@dcd	startAll


startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

endofromcode 

	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
		
pfb_startadr	@DCD	pfb_start
pfb_stopadr	@DCD	pfb_stop
seedadr		@dcd	seed

polyadr		@dcd	poly		
	
	
startAll	
	
	;**** setrand
	
	ldr	r0,[seedadr]
	mvn	r1,r0
	str	r1,[r0]
	mov	r1,r1 lsl 16
	str	r1,[r0,4]
	
	
loop
	
	bl	clearPolyBuffer
	bl	setCoordinates
	bl	drawPoly
	
	bl	rand	
	mov	r7,r1
	bl	fillPoly
	
	b	loop

	

;***********************************************************
;*
;* rand
;*
;***********************************************************

rand

	ldr	r3, [seedadr]		; Point at seeds.
	ldmia	r3, {r1,r2}		; Load them.
	tst	r2, r2, lsr #1		; Top bit into carry.
	movs	r4, r1, rrx		; 33 bit rotate right.
	adc	r2, r2, r2		; Carry into lsb of Rb.
	eor	r4, r4, r1, lsl #12	; (involved!)
	eor	r1, r4, r4, lsr #20	; (similarly involved!)
	stmia	r3, {r1,r2}		; Use these next time.
	mov	pc, lr
	

setCoordinates

	stmfd	sp!,{lr}

	mov	r9,#$ff
	orr	r9,r9,#$ff00

	ldr	r5,[polyadr]
	mov	r6,#3
setCoo	

	bl	rand
	
	and	r0,r1,r9
	mov	r1,#239
	swi	$60000
	mov	r7,r1
	
	bl	rand
	
	and	r0,r1,r9
	mov	r1,#159
	swi	$60000
	;mov	r8,r1
	
	strh	r7,[r5],2		
	strh	r1,[r5],2	
	
	subs	r6,r6,#1
	bne	setCoo

	ldmfd	sp!,{pc}

;***********************************************************
;*
;* drawPoly
;*
;***********************************************************

drawPoly

	stmfd	sp!,{lr}

	ldr	r5,[polyadr]	
	
	ldrh	r0,[r5,0]
	ldrh	r1,[r5,2]
	ldrh	r2,[r5,4]
	ldrh	r3,[r5,6]
	bl	drawPolyLine
	
	ldrh	r0,[r5,4]
	ldrh	r1,[r5,6]
	ldrh	r2,[r5,8]
	ldrh	r3,[r5,10]
	bl	drawPolyLine
	
	ldrh	r0,[r5,0]
	ldrh	r1,[r5,2]
	ldrh	r2,[r5,8]
	ldrh	r3,[r5,10]
	bl	drawPolyLine
	
	
	ldmfd	sp!,{pc}

;***********************************************************
;*
;* fill polygon
;*
;* r7 = color 15bit
;*
;***********************************************************


fillPoly

	stmfd	sp!,{r0-r4,lr}

	ldr	r0,[pfb_startadr]
	ldr	r1,[pfb_stopadr]
	
	;**** flle polygon
	
	mov	r2,#0
dlbu
	ldrb	r3,[r0],1
	ldrb	r4,[r1],1
	
	cmp	r3,#$ff
	beq	nov
	cmp	r4,#$ff
	moveq	r4,r3
	

	bl	drawHLine

nov
	cmp	r2,#160
	add	r2,r2,#1
	bne	dlbu		

	ldmfd	sp!,{r0-r4,pc}


;***********************************************************
;*	
;* init poly buffers (fill with 255)
;*
;***********************************************************

clearPolyBuffer
	
	ldr	r0,[pfb_startadr]
	ldr	r1,[pfb_stopadr]
	
	mvn	r3,#$0
	mov	r2,#160/4
clbu
	str	r3,[r0],4
	str	r3,[r1],4

	subs	r2,r2,#1
	bne	clbu	
	
	mov	pc,lr


;***********************************************************
;*	
;* draw HLine
;*
;* r2 		= y
;* r3 - r4	= x1 - x2
;*
;* r7 		= color
;*
;***********************************************************


drawHLine
	stmfd	sp!,{r3-r6,lr}	

	cmp	r4,r3		;x1 <= x1	
	exgle	r3,r4		;swap
	beq	endHLine	;0 len	
	
	mov	r6,#$6000000
	add	r6,r6,r3 lsl 1		;+x*2
	add	r6,r6,r2 lsl 9		;+y*256*2
	sub	r6,r6,r2 lsl 5		;-y*16*2
	
	;mov	r5,#$ff
	;orr	r5,r5,#$3f00
	
dHPix
	strh	r7,[r6],2
	cmp	r3,r4
	add	r3,r3,#1
	bne	dhPix
		

endHLine
	ldmfd	sp!,{r3-r6,pc}

	

;***********************************************************
;*	
;* clear screen
;*
;***********************************************************

clearScreen
	
	mov 	r12,#$6000000   		
	mov	r11,#((76800*2)/4)/4
	mov	r10,#0
	mov	r9,#0
	mov	r8,#0
	mov	r7,#0
clSc
	stmia	r12!,[r7,r8,r9,r10]
	
	subs	r11,r11,#1
	bne	clSc


	mov	pc,lr

;***********************************************************
;*	
;* zeichne (errechne) polyline
;*
;* r0 = x1 , r1 = y1
;* r2 = x2 , r3 = y2
;*
;***********************************************************

drawPolyLine

	stmfd	sp!,{r0-r11,lr}
	
	cmp	r1,r3		;y1 == y2 
	beq	stopfor
	
	cmp	r1,r3
	ble	calcm
	
	exg	r1,r3
	exg	r0,r2
	
calcm

	;r4 x, r5 y ,  r6 m

	mov	r4,r0 lsl 8	;x = x1 << 8
	
	mov	r8,r1		;r8 = y1 (save wegen div)
	mov	r9,r3		;r9 = y2 (save wegen div)
	
	sub	r0,r2,r0	;tx = x2 - x1		
	sub	r1,r3,r1	;ty = y2 - y1

	mov	r0,r0 lsl 8	;tx << 8

	swi	#$60000		;m (r0) = tx/ty
	
	add	r4,r4,r0	;x = x + m

	ldr	r10,[pfb_startadr]	
	ldr	r11,[pfb_stopadr]

	add	r5,r8,#1	;y = y1	+ 1
forpoly	cmp	r5,r9		;y > y2 stop
	bhi	stopfor
	
	;**** trage in polyliste ein
	
	mov	r7,r4 lsr 8		;x >> 8
	
	ldrb	r3,[r10,r5]		;
	cmp	r3,#255			;if startx[x] == 255
	streqb	r7,[r10,r5]		;startx[x]=y
	strneb	r7,[r11,r5]		;else endx[x]=y

	;mov	r3,#$6000000
	;add	r3,r3,r7 lsl 1		;+x
	;add	r3,r3,r5 lsl 9		;+y*256
	;sub	r3,r3,r5 lsl 5		;-y*16
	;mov	r8,#$1f
	;strh	r8,[r3]


	add	r4,r4,r0	;x = x + m	
	add	r5,r5,#1	;y++
	b	forpoly
	
stopfor	
	
	ldmfd	sp!,{r0-r11,pc}





;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata


	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

	
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000

pfb_start	@dup	dcb	160,0
pfb_stop	@dup	dcb	160,0

seed		@dcd	0,0
	
poly		@dcw	30,50
		@dcw	100,20
		@dcw	170,60	
	
		@endarea
endofewramcode




