@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"lut effects3"		;spiel name (12 byte)
	@dcb	"luef"			;game code
	@dcb	"le"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$05		;mode 5 bg 2	
	strh 	r1,[r6]			;store
	
	ldr	r0,[picadr]
	mov	r1,#$6000000	
	mov	r2,#(160*120*2)
	;bl	dmacpy	
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Dein Programm                                        **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************
	
	; zoom bild auf bildgrsse
	
	mov	r0,#$aa
	mov	r1,#$c0
	mov	r6,#$4000000
	strh	r0,[r6,$20]
	strh	r1,[r6,$26]
	
	;
	
	ldr	pc,[nochmaladr]
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Programmende                                         **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************


		
;*********************** Unterprogramme (extern) *******************

		@include	simple.s 
			
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Variablenadressen                                    **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************	
		      
mystackadr		@dcd	mystack	
picadr			@dcd	pic
nochmaladr		@dcd	nochmal

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

 

gfxtable		@include	table.s
		
endofromcode		
	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
		
picadri		@dcd	pic
gfxtableadr	@dcd	gfxtable
	
	

nochmal

	mov	r10,#0	;trigger
	
	mov	r6,#0	;x
	mov	r7,#0	;y	
	
loop

	
	mov	r0,#$6000000
	ldr	r1,[picadri]
	ldr	r2,[gfxtableadr]
	
	mov	r4,#$4000000
	
	
	ldr	r3,[r4,$130]
	
	ands	r4,r3,#1
	moveq	r10,#1
	
	ands	r4,r3,#2
	moveq	r10,#0
	
	ands	r4,r3,#$0040
	subeq	r7,r7,#512
	
	ands	r4,r3,#$0080
	addeq	r7,r7,#512
	
	ands	r4,r3,#$0020
	subeq	r6,r6,#2
	
	ands	r4,r3,#$0010
	addeq	r6,r6,#2
	
	cmps	r10,#1
	addeq	r6,r6,#2
	
	mov	r9,#$10000
	sub	r9,r9,#1		;r9 = $ffff
	
	;add	r2,r2,r6
	
	mov	r8,#120
cogeny	
	
	mov	r3,#160
cogenx	
	
	ldrh	r4,[r2],2		;get pixel
	
	sub	r4,r4,r6		;+x
	add	r4,r4,r7		;+y
	and	r4,r4,r9
	
	add	r4,r4,r4		;*2	
	
	ldrh	r5,[r1,r4]
	strh	r5,[r0],2
	
	subs	r3,r3,#1
	bne	cogenx

	add	r2,r2,#(256-160)*2
	

	subs	r8,r8,#1
	bne	cogeny
	
	b	loop
	
;*****		

;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata
	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

pic		@incbin 	Bild5.gfx		
		
              
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000

		@endarea
endofewramcode




