@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"line turbo  "		;spiel name (12 byte)
	@dcb	"line"			;game code
	@dcb	"tt"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$04		;mode 4 bg 2	
	strh 	r1,[r6]			;store
	
	
	;**** setze paletten
		
	mov	r1,#$5000000
	mov	r2,#0
	mvn	r3,r2
	strh	r2,[r1],2
	strh	r3,[r1],2
	
	;**** zeichne Linie

	mov	r0,#0		;x1
	mov	r1,#0		;y1	
	mov	r3,#239		;x2
	mov	r4,#159		;y2
	
	add	lr,pc,4
	ldr	r5,[drawlineadr]
	mov	pc,r5
	

loop	b	loop	



;*********************** Unterprogramme (extern) *******************


		@include	simple.s 	
			        
                 
mystackadr	@DCD	mystack	
drawlineadr	@dcd	drawline
 

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

endofromcode 

	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
	
	
;**** zeichne linie
;
; r0 = x1 , r1 = y
; r3 = x2 , r4 = y2
;

drawline

	stmfd	sp!,{r0-r12}

	; fr Quadrant 3/2 und 6/7 gilt
	
	subs	r5,r3,r0
	rsblt	r5,r5,#0	;betrag von r5
	
	subs	r6,r4,r1			
	rsblt	r6,r6,#0	;betrag von r6
	
	mov	r11,#0
	
	cmp	r5,r6		;in Quadrant 3/2/6/7 ?
	bge	noXYMirror
	
	mov	r11,#1	
	mov	r12,r1
	mov	r1,r0
	mov	r0,r12
	
	mov	r12,r3
	mov	r3,r4
	mov	r4,r12

noXYMirror
	
	; fr Quadrant 4 und 5 gilt
	
	subs	r5,r3,r0	;dx:=x2-x1 , dx negative ?
	bge	no_XSwap
	mov	r12,r0
	mov	r0,r3
	mov	r3,r12
	mov	r12,r1
	mov	r1,r4
	mov	r4,r12
no_XSwap
	
	;sub	r5,r3,r0	;dx:=x2-x1
	sub	r6,r4,r1	;dy:=y2-y1;

	; fr Quadrant 8 und 1 gilt

	cmp	r6,#0		;dy negativ ?
	mvnlt	r2,#0		;0 = -1 da 2komplement
	rsblt	r6,r6,#0	;neg r6
	movge	r2,#1		;ansonsten +1
		
	; Bresenham 		
		
	sub	r9,r6,r5	;dy-dx
	
	add	r7,r6,r6	;incE:=2*dy
	add	r8,r9,r9	;incNE:=2*(dy-dx);
	
	add	r10,r6,r6	;d:=2*dy-dx;
	sub	r10,r10,r5
	
draw_loop
	
	cmp	r0,r3			;solange x<=x2
	bhi	stop_draw
	
	;**** setpoint
			
	mov	r6,#$6000000
	
	cmp	r11,#0			;0 ist normal, 1 ist x y swap	
		
	addeq	r6,r6,r0		;+x
	addne	r6,r6,r1		;+x
	
	addeq	r6,r6,r1 lsl 8		;+y*256
	addne	r6,r6,r0 lsl 8		;+y*256
	subeq	r6,r6,r1 lsl 4		;-y*16
	subne	r6,r6,r0 lsl 4		;-y*16
					
	ands	r5,r6,#1		;adresse gerade ?
	bic	r6,r6,#1		;mache gerade	
	
	ldrh	r12,[r6]		;hole wort
	
	orreq	r12,r12,#1		;
	orrne	r12,r12,#$100		;
	
	strh	r12,[r6]		;schreibe wort
	
	;**** setpoint ende
	
	cmp	r10,#0			;d == 0?
	addlt	r10,r10,r7		;<  d:=d+incE;
	addge	r10,r10,r8		;>= d:=d+incNE;
	addge	r1,r1,r2		;>= y++	
	
	add	r0,r0,#1		;x++
	
	b	draw_loop
stop_draw	
	
	ldmfd	sp!,{r0-r12}
	mov	pc,lr

;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata


	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

	
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000

	
		@endarea
endofewramcode




