@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


;@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"kreis       "		;spiel name (12 byte)
	@dcb	"circ"			;game code
	@dcb	"kr"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$04		;mode 4 bg 2	
	strh 	r1,[r6]			;store
	
	;**** setze paletten
		
	mov	r1,#$5000000
	mov	r2,#0
	mvn	r3,r2
	strh	r2,[r1],2
	strh	r3,[r1],2
	
	
;**** zeichne kreis
;
; r0 = x  , r1 = y
; r3 = r 
;
	
	mov	r0,#120
	mov	r1,#80
	mov	r3,#70
				
	add	lr,pc,4
	ldr	r5,[draw_circleadr]
	mov	pc,r5	
			
loop	b	loop	

;**** Unterprogramme

dmacpy  

@ifdef DMAMODE
	mov 	r3,#$04000000	
	mov	r2,r2 lsr 2			; size / 4
	mov 	r0,#$8400 			; 32bit, sofort	
			
	str 	r0,[r3,$d4]			
	str	r1,[r3,$d8]			
	strh 	r2,[r3,$dc]			
	strh	r0,[r3,$de]
	
@else

	stmfd 	sp!,{r0,r1,r3}
	
	mov	r2,r2 lsr 2
dmacpyloop
	ldr	r3,[r0],4
	str	r3,[r1],4
	subs	r2,r2,#1
	bne	dmacpyloop	
	
	ldmfd	sp!,{r0,r1,r3}
@endif
				
	mov 	pc,lr	

;*********************** Unterprogramme (extern)/Variablen  *******************
		                       
mystackadr	@DCD	mystack	
draw_circleadr	@dcd	draw_circle
 
startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

endofromcode 

	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
	
	
;**** zeichne kreis
;
; r0 = x  , r1 = y
; r3 = r 
;

draw_circle

	stmfd	sp!,{r0-r12,lr}
	

	mov	r4,#0		;xh = 0
	mov	r5,r3		;yh = r

	rsb	r6,r3,#1	;d   = 1-r
	mov	r7,#3		;dx  = 3
	
	;dxy = -2*r + 5
	
	rsb	r8,r3,#0	;-r
	mov	r8,r8 lsl 1	;*2
	add	r8,r8,#5	;+5

rep_circle	
	cmp	r5,r4		;WHILE(yh >= xh)
	blt	stop_circle
	
	add	r9,r0,r4	;PSET(x+xh,y+yh)
	add	r10,r1,r5
	bl	setpoint
	
	add	r9,r0,r5	;PSET(x+yh,y+xh)
	add	r10,r1,r4
	bl	setpoint
	
	add	r9,r0,r5	;PSET(x+yh,y-xh)
	sub	r10,r1,r4
	bl	setpoint
	
	add	r9,r0,r4	;PSET(x+xh,y-yh)
	sub	r10,r1,r5
	bl	setpoint
	
	sub	r9,r0,r4	;PSET(x-xh,y-yh)
	sub	r10,r1,r5
	bl	setpoint
	
	sub	r9,r0,r5	;PSET(x-yh,y-xh)
	sub	r10,r1,r4
	bl	setpoint
	
	sub	r9,r0,r5	;PSET(x-yh,y+xh)
	add	r10,r1,r4
	bl	setpoint
	
	sub	r9,r0,r4	;PSET(x-xh,y+yh)
	add	r10,r1,r5
	bl	setpoint
	
	teq	r6,#0		;IF d<0 THEN
	
	addmi	r6,r6,r7	;d=d+dx
	addmi	r7,r7,#2	;dx=dx+2
	addmi	r8,r8,#2	;dxy=dxy+2
	addmi	r4,r4,#1	;xh=xh+1
				;ELSE
	addpl	r6,r6,r8	;d=d+dxy
	addpl	r7,r7,#2	;dx=dx+2
	addpl	r8,r8,#4	;dxy=dxy+4
	addpl	r4,r4,#1	;xh=xh+1
	subpl	r5,r5,#1	;yh=yh-1
				
	b	rep_circle	
	
stop_circle	
	
	ldmfd	sp!,{r0-r12,lr}
	mov	pc,lr



;**** setpoint im mode 4
; r9  = x
; r10 = y

setpoint	
					
	add	r11,r9,#$6000000	;+x
	add	r11,r11,r10 lsl 8	;+y*256
	sub	r11,r11,r10 lsl 4	;-y*16
				
	ands	r12,r11,#1		;adresse gerade ?
	bic	r11,r11,#1		;mache gerade	
	
	ldrh	r12,[r11]		;hole wort
	
	orreq	r12,r12,#1		;
	orrne	r12,r12,#$100		;
	
	strh	r12,[r11]		;schreibe wort
	
	mov	pc ,lr
	
	;****

;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte ed)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata


	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

	
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000

	
		@endarea
endofewramcode




