@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"hblank test"		;spiel name (12 byte)
	@dcb	"blnk"			;game code
	@dcb	"tt"			;marker code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area

	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy	
	
	;**** schalte irqs an
	
	ldr	r0,[irqhandleradr]
	ldr	r1,[irqvectoradr]
	str	r0,[r1]

	mov 	r6,#$4000000   		;dma
	mov	r0,#$18			;h/v blank irq enable
	strh	r0,[r6,4]		;dispstat
	
	mov	r0,#$3			;h/v blank / irq master
	add	r5,r6,#$200
	strh	r0,[r5]			;h/v blank irq enable
	
	mov	r0,#1
	strh	r0,[r5,8]		;irq master enable		     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$00		;mode 2 bg 2	
	strh 	r1,[r6]			;store
	
	;**** setze paletten
		
	
	mov	r1,#$5000000
	ldr	r0,[bg1_paladr]
	mov	r2,#16*2
	bl	dmacpy	
		
	

	;******************** setze Tilemode
		
	;map = 11 * 2048 = $b
	;pic = 0
	;64x32 tiles
	
	mov	r2,#$4b00
	strh	r2,[r6,$C]

	;**** kopiere grafik in vram
		
	mov	r1,#$6000000
	ldr	r0,[bg1_picadr]
	mov	r2,#$4f00		;20640
	orr	r2,r2,#$ec
	bl	dmacpy	
		
	;**** kopiere map
	
	ldr	r0,[bg1_mapadr]
	mov	r1,#$6000000
	add	r1,r1,#2048*11
	
	add	r5,r0,#32*2
	add	r6,r1,#(1024*2)
	
	mov	r4,#30
ty_loop	
	mov	r3,#32		
tx_loop		
	ldrh	r9,[r0],2
	ldrh	r8,[r5],2
	
	strh	r9,[r1],2
	strh	r8,[r6],2
	
	
	subs	r3,r3,#1
	bne	tx_loop
	
	add	r0,r0,#8*2
	
	add	r5,r5,#8*2
	
	subs	r4,r4,#1
	bne	ty_loop
	
	;**** setze x wert
	
	mov	r0,#16 << 16
	ldr	r2,[real_bg_posadr2]
	str	r0,[r2]
		
	;**** berechne Balken		
		
	mov	r10,#0			;winkel 		
		
loop	
	bl	ntscw			;warte
	
	bl	clearRollen		;lsche Backgroundtabellet	
		
	mov	r11,#8			;8 Balken
drRollen			
	
	add	r1,r10,r11 lsl 5	;WinkelNeu = Winkel + Rollen*32
	
	mov	lr,pc			;rcksprung (Prefetch -> pc ist schon hinter ldr)
	ldr	pc,[gba_sinadr]		;berechne Sinus
			
			
	mov	r0,r0 asr 10		;Sinuswert / 1024
	add	r0,r0,#80-8		;+Mitte von Bildschirm - halbe Rollengrsse
	bl	drawRolle	
	
	subs	r11,r11,#1		;nchste Rolle?
	bne	drRollen		;
		
	add	r10,r10,#4		;Winkel +4 (Rollengeschwindigkeit)
	
	b	loop	
		
;****************
;* 
;* clearRollen
;*		
	
clearRollen	
	
	ldr	r1,[backcolortabadr]
	
	mov	r2,#0
	mov	r0,#80
rcls
	str	r2,[r1],4
	
	subs	r0,r0,#1
	bne	rcls	
	mov	pc,lr

;****************
;* 
;* drawRolle
;*		
;*	
	
drawRolle
	
	stmfd	sp!,{r0-r5}

	ldr	r1,[backcolortabadr]	;Hintergrundtabelle
	add	r1,r1,r0 lsl 1		;finde Startposition
	
	mov	r3,#3			;Farbstartwert
	
dl1	
	orr	r5,r3,r3 lsl 5		;geld
	strh	r5,[r1],2		;speichern
	
	rsb	r4,r3,#$1f		;$1f-r3
	add	r3,r3,#4		;+4
	
	orr	r5,r4,r4 lsl 5		;gelb
	strh	r5,[r1,(8*2)-2]		;speichern
	
	cmp	r3,#$23			;Rolle fertig?
	bne	dl1	
	
	ldmfd	sp!,{r0-r5}
	
	mov	pc,lr
	
	
	
;**** ntscwait

ntscw	
	stmfd 	sp!,{r2,lr}
	mov	r2,#160
	bl	wait	
	ldmfd	sp!,{r2,lr}
	mov	pc,lr
forever	b	forever

	


;*********************** Unterprogramme (extern) *******************


		@include	simple.s 
		
		
		        
                 
mystackadr	@DCD	mystack	

bg1_picadr	@dcd	bg1_pic
bg1_mapadr	@dcd	bg1_map
bg1_paladr	@dcd	bg1_pal

gba_sinadr	@dcd	gba_sin

backcolortabadr	@dcd	backcolortab
real_bg_posadr2	@dcd	real_bg_pos
debugmemadr	@dcd	debugmem
irqhandleradr	@DCD	irqhandler   
irqvectoradr	@DCD	$03007ffc   	

		

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

endofromcode 

	
;*************************** IRAM CODE ************************************
startofiwramcode	
	
	@textarea $03000000
		
	

irqstackadr		@dcd	irqstack		
sincntadr		@dcd	sincnt
real_bg_posadr		@dcd	real_bg_pos
backcolortabadri	@dcd	backcolortab
sinadr			@dcd	incsintab

;r1 = winkel; r0 = 32 bit return

gba_sin

	mov	r0,#$ff			;nach 1023 wieder 0 (360 = 0 grad)
        orr	r0,r0,#$300		;
        and	r1,r1,r0		;
        
	ldr	r2,[sinadr]		;lade sintab
	ldr	r0,[r2,r1 lsl 2]	;sin
	
	mov	pc,lr


		
;*************************** irqhandler (30.11.2002)
;*
;* r0 -r3 werden von bios/irq gesichert
;*
;**
irqhandler

	mov	r3,sp
	ldr	sp,[irqstackadr]	;mein irq stack
	stmfd 	sp!,{r3-r6,lr}

	mov	r0,#$4000000
	orr	r0,r0,#$200
		
	ldrh	r2,[r0,2]		;irq lesen
	strh	r2,[r0,2]		;irq ausschalten

	ands	r3,r2,#1		;vblank
	bne	vblank	
irq_endv
	ands	r3,r2,#2		;hblank
	bne	hblank	
irq_endh
		

	ldmfd	sp!,{r3-r6,lr}
	mov	sp,r3
	bx	lr
	
;****
;* 
;* hblank
;*
;*
hblank	
	mov	r6,#$4000000	
	ldrh	r5,[r6,6]		;bekomme line
	
	cmp	r5,#159			;ber sichtbar?
	bhi	irq_endh		;dann raus
	
	ldr	r1,[sincntadr]		;erhhe counter
	ldr	r4,[r1]
	add	r4,r4,#1
	str	r4,[r1]

	mov	r1,r4 lsr 4		;
	add	r1,r1,r5 lsl 3  	;
	bl	gba_sin			;sin(counter * 16 + zeile * 8)
	mov	r1,r0 lsr 13		;/8192
	
	add	r1,r1,#16		;+16
	
	ldr	r2,[real_bg_posadr]	;hole xy wert
	ldr	r0,[r2]			
	
	mov	r0,r0 lsr 16		;oberen 16 bit sind x
	add	r1,r1,r0		;+x
	strh	r1,[r6,$18]		;setze x


	mov	r6,#$5000000		;pal

	ldr	r2,[backcolortabadri]	;hole backcolor Tabelle
	add	r2,r2,r5 lsl 1		;bekomme Farbe an aktueller Zeile
	
	ldrh	r5,[r2]			;lade aus Tabelle
	strh	r5,[r6]			;in Hintergrundfarbe (0)

	b	irq_endh

;****
;* 
;* vblank
;*
;*	
vblank
	b	irq_endv
	
	
;*****		

;**************************** IRAM DATA ****************************

startofeiramdata
		

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata


	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

		 
	
bg1_pic		@incbin 	gfx_background.gfx	
bg1_map		@incbin 	gfx_background.map
bg1_pal		@incbin 	gfx_background.pal

		@include	sincos.s
              
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000
		
sincnt		@dcd	0	
real_bg_pos	@dcd	0

backcolortab	@dup	dcw	160,0
		
		@endarea
endofewramcode




