
;@define DMAMODE			;fr batgba ausschalten

	b	start			;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"test",0,0,0		;spiel name (12 byte)
	@dcb	"test"			;game code
	@dcb	"tt"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	       

start
	
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack
	
	
	;**** setze bildschirm

	mov 	r6,#$4000000   		;dma
	
	mov	r1,#$0400		;bg2	
	strh 	r1,[r6]			;store
	
	;**** setze gfx modes
	
	mov	r2,$10c0		;256, 2048*16, MOSAIC
	strh	r2,[r6,$c]		;reg_bg2
	
	
	;**** setze paletten
	
	mov	r5,#$5000000		;pal
	mvn	r0,#0
	
	strh	r0,[r5]
	
	;**** schalte irqs an
	
	ldr	r0,[irqhandleradr]
	ldr	r1,[irqvectoradr]
	str	r0,[r1]

	mov 	r6,#$4000000   		;dma
	mov	r0,#$18			;h/v blank irq enable
	strh	r0,[r6,4]		;dispstat
	
	mov	r0,#$3			;h/v blank / irq master
	add	r5,r6,#$200
	strh	r0,[r5]			;h/v blank irq enable
	
	mov	r0,#1
	strh	r0,[r5,8]		;irq master enable
	
	
	mov	r5,#$5000000		;pal
	mov	r0,#0
	strh	r0,[r5]
	
end		
	b	end	

;*********** irq handler

;*************************** irqhandler (30.11.2002)
;*
;* r0 -r3 werden von bios/irq gesichert
;*
;**
irqhandler

	mov	r3,sp
	ldr	sp,[irqstackadr]	;mein irq stack
	stmfd 	sp!,{r3,lr}

	mov	r0,#$4000000
	orr	r0,r0,#$200
		
	ldrh	r2,[r0,2]		;irq lesen
	strh	r2,[r0,2]		;irq ausschalten

	ands	r3,r2,#1		;vblank
	blne	vblank	

	ands	r3,r2,#2		;hblank
	blne	hblank	
	
		

	ldmfd	sp!,{r3,lr}
	mov	sp,r3
	bx	lr

;*********************************************************
	
hblank_test

	mov	r2,#$5000000		;pal
	mov	r1,#$4000000	
	orr	r1,r1,#6
	
	
	
	ldrh	r0,[r1]
	cmp	r0,#155
	moveq	r3,#$1f
	movne	r3,#$0
	
	strh	r3,[r2]
	

	mov	pc,lr
	

hblank

	ldr	r3,[colorcntadr]
	mov	r2,#$5000000		;pal
	
		
	ldrh	r0,[r3]	
	mov	r1,r0
	add	r0,r0,#32
	strh	r0,[r3]	
	 
	mov	r1,r1 lsr 8
	mov	r1,r1 lsl 5

	strh	r1,[r2]
	
	mov	pc,lr	
	
vblank

	mov	r0,#0
	ldr	r3,[colorcntadr]
	strh	r0,[r3]
	

	mov	pc,lr			
	
;*********************** Unterprogramme (extern) *******************

		@include	simple.s        	                 
                 
mystackadr	@DCD	mystack	   
debugmemadr	@dcd	debugmem
irqhandleradr	@DCD	irqhandler   
irqvectoradr	@DCD	$03007ffc   
colorcntadr	@DCD	colorcnt	
irqstackadr	@dcd	irqstack	    
                 
;**************************** RAM (32K) ****************************
@textarea $03000000

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte bei ed)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;


colorcnt	@DCW	0
