@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"fire chaos  "		;spiel name (12 byte)
	@dcb	"fire"			;game code
	@dcb	"f2"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$04		;mode 4 bg 2	
	strh 	r1,[r6]			;store
	
	;**** palette
	
	ldr 	r0,[paladr]
	mov	r1,#$5000000
	
	
	
	mov	r2,#256
palco
	ldr	r3,[r0],2	
	str	r3,[r1],2	

	subs	r2,r2,#1
	bne	palco	
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Dein Programm                                        **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************
	

	

	
	ldr	pc,[hotadr]
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Programmende                                         **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************


		
;*********************** Unterprogramme (extern) *******************

		@include	simple.s 
			
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Variablenadressen                                    **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************	
		      
mystackadr		@dcd	mystack	
hotadr			@dcd	hot
paladr			@dcd	pal

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

 

		
endofromcode		
	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
	

		
picadri		@dcd	pica
picbdri		@dcd	picb

objektadr		@dcd	objekt


seedadr	@dcd	seed
	
	
; word gba_rand(void);
; Returns a random word.

rand

	ldr	r3, [seedadr]		; Point at seeds.
	ldmia	r3, {r1,r2}		; Load them.
	tst	r2, r2, lsr #1		; Top bit into carry.
	movs	r4, r1, rrx		; 33 bit rotate right.
	adc	r2, r2, r2		; Carry into lsb of Rb.
	eor	r4, r4, r1, lsl #12	; (involved!)
	eor	r1, r4, r4, lsr #20	; (similarly involved!)
	stmia	r3, {r1,r2}		; Use these next time.
	mov	pc, lr
		
	

hot

;	ldr	r0,[picrdri]
;	ldr	r1,[picadri]

;	mov	r2,#120
;yl	mov	r3,#160
;xl	ldr	r4,[r0],2
;	str	r4,[r1],2
;	subs	r3,r3,#1
;	bne	xl
;	add	r0,r0,#(256-160)*2
;	subs	r2,r2,#1
;	bne	yl	
	
	
	mov	r1,#$1
	mvn	r2,r1
	ldr	r3, [seedadr]	
	stmia	r3, {r1,r2}	

loop
	
	bl	mvObjekt
	
	
	mov	r4,#$4000000
	ldr	r3,[r4,$130]
	ands	r4,r3,#$1
	blne	fireLine
	

	
	ldr	r1,[picadri]
	ldr	r0,[picbdri]
	mov	r10,#$6000000
	

	mov	r2,#160
yloop	

	mov	r3,#120
xloop
						
	ldrb	r5,[r1,240-1]
	ldrb	r9,[r1,240+2]
	ldrh	r6,[r1,240]
	ldrh	r4,[r1],2
	
	
	add	r9,r9,r4 lsr 8
	and	r4,r4 ,#$ff
	
	mov	r7,r6 lsr 8
	and	r6,r6,#$ff
	
	;
	; 00 00 00 
	; 00 r4 r8 
	; r5 r6 r7 r9   
	;
	
	add	r4,r4,r5
	add	r9,r9,r6
	add	r4,r4,r7
	add	r9,r9,r7
	add	r4,r4,r6
	
	mov	r8,r9 lsr 2
	mov	r4,r4 lsr 2
	
	
	; store
		
	orr	r4,r4,r8 lsl 8	
	strh	r4,[r0],2
	strh	r4,[r10],2
	

	
	;add	r1,r1,#1
	
	

	subs	r3,r3,#1
	bne	xloop
	
	
	subs	r2,r2,#1
	bne	yloop	
	
	;****
		
	ldr	r0,[picadri]
	ldr	r1,[picbdri]
	str	r0,[picbdri]
	str	r1,[picadri]
	
	
	b	loop
	

;*****		


ox	@dcw	120
oy	@dcw	240*80

mvObjekt

	
	
	mov	r4,#$4000000
	ldr	r3,[r4,$130]
	
	ldrh	r6,[ox]
	ldrh	r7,[oy]

	ands	r4,r3,#$0040
	subeq	r7,r7,#240
	
	ands	r4,r3,#$0080
	addeq	r7,r7,#240
	
	ands	r4,r3,#$0020
	subeq	r6,r6,#1
	
	ands	r4,r3,#$0010
	addeq	r6,r6,#1
	
	
	
	strh	r6,[ox]
	strh	r7,[oy]

	ldr	r0,[objektadr]
	ldr	r1,[picadri]
	add	r1,r1,r6
	add	r1,r1,r7
	
	
	mov	r6,#6
	
droby	
	mov	r5,#6
drobx	
	ldrb	r2,[r0],1
	cmp	r2,#0
	strneb	r2,[r1],1
	addeq	r1,r1,#1

	
	subs	r5,r5,#1
	bne	drobx
	
	add	r1,r1,#240-6
	
	
	subs	r6,r6,#1
	bne	droby

	mov	pc,lr
	
	
;****

fireLine
	mov	r12,lr
	
	ldr	r5,[picadri]
	mov	r6,#$100
gg

	bl	rand
	mov	r2,#$ff00
	orr	r2,r2,#$ff
	
	and	r1,r1,r2
	
	cmp	r1,#$9600
	movge	r1,r1 lsr 1
	
	
	mov	r0,#$ef
	strb	r0,[r5,r1]
	

	subs	r6,r6,#1
	bne	gg	
	
	mov	pc,r12

	

;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

seed		@dcd	0,0

endofeiramdata
	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

		
pal		@incbin	fire2.pal
		
objektx		
		@dcw	$0000,$0000,$001f,$001f,$0000,$0000
		@dcw	$0000,$0000,$001f,$001f,$0000,$0000
		@dcw	$001f,$001f,$001f,$001f,$001f,$001f
		@dcw	$001f,$001f,$001f,$001f,$001f,$001f
		@dcw	$0000,$0000,$001f,$001f,$0000,$0000
		@dcw	$0000,$0000,$001f,$001f,$0000,$0000
		
objekt		
		@dcb	$00,$00,$00,$00,$00,$00
		@dcb	$00,$00,$00,$00,$00,$00
		@dcb	$ef,$ef,$ef,$ef,$ef,$ef
		@dcb	$00,$ef,$ef,$ef,$ef,$00
		@dcb	$00,$00,$ef,$ef,$00,$00
		@dcb	$00,$00,$ef,$ef,$00,$00		
              
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000

		@dcw	0
pica		@dup	dcb	(240*161),0
		@dcw	0
		@dcw	0
picb		@dup	dcb	(240*161)*2,0
		@dcw	0

		@endarea
endofewramcode




