@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"linear blur2"		;spiel name (12 byte)
	@dcb	"libu"			;game code
	@dcb	"lb"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$03		;mode 3 bg 2	
	strh 	r1,[r6]			;store
	
	ldr	r0,[picadr]
	ldr	r1,[picbadr]
	
	mov	r2,#(240*160*2)
	bl	dmacpy	
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Dein Programm                                        **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************
	ldr	r0,[nochmaladr]
	mov	pc,r0
	;bl	nochmal
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Programmende                                         **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************


		
;*********************** Unterprogramme (extern) *******************

		@include	simple.s 
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Variablenadressen                                    **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************	
		      
mystackadr		@dcd	mystack	
picadr			@dcd	pic
picbadr			@dcd	picbuffer
div3adr			@dcd	div3
nochmaladr		@dcd	nochmal

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

endofromcode 

	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
		
picbadr2	@dcd	picbuffer
picadr2		@dcd	pic
	
restoreOriginal

	mov	r9,#$6000000
	ldr	r8,[picadr2]
	mov	r7,#(240*160*2)/4
copys2
	ldr	r6,[r8],4
	str	r6,[r9],4
	
	subs	r7,r7,#1
	bne	copys2	

	mov	pc,lr

		
	
nochmal	
	
	bl	restoreOriginal	
	
nochmalund
	
	;**** ist idiotisch aber egal
	
	;warte auf taste a
	
	mov	r0,#$4000000
	
warteAufTaste
	
	ldr	r1,[r0,$130]			
	
	ands	r2,r1,#%1		;A
	beq	weiter
	
	ands	r2,r1,#%10		;B
	bleq	restoreOriginal	
	
	b	warteAufTaste
	
weiter	
	
	
	moveq	r0,#$6000000
	ldr	r1,[picbadr2]
	mov	r2,#(240*160*2)/4
copys
	ldr	r3,[r0],4
	str	r3,[r1],4
	
	subs	r2,r2,#1
	bne	copys	
	
;************* blur 

	ldr 	r0,[picbadr2]

	mov 	r1,#$6000000
	
	mov	r2,#76800/2
	sub	r2,r2,#4
	
loop	
	ldrh	r3,[r0,-2]
	ldrh	r4,[r0]
	ldrh	r5,[r0,2]
	
	add	r0,r0,2
	
	and	r6,r3,#$001f
	and	r7,r4,#$001f
	and	r8,r5,#$001f
	
	and	r9,r3,#$03e0
	and	r10,r4,#$03e0
	and	r11,r5,#$03e0
	
	and	r3,r3,#$7c00
	and	r4,r4,#$7c00
	and	r5,r5,#$7c00
	
	add	r6,r6,r8
	add	r6,r6,r7 lsl 1
	
	mov	r9,r9 lsr 5
	add	r9,r9,r11 lsr 5
	add	r9,r9,r10 lsr 4
	
	mov	r3,r3 lsr 10
	add	r3,r3,r4 lsr 10
	add	r3,r3,r5 lsr 9
	
	mov	r6,r6 lsr 2
	mov	r9,r9 lsr 2
	mov	r3,r3 lsr 2
	
	orr	r6,r6,r9 lsl 5
	orr	r6,r6,r3 lsl 10
	
	
	;mov	r6,r6 lsr 2
	
	strh	r6,[r1],2
	
	subs	r2,r2,#1
	bne	loop
	

		
	
	b	nochmalund
	
;*****		

;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata
	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

pic		@incbin 	Bild.gfx		

div3  
  
  @dcb  0
  @dcb  0
  @dcb  0
  @dcb  1
  @dcb  1
  @dcb  1
  @dcb  2
  @dcb  2
  @dcb  2
  @dcb  3
  @dcb  3
  @dcb  3
  @dcb  4
  @dcb  4
  @dcb  4
  @dcb  5
  @dcb  5
  @dcb  5
  @dcb  6
  @dcb  6
  @dcb  6
  @dcb  7
  @dcb  7
  @dcb  7
  @dcb  8
  @dcb  8
  @dcb  8
  @dcb  9
  @dcb  9
  @dcb  9
  @dcb  10
  @dcb  10
  @dcb  10
  @dcb  11
  @dcb  11
  @dcb  11
  @dcb  12
  @dcb  12
  @dcb  12
  @dcb  13
  @dcb  13
  @dcb  13
  @dcb  14
  @dcb  14
  @dcb  14
  @dcb  15
  @dcb  15
  @dcb  15
  @dcb  16
  @dcb  16
  @dcb  16
  @dcb  17
  @dcb  17
  @dcb  17
  @dcb  18
  @dcb  18
  @dcb  18
  @dcb  19
  @dcb  19
  @dcb  19
  @dcb  20
  @dcb  20
  @dcb  20
  @dcb  21
  @dcb  21
  @dcb  21
  @dcb  22
  @dcb  22
  @dcb  22
  @dcb  23
  @dcb  23
  @dcb  23
  @dcb  24
  @dcb  24
  @dcb  24
  @dcb  25
  @dcb  25
  @dcb  25
  @dcb  26
  @dcb  26
  @dcb  26
  @dcb  27
  @dcb  27
  @dcb  27
  @dcb  28
  @dcb  28
  @dcb  28
  @dcb  29
  @dcb  29
  @dcb  29
  @dcb  30
  @dcb  30
  @dcb  30
  @dcb  31
  @dcb  31
  @dcb  31
  @dcb  32
  @dcb  32
  @dcb  32
  @dcb  33
  @dcb  33
  @dcb  33
  @dcb  34
  @dcb  34
  @dcb  34
  @dcb  35
  @dcb  35
  @dcb  35
  @dcb  36
  @dcb  36
  @dcb  36
  @dcb  37
  @dcb  37
  @dcb  37
  @dcb  38
  @dcb  38
  @dcb  38
  @dcb  39
  @dcb  39
  @dcb  39
  @dcb  40
  @dcb  40
  @dcb  40
  @dcb  41
  @dcb  41
  @dcb  41
  @dcb  42
  @dcb  42
  @dcb  42
  @dcb  43
  @dcb  43
  @dcb  43
  @dcb  44
  @dcb  44
  @dcb  44
  @dcb  45
  @dcb  45
  @dcb  45
  @dcb  46
  @dcb  46
  @dcb  46
  @dcb  47
  @dcb  47
  @dcb  47
  @dcb  48
  @dcb  48
  @dcb  48
  @dcb  49
  @dcb  49
  @dcb  49
  @dcb  50
  @dcb  50
  @dcb  50
  @dcb  51
  @dcb  51
  @dcb  51
  @dcb  52
  @dcb  52
  @dcb  52
  @dcb  53
  @dcb  53
  @dcb  53
  @dcb  54
  @dcb  54
  @dcb  54
  @dcb  55
  @dcb  55
  @dcb  55
  @dcb  56
  @dcb  56
  @dcb  56
  @dcb  57
  @dcb  57
  @dcb  57
  @dcb  58
  @dcb  58
  @dcb  58
  @dcb  59
  @dcb  59
  @dcb  59
  @dcb  60
  @dcb  60
  @dcb  60
  @dcb  61
  @dcb  61
  @dcb  61
  @dcb  62
  @dcb  62
  @dcb  62
  @dcb  63
  @dcb  63
  @dcb  63
  @dcb  64
  @dcb  64
  @dcb  64
  @dcb  65
  @dcb  65
  @dcb  65
  @dcb  66
  @dcb  66
  @dcb  66
  @dcb  67
  @dcb  67
  @dcb  67
  @dcb  68
  @dcb  68
  @dcb  68
  @dcb  69
  @dcb  69
  @dcb  69
  @dcb  70
  @dcb  70
  @dcb  70
  @dcb  71
  @dcb  71
  @dcb  71
  @dcb  72
  @dcb  72
  @dcb  72
  @dcb  73
  @dcb  73
  @dcb  73
  @dcb  74
  @dcb  74
  @dcb  74
  @dcb  75
  @dcb  75
  @dcb  75
  @dcb  76
  @dcb  76
  @dcb  76
  @dcb  77
  @dcb  77
  @dcb  77
  @dcb  78
  @dcb  78
  @dcb  78
  @dcb  79
  @dcb  79
  @dcb  79
  @dcb  80
  @dcb  80
  @dcb  80
  @dcb  81
  @dcb  81
  @dcb  81
  @dcb  82
  @dcb  82
  @dcb  82
  @dcb  83
  @dcb  83
  @dcb  83
  @dcb  84
  @dcb  84
  @dcb  84
  @dcb  85
  @dcb  85
  @dcb  85
  @dcb  86
  @dcb  86
  @dcb  86
  @dcb  87
  @dcb  87
  @dcb  87
  @dcb  88
  @dcb  88
  @dcb  88
  @dcb  89
  @dcb  89
  @dcb  89
  @dcb  90
  @dcb  90
  @dcb  90
  @dcb  91
  @dcb  91
  @dcb  91
  @dcb  92
  @dcb  92
  @dcb  92
  @dcb  93
  @dcb  93
  @dcb  93
  @dcb  94
  @dcb  94
  @dcb  94
  @dcb  95
  @dcb  95
  @dcb  95
  @dcb  96
  @dcb  96
  @dcb  96
  @dcb  97
  @dcb  97
  @dcb  97
  @dcb  98
  @dcb  98
  @dcb  98
  @dcb  99
  @dcb  99
  @dcb  99
  @dcb  100
  @dcb  100
  @dcb  100
  @dcb  101
  @dcb  101
  @dcb  101
  @dcb  102
  @dcb  102
  @dcb  102
  @dcb  103
  @dcb  103
  @dcb  103
  @dcb  104
  @dcb  104
  @dcb  104
  @dcb  105
  @dcb  105
  @dcb  105
  @dcb  106
  @dcb  106
  @dcb  106
  @dcb  107
  @dcb  107
  @dcb  107
  @dcb  108
  @dcb  108
  @dcb  108
  @dcb  109
  @dcb  109
  @dcb  109
  @dcb  110
  @dcb  110
  @dcb  110
  @dcb  111
  @dcb  111
  @dcb  111
  @dcb  112
  @dcb  112
  @dcb  112
  @dcb  113
  @dcb  113
  @dcb  113
  @dcb  114
  @dcb  114
  @dcb  114
  @dcb  115
  @dcb  115
  @dcb  115
  @dcb  116
  @dcb  116
  @dcb  116
  @dcb  117
  @dcb  117
  @dcb  117
  @dcb  118
  @dcb  118
  @dcb  118
  @dcb  119
  @dcb  119
  @dcb  119
  @dcb  120
  @dcb  120
  @dcb  120
  @dcb  121
  @dcb  121
  @dcb  121
  @dcb  122
  @dcb  122
  @dcb  122
  @dcb  123
  @dcb  123
  @dcb  123
  @dcb  124
  @dcb  124
  @dcb  124
  @dcb  125
  @dcb  125
  @dcb  125
  @dcb  126
  @dcb  126
  @dcb  126
  @dcb  127
  @dcb  127
  @dcb  127
  @dcb  128
  @dcb  128
  @dcb  128
  @dcb  129
  @dcb  129
  @dcb  129
  @dcb  130
  @dcb  130
  @dcb  130
  @dcb  131
  @dcb  131
  @dcb  131
  @dcb  132
  @dcb  132
  @dcb  132
  @dcb  133
  @dcb  133
  @dcb  133
  @dcb  134
  @dcb  134
  @dcb  134
  @dcb  135
  @dcb  135
  @dcb  135
  @dcb  136
  @dcb  136
  @dcb  136
  @dcb  137
  @dcb  137
  @dcb  137
  @dcb  138
  @dcb  138
  @dcb  138
  @dcb  139
  @dcb  139
  @dcb  139
  @dcb  140
  @dcb  140
  @dcb  140
  @dcb  141
  @dcb  141
  @dcb  141
  @dcb  142
  @dcb  142
  @dcb  142
  @dcb  143
  @dcb  143
  @dcb  143
  @dcb  144
  @dcb  144
  @dcb  144
  @dcb  145
  @dcb  145
  @dcb  145
  @dcb  146
  @dcb  146
  @dcb  146
  @dcb  147
  @dcb  147
  @dcb  147
  @dcb  148
  @dcb  148
  @dcb  148
  @dcb  149
  @dcb  149
  @dcb  149
  @dcb  150
  @dcb  150
  @dcb  150
  @dcb  151
  @dcb  151
  @dcb  151
  @dcb  152
  @dcb  152
  @dcb  152
  @dcb  153
  @dcb  153
  @dcb  153
  @dcb  154
  @dcb  154
  @dcb  154
  @dcb  155
  @dcb  155
  @dcb  155
  @dcb  156
  @dcb  156
  @dcb  156
  @dcb  157
  @dcb  157
  @dcb  157
  @dcb  158
  @dcb  158
  @dcb  158
  @dcb  159
  @dcb  159
  @dcb  159
  @dcb  160
  @dcb  160
  @dcb  160
  @dcb  161
  @dcb  161
  @dcb  161
  @dcb  162
  @dcb  162
  @dcb  162
  @dcb  163
  @dcb  163
  @dcb  163
  @dcb  164
  @dcb  164
  @dcb  164
  @dcb  165
  @dcb  165
  @dcb  165
  @dcb  166
  @dcb  166
  @dcb  166
  @dcb  167
  @dcb  167
  @dcb  167
  @dcb  168
  @dcb  168
  @dcb  168
  @dcb  169
  @dcb  169
  @dcb  169
  @dcb  170
  @dcb  170
  @dcb  170
  @dcb  171
  @dcb  171
  @dcb  171
  @dcb  172
  @dcb  172
  @dcb  172
  @dcb  173
  @dcb  173
  @dcb  173
  @dcb  174
  @dcb  174
  @dcb  174
  @dcb  175
  @dcb  175
  @dcb  175
  @dcb  176
  @dcb  176
  @dcb  176
  @dcb  177
  @dcb  177
  @dcb  177
  @dcb  178
  @dcb  178
  @dcb  178
  @dcb  179
  @dcb  179
  @dcb  179
  @dcb  180
  @dcb  180
  @dcb  180
  @dcb  181
  @dcb  181
  @dcb  181
  @dcb  182
  @dcb  182
  @dcb  182
  @dcb  183
  @dcb  183
  @dcb  183
  @dcb  184
  @dcb  184
  @dcb  184
  @dcb  185
  @dcb  185
  @dcb  185
  @dcb  186
  @dcb  186
  @dcb  186
  @dcb  187
  @dcb  187
  @dcb  187
  @dcb  188
  @dcb  188
  @dcb  188
  @dcb  189
  @dcb  189
  @dcb  189
  @dcb  190
  @dcb  190
  @dcb  190
  @dcb  191
  @dcb  191
  @dcb  191
  @dcb  192
  @dcb  192
  @dcb  192
  @dcb  193
  @dcb  193
  @dcb  193
  @dcb  194
  @dcb  194
  @dcb  194
  @dcb  195
  @dcb  195
  @dcb  195
  @dcb  196
  @dcb  196
  @dcb  196
  @dcb  197
  @dcb  197
  @dcb  197
  @dcb  198
  @dcb  198
  @dcb  198
  @dcb  199
  @dcb  199
  @dcb  199
  @dcb  200
  @dcb  200
  @dcb  200
  @dcb  201
  @dcb  201
  @dcb  201
  @dcb  202
  @dcb  202
  @dcb  202
  @dcb  203
  @dcb  203
  @dcb  203
  @dcb  204
  @dcb  204
  @dcb  204
  @dcb  205
  @dcb  205
  @dcb  205
  @dcb  206
  @dcb  206
  @dcb  206
  @dcb  207
  @dcb  207
  @dcb  207
  @dcb  208
  @dcb  208
  @dcb  208
  @dcb  209
  @dcb  209
  @dcb  209
  @dcb  210
  @dcb  210
  @dcb  210
  @dcb  211
  @dcb  211
  @dcb  211
  @dcb  212
  @dcb  212
  @dcb  212
  @dcb  213
  @dcb  213
  @dcb  213
  @dcb  214
  @dcb  214
  @dcb  214
  @dcb  215
  @dcb  215
  @dcb  215
  @dcb  216
  @dcb  216
  @dcb  216
  @dcb  217
  @dcb  217
  @dcb  217
  @dcb  218
  @dcb  218
  @dcb  218
  @dcb  219
  @dcb  219
  @dcb  219
  @dcb  220
  @dcb  220
  @dcb  220
  @dcb  221
  @dcb  221
  @dcb  221
  @dcb  222
  @dcb  222
  @dcb  222
  @dcb  223
  @dcb  223
  @dcb  223
  @dcb  224
  @dcb  224
  @dcb  224
  @dcb  225
  @dcb  225
  @dcb  225
  @dcb  226
  @dcb  226
  @dcb  226
  @dcb  227
  @dcb  227
  @dcb  227
  @dcb  228
  @dcb  228
  @dcb  228
  @dcb  229
  @dcb  229
  @dcb  229
  @dcb  230
  @dcb  230
  @dcb  230
  @dcb  231
  @dcb  231
  @dcb  231
  @dcb  232
  @dcb  232
  @dcb  232
  @dcb  233
  @dcb  233
  @dcb  233
  @dcb  234
  @dcb  234
  @dcb  234
  @dcb  235
  @dcb  235
  @dcb  235
  @dcb  236
  @dcb  236
  @dcb  236
  @dcb  237
  @dcb  237
  @dcb  237
  @dcb  238
  @dcb  238
  @dcb  238
  @dcb  239
  @dcb  239
  @dcb  239
  @dcb  240
  @dcb  240
  @dcb  240
  @dcb  241
  @dcb  241
  @dcb  241
  @dcb  242
  @dcb  242
  @dcb  242
  @dcb  243
  @dcb  243
  @dcb  243
  @dcb  244
  @dcb  244
  @dcb  244
  @dcb  245
  @dcb  245
  @dcb  245
  @dcb  246
  @dcb  246
  @dcb  246
  @dcb  247
  @dcb  247
  @dcb  247
  @dcb  248
  @dcb  248
  @dcb  248
  @dcb  249
  @dcb  249
  @dcb  249
  @dcb  250
  @dcb  250
  @dcb  250
  @dcb  251
  @dcb  251
  @dcb  251
  @dcb  252
  @dcb  252
  @dcb  252
  @dcb  253
  @dcb  253
  @dcb  253
  @dcb  254
  @dcb  254
  @dcb  254
  @dcb  255
  @dcb  255
  @dcb  255

              
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000

		@dcb	0
picbuffer	@dup	dcb	(240*160*2),0	
		@dcb	0	
		
		@endarea
endofewramcode




