@echo   ""
@echo   " Programmgroesse (ROM) ~ $",endofromcode-startofromcode, "Bytes"
@echo	" Programmgroesse (IRAM)= $",endofiwramcode-startofiwramcode-(endofeiramdata-startofeiramdata), "Bytes"
@echo   ""
@echo   " Datengroesse    (ROM) ~ $",endofromdata-startofromdata, "Bytes"
@echo   " Datengroesse    (WRAM)= $",endofewramcode-startofewramcode, "Bytes"
@echo   " Datengroesse    (IRAM)= $",endofeiramdata-startofeiramdata, "Bytes"


@define DMAMODE			;fr batgba ausschalten

	b	startofromcode		;skip header
	@include nintendologo.s		;nintendo logo (sonst macht original rger)
	@dcb	"grad. blur2 "		;spiel name (12 byte)
	@dcb	"gb2 "			;game code
	@dcb	"tt"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area
	
	
	
;*************************** ROM CODE ***********************************
startofromcode
            
	;**** wichtige sachen

	ldr	sp,[mystackadr]		;mystack	
	
	;**** schalte prefetch an
	
	mov 	r6,#$4000000   		;dma
	orr	r5,r6,#$200
	orr	r5,r5,#$4
	mov	r0,#$4300
	orr	r0,r0,#$17
	strh	r0,[r5]
	
	;**** kopiere iramcode            
            
	ldr 	r0,[startofiwramcodeadr]
	mov	r1,#$3000000
	ldr 	r3,[endofiwramcodeadr]
	sub	r2,r3,r0
	bl	dmacpy			     		
	
	;**** setze bildschirm
	
	mov 	r6,#$4000000   		;dma
	mov	r1,#$0400
	orr	r1,r1,#$03		;mode 3 bg 2	
	strh 	r1,[r6]			;store
	
	ldr	r0,[picadr]
	ldr	r1,[picbadr]
	
	mov	r2,#(240*160*2)
	bl	dmacpy	
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Dein Programm                                        **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************
	ldr	r0,[nochmaladr]
	mov	pc,r0
	;bl	nochmal
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Programmende                                         **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************


		
;*********************** Unterprogramme (extern) *******************

		@include	simple.s 
	
;******************************************************************************************
;******************************************************************************************
;**                                                                                      **
;**                                 Variablenadressen                                    **
;**                                                                                      **
;******************************************************************************************
;******************************************************************************************	
		      
mystackadr		@dcd	mystack	
picadr			@dcd	pic
picbadr			@dcd	picbuffer
;div3adr			@dcd	div3
nochmaladr		@dcd	nochmal

startofiwramcodeadr	@dcd	startofiwramcode
endofiwramcodeadr	@dcd	endofiwramcode

endofromcode 

	
;*************************** IRAM CODE ************************************
startofiwramcode	
		@textarea $03000000
		
picbadr2	@dcd	picbuffer
picadr2		@dcd	pic
	
restoreOriginal

	mov	r9,#$6000000
	ldr	r8,[picadr2]
	mov	r7,#(240*160*2)/4
copys2
	ldr	r6,[r8],4
	str	r6,[r9],4
	
	subs	r7,r7,#1
	bne	copys2	

	mov	pc,lr

		
	
nochmal	
	
	bl	restoreOriginal	
	
nochmalund
	
	;**** ist idiotisch aber egal
	
	;warte auf taste a
	
	mov	r0,#$4000000
	
warteAufTaste
	
	ldr	r1,[r0,$130]			
	
	ands	r2,r1,#%1		;A
	beq	weiter
	
	ands	r2,r1,#%10		;B
	bleq	restoreOriginal	
	
	b	warteAufTaste
	
weiter	
	
	
	moveq	r0,#$6000000
	ldr	r1,[picbadr2]
	mov	r2,#(240*160*2)/4
copys
	ldr	r3,[r0],4
	str	r3,[r1],4
	
	subs	r2,r2,#1
	bne	copys	
	
;************* blur 

	ldr 	r0,[picbadr2]

	mov 	r1,#$6000000
	
	mov	r2,#76800/2
	sub	r2,r2,#4
	
loop	
	ldrh	r3,[r0,-2]
	;mvn	r3,r3
	ldrh	r5,[r0,2]
	;mvn	r5,r5
		
	and	r6,r3,#$001f
	and	r8,r5,#$001f
	
	and	r9,r3,#$03e0
	and	r11,r5,#$03e0
	
	and	r3,r3,#$7c00
	and	r5,r5,#$7c00
	
	add	r6,r6,r8
	add	r9,r9,r11 
	add	r3,r3,r5  
	
	mov	r9,r9 lsr 5
	mov     r3,r3 lsr 10
	
	mov	r6,r6 lsr 1
	mov	r9,r9 lsr 1
	mov	r3,r3 lsr 1
	
	orr	r6,r6,r9 lsl 5
	orr	r6,r6,r3 lsl 10
	
	add	r0,r0,2
	
	strh	r6,[r1],2
	
	subs	r2,r2,#1
	bne	loop
	

		
	
	b	nochmalund
	
;*****		

;**************************** IRAM DATA ****************************

startofeiramdata
		
irqstackadr	@dcd	irqstack

debugmem	@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
mystack		@DCD	0;	512 Byte Stack + (4Byte sec)

		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		@DCD	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
irqstack	@DCD	0;

endofeiramdata
	
		@endarea
		
endofiwramcode 		
 	    
 
;*************************** ROM DATA ***********************************
startofromdata

pic		@incbin 	Bild.gfx		


              
endofromdata 
                         
;*************************** WRAM DATA ***********************************

startofewramcode
		@textarea $02000000

		@dcb	0
picbuffer	@dup	dcb	(240*160*2),0	
		@dcb	0	
		
		@endarea
endofewramcode




