/***************************************************************************
                          main.cpp  -  SDLSprite_Example2
                             -------------------
    begin                : lun oct  2 19:27:48 CEST 2000
    copyright            : (C) 2000 by Regis Quercioli
    email                : edorul@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <SDL/SDL.h>
#include "SDLSprite.h"

#define  TRUE    SDL_TRUE
#define  FALSE   SDL_FALSE

// program variables
#define Screen_w	640     // Width ecran affiche
#define Screen_h	480     // Height ecran affiche
#define Screen_bpp	16      // Nb de bits par pixel

SDL_Surface *screen;   		// screen surface
SDL_Event event;
SDLSprite *voiture;			// THE sprite

// arrow key used ?
int		 FD=0,      // right arrow pressed
		 FG=0,      // left  ----- -------
		 FH=0,      // up    ----- -------
		 FB=0;      // down  ----- -------

// Frame rate counters
Uint32	LastTime        = 0;
Uint32	CurTime         = 0;
double	DeltaTime       = 0;    // time between 2 frames

// out with done=1
int done=0;
 	
//////////////////////////////////////////////////
// if something goes wrong with SDL
//////////////////////////////////////////////////
void ComplainAndExit(void)
{
	fprintf(stderr, "Problem: %s\n", SDL_GetError());
}


double Delta_Time(void)
{
	CurTime   = SDL_GetTicks();
	DeltaTime = (CurTime - LastTime)/1000.0;
	LastTime  = CurTime;
	
	return DeltaTime;
}

//////////////////////////////////
// SDL Initialization
//////////////////////////////////
void InitSDL()
{
 	/* Initialize SDL */
	if ( SDL_Init(SDL_INIT_VIDEO) < 0 )
		ComplainAndExit();

	atexit(SDL_Quit);
	
	/* Set the video mode */
	screen = SDL_SetVideoMode(Screen_w, Screen_h, Screen_bpp, SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN);
	if ( screen == NULL )
		ComplainAndExit();

	SDL_ShowCursor(0);  // hide the mouse system cursor
}

/////////////////////////////////////
// "game" Initialization
/////////////////////////////////////
void InitGame()
{
	/* Sprite loading and init */
	voiture = new SDLSprite("/cd/Voiture2.bmp", 32, 32, 24);
	voiture->SetPos(Screen_w/2, Screen_h/2);
	voiture->SetVel(200,200);
	voiture->SetColorKey();
	voiture->m_Delay = 50;
	voiture->m_NbFrame = 3;
	voiture->InitShadow(4,4,200,125);
}

//////////////////////////////////////////////////////
// - calc if the player actions are autorized
// - calc the good animation frame
// - sprite drawing
//////////////////////////////////////////////////////
void UpdatePlayer()
{
	int base;
	
	if (FD == 1)
	{
		base=6;
		
		voiture->m_PosX += (voiture->m_VelX*DeltaTime);
		if (voiture->m_PosX > (Screen_w-32-voiture->m_ShadowOffsetX))
			voiture->m_PosX = Screen_w-32-voiture->m_ShadowOffsetX;	
	}
	if (FG == 1)
	{
		base=18;
		
		voiture->m_PosX -= (voiture->m_VelX*DeltaTime);
		if (voiture->m_PosX < 0)
			voiture->m_PosX = 0;	
	}
	if (FB == 1)
	{
		if (FD == 1)
			base=9;
		else if (FG == 1)
			base=15;
		else
			base=12;
		
		voiture->m_PosY += (voiture->m_VelY*DeltaTime);
		if (voiture->m_PosY > (Screen_h-32-voiture->m_ShadowOffsetY))
			voiture->m_PosY = Screen_h-32-voiture->m_ShadowOffsetY;	
	}
	if (FH == 1)
	{
		if (FD == 1)
			base=3;
		else if (FG == 1)
			base=21;
		else
			base=0;
		
		voiture->m_PosY -= (voiture->m_VelY*DeltaTime);
		if (voiture->m_PosY < 0)
			voiture->m_PosY = 0;	
	}
	
	if ((FH+FB+FD+FG) != 0)
	{	
		/* calc the good animation frame */
		voiture->m_Frame = base+(SDL_GetTicks()/voiture->m_Delay)%voiture->m_NbFrame;
	}
	voiture->Draw(screen, 0, 0);  // 0,0 because there's no scrolling
}

////////////////////////////////////////////////////////////////
// look if : - a key is pressed or released
////////////////////////////////////////////////////////////////
void EventsHandle()
{
	while ( SDL_PollEvent(&event) )
	{
		switch (event.type)
		{
			case SDL_KEYDOWN:
				switch (event.key.keysym.sym)
				{
					case SDLK_ESCAPE: // ESC key press quits the app...
						done = 1;
						break;
					case SDLK_RIGHT:
						FD=1;
						break;
                    case SDLK_LEFT:
                    	FG=1;
                    	break;
                    case SDLK_UP:
                    	FH=1;
                    	break;
                    case SDLK_DOWN:
                    	FB=1;
                    	break;
                    case SDLK_d:
                    	SDL_SaveBMP(screen, "SDLSprite_Example2.bmp");
                    	break;
					default:
						break;
				}
				break;
			case SDL_KEYUP:   // because if we keep pressed there is onlu one event
			                  // but we must repeat the sprite's deplacement
				switch (event.key.keysym.sym)
				{
					case SDLK_RIGHT:
						FD=0;
						break;
                    case SDLK_LEFT:
                    	FG=0;
                    	break;
                    case SDLK_UP:
                    	FH=0;
                    	break;
                    case SDLK_DOWN:
                    	FB=0;
                    	break;
					default:
						break;
				}
				break;
			case SDL_QUIT:
				done = 1;
				break;
			default:
				break;
		}
	}
}

int main(int argc, char *argv[])
{
	SDL_Rect *dstrect;
	
	/* SDL Initialization */
	InitSDL();
	
	/* "Game" Initialization */
	InitGame();
	dstrect->w = voiture->m_BlockWidth+voiture->m_ShadowOffsetX;
	dstrect->h = voiture->m_BlockHeight+voiture->m_ShadowOffsetY;
	
	/* Game Loop */
	while ( !done )
	{
		Delta_Time();
		EventsHandle();
		
		dstrect->x = (int)voiture->m_PosX;
		dstrect->y = (int)voiture->m_PosY;
		SDL_FillRect(screen, dstrect, 0);
		
		UpdatePlayer();
		
		SDL_Flip(screen);  // works even if we're not double-buffering
	}
	
	SDL_FreeSurface(screen);
	return 0;
}
