{----------------------------}
{      <<<TURBOPIC>>>        }
{    By Jeff Duntemann       }
{    Turbo Pascal V2.0       }
{   Last Update 12/11/84     }
{----------------------------}
PROGRAM TURBOPIC;            {Converts BASICA BLOAD screen images}
                             {to pure memory images of the video }
                             {refresh buffer}

Type GBUFF         = Array [0..16383] of Byte; {A graphics screen}
                                               {buffer}
     BASCREEN      = Record                    {A screen saved   }
                                               {via BLOAD}
                       HEADER : Array [0..6] of Byte;
                       SCREEN : GBUFF;
                     End;
Var BASFILE        : File of BASCREEN;
    BASIC_SCREEN   : BASCREEN;
    TURBO_SCREEN   : File;
    BASIC_NAME     : String[80];
    TURBO_NAME     : String[80];
    VISIBUF        : GBUFF Absolute $B800 : $0000;

Begin
  Write('>>Enter the name of the BASICA-format screen file: ');
  ReadLn(BASIC_NAME);
  Assign(BASFILE,BASIC_NAME);     {Check if requested file exists}
  Reset(BASFILE);
  If IORESULT = 255 Then
    WriteLn(BASIC_NAME,' is not on disk!  Try again... ')
  Else
    Begin
      Write('>>Enter the name of the Turbo-Format screen file:  ');
      ReadLn(TURBO_NAME);
      GraphColorMode;             {Switch to graphics mode}
      Read(BASFILE,BASIC_SCREEN); {Read the BASICA saved file to RAM}
      Close(BASFILE);
                                  {Now move just the SCREEN part}
                                  {to the video refresh buffer}
      Move(BASIC_SCREEN.SCREEN,VISIBUF,SizeOf(BASIC_SCREEN.SCREEN));
                                  {Write Out screen image}
                                  {to Turbo file}
      Assign(TURBO_SCREEN,TURBO_NAME);
      ReWrite(TURBO_SCREEN);
      BlockWrite(TURBO_SCREEN,VISIBUF,128);
      Close(TURBO_SCREEN);
                                  {And load it again to prove}
                                  {it is Okay}
      GoToXY(13,12); Write('<<PRESS RETURN:>>');
      ReadLn;
      FillChar(VISIBUF,SizeOf(VISIBUF),Chr(0)); {This clears the}
                                               {graphics buffer}
      Assign(TURBO_SCREEN,TURBO_NAME);
      Reset(TURBO_SCREEN);
      BlockRead(TURBO_SCREEN,VISIBUF,128); {BlockRead the screen}
                                           {to the buffer}
      Close(TURBO_SCREEN);
      ReadLn;
      TextMode                    {Wait for (CR) and exit}
    End
End.
                                                                                                 