'*****************************************************
' This is an example of using PEEK to read the user
' specified contents of memory.  DUMPMEM.BAS
' Functionally, it is very similar to READMEM except i
' DUMPMEM is command line driven.  A user could
' easily combine the two into one program by testing
' for a command line first and then prompting for
' input if the program is run without a command line.
'
' By:  George Spafford  Copyright 1993
'                       All Rights Reserved
'
' No external libraries are required
'
' v1.0  05/01/93
'
'*****************************************************

DEFINT A-Z

title$ = "S3 Demo of Dumping Memory v1.0         Copyright George Spafford 04/30/93"
PRINT
PRINT title$
PRINT

'One neat ability of BASIC is its ability to have a hexadecimal value
'specified during input and convert it on the fly.  In this example, I
'am not performing any error trapping.  Usually, I input to a string,
'check and see if it is NULL and then exit the program.  It serves as
'a back door for users who want to exit the program.  Here, I am just
'inputting directly do an integer. If the user enters a hex value in the
'form of &Hnnnn, the program will use it.  However, if they get carried
'away, they can cause an overflow condition by exceding the bounds of
'an integer.

CL$ = LTRIM$(RTRIM$(UCASE$(COMMAND$)))
IF INSTR(CL$, "?") > 0 OR CL$ = "" THEN GOTO CLHelp
a = INSTR(CL$, ":")
IF a = 0 THEN GOTO CLHelp

Segment = VAL(LEFT$(CL$, (a - 1)))
Offset = VAL(MID$(CL$, (a + 1)))
Length = 64

PRINT

DEF SEG = Segment                                   'set default segment to 0000
FOR n = Offset TO (Offset + (Length - 1)) STEP 1    'start at offset and look at
                                                    'at the bytes
    T$ = HEX$(PEEK(n))                              'get the values at offset
    IF LEN(T$) = 1 THEN T$ = "0" + T$               'HEX$ doesn't add "0" if
                                                    'it is the first byte.
    PRINT T$; " ";                                  'print it
    CharLine = CharLine + 1                         'track hex codes one screen
    IF CharLine = 8 AND Length <> 8 THEN            'if 8 codes and user wanted
                                                    'more than eight, add hyphen
       PRINT "- ";
    END IF
    IF CharLine = 16 THEN                           'if 16 codes on screen, then
       PRINT                                        'do a line feed
       CharLine = 0
    END IF
NEXT n                                      'do next n
DEF SEG                                     'return to BASIC segment

PRINT
END


CLHelp:
    CLS
    PRINT title$
    PRINT
    PRINT "Usage:  DUMPMEM Segment:Offset"
    PRINT
    PRINT "        Segment is the memory segment"
    PRINT "        Offset is the memory offset"
    PRINT
    PRINT "Numbers are integer by default.  To enter a hexadecimal number,"
    PRINT "prefix the number with &H.  For example &H400 is 400 hex."
    PRINT
    PRINT "DUMPMEM will then display 64 bytes starting at the given location"
    PRINT "in hexadecimal."
    PRINT
    END

