DEFINT A-Z

'$INCLUDE: 'QBXM.BI'

COMMON SHARED paramBuffer AS STRING * 530

'$DYNAMIC:

DIM test1(1 TO 32000)
DIM rec1 AS STRING * 20
DIM rec2 AS STRING * 20

'========================================================================
'
'   Comment out the below for invoking this program by a RUN command
'   instead of a CHAIN command.
'
'========================================================================

'OPEN "XMPARAM.DAT" FOR BINARY AS #1
'GET #1, 1, paramBuffer
'CLOSE

'========================================================================
'
'   This is the last program in the chain that will use extra memory, so
'   to be safe, call AutoCloseXM first.
'
'========================================================================

CALL AutoCloseXM

PRINT
PRINT "********* Now in XMDEMO2. ";
PRINT "Restoring extra memory status."

CALL RestParamXM(VARSEG(paramBuffer), VARPTR(paramBuffer), errCode)

IF errCode THEN
	PRINT
	PRINT "Error return on RestParamXM."
	PRINT "Error: "; RIGHT$("0000" + HEX$(errCode), 4)
	END
END IF

'========================================================================
'
'   First, GET the array of 32000 integers created in XMDEMO1.
'   then loop through it and see if it's correct.  Need to have
'   the memory handle first, GetNameXM will return it.
'
'========================================================================


CALL GetNameXM("ARRAY", arrayMemHandle, errCode)

IF errCode THEN
	PRINT
	PRINT "Error return on GetNameXm."
	PRINT "Error: "; RIGHT$("0000" + HEX$(errCode), 4)
	END
END IF

CALL XM2Conv(VARSEG(test1(1)), VARPTR(test1(1)), arrayMemHandle, &HFA00, 0, errCode)

IF errCode THEN
	PRINT
	PRINT "Error return on XM2Conv."
	PRINT "Error: "; RIGHT$("0000" + HEX$(errCode), 4)
	END
END IF

PRINT "Comparing array integer elements. ";
compErr = 0

FOR i = 1 TO 32000
	IF test1(i) <> i THEN
		PRINT "error in array compasion."
		PRINT "element"; i; " is"; test1(i)
		compErr = compErr + 1
	END IF
NEXT

PRINT "Comparison errors: "; compErr

ERASE test1

'========================================================================
'
'   Next display the screen pages generated in XMDEMO1.  As in XMDEMO1,
'   use the ScreenCountXM% to get the last available screen, save the
'   current output screen to that screen number, and save the cursor
'   location.  Then print the prompt and act accordingly.
'
'========================================================================
			 
screens = ScreenCountXM%
CALL SaveScreenXM(screens, errCode)
holdRow = CSRLIN
holdCol = POS(0)

PRINT "Do you want to inspect each page of the"; screens - 1; "screens that were"
PRINT "generated in XDEMO1? (Y/N)"

DO
	z$ = UCASE$(INKEY$)
LOOP WHILE z$ <> "Y" AND z$ <> "N"

pause = z$ = "Y"

FOR scrNum = 1 TO screens - 1
	CALL RestScreenXM(scrNum, errCode)

	IF errCode THEN
		CLS
		PRINT "Error return on RestScreenXM."
		PRINT "Error: "; RIGHT$("0000" + HEX$(errCode), 4)
		END
	END IF

	IF pause THEN DO: LOOP WHILE INKEY$ = ""
NEXT

'========================================================================
'
'   Now let's try the 1000 element memory 'file' generated in XMDEMO1.
'   A temporary 'record' is generated just as in XMDEMO1.  The
'   corresponding record is retrieved from the extra memory 'file' and
'   the two are compared.  If you have a comparison error, let me know!
'
'========================================================================

CALL RestScreenXM(screens, errCode)
LOCATE holdRow, holdCol
PRINT "Generating records & comparing to eXtraMemory. ";

CALL GetNameXM("RECORDS", recordMemhandle, errCode)

IF errCode THEN
	PRINT
	PRINT "Error return on GetNameXm."
	PRINT "Error: "; RIGHT$("0000" + HEX$(errCode), 4)
	END
END IF

compErr = 0

FOR i& = 1 TO 1000
	rec1 = "Record:" + STR$(i&)
	CALL GetRecXM(recordMemhandle, i&, VARSEG(rec2), VARPTR(rec2), errCode)
   
	IF errCode THEN
		PRINT
		PRINT "Error return on GetRecXM."
		PRINT "Error: "; RIGHT$("0000" + HEX$(errCode), 4)
		END
	END IF

	IF rec1 <> rec2 THEN compErr = compErr + 1
NEXT

PRINT "Comparison errors: "; compErr

'========================================================================
'
'   Close out all extra memory because technically we're done with it.
'   XMDEMO3 will only display the status of memory again.
'
'========================================================================

CALL CloseAllXM
RUN "XMDEMO3"
END

