'
' ControlC.BAS - workaround for PB's CTRL-C termination bug
'
' SUB       ControlC()
' FUNCTION  CtrlCFlag()
'

$OPTION CNTLBREAK OFF
$COMPILE UNIT

DEFINT A-Z
' for some odd reason, the following internal routine
' insists you have map generation on when compiling
' your exe code (not here in the pbu)
DECLARE FUNCTION SetOnExit%( BYVAL CodePntr??? )
SHARED CtrlCInstalled, CtrlCFlagSeg??, CtrlCFlagOfs??

SUB ControlC PUBLIC
  ' Installs a Ctrl-C handler which sets a flag and returns
  ' to DOS, avoiding program termination without cleanup when
  ' using DOS for output.
  ' You will have to check the Ctrl-C flag yourself.  A Function
  ' is provided here for this purpose.
  ' This routine uninstalls itself when your program ends by
  ' calling itself a second time.
  ' Make sure to only call it ONCE at the start of your program.

  IF CtrlCInstalled = 0 THEN ' install control-c handler
    CtrlCInstalled = -1

    ' establish flag address and clear flag
    CtrlCFlagSeg?? = CODESEG(OurFlag)
    CtrlCFlagOfs?? = CODEPTR(OurFlag)
    SaveSeg?? = pbvDefSeg
    DEF SEG = CtrlCFlagSeg??
    POKE CtrlCFlagOfs??, 0
    DEF SEG = SaveSeg??

    ' get and save current ctrl-c handler vector
    XSeg?? = 0
    XPtr?? = 0
    ! mov ax, &H3523
    ! int &H21
    ! mov XPtr??, bx
    ! mov ax, es
    ! mov XSeg??, ax

    ' point ctrl-c vector to our handler
    CSeg?? = CODESEG(OurCtrlC)
    CPtr?? = CODEPTR(OurCtrlC)
    ! push ds
    ! mov dx, CPtr??
    ! mov ax, CSeg??
    ! mov ds, ax
    ! mov ax, &H2523
    ! int &H21
    ! pop ds

    ' make sure this is uninstalled on exit by adding to
    ' internal procedure SetOnExit queue
    ThisPtr??? = CODESEG(ControlC)
    SHIFT LEFT ThisPtr???, 16
    ThisPtr??? = ThisPtr??? + CODEPTR(ControlC)
    Success = SetOnExit( ThisPtr??? )
    ' I haven't put in any check for success - not likely that
    ' there are more than eight programs queued up.

  ELSE
    ' this code executes when the SetOnExit queue is processed
    ' upon program termination.

    ' uninstall handler by resetting vector to original value
    ! push ds
    ! mov dx, XPtr??
    ! mov ax, XSeg??
    ! mov ds, ax
    ! mov ax, &H2523
    ! int &H21
    ! pop ds

    CtrlCInstalled = 0
  END IF
  EXIT SUB


  ' here is the actual control-c interrupt handler
  ' all it does is set the flag and return to the program
  ' you have to check the flag in your program if you want
  ' to act on control-c
  OurCtrlC:
    ! push ax
    ! mov al, &HFF
    ! mov OurFlag, al
    ! pop ax
    ! iret

  ' here is our flag, in the code segment for the interrupt 
  OurFlag:
    ! db 0

END SUB

FUNCTION CtrlCFlag% PUBLIC
  '
  ' Checks Flag set by ControlC handler
  '

  ' don't bother unless it's installed
  IF CtrlCInstalled THEN
    SaveSeg?? = pbvDefSeg
    DEF SEG = CtrlCFlagSeg??
    CtrlCFlag% = PEEK(CtrlCFlagOfs??)
    DEF SEG = SaveSeg??
  END IF
END FUNCTION

