DECLARE FUNCTION RemoveExt$ (FileName$)
' Billy Dennigan MBN International Systems Ltd 17-7-1992
' Compuserve ID 100014,2700
' Makefile Generator
' This program generates a simple makefile by copying the MS Basic .MAK file
' to a file usable by the NMAKE utility, with all the necessary flags.

CONST NumOfSources = 64
REDIM ObjList$(NumOfSources)
PRINT
PRINT "Makefile Generator by Billy Dennigan, MBN International Systems Ltd."

Lang$ = ".BAS"

'get the target filename if necessary
IF COMMAND$ = "" THEN
  PRINT "Target File :";
  INPUT TargetFile$
ELSE
  TargetFile$ = COMMAND$
END IF
 
IF LEN(TargetFile$) = 0 THEN END

'truncate the extension if it was given
TargetFile$ = UCASE$(TargetFile$)
TargetFile$ = RemoveExt$(TargetFile$)

'for simplicity, everything is based around the name specified by TargetFile$
'Eg: PROG.EXE, PROG.MAK, PROG., etc.

MakeFile$ = TargetFile$                  ' Makefile to be generated
RespFile$ = TargetFile$ + ".LNK"         ' response file for linker
ListFile$ = TargetFile$ + ".MAK"         ' list of required files
Tab$ = CHR$(9)

'------ load in the list of required files from the .MAK file --------
IF LEN(DIR$(ListFile$)) THEN
  OPEN ListFile$ FOR INPUT AS #2
  DO UNTIL EOF(2)
    INPUT #2, Line$
    Line$ = UCASE$(Line$)
    IF (LEN(Line$) = 0) THEN
      EXIT DO
    END IF
    NumObjs% = NumObjs% + 1
    ObjList$(NumObjs%) = RemoveExt$(Line$)
  LOOP
  CLOSE #2
ELSE
  ' there is no .MAK file, just a single source file
  NumObjs% = 1
  ObjList$(NumObjs%) = RemoveExt$(TargetFile$)
END IF
  

OPEN MakeFile$ FOR OUTPUT AS #1
OPEN RespFile$ FOR OUTPUT AS #2

PRINT #1, "# Makefile for "; TargetFile$
PRINT #1, "# Date written "; DATE$;
PRINT #1, " at "; TIME$; " by Makefile Generator [MM]"
PRINT #1, "# Billy Dennigan, MBN International Systems Ltd."
PRINT #1, "# Uses response file "; RespFile$; " for Linker"
PRINT #1, "#"

'---- first define the necessary macros ----
PRINT #1, "# Can change your source file and compilers,etc here:"
PRINT #1, ""
PRINT #1, "EXE = "; TargetFile$
PRINT #1, "COMPILE = bc"
PRINT #1, "LINK = link"
PRINT #1, "COMPFLAGS = /O /Ot /G2 /Fs /Lr /FPi /T /C:512"
PRINT #1, "LINKFLAGS = /EX /NOE /NOD:brt71efr.lib"
PRINT #1, ""
PRINT #1, "ALL : $(EXE).EXE"

'------ Dependencies for the .OBJ file. (Compilation phase) ---
FOR i% = 1 TO NumObjs%
  Stem$ = ObjList$(i%)
  PRINT Stem$
  PRINT #1, ""
  PRINT #1, Stem$; ".OBJ : "; Stem$; Lang$
  PRINT #1, Tab$; "$(COMPILE) $(COMPFLAGS) "; Stem$; Lang$; " "; Stem$; ".OBJ ;"
NEXT i%

'------ Dependencies for the .EXE file i.e. the LINK phase ---
PRINT #1, ""
PRINT #1, "$(EXE).EXE : ";
FOR i% = 1 TO NumObjs%
  PRINT #1, ObjList$(i%); ".OBJ ";
NEXT i%
PRINT #1, ""

PRINT #1, Tab$; "$(LINK) $(LINKFLAGS) ";
PRINT #1, "@"; RespFile$

FOR i% = 1 TO NumObjs%
  PRINT #2, ObjList$(i%); ".OBJ +"
NEXT i%
PRINT #2,

PRINT #2, TargetFile$; ".EXE"
PRINT #2, "NUL.MAP"
PRINT #2, "BCL71EFR.LIB+"
DO
  PRINT "Extra Libraries : ";
  INPUT "", Lib$
  IF LEN(Lib$) THEN
    PRINT #2, UCASE$(Lib$); "+"
  END IF
LOOP UNTIL LEN(Lib$) = 0

PRINT #2, ""
PRINT #2, "NUL.DEF ;"
PRINT #2,

CLOSE #1, #2

PRINT "Makefile has been generated."
PRINT "Type NMAKE "; MakeFile$; " to begin compilation."
END

' Billy Dennigan  17-Jul-1992
' Function to strip the '.EXT' off a filename
' Eg:   Input:  "MENU.C"
'       Output: "MENU"
FUNCTION RemoveExt$ (FileName$)

'step from Right to Left to avoid dots which specify a relative path
FOR Dot% = LEN(FileName$) TO 1 STEP -1
  Ch$ = MID$(FileName$, Dot%, 1)
  IF Ch$ = "." THEN EXIT FOR
  IF Ch$ = "\" THEN Dot% = 0
NEXT Dot%

IF Dot% > 0 THEN
  FileName$ = LEFT$(FileName$, Dot% - 1)
END IF
RemoveExt$ = FileName$

END FUNCTION

