'PROGRAM - ISAMTEST.BAS

'****************************************************************
'** Purpose - This program demonstrates the essential elements  *
'**           you incorporate in programs using the ISAM engine *
'****************************************************************

  CLS

'******************  Setup ISAM file  **************************

  TYPE BusMailList              'Definition for ISAM table
    FirstName AS STRING * 15
    LastName  AS STRING * 15
    Company   AS STRING * 30
    Address   AS STRING * 30
    City      AS STRING * 20
    State     AS STRING * 2
    Zip       AS STRING * 5
  END TYPE

  DIM ML AS BusMailList         'Record variable to move data
                                '  in and out of file

  OPEN "MailList.MDB" FOR ISAM BusMailList "BusinessList1" AS #1

' Use the CREATEINDEX cmd only if the index does not exist

  CREATEINDEX #1, "B1Zip", 0, "Zip"
  SETINDEX #1, "B1Zip"               'Set the active index

'*******************  Add records to file **********************

  INPUT "Add a record to the file (Y/N)"; Response$
  
  WHILE UCASE$(Response$) = "Y"

    CLS

    PRINT "Enter the following information"
    PRINT

    LINE INPUT "First name: "; ML.FirstName
    LINE INPUT "Last name : "; ML.LastName
    LINE INPUT "Company   : "; ML.Company
    LINE INPUT "Address   : "; ML.Address
    LINE INPUT "City      : "; ML.City
    LINE INPUT "State     : "; ML.State
    LINE INPUT "Zip       : "; ML.Zip

    INSERT #1, ML
    PRINT
    INPUT "Add another record to the file (Y/N)"; Response$

  WEND

'******  Sequentially display records from file *****************

  MOVEFIRST #1                          'Set initial file postion

  NbrRecs = LOF(1)  'For ISAM files, LOF returns the # of records

  FOR RecNbr = 1 TO NbrRecs

    CLS
    
    RETRIEVE #1, ML                     'Get the next ISAM record

    PRINT "Business mailing list display"
    PRINT
    PRINT "First name: "; ML.FirstName
    PRINT "Last name : "; ML.LastName
    PRINT "Company   : "; ML.Company
    PRINT "Address   : "; ML.Address
    PRINT "City      : "; ML.City
    PRINT "State     : "; ML.State
    PRINT "Zip       : "; ML.Zip
    PRINT
    INPUT "Press <Enter> to see the next record."; Response$

    MOVENEXT #1                         'Advance next record
    
  NEXT RecNbr

  PRINT
  PRINT "End of file reached."
  PRINT "Terminating program."

  CLOSE 1
  END

