DECLARE FUNCTION RandomSymbol$ (Parms AS ANY)
'----------------------------------------------------------------
' Test the lookup table routines
'----------------------------------------------------------------
DEFINT A-Z


'$INCLUDE: 'TABLMNGR.BI'

  CLS
  RANDOMIZE TIMER
  CONST True = -1, False = 0

'Initialize the table values

  DIM Sym AS SymbolTableParameters
  Sym.Delim = "\": Sym.SWidth = 10: NbrEnt = 1000
  Successful = SymCreateTbl(SymTbl$, Sym, NbrEnt)

'Start the test

  IF Successful THEN

'Fill the array

    PRINT "Filling table for test with"; NbrEnt; "entries ";
    A! = TIMER
    FOR I = 1 TO NbrEnt
L:    Symbol$ = RandomSymbol$(Sym)
      IF NOT SymDefine(SymTbl$, Symbol$, Sym) THEN
        BEEP  'Collision
        GOTO L
      END IF
      LOCATE 2, 1: PRINT USING " #### \        \"; I; Symbol$
    NEXT I
    B! = TIMER
    PRINT "Elapsed time for setting";
    PRINT USING " ##,### entries: ###.##"; NbrEnt; B! - A!
    PRINT USING "##.##### "; (B! - A!) / NbrEnt;
    PRINT "seconds per create"

    PRINT "Lookup the last entry:"; NbrEnt; "times"
    TestSym$ = SymGet$(SymTbl$, Sym.NbrEntries, Sym)

'Search for the last element

    PRINT "Looking for "; TestSym$
    A! = TIMER
    FOR I = 1 TO NbrEnt
      S% = SymDefined(SymTbl$, TestSym$, Sym)
    NEXT I
    B! = TIMER
    PRINT "Elapsed time for lookups";
    PRINT USING " ##,### entries: ###.##"; NbrEnt; B! - A!
    PRINT USING "##.##### "; (B! - A!) / NbrEnt;
    PRINT "seconds per lookup"
  ELSE
    PRINT "Couldn't pre-allocate table"
  END IF
END

FUNCTION RandomSymbol$ (Parms AS SymbolTableParameters)
  R$ = ""
  FOR I = 1 TO INT((Parms.SWidth - 5 + 1) * RND + 5)
L1: C% = INT(26 * RND + 65)   'A to Z
    IF C% = ASC(Parms.Delim) THEN GOTO L1:
    R$ = R$ + CHR$(C%)
  NEXT I
  RandomSymbol$ = R$
END FUNCTION

