'----------------------------------------------------------------
'Menu driven routines to test the string table routines
'----------------------------------------------------------------
DECLARE FUNCTION RandomSymbol$ (Parms AS ANY)
DEFINT A-Z

'$INCLUDE: 'TABLMNGR.BI'

  RANDOMIZE TIMER

  CONST True = -1, False = 0

  DIM Sym AS SymbolTableParameters

  Sym.Delim = "\"
  Sym.Width = 10

  IF SymCreateTbl(SymTbl$, Sym, 1) THEN

    DO WHILE True

      CLS

      PRINT "<C>reate/Initialize table"
      PRINT "<A>dd a symbol"
      PRINT "<D>elete a symbol"
      PRINT "<P>rint symbol table"
      PRINT "<F>ill table"
      PRINT "<S>earch for entry"
      PRINT "s<T>ore table to disk"
      PRINT "<R>etrieve table from disk"
      PRINT
      PRINT "<Q>uit"
      PRINT
      INPUT "Enter option: "; Response$

      PRINT

      SELECT CASE UCASE$(Response$)
        CASE "Q"
          EXIT DO
        CASE "C"
          SymTbl$ = ""
          INPUT "Enter number of records to size table:"; NbrRecs
          Successful = SymCreateTbl(SymTbl$, Sym, NbrRecs)
          IF NOT Successful THEN EXIT DO
        CASE "A"
          INPUT "Enter symbol: "; Symbol$
          IF INSTR(Symbol$, Sym.Delim) <> 0 THEN
            PRINT "Error - Symbol contains the delimiter"
            GOSUB Pause
          ELSE
            IF NOT SymDefine(SymTbl$, Symbol$, Sym) THEN
              PRINT Symbol$; " - Can't add duplicate symbols."
              GOSUB Pause
            END IF
          END IF
        CASE "D"
          INPUT "Enter symbol: "; Symbol$
          IF INSTR(Symbol$, Sym.Delim) <> 0 THEN
            PRINT "Error - Symbol contains the delimiter"
            GOSUB Pause
          ELSE
            IF NOT SymUnDefine(SymTbl$, Symbol$, Sym) THEN
              PRINT Symbol$; " - Can't delete undefined symbol."
              GOSUB Pause
            END IF
          END IF
        CASE "P"
          IF Sym.NbrEntries THEN
            CALL SymDisplayTbl(SymTbl$, Sym)
          ELSE
            PRINT "No symbols defined"
          END IF
          GOSUB Pause
        CASE "F"
          INPUT "Enter the # of symbols to create: "; NLoops
          A! = TIMER
          FOR I = 1 TO NLoops
L:          Symbol$ = RandomSymbol$(Sym)
            IF NOT SymDefine(SymTbl$, Symbol$, Sym) THEN
              BEEP  'Collision
              GOTO L
            END IF
            LOCATE 20, 20: PRINT USING "#### "; I;
            PRINT Symbol$ + SPACE$(30)
          NEXT I
          B! = TIMER
          PRINT "Elapsed time for setting";
          PRINT USING " ##,### entries: ###.##"; NLoops; B! - A!
          PRINT USING "##.##### "; (B! - A!) / NLoops;
          PRINT "seconds per create"
          GOSUB Pause
        CASE "S"
          INPUT "Enter the number of lookups: "; NLoops
          TestSym$ = SymGet$(SymTbl$, Sym.NbrEntries - 1, Sym)
          PRINT "Looking for "; TestSym$
          A! = TIMER
          FOR I = 1 TO NLoops
            S% = SymDefined(SymTbl$, TestSym$, Sym)
          NEXT I
          B! = TIMER
          PRINT "Elapsed time for lookups";
          PRINT USING " ##,### entries: ###.##"; NLoops; B! - A!
          PRINT USING "##.##### "; (B! - A!) / NLoops;
          PRINT "seconds per lookup"
          GOSUB Pause
        CASE "T"  'Store table to the file
          KILL "SYMBOL.TBL"
          OPEN "B", 1, "Symbol.tbl"
          PUT 1, , Sym
          PUT 1, , SymTbl$
          CLOSE 1
        CASE "R"  'Get the table from file
          OPEN "B", 1, "Symbol.tbl"
          GET 1, , Sym
          IF Sym.TblLength > 0 THEN
            SymTbl$ = SPACE$(Sym.TblLength)
            GET 1, , SymTbl$
          END IF
          CLOSE 1
        CASE ELSE
          BEEP
      END SELECT
    LOOP
  ELSE
    PRINT "Couldn't pre-allocate table"
  END IF

END

Pause:
  PRINT : PRINT "Press a key to continue...."
  WHILE LEN(INKEY$) = 0: WEND
  RETURN

'----------------------------------------------------------------
'Create a random symbol for test lookups
'----------------------------------------------------------------
FUNCTION RandomSymbol$ (Parms AS SymbolTableParameters)

  R$ = ""

  FOR I = 1 TO INT((Parms.Width - 5 + 1) * RND + 5)

L1: C% = INT((26 * RND + 65)   'A to Z
    IF C% = ASC(Parms.Delim) THEN GOTO L1:
    R$ = R$ + CHR$(C%)

  NEXT I

  RandomSymbol$ = R$

END FUNCTION

