'****************************************************************************
'*  Copyright (C) 1988,1989 The GAP Development Company
'*
'*  All Rights Reserved
'*
'*
'*  DOOR.BAS
'*
'*  Demonstration program for GAPQBDR
'*
'*  To compile : bc door;
'*  To link    : link door,,NUL.MAP,+gapqbdr
'*
'*  Program will need access to DOOR.CNF, DOOR.SYS, GAPBBS.CNF, GAPDOS.DAT
'*
'****************************************************************************


   '***********************************************************************
   '*  Before doing ANYTHING else, include the following file.            *
   '***********************************************************************

' $INCLUDE: 'GAPQBDR.BI'


   '***********************************************************************
   '*  Declare any local variables prior to use                           *
   '***********************************************************************

   DIM oldbell AS INTEGER                 ' so we dont make sysop mad
   DIM bobo AS INTEGER                    ' error return codes
   DIM anystring AS STRING                ' string used for most everything
   DIM response AS STRING                 ' for getting responses
   DIM menu AS STRING                     ' for building a menu
   DIM prompt AS STRING                   ' for the command prompt


   '***********************************************************************
   '*  Begin main line code here                                          *
   '***********************************************************************

   '***********************************************************************
   '*  Before doing ANYTHING else, initialize the door with the following *
   '*  two function calls.                                                *
   '*  Then, if you have any configuration options, line input them in    *
   '*  and close file # 1.                                                *
   '***********************************************************************

   CALL read.cnf("DOOR.CNF")              ' read door configuration file
   CALL init.door                         ' initialize the door

   close #1                               ' we dont have any configuration
                                          ' options so we will just close


   '***********************************************************************
   '*  Now, we are going to keep track of the time credit variable that   *
   '*  is stored in the GAPDOS.DAT file.  We are going to do this because *
   '*  we are such nice people and we want to credit the caller for the   *
   '*  time spent during our chat demonstration.  Remember, at the        *
   '*  beginning of the program, after initializing the door, is the      *
   '*  place to do this because the variable 'timecredit' is initialized  *
   '*  at doors beginning.                                                *
   '*                                                                     *
   '*  NOTE!  This function will fail (the reason for bobo) if GAPDOS.DAT *
   '*  does not exist (which it will not unless this program is being     *
   '*  tested via the BBS door routines.  If you need to test this        *
   '*  feature, you will need to have a backup copy of GAPDOS.DAT that    *
   '*  can be placed in your BBS default directory prior to running this  *
   '*  demo!                                                              *
   '***********************************************************************

   bobo = read.gapdos%                    ' read the system file

   IF bobo = 0 THEN
      anystring = "GAPDOS.DAT says you have " + STR$(gapdos.timecredit)
      anystring = anystring + " time credits (in minutes)."

      CALL show.mess(anystring, NO, YES)
   ELSE
      CALL nl(2)                           ' display a couple of blank lines

      CALL ansi(BRED)                      ' Humm, error time!
      CALL show.mess("Could Not Open GAPDOS.DAT!", YES, YES)
   END IF

   CALL nl(2)                              ' display a couple of blank lines


   '***********************************************************************
   '*  Change the color prior to displaying a prompt.  Send a prompt to   *
   '*  the caller and await an answer.                                    *
   '***********************************************************************

   CALL ansi(BGREEN)                      ' set default color to Green

   CALL show.mess("Please Enter Your Name : ", YES, NO) ' main output routine

   response = SPACE$(30)                  ' must initialize all variables
					  ' passed to get.string
   CALL get.string(response)              ' now get the caller's name

   CALL nl(1)                             ' display a blank line


   '***********************************************************************
   '*  An alternative way to change colors on the fly is to do it         *
   '*  inline.  It is also a bit faster since fewer function calls are    *
   '*  made.  But note that to change colors like this, you have to test  *
   '*  if the caller is in color mode.                                    *
   '***********************************************************************

   IF c.olor = 1 THEN
      anystring = BCYAN + "Your name is : " + BRED + response + BCYAN + "."
   ELSE
      anystring = "Your name is : " + response + "."
   END IF

   CALL show.mess(anystring, NO, YES)' tell caller what was entered

   CALL nl(1)                        ' display a blank line

   CALL ansi(BGREEN)                 ' change colors

   call show.mess("But on the BBS, your First Name is : "+first +".",NO,YES)

   CALL nl(1)                        ' display a blank line

   CALL pause                        ' wait for a key press before continuing

   CALL nl(2)                        ' display a couple of blank lines


   '***********************************************************************
   '*  The next example is the WRONG way to display a color string since  *
   '*  it does not bother checking if the user is in color mode.          *
   '*  The correct way is to check the c.olor variable.  If it is a 1     *
   '*  then it is safe to send color.  This is exactly what ansi() does.  *
   '***********************************************************************

   anystring = BRED + "I'm going to mess up your black & white screen." + CRLF
   anystring = anystring + "Because I'm not checking to see if you have " + CRLF
   anystring = anystring + BWHITE + "Color turned on!!!"

   CALL show.mess(anystring, NO, YES)

   CALL nl(2)                        ' display a couple of blank lines



   '***********************************************************************
   '*  It is now time to page the sysop.  Just in case the sysop has his  *
   '*  page bell turned off, we are going to cheat a bit and turn it on.  *
   '*  For demonstration purposes only, you see!                          *
   '*  We will also demonstrate how to obtain and display the time left.  *
   '*                                                                     *
   '*  Note that the 'timeleft' variable is automatically updated by the  *
   '*  input routines.  If you need to make sure that it is current, you  *
   '*  can always call time.left() prior to using it.  Since 'timeleft'   *
   '*  is an integer, you will need to convert it to a string and then    *
   '*  trim the leading space from it.                                    *
   '***********************************************************************

   DO
      CALL nl(1)

      if c.olor = 1 then
         anystring = YELLOW + "["+BRED + LTRIM$(str$(timeleft))+" mins" + YELLOW + "] To Page the Sysop, type a 'P' : "
      else
         anystring = "["+ LTRIM$(str$(timeleft))+" mins] To Page the Sysop, type a 'P' : "
      end if

      CALL show.mess(anystring, NO, NO)

      response = " "                 ' must initialize get.string variable
      CALL get.string(response)      ' get the caller's response

   LOOP WHILE response <> "P"        ' loop till valid response
       
   '***********************************************************************
   '*  We are going to override the sysop's page bell flag so we can      *
   '*  can hear the bell.  This is not a good thing to do as it will tend *
   '*  to anger the sysop if a door program does not honor his BBS        *
   '*  settings.  Sorry sysop.  We'll put the bell flag back the way it   *
   '*  was when we are finished.                                          *
   '***********************************************************************

   oldbell = bell                    ' keep track of old bell setting
   bell = 1                          ' turn sysop's page bell on

   CALL pagesysop                    ' now page the sysop

   bell = oldbell                    ' restore old bell setting


   '***********************************************************************
   '*  Lets now display a file.  We want to display a color version of    *
   '*  the file if the caller is in color mode and an ascii version of    *
   '*  the file if the caller is in non-color mode.  So, we will ask the  *
   '*  programmer to supply the name of a BBS welcome file.               *
   '*  The programmer should supply the name of the non-color version of  *
   '*  the file (IE, no 'G' at the end of the name).                      *
   '*                                                                     *
   '*  The show.file() routine makes certain assumptions about the file   *
   '*  name being passed to it.  It assumes that you are calling it with  *
   '*  a path and file name for a file that you know is or should be      *
   '*  present.  Show.file() will attempt to find the file, but if it     *
   '*  cannot, it simply returns (no error code).                         *
   '*  If you are gathering input from the user, as this example does,    *
   '*  you may want to call a.ccess() to first see if the file exists.    *
   '***********************************************************************


   CALL nl(2)                        ' display a couple of blank lines

   do

      CALL ansi(YELLOW)              ' set a default color

      CALL show.mess("Enter full path name to your BBS Welcome File : ", NO, NO)

      response = SPACE$(65)          ' must initialize variable
      CALL get.string(response)      ' get the path and name of file to show

      if a.ccess% (response) <> 0 then     ' does file exist?
         call nl(1)
         call ansi(BRED)                   ' no, tell them in RED!
         call show.mess("File Not Found!",YES,YES)
         call nl(1)
      else
         exit do                           ' yes, go show it
      end if
   loop                              ' till valid file name entered

   call ansi (YELLOW)                ' reset default color

   CALL show.file(response)          ' now show the file.



   '***********************************************************************
   '*  Lets see what is going on with the time credit variable.           *
   '*  Depending upon how long the programmer chatted with his/her self,  *
   '*  or if the up or down arrow keys were pressed at any time, it could *
   '*  be quite different from what GAP wrote to the GAPDOS.DAT file!     *
   '***********************************************************************

   
   IF bobo = 0 THEN                  ' only if we could 1st read the file
      CALL nl(2)                     ' display a couple of blank lines
      CALL ansi(BGREEN)              ' set a default color

      CALL show.mess("GAPDOS timecredit was " + STR$(gapdos.timecredit) + " mins.", NO, YES)

      CALL ansi(BWHITE)

      CALL show.mess("We are going to explicitly ADD 20 minutes.", NO, YES)
 
      timecredit = timecredit + 20      ' add 20 minutes
 
      gapdos.timecredit = gapdos.timecredit + timecredit

      bobo = write.gapdos%           ' update GAPDOS.DAT
      CALL nl(1)                     ' show a blank line
      CALL ansi(BGREEN)
      CALL show.mess("GAPDOS timecredit now equals " + STR$(gapdos.timecredit) + " mins.", NO, YES)

      CALL ansi(YELLOW)              ' set a default color

      CALL show.mess("Any difference came from CHAT or Up/Down Arrow Keys!", YES, NO)

   END IF
    
   CALL nl(2)                        ' display a couple of blank lines

   CALL pause                        ' pause before continuing


   '***********************************************************************
   '*  Lets now build some menus all at once.                             *
   '*  These menus were created with an ANSI editor.  This is perhaps the *
   '*  fastest and easiest way to create menus.  It is also faster to     *
   '*  display a menu all at once instead of displaying each line of the  *
   '*  menu one at a time.                                                *
   '***********************************************************************

   if c.olor = 1 then
      menu = "[3C[0;1;40mͻ"+CRLF
      menu = menu + "   [14C[32mMain Menu[15C[37m"+CRLF
      menu = menu + "   Ķ"+CRLF
      menu = menu + "   [38C"+CRLF
      menu = menu + "     [33m[[31mT[33m]op Players[9C[[31mP[33m]age Sysop  [37m"+CRLF
      menu = menu + "     [33m[[31mH[33m]elp[16C[[31mU[33m]ser Stats  [37m"+CRLF
      menu = menu + "     [33m[[31mQ[33m]uit[16C[[31mG[33m]amble[6C[37m"+CRLF
      menu = menu + "   ͼ"+CRLF+CRLF
   else   
      menu = "   ͻ"+CRLF
      menu = menu + "                 Main Menu               "+CRLF
      menu = menu + "   Ķ"+CRLF
      menu = menu + "                                         "+CRLF
      menu = menu + "     [T]op Players         [P]age Sysop  "+CRLF
      menu = menu + "     [H]elp                [U]ser Stats  "+CRLF
      menu = menu + "     [Q]uit                [G]amble      "+CRLF
      menu = menu + "   ͼ"+CRLF+CRLF
   end if

   do
      call clear.scr                 ' fist clear the screen

      call nl(2)                     ' do a couple of blank lines

      if c.olor = 1 then
         prompt = YELLOW + "["+BRED + LTRIM$(str$(timeleft))+" mins" + YELLOW + "] Main Command : "
      else
         prompt = "["+ LTRIM$(str$(timeleft))+" mins] Main Command : "
      end if
     
      call show.mess(menu,NO,YES)    ' show the menu
      call show.mess(prompt,NO,NO)   ' show the prompt

      response = " "                 ' initialize response
      call get.string(response)      ' get user input

      if response <> "Q" then
         call nl(2)
         call ansi(BRED)
         call show.mess("Only Menu Choice 'Q' Is Working!",YES,YES)
         call nl(1)
         call pause
      end if

   loop until response = "Q"

END

