library WNDFIND;

{These are the units used}
uses Strings, WinTypes;

{These are global variables to the DLL}
var
	VBhWnd:hWnd;
   ThWnd:Integer;
  	Capt:Array[0..255] of Char;


{These are the API functions used}
procedure GetWindowText (Wnd:hWnd; Buff:PChar; BufSize:word); far;
	External 'USER' index 36;
procedure SendMessage (Wnd, Msg, wParam:word;lParam:PChar); far;
	External 'USER' index 111;
procedure EnumWindows (Func:TFarProc; lParam:PChar);far;
	External 'USER' index 54;


{This is the call-back function that is sent the hWnd of every window}
function EnumFunc (hWnd:hWnd; Search:PChar):Bool;export;
	Begin
      {First retrieve the caption of the Window}
  		GetWindowText (hWnd, @Capt, 256);
      {StrPos is identical to Instr. We cap both strings to be insensitive}
   	if StrPos (StrUpper (@Capt), Search) <> Nil then
  			Begin
         	{List1.AddLine Caption$}
     			SendMessage (VBhWnd, LB_AddString, 0, @Capt);
            {ThWnd = ThWnd + 1}
           	Inc (ThWnd);
         end;
  		   EnumFunc := TRUE;
   End;

function FindCaptions (Wnd:hWnd; Search:PChar):Integer;export;
	Begin
   	{Set the global variable so EnumFunc can find it}
     	VBhWnd := Wnd;
      {Set counter to zero}
      ThWnd := 0;
      {Clear the list box}
      SendMessage (Wnd, LB_ResetContent, 0, StrUpper(Search));
      {Tell Windows to start sending hWnds to EnumFunc}
      EnumWindows (@EnumFunc, Search);
      {When all windows have been examined, return total to VB}
      FindCaptions := ThWnd;
   end;



Exports
   EnumFunc,
   {The resident keyword makes access from VB quicker}
	FindCaptions resident;


{No startup code but we need the empty routine anyway}
Begin
End.
