100! THIS PROGRAM IS DESIGNED TO CALCULATE THE AZIMUTH AND
110! ELEVATION OF THE MOON.
120!
130! THE REQUIRED INPUT IS THE GMT MONTH, DAY, AND YEAR FOR
140! WHICH THE MOON'S AZIMUTH AND ELEVATION ARE DESIRED.  IN
150! ADDITION, IF PRINTOUT IS DESIRED NOT ONLY WHEN THE MOON
160! IS NEAR THE HORIZON, THE TIME INTERVAL OVER WHICH THE
170! POSITION IS DESIRED MUST BE ENTERED.
180!
190! THE COMPLETE INPUT FORMAT FOR THE ABOVE IS:
200!
210!  MM,DD,YYYY,TTTT,TTTT
220!
230! IF YOU ELECT TO HAVE PRINTOUT OCCUR ONLY WHEN THE MOON IS
240! NEAR THE HORIZON, YOU WILL BE ASKED TO INPUT THE MAXIMUM
250! ELEVATION FOR WHICH YOU WANT THE PRINTOUT.  IN THIS CASE,
260! YOU WILL NOT BE ASKED TO SUPPLY TIMES FOR THE TIME INTERVALS.
270!
280! PRINTOUT IS SUSPENDED WHENEVER THE ELEVATION OF THE MOON
290! IS NEGATIVE.
300!
310! YOU CAN ASK FOR DATA FOR UP TO 25 DAYS AT ONCE: SIMPLY TYPE
320! IN THE INFORMATION FOR ONE DAY (AS IN THE REQUIRED FORMAT
330! FOR YOUR PARTICULAR NEEDS) EACH TIME THE COMPUTER PRINTS A
340! "?".  WHEN YOU HAVE ENTERED ALL THE DATA YOU WISH, FOLLOW
350! THE LAST "?" BY AN INPUT OF ZEROES SEPERATED BY COMMAS --
360! JUST AS IN THE FORMAT YOU WERE USING TO ENTER THE DATA.
370!
380! ALL DATES AND TIMES USED IN THIS PROGRAM ARE IN GREENWICH
390! MEAN TIME.  IN ADDITION, ALL TIMES ARE IN THE 0000 TO 2400
395! HOUR SYSTEM.
400!
410! THE BASIC USED IN THIS PROGRAM HAS BEEN KEPT AS EL!ENTARY
420! AS POSSIBLE TO FACILITATE ITS USE ON OTHER TIME SHARING
430! SYSTEMS.  I WISH TO ACKNOWLEDGE THE GENEROUS ASSISTANCE OF
440! THOMAS AKE OF THE WARNER-SWASEY OBSERVATORY, WITHOUT WHOM
450! THE VITAL EQUATIONS FOR COMPUTING THE MOON'S POSITION WOULD
455! NOT HAVE BEEN AVAILABLE.
460!
470!					LANCE COLLISTER
480!					WA1JXN/WA3GPL
490!					CLEVELAND, OHIO
500!					MARCH 1974
510!
520!
530 DIM F(25), V(25), Y(25), Q(25), S(25)
540 DEF FNA(X)=INT(X*D5*10+.5)/10
550 DEF FNB(X)=(X-INT(X))*P5
560 LET P5=2.0000000000*3.1415926535
570 LET D5=360.0000000000/P5 : ! CONVERSION TO DEGREES
580 LET R5=P5/360.0000000000 : ! CONVERSION TO RADIANS
583 STRING Z8
584 PRINT
585 PRINT "WHAT ARE THE CALL LETTERS OF THE STATION":
586 INPUT Z8
590 PRINT "WHAT IS THE LATITUDE IN DEGREES, MINUTES":
600 INPUT L5,U5
610 PRINT "WHAT IS THE LONGITUDE IN DEGREES, MINUTES":
620 INPUT L6,U6
630 LET L5=(L5+U5/60)*R5
640 LET L6=(L6+U6/60)*R5
650 PRINT "WHAT IS THE DESIRED PRINTING INCREMENT IN MINUTES":
660 INPUT I
670 PRINT "DO YOU ONLY WANT PRINTOUT WHEN THE MOON"
680 PRINT "IS NEAR THE HORIZON":
690 INPUT B$
700 IF B$="YES" THEN 730
710 LET I6=100
720 GOTO 800
730 PRINT "BELOW WHAT ELEVATION IN DEGREES DO YOU WANT PRINTOUT TO OCCUR":
740 INPUT I6
750 PRINT "WHAT ARE THE GMT MONTH,DAY,YEAR DESIRED":
760 FOR N=1 TO 25
770 INPUT F(N),V(N),Y(N),Q(N),S(N)
780 IF F(N)=0 THEN 860
790 GOTO 760
800 PRINT "WHAT ARE THE GMT MONTH,DAY,YEAR,TIME INTERVAL (BEGINNING,"
810 PRINT "ENDING) DESIRED":
820 FOR N=1 TO 25
830 INPUT F(N),V(N),Y(N),Q(N),S(N)
840 IF F(N)=0 THEN 860
850 GOTO 820
860 LET N5=N-1
870 FOR N=1 TO N5
880 IF B$="YES" THEN 900
890 GOTO 930
900 LET E1=2400
910 LET B=0
920 GOTO 950
930 LET E1=S(N)
940 LET B=Q(N)
950 LET M=F(N)
960 LET D=V(N)
970 LET Y=Y(N)
980 LET Y1=Y-(INT(Y/100)*100)
990 PRINT
1000 PRINT
1010 PRINT "POSITION OF MOON ON ":M:"/":D:"/":Y1:"GMT"
1020 PRINT
1030 PRINT "GMT","AZ","EL","GHA","DEC"
1040 PRINT "---","--","--","---","---"
1050 PRINT
1060 LET I1=2
1070 !HERE BEGINS CALCULATION OF JULIAN DATE
1080 IF M>=3 THEN 1160
1090 IF INT((Y-1853)/4)<11 THEN 1120
1100 LET C1=-1
1110 GOTO 1130
1120 LET C1=0
1130 LET J1=365*(Y-1853)+D+30*(M+9)+INT((M+10)/2)
1140 LET J2=INT((Y-1853)/4)+1+C1
1150 GOTO 1270
1160 IF INT((Y-1852)/4)<11 THEN 1190
1170 LET C1=-1
1180 GOTO 1200
1190 LET C1=0
1200 IF M=9 THEN 1240
1210 IF M=11 THEN 1240
1220 LET C2=0
1230 GOTO 1250
1240 LET C2=1
1250 LET J1=365*(Y-1852)+D+30*(M-3)+INT((M-2)/2)
1260 LET J2=INT((Y-1852)/4)+C1+C2
1270 LET J=J1+J2 !(JULIAN DATE-2397547.5) FOR 0 HOURS GMT
1280 LET T1=J-17472.5
1290 LET D9=(B-INT(B/100)*100)+INT(B/100)*60
1300 LET D6=(E1-INT(E1/100)*100)+INT(E1/100)*60
1310 LET D7=D9-D6
1320 LET D8=D7-I
1330 IF D7>0 THEN 1350
1340 GOTO 1380
1350 IF D8>=0 THEN 2220
1360 LET B=E1
1370 !CALCULATION OF LATITUDE AND LONGITUDE OF MOON
1380 LET T=(B-INT(B/100)*100)/1440+INT(B/100)*24
1390 LET T5=T1+T
1400 LET K1=FNB(.751213+.036601102*T5)
1410 LET K2=FNB(.822513+.0362916457*T5)
1420 LET K3=FNB(.995766+.00273777852*T5)
1430 LET K4=FNB(.974271+.0338631922*T5)
1440 LET K5=FNB(.0312525+.0367481957*T5)
1450 LET L8=K1+.658*R5*SIN(2*K4)+6.289*R5*SIN(K2)
1460 LET L8=L8-1.274*R5*SIN(K2-2*K4)-.186*R5*SIN(K2-2*K4)-.186*R5*SIN(K3)
1470 LET L8=L8+.214*R5*SIN(2*K2)-.114*R5*SIN(2*K5)
1480 LET L8=L8-.059*R5*SIN(2*K2-2*K4)-.057*R5*SIN(K2+K3-2*K4)
1490 LET K6=K5+.6593*R5*SIN(2*K4)+6.2303*R5*SIN(K2)-1.272*R5*SIN(K2-2*K4)
1500 LET L7=5.144*R5*SIN(K6)-.146*R5*SIN(K5-2*K4)
1510 !CALCULATION OF RIGHT ASCENSION (A=R1) AND DECLINATION (D1)
1520 LET D1=COS(L7)*SIN(L8)*.397821+SIN(L7)*.917463
1530 LET D1=ATN(D1/(SQR(1-D1^2)))
1540 LET A2=COS(L7)*COS(L8)/COS(D1)
1550 LET A2=COS(L7)*SIN(L8)*.917463-SIN(L7)*.397821)/COS(D1)
1560 LET A=ATN(A1/A2)
1570 GOSUB 1860
1580 LET R1=A
1590 LET L1=.065709822*T1
1600 LET L=T*24*1.002738+6.646055+(L1-INT(L1/24)*24
1610 LET L=(L-INT(L/24)*24)
1620! CALCULATION OF GREENWICH HOUR ANGLE,G, FROM LOCAL SIDEREAL TIME
1630 LET G=(L/24)*P5-R1
1640 IF G<P5 THEN 1670
1650 G=G-P5
1660 GOTO 1710
1670 IF G<0 THEN 1690
1680 GOTO 1710
1690 G=G+P5
1700! CALCULATION OF YOUR LOCAL HOUR ANGLE,H, FROM GHA
1710 LET H=L6-G
1720! CALCULATION OF ELEVATION,E, OF OBJECT
1730 LET E3=COS(L5)*COS(H)*COS(D1)+SIN(D1)*SIN(L5) !SIN OF ELEVATION
1740 LET E2=SQR(1-(E3*E3))
1750 LET E=ATN(E3/E2)
1760 IF E<0 THEN 2170
1770 IF E>I6*R5 THEN 2170
1780! CALCULATION OF AZIMUTH,A, OF OBJECT
1790 LET A2=SIN(D1)/(COS(L5)*COS(E))
1800 LET A2=A2-(SIN(L5)/COS(L5))*(SIN(E)/COS(E))
1810 LET A1=SIN(L5)*SIN(D1)+COS(L5)*COS(D1)*COS(H)
1820 LET A1=(SIN(H)*COS(D1))/(SQR(1-A1^2))
1830 LET A=ATN(A1/A2) !AZIMUTH=ARCTAN (SIN OF AZ/COS OF AZ)
1840 GOSUB 1860
1850 GOTO 2020
1860! REMOVAL OF AMBIGUITIES INCURRED WITH ATN FUNCTION
1870 IF A=0 THEN 1890
1880 GOTO 1930
1890 IF A2<0 THEN 1910
1900 GOTO 2010
1910 LET A=P5/2
1920 GOTO 2010
1930 IF A>0THEN 1990
1940 IF A2<0 THEN 1970
1950 LET A=P5+A
1960 GOTO 2010
1970 LET A=P5+(A-P5/2)
1980 GOTO 2010
1990 IF A2>=0 THEN 2010
2000 LET A=A+P5/2
2010 RETURN
2020 IF (T-I1)>(2*I)/1440 THEN 2040
2030 GOTO 2145
2040 PRINT
2145 PRINT IN FORM "4D":(INT(B+.5))
2150 PRINT IN IMAGE "          %%%.%          %%.%
%%%.%         %%%.%":FNA(A),FNA(E),FNA(G),FNA(D1)
2160 LET I1=T
2170 LET B=B+1
2180 LET Z=(B-INT(B/100)*100)-60
2190 IF Z<0 THEN 1290
2200 LET B=INT(B/100)*100+1100+Z
2210 GOTO 1290
2220 NEXT N
2230 LET N=0
2240 PRINT
2250 PRINT
2260 PRINT
2270 PRINT "DO YOU WANT MORE INFORMATION":
2280 INPUT D$
2290 IF D$="YES" THEN 540
2300 END
