program de_tokenize;

{
  11/15/1985

  Version 1.0    by John Michael T.
                    Detroit, Michigan

  detokenize IBM basica tokenized programs into ascii

  this is a preliminary version that works most of the time.
  i'm still having problems with conversion of double and
  single precision numbers.

  i have put this out as a demo of how to detokenize and also
  just in case someone out there can help out with the double/
  single precision conversions.

}

type
 st255 = string[255];
 st2 = string[2];

var
    fvar1,fvar2 : text[$F00];
    ch_r,a,b,c,header,mystery_a,mystery_b : char;
    a_val,b_val,c_val : integer;
    line_no : integer;
    line : st255;
    end_flag : boolean;

FUNCTION POWER(X,N : INTEGER) : INTEGER;
BEGIN
   IF N = 1
      THEN POWER := X
      ELSE POWER := X*POWER(X,N-1)
END;

FUNCTION SPACES(NUM : INTEGER) : ST255;
  VAR
    SP1 : INTEGER;
    SPACE : ST255;
  BEGIN
    SPACE := '';
    FOR SP1 := 1 TO NUM DO
        SPACE := SPACE + ' ';
    SPACES := SPACE;
  END;

function fns ( a1 : integer) : st255;
var
 a1s : st255;
begin
 str(a1,a1s);
 fns := a1s;
end;

function fnsr ( a1 : real) : st255;
var
 a1s : st255;
begin
 str(a1,a1s);
 fnsr := a1s;
end;

function cvi (a1,a2 : char) : integer;
begin
 cvi := ord(a1) + (ord(a2)*256);
end;

function hex(num : integer) : st2;
var
 hex_str : string[16];
 h1,h2 : integer;
begin
 hex_str := '0123456789ABCDEF';
 h1 := num div 16;
 h2 := num mod 16;
 if h1 <> 0
  then
     hex := hex_str[h1+1] + hex_str[h2+1]
   else
     hex := hex_str[h2+1];
end;

procedure accept_cvi;
var
 a_val,b_val,c_val : integer;
 a1,b1,a3 : char;
begin
 read(fvar1,a1);
 read(fvar1,b1);
 a_val := ord(a1);
 b_val := ord(b1);
 c_val := a_val + (b_val*256);
 line := line + fns(c_val);
end;

procedure accept_hex;
var
 a_val,b_val : integer;
 a1,b1 : char;
begin
 read(fvar1,a1);
 read(fvar1,b1);
 a_val := ord(a1);
 b_val := ord(b1);
 line := line + '&H' + hex(b_val) + hex(a_val);
end;

procedure accept_cvs;
var
 a1,a2,a3,a4,a5 : char;
 base,bnum,a,b,c,d,laser,ph : integer;
 resol,cvs : real;
begin
 read(fvar1,a1);
 read(fvar1,a2);
 read(fvar1,a3);
 read(fvar1,a4);
 a := ord(a1);
 b := ord(a2);
 c := ord(a3);
 d := ord(a4);
 if (c=128) and (d=129)
    then cvs := -1
    else
      begin
        base := d-129;
        bnum := power(2,base);
        resol := bnum/128;
        laser := trunc(c*resol);
        ph := trunc(b/(128/resol));
        cvs := bnum+laser+ph
      end;
  line := line + fnsr(cvs);
end;

procedure accept_cvd;
var
 a1,a2,a3,a4,a5 : integer;
 base,bnum,a,b,c,d,laser,ph : integer;
 resol,cvs : real;
begin
 read(fvar1,a1);
 read(fvar1,a2);
 read(fvar1,a3);
 read(fvar1,a4);
 a := ord(a1);
 b := ord(a2);
 c := ord(a3);
 d := ord(a4);
 if (c=128) and (d=129)
    then cvs := -1
    else
      begin
        base := d-129;
        bnum := power(2,base);
        resol := bnum/128;
        laser := trunc(c*resol);
        ph := trunc(b/(128/resol));
        cvs := bnum+laser+ph
      end;
  line := line + fnsr(cvs);
end;

procedure get_line_no;
var
 lsb,msb : char;
begin
 read(fvar1,lsb);
 read(fvar1,msb);
 line_no := cvi(lsb,msb);
 line := fns(line_no) + ' ';
end;

procedure form_line;
begin
  a_val := 1;
  end_flag := false;
  repeat
   read(fvar1,a);
   a_val := ord(a);
   case a_val of
     255 : begin
             read(fvar1,b);
             b_val := ord(b);
             case b_val of
               165 : line := line + 'LOF';
               164 : line := line + 'LOC';
               163 : line := line + 'EOF';
               162 : line := line + 'STRIG';
               161 : line := line + 'STICK';
               160 : line := line + 'PEN';  {???}
               159 : line := line + 'FIX';
               158 : line := line + 'CDBL';
               157 : line := line + 'CSNG';
               156 : line := line + 'CINT';
               155 : line := line + 'LPOS';
               154 : line := line + 'HEX$';
               153 : line := line + 'OCT$';
               152 : line := line + 'SPACE$';
               151 : line := line + 'PEEK';
               150 : line := line + 'CHR$';
               149 : line := line + 'ASC';
               148 : line := line + 'VAL';
               147 : line := line + 'STR$';
               146 : line := line + 'LEN';
               145 : line := line + 'POS';
               144 : line := line + 'INP';
               143 : line := line + 'FRE';
               142 : line := line + 'ATN';
               141 : line := line + 'TAN';
               140 : line := line + 'COS';
               139 : line := line + 'EXP';
               138 : line := line + 'LOG';
               137 : line := line + 'SIN';
               136 : line := line + 'RND';
               135 : line := line + 'SQR';
               134 : line := line + 'ABS';
               133 : line := line + 'INT';
               132 : line := line + 'SGN';
               131 : line := line + 'MID$';
               130 : line := line + 'RIGHT$';
               129 : line := line + 'LEFT$';
             end; {case 255 & b_val of}
           end; {case a_val of 255}

     254 : begin
             read(fvar1,b);
             b_val := ord(b);
             case b_val of
               158 : line := line + 'PMAP';
               157 : line := line + 'WINDOW';
               156 : line := line + 'VIEW';
               155 : line := line + 'ENVIRON';
               154 : line := line + 'SHELL';                                   
               153 : line := line + 'RMDIR';                                   
               152 : line := line + 'MKDIR';                                   
               151 : line := line + 'CHDIR';
               150 : line := line + 'IOCTL';
               149 : line := line + 'ERDEV';
               148 : line := line + 'TIMER';                                   
               147 : line := line + 'PLAY';
               146 : line := line + 'DRAW';
               145 : line := line + 'CIRCLE';
               144 : line := line + 'COM';
               143 : line := line + 'PAINT';
               142 : line := line + 'TIME$';                                   
               141 : line := line + 'DATE$';
               140 : line := line + 'CHAIN';
               139 : line := line + 'COMMON';
               138 : line := line + 'RESET';
               137 : line := line + 'GET';
               136 : line := line + 'PUT';
               135 : line := line + 'KILL';
               134 : line := line + 'RSET';
               133 : line := line + 'LSET';
               132 : line := line + 'NAME';
               131 : line := line + 'SYSTEM';
               130 : line := line + 'FIELD';
               129 : line := line + 'FILES';
             end; {case 254 & b_val of}
           end; {case a_val of 254}

     253 : begin
             read(fvar1,b);
             b_val := ord(b);
             case b_val of
               129 : line := line + 'CVI';
               130 : line := line + 'CVS';
               131 : line := line + 'CVD';
               132 : line := line + 'MKI$';
               133 : line := line + 'MKS$';
               134 : line := line + 'MKD$';
             end; {case 253 & b_val of}
           end; {case a_val of 253}

     250 : line := line + 'RESTORE';

     244 : line := line + '\';
     243 : line := line + 'MOD';
     242 : line := line + 'IMP';
     241 : line := line + 'EQV';
     240 : line := line + 'XOR';
     239 : line := line + 'OR';
     238 : line := line + 'AND';
     237 : line := line + '^';
     236 : line := line + '/';
     235 : line := line + '*';
     234 : line := line + '-';
     233 : line := line + '+';
     232 : line := line + '<';
     231 : line := line + '=';
     230 : line := line + '>';

     222 : line := line + 'INKEY$';
     221 : line := line + 'OFF';
     220 : line := line + 'POINT';
     219 : line := line + 'CSRLIN';
     218 : line := line + 'VARPTR';

     216 : line := line + 'INSTR';
     215 : line := line + 'USING';
     214 : line := line + 'STRING$';
     213 : line := line + 'ERR';
     212 : line := line + 'ERL';
     211 : line := line + 'NOT';
     210 : line := line + 'SPC(';
     209 : line := line + 'FN';
     208 : line := line + 'USR';
     207 : line := line + 'STEP';
     206 : line := line + 'TAB(';
     205 : line := line + 'THEN';
     204 : line := line + 'TO';

     202 : line := line + 'LOCATE';
     201 : line := line + 'KEY';
     200 : line := line + 'SCREEN';
     199 : line := line + 'PRESET';
     198 : line := line + 'PSET';
     197 : line := line + 'BEEP';
     196 : line := line + 'SOUND';
     195 : line := line + 'BLOAD';
     194 : line := line + 'BSAVE';
     193 : line := line + 'MOTOR';
     192 : line := line + 'CLS';
     191 : line := line + 'COLOR';
     190 : line := line + 'SAVE';
     189 : line := line + 'MERGE';
     188 : line := line + 'LOAD';
     187 : line := line + 'CLOSE';
     186 : line := line + 'OPEN';
     185 : line := line + 'RANDOMIZE';
     184 : line := line + 'OPTION';
     183 : line := line + 'WRITE';

     179 : line := line + 'CALL';
     178 : line := line + 'WEND';

   {  177 : line := line + 'WHILE'; }
     177 : begin
             read(fvar1,b);
             b_val := ord(b);
             if b_val = 233
              then
                line := line + 'WHILE'
             else
              line := line + '*** UNKNOWN for 177 ***';
           end; {case 177 of}

     176 : line := line + 'LINE';
     175 : line := line + 'DEFDBL';
     174 : line := line + 'DEFSNG';
     173 : line := line + 'DEFINT';
     172 : line := line + 'DEFSTR';
     171 : line := line + 'RESUME';
     170 : line := line + 'AUTO';
     169 : line := line + 'DELETE';
     168 : line := line + 'RESUME';
     167 : line := line + 'ERROR';
     166 : line := line + 'EDIT';
     165 : line := line + 'ERASE';
     164 : line := line + 'SWAP';
     163 : line := line + 'TROFF';
     162 : line := line + 'TRON';

     160 : line := line + 'WIDTH';

     158 : line := line + 'LLIST';
     157 : line := line + 'LPRINT';
     156 : line := line + 'OUT';

     153 : line := line + 'CONT';
     152 : line := line + 'POKE';

     151 : begin
             read(fvar1,b);
             b_val := ord(b);
             case b_val of
               { 209 : line := line + 'DEF FN'; }
               208 : line := line + 'DEF USR';
                32 : line := line + 'DEF ';
             end; {case b_val of}
            end; {case a_val 151 of}

     150 : line := line + 'WAIT';
     149 : line := line + 'ON';
     148 : line := line + 'NEW';
     147 : line := line + 'LIST';
     146 : line := line + 'CLEAR';
     145 : line := line + 'PRINT';
     144 : line := line + 'STOP';
     143 : line := line + 'REM';
     142 : line := line + 'RETURN';
     141 : line := line + 'GOSUB';

     139 : line := line + 'IF';
     138 : line := line + 'RUN';
     137 : line := line + 'GOTO';
     136 : line := line + 'LET';
     135 : line := line + 'READ';
     134 : line := line + 'DIM';
     133 : line := line + 'INPUT';
     132 : line := line + 'DATA';
     131 : line := line + 'NEXT';
     130 : line := line + 'FOR';
     129 : line := line + 'END';

      58 : begin
             read(fvar1,b);
             b_val := ord(b);
             case b_val of
                  0 : begin
                        line := line + ':';
                        end_flag := true;
                      end;
                161 : line := line + 'ELSE';
                143 : begin
                        read(fvar1,c);
                        c_val := ord(c);
                        if c_val = 217
                          then
                            line := line + chr(39)
                          else
                           line := line + chr(58) + chr(b_val) + chr(c_val);
                      end; {case b_val 143 of}
             else
               line := line + chr(58) + chr(b_val);
            end; {case b_val of}
           end; {case a_val 58 of}

     30 : accept_cvd;
     29 : accept_cvs;
     28 : accept_cvi;
     26 : end_flag := true;
 17..25 : line := line + fns(a_val-17);

     15 : begin
            read(fvar1,b);
            b_val := ord(b);
            line := line + fns(b_val);
          end;

     14 : accept_cvi;

     12 : accept_hex;


  else
    if (a_val <> 0) and (not end_flag)
     then
      line := line + chr(a_val);
   end; {case a_val of}
   until (a_val = 0) or end_flag;
end;


{ -------- MAIN --------- }

begin
    assign(fvar1,'test2.bas');    {source tokenized}
    assign(fvar2,'test2.asc');    {dest ascii}
    reset(fvar1);
    rewrite(fvar2);
    read(fvar1,header);
    line_no := 1;
    while line_no <> 0 do
      begin
        read(fvar1,mystery_a);
        read(fvar1,mystery_b);
        get_line_no;
        form_line;
        writeln(fvar2,line);
      end;
    close(fvar1);
    close(fvar2);
end.
