SUB CREDITS STATIC

REM PUTS UP CREDITS WHEN PROGRAM INVOKED

DEFINT A-Z
SEC = 3
CLS
KEY OFF

RO=01:CO=12:X$="BLED - A SOURCE CODE MERGE UTILITY  ver 1.61  Mar 21, 1987"
CALL QPRINT (X$,RO,CO)
RO=03:CO=03:X$="Copyright (c) 1985-87  Ken Goosens, 5020 Portsmouth Rd, Fairfax, VA 22032"
CALL QPRINT (X$,RO,CO)
RO=06:CO=02:X$="You are granted a limited license to use and distribute this program provided"
CALL QPRINT (X$,RO,CO)
RO=08:CO=10:X$="1.  you do not alter or remove this notice"
CALL QPRINT (X$,RO,CO)
RO=10:CO=10:X$="2.  you receive no fee or charge for this program"
CALL QPRINT (X$,RO,CO)
RO=12:CO=10:X$="3.  modifications are distributed only as a merge to this program"
CALL QPRINT (X$,RO,CO)
RO=14:CO=10:X$="4.  you assume all liability for using this program"
CALL QPRINT (X$,RO,CO)
LOCATE 16,1:CALL PRTHELP
CALL WAITSECORKEY (SEC)

END SUB

SUB PRTHELP STATIC

REM PRINTS HELP (DOCUMENTATION) SCREEN

PRINT
PRINT "    To apply  a merge:  BLED[/B/L/M]  {source} {merges} {new file}"
PRINT "    To create a merge:  BLED[/F/B]  {old version} {new version} {merges}"
PRINT "All arguments optional: B=run batch  F=file compare  L=line# merge  M=merge"
PRINT

END SUB
SUB GETNXTCMD (CMD$,DOCCHAR$,STBLKTYPE$,ENDBLKTYPE$,STDES.NO%,ENDDES.NO%,_
               STTARGET$,ENDTARGET$,INCREMENT%,PTR%,CMD.TYPE$,_
               INS.BLKTYPE$,FIXED.NO%,BLK.DISP$) STATIC

REM FETCHES NEXT COMMAND, PARSES, AND SETS ALL PARMS FOR PROCESSING

DEFINT A-Z
DIM BUF$(10)
REM PRINT "GETNXTCMD ENTERED"
CALL READNXT (BUF$(),NUM.NBUF%,DOCCHAR$,CMD$)

IF CMD$ = "" THEN_
   CMD.TYPE$ = ""_
ELSE_
   CALL PARSECMD (CMD$,STBLKTYPE$,ENDBLKTYPE$,STDES.NO%,ENDDES.NO%,_
               STTARGET$,ENDTARGET$,INCREMENT%,PTR%,INCLUSIVE%,CMD.TYPE$,_
               INS.BLKTYPE$,FIXED.NO%):_
   IF CMD.TYPE$ = "B" THEN_
      CALL GETDISP (BUF$(),NUM.NBUF%,DOCCHAR$,BLK.DISP$):_
      IF INCLUSIVE% THEN_
        NUM.NBUF% = NUM.NBUF%+1:_
        BUF$(NUM.NBUF%) = BLK.DISP$:_
        NUM.NBUF% = NUM.NBUF%+1:_
        BUF$(NUM.NBUF%)="BLOCK FROM LINE * TO *+1"

REM PRINT "GETNXTCMD: CMD=";CMD$;" CMD TYPE=";CMD.TYPE$;" BLOCK DISP=";BLK.DISP$
END SUB

SUB GETDISP (BUF$(1),NUM.NBUF%,DOCCHAR$,BLK.DISP$) STATIC

REM PASS BUF$      - ARRAY CONTAINING BUFFERED BLED COMMANDS
REM      NUM.NBUF%  - NUMBER OF UNUSED ELEMENTS IN BUF$
REM      DOCCHAR$   - FIRST CHAR OF REMARK LINE IN MERGE FILE (1ST WORD)
REM GET  BLK.DISP$  - DISPOSITION OF BLOCK

DEFINT A-Z
REM PRINT "GETDISP ENTERED NUM.NBUF=";NUM.NBUF%
ONE = 1
  CALL READNXT (BUF$(),NUM.NBUF%,DOCCHAR$,CMD$)
  CALL FIRSTNB (CMD$,ONE,BS)
  IF BS>0 THEN BLK.DISP$ = MID$(CMD$,BS,1) ELSE BLK.DISP$ = "K"
  IF INSTR("DRK",BLK.DISP$) = 0 THEN_
     BLK.DISP$="K":_
     NUM.NBUF% = NUM.NBUF%+1:_
     BUF$(NUM.NBUF%) = CMD$_
  ELSE_
     IF BLK.DISP$ = "R" THEN_
        BLK.DISP$ = "D":_
        NUM.NBUF% = NUM.NBUF%+1:_
        CALL LASTNB (CMD$,BS,ES):_
        IF ES < LEN(CMD$) THEN_
           BUF$(NUM.NBUF%) = "I "+MID$(CMD$,ES+1)_
        ELSE_
           N$="REPLACE command must be followed by 'BLOCK' or # of lines":_
           CALL WRMIS (CMD$,N$)
           
END SUB

SUB READNXT (BUF$(1),NUM.NBUF%,DOCCHAR$,CMD$) STATIC

REM PROCESSES REQUEST FOR NEXT BLED COMMAND
REM PASS BUF$     - BUFFER ARRAY
REM      NUM.NBUF% - NUMBER ACTIVE ENTRIES IN BUFFER
REM      DOCCHAR$  - FIRST CHAR OF DOCUMENTATION LINE
REM GET  CMD$     - BLED COMMAND LINE 

DEFINT A-Z
ONE = 1
CMD$=""
FW$=""
IF NUM.NBUF% > 0 THEN_
   CMD$ = BUF$(NUM.NBUF%):_
   NUM.NBUF% = NUM.NBUF%-1:_
   GOTO GETOUTREADNXT

WHILE (CMD$=SPACE$(LEN(CMD$)) OR LEFT$(FW$,1)=DOCCHAR$) AND NOT EOF(2)
   CALL GETTRANS (CMD$,ONE)
   CALL FIRSTWORD (CMD$,FW$,BEGIN.AT)
WEND
IF EOF(2) AND LEFT$(FW$,1)=DOCCHAR$ THEN_
   CMD$=""
IF CMD$=SPACE$(LEN(CMD$)) THEN_
   IF EOF(1) THEN_
      CMD$=""_
   ELSE_
      CMD$ = "BLOCK FROM LINE * THRU END":_
      NUM.NBUF% = NUM.NBUF%+1:_
      BUF$(NUM.NBUF%)="KEEP"

GETOUTREADNXT:
REM PRINT "FROM READNXT: CMD IS {";CMD$;"}  DOCCHAR=";DOCCHAR$
END SUB

SUB PRTSCRN (NUMFLDS%,ROW%(1),COL%(1),PROMPT$(1),FLDSIZE%(1),_
                FLDTYPE$(1),FLDVAL$(1),HLP$(1)) STATIC

REM PRINTS TABLE DRIVEN SCREEN

DEFINT A-Z
CLS
FOR I=1 TO NUMFLDS%
  CALL QPRINT (PROMPT$(I),ROW%(I),COL%(I))
  X% = COL%(I)+LEN(PROMPT$(I))+1
  CALL ECHO (FLDVAL$(I),ROW%(I),X%,FLDSIZE%(I))
NEXT I

END SUB

SUB GETSCRN (NUMFLDS%,ROW%(1),COL%(1),PROMPT$(1),FLDSIZE%(1),_
                FLDTYPE$(1),FLDVAL$(1),HLP$(1)) STATIC

REM DOES FULL SCREEN DATA ENTRY FOR TABLE DRIVEN SCREEN

DEFINT A-Z
NUL$ = ""
TOPGETSCRN:
  FOR I=1 TO NUMFLDS%
    CALL EXPLAIN (HLP$(I))
    X = INSTR("LSN",FLDTYPE$(I))
    IF X > 1 THEN_
      IF X = 2 THEN_
         CALL GETSTR (ROW%(I),COL%(I),PROMPT$(I),FLDSIZE%(I),FLDVAL$(I))_
      ELSE_
         CALL GETNATNUM (ROW%(I),COL%(I),PROMPT$(I),FLDSIZE%(I),FLDVAL$(I))
  NEXT I

END SUB

SUB PARSECMD (CMD$,STBLKTYPE$,ENDBLKTYPE$,STDES.NO%,ENDDES.NO%,_
               STTARGET$,ENDTARGET$,INCREMENT%,PTR%,INCLUSIVE%,CMD.TYPE$,_
               INS.BLKTYPE$,FIXED.NO%) STATIC

DEFINT A-Z
DIM WRDS$(10)
REM BREAKS COMMAND LINE INTO WORDS AND CHECKS FOR PROPER SYNTAX

REM PASS CMD$     - BLED COMMAND LINE
REM      PTR%     - CURRENT LINE POSITION IN ORIGINAL SOURCE FILE
REM GET  STBLKTYPE$  - BLOCK TYPE DEFINING START BLOCK
REM     ENDBLKTYPE#  - BLOCK TYPE DEFINING END BLOCK
REM      STDES.NO%   - LINE NUMBER OF SOURCE THAT BEGINS BLOCK
REM     ENDDES.NO%   - LINE NUMBER OF SOURCE THAT ENDS BLOCK
REM      STTARGET$   - STRING/LABEL DEFINING START OF BLOCK
REM     ENDTARGET$   - STRING/LABEL DEFINING END OF BLOCK
REM     INCREMENT%   - COUNTER FOR ADVANCING READS (0 IF TO END,
REM                       NORMALLY AND OTHERWISE 1)
REM     CMD.TYPE$    - TYPE OF COMMAND (Insert, Block)
REM     INS.BLKTYPE$ - TYPE OF INSERT BLOCK (Blocked, or Lines)
REM     FIXED.NO%    - Fixed number of lines to insert

CALL BRKWORDS(CMD$,WRDS$())

CMD.TYPE$ = LEFT$(WRDS$(1),1)
IF INSTR("IB",CMD.TYPE$) = 0 THEN_
   EXP$ = "BLED COMMAND MUST BEGIN WITH 'I' OR 'B'":_
   CALL WRMIS(EXP$,CMD$):_
   GOTO GETOUT:
IF CMD.TYPE$ = "I" AND WRDS$(2)="" THEN WRDS$(2)="B"
IF CMD.TYPE$ = "I" THEN_
   IF LEFT$(WRDS$(2),1) <> "B" THEN_
      INS.BLKTYPE$="L":_
      CALL NUMERIC(WRDS$(2),POSNUM):_
      IF POSNUM THEN_
         FIXED.NO% = VAL(WRDS$(2)):GOTO GETOUT:_
      ELSE_
         EXP$ = "INSERT command should specify # of lines to include":_
         CALL WRMIS(EXP$,CMD$):GOTO GETOUT:_
   ELSE_
      INS.BLKTYPE$="B":_
      GOTO GETOUT:
  
IF LEFT$(WRDS$(2),1) = "F" THEN_
   NXT.WRD = 3 _
ELSE_
   NXT.WRD = 2
CALL CHKWRDS (STBLKTYPE$,STDES.NO%,STTARGET$,NXT.WRD,INCREMENT%,WRDS$(),_
              NXT.WRD,PTR%)
NXT.WRD = NXT.WRD + 1
FL$ = LEFT$(WRDS$(NXT.WRD),1)
IF INSTR("UT",FL$) = 0 THEN_
   INCLUSIVE%=0 _
ELSE_
   NXT.WRD = NXT.WRD+1:_
   IF FL$="U" OR WRDS$(NXT.WRD-1)="TO" THEN_
      INCLUSIVE% = 0_
   ELSE_
      INCLUSIVE% = -1
CALL CHKWRDS (ENDBLKTYPE$,ENDDES.NO%,ENDTARGET$,NXT.WRD,INCREMENT%,WRDS$(),_
              NXT.WRD,PTR%)
GETOUT:
REM PRINT "PARSECMD: INCLUSIVE=";INCLUSIVE%
END SUB

SUB CHKWRDS(BLKTYPE$,DES.NO%,TARGET$,NUWRD%,INCMT%,WRDS$(1),BEG%,PTR%) STATIC

DEFINT A-Z
REM PASS WRDS$      - ARRAY OF WORDS
REM      BEG%        - FIRST ELEMENT OF ARRAY TO EXAMINE
REM      PTR%        - CURRENT LINE # OF SOURCE FILE
REM GET  BLKTYPE$  - HOW BLOCK DEFINED (LINE,STRING,LABEL)
REM      DES.NO%     - DESIRED LINE NUMBER FOR LINE BLOCK TYPE
REM      TARGET$    - TARGET STRING FOR STRING/LABEL BLOCK TYPE
REM      INCMT%      - FLAG SET TO 0 WHEN BLOCK EXTENDS TO END-OF-FILE,
REM                     OTHERWISE 1
REM      NUWRD%      - LAST WORD POSITION THIS ROUTINE EXAMINED
REM PRINT "SUB CHKWRDS RECEIVED BEG=";BEG%;" PTR=";PTR%
TARGET$=""
INCMT%=1
DES.NO%=0
IF BEG%<1 THEN BEG%=1:PRINT "UPPED BEG%"
REM IF PTR%<10 THEN PTR%=10:PRINT "UPPED PTR%"
WD$ = WRDS$(BEG%)
FLET$ = LEFT$(WD$,1)
IF FLET$ <> "L" AND FLET$ <> "S" THEN_
   BLKTYPE$ = "L":_
   NUWRD% = BEG%_
ELSE_
   NUWRD% = BEG%+1:_
   IF WD$ = "LABEL" OR WD$="LABEL#" THEN_
     BLKTYPE$ = "LABEL":_
     TARGET$ = WRDS$(NUWRD%)_
   ELSE IF FLET$ = "S" THEN_
     BLKTYPE$ = "S":_
     TARGET$ = WRDS$(NUWRD%)_
   ELSE_
     BLKTYPE$ = "L"
WD$ = WRDS$(NUWRD%)
L2$ = LEFT$(WD$,2)
RES$ = MID$(WD$,3)
IF BLKTYPE$ = "L" THEN_
  IF L2$ = "*+" THEN_
      CALL NUMERIC (RES$,POSNUM):_
      IF POSNUM THEN_
         DES.NO% = VAL(RES$)+PTR%_
      ELSE_
         M$="NON-NUMERIC IN LINE NUMBER FIELD":_
         CALL WRMIS(M$,WD$)_
  ELSE_
      IF L2$ = "*" THEN_
        DES.NO% = PTR%_
      ELSE_
        CALL NUMERIC(WD$,POSNUM):_
        IF POSNUM THEN_
           DES.NO% = VAL(WD$)_
        ELSE IF WD$ = "END" THEN_
               INCMT% = 0_
             ELSE_
               M$="NON-NUMERIC IN LINE NUMBER FIELD":_
               CALL WRMIS(M$,WD$)
IF BLKTYPE$ <> "L" AND TARGET$ = "" THEN_
    M$ = "STRING/LABEL MISSING":_
    CALL WRMIS(M$,WD$)
REM PRINT "CHKWRDS RETURNED DESNO=";DES.NO%;" NUWRD=";NUWRD%
END SUB

SUB GETSTR (ROW%,COL%,PROMPT$,FLDSIZE%,RESULT$) STATIC

REM INPUT ROUTINE TO GET A STRING
REM LOCATE 24,70:PRINT "GETSTR  ";

X% = FLDSIZE%+1:IF X%<8 THEN X%=8
CALL QPRINT (PROMPT$+SPACE$(X%),ROW%,COL%)
X% = COL% + LEN(PROMPT$) + 1
CALL ECHO (RESULT$,ROW%,X%,FLDSIZE%)
LOCATE ROW%,X%
INPUT "",X$
IF X$ <> "" THEN RESULT$ = X$:CALL ECHO (RESULT$,ROW%,X%,FLDSIZE%)

END SUB

SUB GETCHAR (ROW%,COL%,PROMPT$,VLDANS$,RESULT$) STATIC

REM ROUTINE TO GET SINGLE CHARACTER
REM LOCATE 24,70:PRINT "GETCHAR ";
DEFINT A-Z
CR$ = CHR$(13)
FLDSIZE% = 1
CALL QPRINT (PROMPT$+RESULT$,ROW%,COL%)
X% = COL% + LEN(PROMPT$)
LOCATE ROW%,X%,1,6,7
X$ = INPUT$(1)
IF X$ = CR$ THEN X$ = RESULT$:IF X$="" THEN X$=CHR$(0)
CALL UPCASE (X$)
IF VLDANS$ <> "" THEN_
    WHILE INSTR(VLDANS$,X$)=0:_
      BEEP:_
      X$ = INPUT$(1):CALL UPCASE (X$):_
    WEND
RESULT$ = X$:PRINT RESULT$;

END SUB

SUB GETNATNUM (ROW%,COL%,PROMPT$,FLDSIZE%,RESULT$) STATIC

REM ROUTINE TO INPUT ONLY NATURAL NUMBER (> OR = 0)
REM LOCATE 24,70:PRINT "GETNATNUM ";

DEFINT A-Z
RESTART:
  CALL GETSTR (ROW%,COL%,PROMPT$,FLDSIZE%,RESULT$)
  CALL NUMERIC (RESULT$,NONNEG%)
IF NOT NONNEG% THEN BEEP:GOTO RESTART

END SUB

SUB ECHO (STRNG$,ROW%,COL%,FLDSIZE%) STATIC

REM ROUTINE FOR CLEARING A SPACE AND PRINTING MESSAGE

CALL QPRINT (SPACE$(FLDSIZE%),ROW%,COL%)
CALL QPRINT (STRNG$,ROW%,COL%)

END SUB

SUB TRIM (STRNG$) STATIC

REM REMOVES LEADING AND TRAILING BLANKS FROM STRNG$

DEFINT A-Z
ONE = 1
CALL FIRSTNB (STRNG$,ONE,STRT)
IF STRT < 1 THEN_
   STRT = 1:LST = 0_
ELSE_
   CALL ENDNB (STRNG$,LST)
STRNG$ = MID$(STRNG$,STRT,LST-STRT+1)

END SUB

SUB ENDNB (STRNG$,LST%) STATIC

REM LOCATES LAST NON-BLANK CHARACTER IN STRNG$.  0 IF NONE.

REM PASS STRNG$ - STRING TO BE SEARCHED
REM GET  LST%   - POSITION IN STRNG$ OF LAST NON-BLANK

   X$ = "!"+STRNG$
   LST% = LEN(X$)
   WHILE MID$(X$,LST%,1)=" "
     LST% = LST%-1
   WEND
   LST% = LST% - 1

END SUB

SUB BRKWORDS (STRNG$,WORDS$(1)) STATIC

REM PASS STRNG$  - A STRING TO BE BROKEN INTO WORDS (SPACE
REM                 DELIMITED STRINGS)
REM      WORDS$  - AN ARRAY TO PUT WORDS IN

DEFINT A-Z
ONE = 1
LST = LEN(STRNG$)
X$ = STRNG$ + " !"
CALL FIRSTNB(X$,ONE,BS)
NPARMS = 0
MAXPARMS = UBOUND(WORDS$)
WHILE BS <= LST
  NPARMS = NPARMS + 1
  CALL LASTNB (X$,BS,ES)
  IF NPARMS > MAXPARMS THEN _
     BS = LST+1_
  ELSE_
     WORDS$(NPARMS) = MID$(X$,BS,ES-BS+1):_
     BS = ES+1:_
     CALL FIRSTNB(X$,BS,BS)
WEND
END SUB

SUB FIRSTWORD (STRNG$,FIRST.WORD$,BS) STATIC

REM RETURNS FIRST WORD IN STRNG$
REM PASS STRNG$   - STRING TO BE SEARCHED
REM GET  FIRST.WORD$ - FIRST WORD IN STRNG$

DEFINT A-Z

ONE = 1
CALL FIRSTNB (STRNG$,ONE,BS)
IF BS > 0 THEN_
   CALL LASTNB (STRNG$,BS,ES):_
   FIRST.WORD$ = MID$(STRNG$,BS, ES-BS+1)_
ELSE_
   FIRST.WORD$ = ""

END SUB

SUB FIRSTNB (STRNG$,BEG%,WHEREIS%) STATIC

REM PASS STRNG$  - A STRING TO BE SEARCHED
REM      BEG%     - POSITION TO BEGIN SEARCH
REM GET  WHEREIS% - POSITION IN STRNG$ OF FIRST NON-BLANK AT
REM                  BEG% OR LATER.  RETURNS 0 IF NO NON-BLANK.

DEFINT A-Z
REM LOCATE 24,70:PRINT "FIRSTNB  ";
X$ = STRNG$+"!"
WHEREIS% = BEG%
IF WHEREIS% < 1 THEN WHEREIS% = 1
WHILE MID$(X$,WHEREIS%,1) = " "
   WHEREIS% = WHEREIS% + 1
WEND
IF WHEREIS% > LEN(STRNG$) THEN WHEREIS% = 0

END SUB

SUB LASTNB (STRNG$,BEG%,WHEREIS%) STATIC

REM PASS STRNG$   - A STRING TO BE SEARCHED
REM      BEG%      - POSITION TO BEGIN SEARCH
REM GET  WHEREIS%  - LAST POSITION IN STRNG$ OF ANY WORD BEGINNING AT
REM                   BEG% OR LATER.  RETURNS BEG%-1 IF NO WORD AT BEG%.

DEFINT A-Z
REM LOCATE 24,70:PRINT "LASTNB  ";
B = BEG%
IF B < 1 THEN B = 1
IF B > LEN(STRNG$) THEN_
   X$ = " " _
ELSE_
   X$ = MID$(STRNG$,B)+" "
WHEREIS% = INSTR(X$," ") - 1 + B - 1

END SUB

SUB REALNUM (STRNG$,RESULT%) STATIC

REM CHECKS WHETHER STRNG$ IS A VALID REAL NUMBER
REM PASS STRNG$  - STRING TO BE CHECKED
REM GET  RESULT% - TRUE IF REAL

DEFINT A-Z
X$ = STRNG$+"."
LENGTH = LEN(STRNG$)
J=1
WHILE INSTR("+- ",MID$(X$,J,1))
  J=J+1
WEND
IF J > LENGTH THEN RESULT% = 0:EXIT SUB

X = INSTR(X$,".")
FRONT$ = MID$(STRNG$,J,X-J)
IF X > LENGTH THEN_
   BACK$=""_
ELSE_
   BACK$  = MID$(STRNG$,X+1)

CALL NUMERIC (FRONT$,FRNNAT%)
CALL NUMERIC (BACK$,BNNAT%)
RESULT% = (FRNNAT% AND BNNAT%)

END SUB

SUB NUMERIC (STRNG$,RESULT%) STATIC

REM PASS STRNG$  - A STRING TO BE SEARCHED
REM GET  RESULT%  - TRUE IF STRNG$ CONTAINS ONLY NON-NEGATIVE DIGITS 
REM                  OR LEADING OR TRAILING BLANKS

DEFINT A-Z
IF STRNG$=SPACE$(LEN(STRNG$)) THEN RESULT%=0:GOTO GETOUTNUMERIC
NUM$="0123456789"
CALL NOOTHER (STRNG$,NUM$,RESULT%)
GETOUTNUMERIC:
END SUB

SUB NOOTHER (STRNG$,ONLY$,RESULT%) STATIC

REM PASS STRNG$  - A STRING TO BE SEARCHED
REM      ONLY$   - A LIST OF THE ONLY CHARACTERS TO BE IN STRNG$
REM GET  RESULT%  - TRUE OF ONLY CHARACTERS IN STRNG$ ARE THOSE IN ONLY$
REM                   OR ARE LEADING OR TRAILING BLANKS

DEFINT A-Z

RESULT% = -1
IF LEN(STRNG$) < 1 THEN GOTO GETOUTNOOTHER
ONE = 1
CALL FIRSTNB(STRNG$,ONE,BS)
CALL LASTNB(STRNG$,BS,ES)

FOR I=BS TO ES
   IF INSTR(ONLY$,MID$(STRNG$,I,1)) = 0 THEN_
      RESULT% = 0:_
      I=ES+1
NEXT I

IF STRNG$ <> MID$(STRNG$,1,ES)+SPACE$(LEN(STRNG$)-ES) THEN RESULT% = 0

GETOUTNOOTHER:
END SUB

SUB REMOVE (L$,BADSTRNG$) STATIC

REM REMOVES FROM L$ ALL INSTANCES OF CHARACTERS IN BADSTRNG$

REM PASS L$        - STRING TO BE ALTERED
REM      BADSTRNG$ - LIST OF CHARACTERS TO REMOVE
REM GET  L$        - ORIGINAL MINUS BADSTRNG$

DEFINT A-Z
J = 0
FOR I=1 TO LEN(L$)
  IF INSTR(BADSTRNG$,MID$(L$,I,1)) = 0 THEN_
     J = J+1:_
     MID$(L$,J,1) = MID$(L$,I,1)
NEXT I
L$ = LEFT$(L$,J)

END SUB

SUB KEEPONLY (L$,GOODSTRNG$) STATIC

REM KEEPS IN L$ ONLY THOSE CHARACTERS IN GOODSTRNG$, I.E.
REM     REMOVES FROM L$ ALL INSTANCES OF CHARACTERS NOT IN GOODSTRNG$

REM PASS L$         - STRING TO BE ALTERED
REM      GOODSTRNG$ - LIST OF CHARACTERS TO KEEP
REM GET  L$         - ORIGINAL MINUS CHARS NOT IN GOODSTRNG$

DEFINT A-Z
J = 0
FOR I=1 TO LEN(L$)
  IF INSTR(GOODSTRNG$,MID$(L$,I,1)) THEN_
     J = J+1:_
     MID$(L$,J,1) = MID$(L$,I,1)
NEXT I
L$ = LEFT$(L$,J)

END SUB

SUB TRANSLATE (L$,GOT$,WANT$) STATIC

REM REPLACES IN L$ ALL INSTANCES OF CHARACTER IN GOT$ BY CORRESPONDING
REM   CHARACTER IN WANT$

REM PASS L$     - STRING TO BE ALTERED
REM      GOT$   - LIST OF CHARACTERS WANTED REPLACED
REM      WANT$  - WHAT REPLACE BY
REM GET  L$     - ALTERED STRING

DEFINT A-Z
FOR I=1 TO LEN(L$)
  PO = INSTR(GOT$,MID$(L$,I,1))
  IF PO THEN MID$(L$,I,1) = MID$(WANT$,PO,1)
NEXT I

END SUB

SUB EXPERR (STRNG$) STATIC

REM EXPLAIN AN ERROR

DEFINT A-Z
BEEP

CALL EXPLAIN (STRNG$)
SEC = 2
CALL WAITSECORKEY (SEC)
BEEP

END SUB

SUB EXPLAIN (STRNG$) STATIC

REM CONTROLS MESSAGE IN INVERSE VIDEO ON LINE 24

DEFINT A-Z
RO = 24
CO = 3
PGE = 0
ATTR = (7 AND 7)*16
X$ = LEFT$(STRNG$,75)
CALL XQPRINT (" "+X$+SPACE$(75-LEN(X$)),RO,CO,ATTR,PGE)
COLOR 7,0

END SUB

SUB WAITSECORKEY (SECONDS%) STATIC

REM PAUSE ROUTINE BASED ON CLOCK
REM SEND SECONDS% - MAXIMUM # SECONDS TO WAIT
REM WILL QUIT IF ANY KEY PRESSED

CURSEC! = (val(mid$(time$,4,2))*60+val(mid$(time$,7,2)))
DONE!   = CURSEC! + SECONDS%
WHILE CURSEC! < DONE! AND INKEY$ = ""
   CURSEC! = (val(mid$(time$,4,2))*60+val(mid$(time$,7,2)))
WEND

END SUB

SUB WRMIS (EXPLAIN$,MISTAKE$) STATIC

REM PASS EXPLAIN$  - ERROR MESSAGE
REM      MISTAKE#  - THE MISTAKE CAUSING THE ERROR
REM      WARNFILE$ - FILE TO WRITE MESSAGES TO
REM GET            - LOG MISTAKE & EXPLANATION TO FILE F$

DEFINT A-Z

PRINT #4,MISTAKE$
PRINT #4,EXPLAIN$
NWARN = NWARN + 1
LOCATE 24,69:PRINT NWARN;

END SUB

SUB GETTRANS (TRANS$,NTRANS%) STATIC

REM FETCHES TRANSACTION RECORD
REM PASS NTRANS% - VALUE OF 0 TO INITIALIZE COUNTER, OTHERWISE > 0
REM GET  TRANS%  - NEW TRANSACTION RECORD

   DEFINT A-Z

   LINE INPUT #2,TRANS$
   IF NTRANS% < 1 THEN LOCTRANS = 0:NTRANS% = 1
   LOCTRANS = LOCTRANS% + 1
   LOCATE 24,31:PRINT LOCTRANS%;

END SUB

SUB CENTERBEG (STRNG$,LSIZE%,BEG%) STATIC

REM COMPUTERS CENTERED POSITION OF STRNG$ IN FIELD OF SIZE LSIZE%
REM PASS STRNG$   - STRING TO BE CENTERED
REM      LSIZE%   - LENGTH OF FIELD TO CENTER
REM GET  BEG%     - STARTING POSITION OF STRNG$ IN LSIZE%.  RETURNS
REM                 1 IF STRNG$ TOO BIG TO FIT

   DEFINT A-Z
   X = LEN(STRNG$)
   IF X > LSIZE% THEN_
     BEG% = 1_
   ELSE_
     BEG% = (LSIZE% - X)/2

END SUB
