100 '   DATAFILE        This program will allow the user to create, append,
110 '                   edit, or display information from a random-access
120 '                   data file called MBRLIST. It shows a few of the
130 '                   fundamental techniques of data file programming.
140 '             NOTE: BASIC must be loaded as follows to run this program:
150 '                   BASIC/S:256
160 '             NOTE: Data entry tests have not been included. The program
170 '                   will run fine without them, but the user should be
180 '                   very careful when entering data. Better yet, insert
190 '                   the tests in the program.
200 '
210 '   Models and techniques in coding have been taken from "Data File Pro-
220 '   gramming in Basic" by LeRoy Finkel and Jerald Brown, John Wiley & Sons,
230 '   Inc., 1981.
240 '
250 '   For limited help call Bob Noble in Philadelphia (215) 329-4205.
260 '
270 '   Variables/Fields Used (22)
280 '     N$ = NF$ = Name. . . . . . . . . . . . . . . . . . . . . . (20)
290 '     S$ = SF$ = Street address. . . . . . . . . . . . . . . . . (30)
300 '     C$ = CF$ = City. . . . . . . . . . . . . . . . . . . . . . (15)
310 '     ST$ = STF$ = State . . . . . . . . . . . . . . . . . . . . .(2)
320 '     Z$ = ZF$ = Zip code. . . . . . . . . . . . . . . . . . . . .(5)
330 '     P$ = PF$ = Phone number. . . . . . . . . . . . . . . . . . (14)
340 '     MJ$ = MJF$ = Month joined. . . . . . . . . . . . . . . . . .(3)
350 '     YJ$ = YJF$ = Year joined . . . . . . . . . . . . . . . . . .(4)
360 '     Q1 = Q1F$ = MKS$(Q1) = Number of times dues paid . . . . . .(2)
370 '     D(1) = DF$(1) = Dues paid. . . . . . . . . . . . . . . . . .(4)
380 '     D(2) = DF$(2) = Dues paid. . . . . . . . . . . . . . . . . .(4)
390 '     D(3) = DF$(3) = Dues paid. . . . . . . . . . . . . . . . . .(4)
400 '     DA$(1) = DAF$(1) = Date dues paid. . . . . . . . . . . . . .(8)
410 '     DA$(2) = DAF$(2) = Date dues paid. . . . . . . . . . . . . .(8)
420 '     DA$(3) = DAF$(3) = Date dues paid. . . . . . . . . . . . . .(8)
430 '     Q2 = Q2F$ = MKS$(Q2) = Number of times other donations made (2)
440 '     OD(1) = ODF$(1) = Other donations. . . . . . . . . . . . . .(4)
450 '     OD(2) = ODF$(2) = Other donations. . . . . . . . . . . . . .(4)
460 '     OD(3) = ODF$(3) = Other donations. . . . . . . . . . . . . .(4)
470 '     DOD$(1) = FDOD$(1) = Date donations made . . . . . . . . . .(8)
480 '     DOD$(2) = FDOD$(2) = Date donations made . . . . . . . . . .(8)
490 '     DOD$(3) = FDOD$(3) = Date donations made . . . . . . . . . .(8)
500 '
510 '           TOTAL = 169 bytes
520 '
530 '   Files Used = MBRLIST
540 '
550 '   Initialize
560 KEY OFF: OPEN "R", 1, "MBRLIST", 256
570 FIELD 1,20ASNF$,30ASSF$,15ASCF$,2ASSTF$,5ASZF$,14ASPF$,3ASMJF$,4ASYJF$,2ASQ1F$,4ASDF$(1),4ASDF$(2),4ASDF$(3),8ASDAF$(1),8ASDAF$(2),8ASDAF$(3),2ASQ2F$,4ASODF$(1),4ASODF$(2),4ASODF$(3),8ASFDOD$(1),8ASFDOD$(2),8ASFDOD$(3)
580 I% = 0
590 '
600 '   Menu of operations
610 '
620 CLS: PRINT "DATAFILE * * * File Open: MBRLIST": PRINT
630 PRINT "    1. Add New Record(s)"
640 PRINT "    2. Edit Record(s)"
650 PRINT "    3. Display Record(s)"
660 PRINT "    4. Task Completed - Return to BASIC"
670 PRINT: INPUT "ENTER SELECTION (1-4):", Q
680 IF Q = 4 THEN CLS: KEY ON: CLOSE 1: END
690 ON Q GOTO 730, 1110, 1550
700 '
710 '  Routine to Add a New Record
720 '
730 CLS: I% = LOF(1) \ 256 + 1:     ' Data Entry
740 '
750 PRINT "M B R L I S T"
760 PRINT "Record No.:"; LOF(1) \ 256 + 1
770 PRINT: LINE INPUT "Name (last name first)(20): ", N$
780 LINE INPUT "Street Address (30): ", S$
790 LINE INPUT "City (15): ", C$
800  LINE INPUT "State (2): ", ST$
810 LINE INPUT "Zip Code (5): ", Z$
820 LINE INPUT "Phone (14): ", P$
830 LINE INPUT "Month Joined (3): ", MJ$
840 LINE INPUT "Year Joined (4): ", YJ$
850 INPUT "Number of times dues paid (0-10): ", Q1$
860 IF Q1$ = "0" THEN 910
870 FOR X = 1 TO VAL(Q1$)
880   INPUT "Amount dues paid (6): ", D$(X)
890   LINE INPUT "Date dues paid (8): ", DA$(X)
900 NEXT X
910 INPUT "Number of times other donations made (0-20): ", Q2$
920 IF Q2$ = "0" THEN 1040
930 FOR X = 1 TO VAL(Q2$)
940   INPUT "Amount other donations (7): ", OD$(X)
950   LINE INPUT "Date donations made (8): ", DOD$(X)
960 NEXT X
970 '
980 GOSUB 2240:        ' Transfer variables to buffer
990 '
1000 PUT 1, I%:         ' Copy buffer to file
1010 '
1020 '   Query user to enter another record
1030 '
1040 CLS: LINE INPUT "Do you want to enter another record? "; Q$
1050 IF LEFT$(Q$,1) = "Y" OR LEFT$(Q$,1) = "y" THEN 730
1060 '
1070 CLOSE 1: GOTO 560: '    Return to main menu
1080 '
1090 '  Routine to Edit a Record
1100 '
1110 CLS: LINE INPUT "Name of member for record edit: "; NN$
1120 '
1130 FOR X = 1 TO LOF(1) \ 256: ' Search file for name
1140   I% = X
1150   GET 1, I%
1160   IF INSTR(NF$,NN$) <> 0 THEN 1260
1170 NEXT X
1180 '
1190 '   Print error message and query user for another record edit
1200 '
1210 PRINT: PRINT NN$; " not found in file."
1220 LINE INPUT "Do you want to enter a name again for record edit? ", Q$
1230 IF LEFT$(Q$,1) = "Y" OR LEFT$(Q$,1) = "y" THEN 1110
1240 IF LEFT$(Q$,1) = "N" OR LEFT$(Q$,1) = "n" THEN CLOSE 1: GOTO 560
1250 '
1260 GOSUB 1960:        ' Display record
1270 '
1280 '  Display edit menu beneath record
1290 '
1300 PRINT "*****************************************************************"
1310 PRINT "Select field to edit (ENTER `0' IF NO CHANGE):"
1320 PRINT "   1. Name             4. State            7. When joined"
1330 PRINT "   2. Street address   5. Zip code         8. Dues"
1340 PRINT "   3. City             6. Phone            9. Other donations"
1350 INPUT "Enter selection (0-10): ", K
1360 IF K = 0 THEN CLS: GOTO 1440
1370 ON K GOSUB 2170, 2460, 2530, 2600, 2670, 2740, 2810, 2900, 3120
1380 '
1390 '   Query user for more editing of same record
1400 '
1410 PRINT: LINE INPUT "Do you want to edit another field in this record? ", Q$
1420 IF LEFT$(Q$,1) = "Y" OR LEFT$(Q$,1) = "y" THEN 1260
1430 '
1440 PUT 1, I%:         ' Replace original record with edited version
1450 '
1460 '   Query user to edit another record
1470 '
1480 PRINT: LINE INPUT "Do you want to edit another record? ", Q$
1490 IF LEFT$(Q$,1) = "Y" OR LEFT$(Q$,1) = "y" THEN 1110
1500 '
1510 CLOSE 1: GOTO 560:         ' Close and return to main menu
1520 '
1530 '   Routine to display records
1540 '
1550 CLS: LOCATE 10,20: PRINT "1. Display a specific record."
1560 LOCATE 12,20: PRINT "2. Display file, one record at a time."
1570 LOCATE 15,20:COLOR 0,7:PRINT "SELECT METHOD OF DISPLAY (1 OR 2):":COLOR 7
1580 LOCATE 15,55: INPUT Q
1590 ON Q GOTO 1630, 1820
1600 '
1610 '   Routine to display a specific record
1620 '
1630 CLS: LINE INPUT "Enter member's name: ", NN$
1640 '
1650 FOR X = 1 TO LOF(1) \ 256
1660   I% = X
1670   GET 1, I%
1680   IF INSTR(NF$,NN$) <> 0 THEN 1710
1690 NEXT X
1700 '
1710 GOSUB 1960:        ' Display record
1720 '
1730 '   Query user to display another record
1740 '
1750 PRINT: PRINT: LINE INPUT "Do you want to see another record? ", Q$
1760 IF LEFT$(Q$,1) = "Y" OR LEFT$(Q$,1) = "y" THEN 1630
1770 '
1780 CLOSE 1: GOTO 560:   ' Close and return to menu
1790 '
1800 '   Routine to display records one at a time
1810 '
1820 FOR G = 1 TO LOF(1) \ 256
1830   I% = G
1840   GET 1, I%
1850   GOSUB 1960
1860   PRINT: PRINT: LINE INPUT "PRESS <ENTER> TO SEE NEXT RECORD.", Q$
1870 NEXT G
1880 '
1890 CLS: PRINT "END OF FILE"
1900 PRINT: LINE INPUT "Press <ENTER> to continue.", Q$
1910 '
1920 CLOSE 1: GOTO 560:         ' Close and return to main menu
1930 '
1940 '   Subroutine to display record
1950 '
1960 CLS: PRINT "M B R L I S T"
1970 PRINT "Record No.: "; I%
1980 PRINT "*****************************************************************"
1990 PRINT NF$: LOCATE 4,40: PRINT PF$
2000 PRINT SF$
2010 PRINT CF$; ", "; STF$; " "; ZF$
2020 PRINT: PRINT "Joined: "; MJF$; " "; YJF$
2030 PRINT "Dues Paid"
2040 FOR X = 1 TO CVI(Q1F$)
2050   PRINT USING "$$###.##"; CVS(DF$(X)),
2060   PRINT " *** "; DAF$(X)
2070 NEXT X
2080 PRINT "Other Donations"
2090 FOR X = 1 TO CVI(Q2F$)
2100   PRINT USING "$$####.##"; CVS(ODF$(X)),
2110   PRINT " *** "; FDOD$(X)
2120 NEXT X
2130 RETURN
2140 '
2150 '   Subroutine to change name
2160 '
2170 CLS: PRINT "Old Name: "; NF$
2180 PRINT: LINE INPUT "Enter New Name: ", N$
2190 LSET NF$ = N$
2200 RETURN
2210 '
2220 '  Subroutine to transfer variables to buffer
2230 '
2240 LSET NF$ = N$
2250 LSET SF$ = S$
2260 LSET CF$ = C$
2270 LSET STF$ = ST$
2280 LSET ZF$ = Z$
2290 LSET PF$ = P$
2300 LSET MJF$ = MJ$
2310 LSET YJF$ = YJ$
2320 LSET Q1F$ = MKI$(VAL(Q1$))
2330 FOR X = 1 TO 3
2340   RSET DF$(X) = MKS$(VAL(D$(X)))
2350   LSET DAF$(X) = DA$(X)
2360 NEXT X
2370 LSET Q2F$ = MKI$(VAL(Q2$))
2380 FOR X = 1 TO 3
2390   RSET ODF$(X) = MKS$(VAL(OD$(X)))
2400   LSET FDOD$(X) = DOD$(X)
2410 NEXT X
2420 RETURN
2430 '
2440 '   Subroutine to change street address
2450 '
2460 CLS: PRINT "Old Street Address: "; SF$
2470 PRINT: LINE INPUT "Enter New Street Address: ", S$
2480 LSET SF$ = S$
2490 RETURN
2500 '
2510 '   Subroutine to change city
2520 '
2530 CLS: PRINT "Old City: "; CF$
2540 PRINT: LINE INPUT "Enter New City: ", C$
2550 LSET CF$ = C$
2560 RETURN
2570 '
2580 '   Subroutine to change state
2590 '
2600 CLS: PRINT "Old State: "; STF$
2610 PRINT: LINE INPUT "Enter New State: ", ST$
2620 LSET STF$ = ST$
2630 RETURN
2640 '
2650 '   Subroutine to change zip code
2660 '
2670 CLS: PRINT "Old Zip Code: "; ZF$
2680 PRINT: LINE INPUT "Enter New Zip Code: ", Z$
2690 LSET ZF$ = Z$
2700 RETURN
2710 '
2720 '   Subroutine to change phone
2730 '
2740 CLS: PRINT "Old Phone: "; PF$
2750 PRINT: LINE INPUT "Enter New Phone: ", P$
2760 LSET PF$ = P$
2770 RETURN
2780 '
2790 '   Subroutine to change `when joined'
2800 '
2810 CLS: PRINT "Old `When Joined': "; MJF$; " "; YJF$
2820 PRINT: LINE INPUT "Enter New Month Joined: ", MJ$
2830 LINE INPUT "Enter New Year Joined: ", YJ$
2840 LSET MJF$ = MJ$
2850 LSET YJF$ = YJ$
2860 RETURN
2870 '
2880 '   Subroutine to change dues
2890 '
2900 CLS: PRINT "Old Dues Paid"
2910 FOR X = 1 TO CVI(Q1F$)
2920   PRINT "   ";
2930   PRINT USING "$$##.##"; CVS(DF$(X)),
2940   PRINT " *** ";DAF$(X)
2950 NEXT X
2960 PRINT: PRINT "`Old' Number of Times Dues Paid: "; CVI(Q1F$)
2970 LINE INPUT "Enter New Number of Times Dues Paid: ", Q1$
2980 FOR X = 1 TO VAL(Q1$)
2990   PRINT: LINE INPUT "Enter New Dues Paid: ", D$(X)
3000   LINE INPUT "Enter Date New Dues Paid: ", DA$(X)
3010 NEXT X
3020 LSET Q1F$ = MKI$(VAL(Q1$))
3030 FOR X = 1 TO VAL(Q1$)
3040   RSET DF$(X) = MKS$(VAL(D$(X)))
3050   LSET DAF$(X) = DA$(X)
3060 NEXT X
3070 IF VAL(Q1$) < CVI(Q1F$) THEN GOSUB 3330
3080 RETURN
3090 '
3100 '   Subroutine to change other donations
3110 '
3120 CLS: PRINT "Old Other Donations Made"
3130 FOR X = 1 TO CVI(Q2F$)
3140   PRINT "   ";
3150   PRINT USING "$$##.##"; CVS(ODF$(X)),
3160   PRINT " *** "; FDOD$(X)
3170 NEXT X
3180 PRINT: PRINT "Old Number of Times Other Donations Made: "; CVI(Q2F$)
3190 LINE INPUT "Enter New Number of Times Other Donations Made: ", Q2$
3200 FOR X = 1 TO VAL(Q2$)
3210   PRINT: LINE INPUT "Enter New Dues Paid: ", OD$(X)
3220   LINE INPUT "Enter Date New Dues Paid: ", DOD$(X)
3230 NEXT X
3240 LSET Q2F$ = MKI$(VAL(Q2$))
3250 FOR X = 1 TO VAL(Q2$)
3260   RSET ODF$(X) = MKS$(VAL(OD$(X)))
3270   LSET FDOD$(X) = DOD$(X)
3280 NEXT X
3290 RETURN
3300 '
3310 '   Sub-subroutine to delete extra `old' dues from edited record
3320 '
3330 FOR X = VAL(Q1$) + 1 TO 3
3340   D$(X) = ""
3350   LSET DF$(X) = MKS$(VAL(D$(X)))
3360   DA$(X) = ""
3370   LSET DAF$(X) = DA$(X)
3380 NEXT X
3390 RETURN
D$(X) = ""
3350   LSET DF$(X) = MKS$(VAL(D$(X)))
3360   DA$(X) = ""
3370   LSET DAF$(X) = DA$(